/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.primitive.iterator;

import io.deephaven.engine.primitive.function.ShortConsumer;
import io.deephaven.engine.primitive.function.ShortToIntFunction;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIterator;
import io.deephaven.engine.primitive.iterator.CloseablePrimitiveIteratorOfInt;
import io.deephaven.util.SafeCloseableArray;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CloseablePrimitiveIteratorOfShort
extends CloseablePrimitiveIterator<Short, ShortConsumer> {
    public static final CloseablePrimitiveIteratorOfShort EMPTY = new CloseablePrimitiveIteratorOfShort(){

        @Override
        public short nextShort() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasNext() {
            return false;
        }
    };

    public short nextShort();

    @Override
    default public void forEachRemaining(@NotNull ShortConsumer action) {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.nextShort());
        }
    }

    @Override
    default public Short next() {
        return this.nextShort();
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Short> action) {
        if (action instanceof ShortConsumer) {
            this.forEachRemaining((ShortConsumer)((Object)action));
        } else {
            Objects.requireNonNull(action);
            this.forEachRemaining(action::accept);
        }
    }

    default public CloseablePrimitiveIteratorOfInt adaptToOfInt(final @NotNull ShortToIntFunction adapter) {
        return new CloseablePrimitiveIteratorOfInt(){

            @Override
            public boolean hasNext() {
                return CloseablePrimitiveIteratorOfShort.this.hasNext();
            }

            @Override
            public int nextInt() {
                return adapter.applyAsInt(CloseablePrimitiveIteratorOfShort.this.next());
            }

            @Override
            public void close() {
                CloseablePrimitiveIteratorOfShort.this.close();
            }
        };
    }

    default public IntStream streamAsInt(@NotNull ShortToIntFunction adapter) {
        return this.adaptToOfInt(adapter).intStream();
    }

    default public IntStream streamAsInt() {
        return this.streamAsInt(value -> value);
    }

    public static CloseablePrimitiveIteratorOfShort empty() {
        return EMPTY;
    }

    public static CloseablePrimitiveIteratorOfShort of(final short ... values) {
        Objects.requireNonNull(values);
        return new CloseablePrimitiveIteratorOfShort(){
            private int valueIndex;

            @Override
            public short nextShort() {
                if (this.valueIndex < values.length) {
                    return values[this.valueIndex++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.valueIndex < values.length;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfShort repeat(final short value, final long repeatCount) {
        return new CloseablePrimitiveIteratorOfShort(){
            private long repeatIndex;

            @Override
            public short nextShort() {
                if (this.repeatIndex < repeatCount) {
                    ++this.repeatIndex;
                    return value;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.repeatIndex < repeatCount;
            }
        };
    }

    public static CloseablePrimitiveIteratorOfShort concat(final CloseablePrimitiveIteratorOfShort ... subIterators) {
        Objects.requireNonNull(subIterators);
        if (subIterators.length == 0) {
            return CloseablePrimitiveIteratorOfShort.empty();
        }
        if (subIterators.length == 1) {
            return subIterators[0];
        }
        return new CloseablePrimitiveIteratorOfShort(){
            private boolean hasNextChecked;
            private int subIteratorIndex;

            @Override
            public short nextShort() {
                if (this.hasNext()) {
                    this.hasNextChecked = false;
                    return subIterators[this.subIteratorIndex].nextShort();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasNextChecked) {
                    return true;
                }
                while (this.subIteratorIndex < subIterators.length) {
                    if (subIterators[this.subIteratorIndex].hasNext()) {
                        this.hasNextChecked = true;
                        return true;
                    }
                    ++this.subIteratorIndex;
                }
                return false;
            }

            @Override
            public void close() {
                SafeCloseableArray.close((AutoCloseable[])subIterators);
            }
        };
    }

    public static CloseablePrimitiveIteratorOfShort maybeConcat(@Nullable CloseablePrimitiveIteratorOfShort first, @Nullable CloseablePrimitiveIteratorOfShort second, @Nullable CloseablePrimitiveIteratorOfShort third) {
        if (first != null) {
            if (second != null) {
                if (third != null) {
                    return CloseablePrimitiveIteratorOfShort.concat(first, second, third);
                }
                return CloseablePrimitiveIteratorOfShort.concat(first, second);
            }
            if (third != null) {
                return CloseablePrimitiveIteratorOfShort.concat(first, third);
            }
            return first;
        }
        if (second != null) {
            if (third != null) {
                return CloseablePrimitiveIteratorOfShort.concat(second, third);
            }
            return second;
        }
        if (third != null) {
            return third;
        }
        return CloseablePrimitiveIteratorOfShort.empty();
    }
}

