/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.processor.function;

import io.deephaven.chunk.ObjectChunk;
import io.deephaven.chunk.WritableByteChunk;
import io.deephaven.chunk.WritableCharChunk;
import io.deephaven.chunk.WritableChunk;
import io.deephaven.chunk.WritableDoubleChunk;
import io.deephaven.chunk.WritableFloatChunk;
import io.deephaven.chunk.WritableIntChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.chunk.WritableObjectChunk;
import io.deephaven.chunk.WritableShortChunk;
import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.processor.ObjectProcessor;
import io.deephaven.processor.function.ChunkUtils;
import io.deephaven.qst.type.ArrayType;
import io.deephaven.qst.type.BoxedBooleanType;
import io.deephaven.qst.type.BoxedByteType;
import io.deephaven.qst.type.BoxedCharType;
import io.deephaven.qst.type.BoxedDoubleType;
import io.deephaven.qst.type.BoxedFloatType;
import io.deephaven.qst.type.BoxedIntType;
import io.deephaven.qst.type.BoxedLongType;
import io.deephaven.qst.type.BoxedShortType;
import io.deephaven.qst.type.BoxedType;
import io.deephaven.qst.type.CustomType;
import io.deephaven.qst.type.GenericType;
import io.deephaven.qst.type.InstantType;
import io.deephaven.qst.type.StringType;
import io.deephaven.qst.type.Type;
import io.deephaven.time.DateTimeUtils;
import io.deephaven.util.BooleanUtils;
import io.deephaven.util.type.TypeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

final class ObjectProcessorFunctionsImpl<T>
implements ObjectProcessor<T> {
    private final List<Type<?>> logicalTypes;
    private final List<Appender<? super T>> appenders;

    static <T> ObjectProcessorFunctionsImpl<T> create(List<TypedFunction<? super T>> functions) {
        List<Type<?>> logicalTypes = functions.stream().map(TypedFunction::returnType).collect(Collectors.toList());
        List<Appender<? super T>> appenders = functions.stream().map(AppenderVisitor::of).collect(Collectors.toList());
        return new ObjectProcessorFunctionsImpl<T>(logicalTypes, appenders);
    }

    private ObjectProcessorFunctionsImpl(List<Type<?>> logicalTypes, List<Appender<? super T>> appenders) {
        this.logicalTypes = List.copyOf((Collection)Objects.requireNonNull(logicalTypes));
        this.appenders = Objects.requireNonNull(appenders);
    }

    public List<Type<?>> outputTypes() {
        return this.logicalTypes;
    }

    public void processAll(ObjectChunk<? extends T, ?> in, List<WritableChunk<?>> out) {
        this.checkChunks(out);
        int L = this.appenders.size();
        for (int i = 0; i < L; ++i) {
            this.appenders.get(i).append(in, out.get(i));
        }
    }

    private void checkChunks(List<WritableChunk<?>> out) {
        int numColumns = this.appenders.size();
        if (numColumns != out.size()) {
            throw new IllegalArgumentException(String.format("Expected appenders.size() == out.size(). appenders.size()=%d, out.size()=%d", numColumns, out.size()));
        }
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, ToByteFunction<? super T> byteFunction, WritableByteChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(byteFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, ToCharFunction<? super T> charFunction, WritableCharChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(charFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, ToShortFunction<? super T> shortFunction, WritableShortChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(shortFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, java.util.function.ToIntFunction<? super T> intFunction, WritableIntChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(intFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, java.util.function.ToLongFunction<? super T> longFunction, WritableLongChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(longFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, ToFloatFunction<? super T> floatFunction, WritableFloatChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(floatFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T> void append(ObjectChunk<? extends T, ?> src, ToDoubleFunction<? super T> doubleFunction, WritableDoubleChunk<?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(doubleFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static <T, R> void append(ObjectChunk<? extends T, ?> src, Function<? super T, ? extends R> objFunction, WritableObjectChunk<R, ?> dest) {
        int destSize = dest.size();
        ChunkUtils.applyInto(objFunction, src, 0, dest, destSize, src.size());
        dest.setSize(destSize + src.size());
    }

    private static class DoubleAppender<T>
    implements Appender<T> {
        private final ToDoubleFunction<? super T> f;

        DoubleAppender(ToDoubleFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableDoubleChunk());
        }
    }

    private static class FloatAppender<T>
    implements Appender<T> {
        private final ToFloatFunction<? super T> f;

        FloatAppender(ToFloatFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableFloatChunk());
        }
    }

    private static class LongAppender<T>
    implements Appender<T> {
        private final java.util.function.ToLongFunction<? super T> f;

        LongAppender(java.util.function.ToLongFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableLongChunk());
        }
    }

    private static class IntAppender<T>
    implements Appender<T> {
        private final java.util.function.ToIntFunction<? super T> f;

        IntAppender(java.util.function.ToIntFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableIntChunk());
        }
    }

    private static class ShortAppender<T>
    implements Appender<T> {
        private final ToShortFunction<? super T> f;

        ShortAppender(ToShortFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableShortChunk());
        }
    }

    private static class ByteAppender<T>
    implements Appender<T> {
        private final ToByteFunction<? super T> f;

        static <T> ByteAppender<T> from(ToBooleanFunction<? super T> f) {
            return new ByteAppender<T>(x -> BooleanUtils.booleanAsByte((boolean)f.test(x)));
        }

        static <T> ByteAppender<T> from(ToObjectFunction<? super T, ? extends Boolean> f) {
            return new ByteAppender<T>(f.mapToByte(BooleanUtils::booleanAsByte));
        }

        ByteAppender(ToByteFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableByteChunk());
        }
    }

    private static class CharAppender<T>
    implements Appender<T> {
        private final ToCharFunction<? super T> f;

        CharAppender(ToCharFunction<? super T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableCharChunk());
        }
    }

    private static class ObjectAppender<T>
    implements Appender<T> {
        private final ToObjectFunction<? super T, ?> f;

        ObjectAppender(ToObjectFunction<? super T, ?> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public void append(ObjectChunk<? extends T, ?> src, WritableChunk<?> dest) {
            ObjectProcessorFunctionsImpl.append(src, this.f, dest.asWritableObjectChunk());
        }
    }

    private static class ObjectFunctionAppenderVisitor<T>
    implements GenericType.Visitor<Appender<T>>,
    BoxedType.Visitor<Appender<T>> {
        private final AppenderVisitor<T> v;
        private final ToObjectFunction<T, ?> f;

        private ObjectFunctionAppenderVisitor(AppenderVisitor<T> v, ToObjectFunction<T, ?> f) {
            this.v = Objects.requireNonNull(v);
            this.f = Objects.requireNonNull(f);
        }

        public Appender<T> visit(BoxedType<?> boxedType) {
            return (Appender)boxedType.walk((BoxedType.Visitor)this);
        }

        public ByteAppender<T> visit(BoxedBooleanType booleanType) {
            return ByteAppender.from(this.f.cast((GenericType)booleanType));
        }

        public ByteAppender<T> visit(BoxedByteType byteType) {
            return this.v.visit(this.f.cast((GenericType)byteType).mapToByte(TypeUtils::unbox));
        }

        public CharAppender<T> visit(BoxedCharType charType) {
            return this.v.visit(this.f.cast((GenericType)charType).mapToChar(TypeUtils::unbox));
        }

        public ShortAppender<T> visit(BoxedShortType shortType) {
            return this.v.visit(this.f.cast((GenericType)shortType).mapToShort(TypeUtils::unbox));
        }

        public IntAppender<T> visit(BoxedIntType intType) {
            return this.v.visit(this.f.cast((GenericType)intType).mapToInt(TypeUtils::unbox));
        }

        public LongAppender<T> visit(BoxedLongType longType) {
            return this.v.visit(this.f.cast((GenericType)longType).mapToLong(TypeUtils::unbox));
        }

        public FloatAppender<T> visit(BoxedFloatType floatType) {
            return this.v.visit(this.f.cast((GenericType)floatType).mapToFloat(TypeUtils::unbox));
        }

        public DoubleAppender<T> visit(BoxedDoubleType doubleType) {
            return this.v.visit(this.f.cast((GenericType)doubleType).mapToDouble(TypeUtils::unbox));
        }

        public ObjectAppender<T> visit(StringType stringType) {
            return new ObjectAppender<T>(this.f);
        }

        public LongAppender<T> visit(InstantType instantType) {
            return this.v.visit(this.f.cast((GenericType)instantType).mapToLong(DateTimeUtils::epochNanos));
        }

        public ObjectAppender<T> visit(ArrayType<?, ?> arrayType) {
            return new ObjectAppender<T>(this.f);
        }

        public ObjectAppender<T> visit(CustomType<?> customType) {
            return new ObjectAppender<T>(this.f);
        }
    }

    private static class AppenderVisitor<T>
    implements TypedFunction.Visitor<T, Appender<T>>,
    ToPrimitiveFunction.Visitor<T, Appender<T>> {
        private AppenderVisitor() {
        }

        static <T> Appender<T> of(TypedFunction<T> f) {
            return (Appender)f.walk(new AppenderVisitor<T>());
        }

        public Appender<T> visit(ToPrimitiveFunction<T> f) {
            return (Appender)f.walk((ToPrimitiveFunction.Visitor)this);
        }

        public ByteAppender<T> visit(ToBooleanFunction<T> f) {
            return ByteAppender.from(f);
        }

        public CharAppender<T> visit(ToCharFunction<T> f) {
            return new CharAppender<T>(f);
        }

        public ByteAppender<T> visit(ToByteFunction<T> f) {
            return new ByteAppender<T>(f);
        }

        public ShortAppender<T> visit(ToShortFunction<T> f) {
            return new ShortAppender<T>(f);
        }

        public IntAppender<T> visit(ToIntFunction<T> f) {
            return new IntAppender<T>(f);
        }

        public LongAppender<T> visit(ToLongFunction<T> f) {
            return new LongAppender<T>(f);
        }

        public FloatAppender<T> visit(ToFloatFunction<T> f) {
            return new FloatAppender<T>(f);
        }

        public DoubleAppender<T> visit(io.deephaven.function.ToDoubleFunction<T> f) {
            return new DoubleAppender<T>(f);
        }

        public Appender<T> visit(ToObjectFunction<T, ?> f) {
            return (Appender)f.returnType().walk(new ObjectFunctionAppenderVisitor<T>(this, f));
        }
    }

    static interface Appender<T> {
        public void append(ObjectChunk<? extends T, ?> var1, WritableChunk<?> var2);
    }
}

