/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util;

public class BooleanUtils {
    public static final byte NULL_BOOLEAN_AS_BYTE = -128;
    public static final byte TRUE_BOOLEAN_AS_BYTE = 1;
    public static final byte FALSE_BOOLEAN_AS_BYTE = 0;
    public static final Byte NULL_BOOLEAN_AS_BYTE_BOXED = -128;

    public static Boolean byteAsBoolean(byte byteValue) {
        return byteValue == 0 ? Boolean.FALSE : (byteValue > 0 ? Boolean.TRUE : null);
    }

    public static byte booleanAsByte(Boolean booleanValue) {
        return booleanValue == null ? (byte)-128 : (booleanValue != false ? (byte)1 : 0);
    }

    public static byte booleanAsByte(boolean booleanValue) {
        return booleanValue ? (byte)1 : 0;
    }

    public static byte[] booleanAsByteArray(boolean[] booleanArray) {
        byte[] result = new byte[booleanArray.length];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = BooleanUtils.booleanAsByte(booleanArray[ii]);
        }
        return result;
    }

    public static byte[] booleanAsByteArray(Boolean[] booleanArray) {
        byte[] result = new byte[booleanArray.length];
        for (int ii = 0; ii < result.length; ++ii) {
            result[ii] = BooleanUtils.booleanAsByte(booleanArray[ii]);
        }
        return result;
    }
}

