/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeConsumer;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.util.function.LongConsumer;

public interface RowSequence
extends SafeCloseable,
LongSizedDataStructure {
    public static final long NULL_ROW_KEY = -1L;

    public Iterator getRowSequenceIterator();

    public RowSequence getRowSequenceByPosition(long var1, long var3);

    public RowSequence getRowSequenceByKeyRange(long var1, long var3);

    public RowSet asRowSet();

    public LongChunk<OrderedRowKeys> asRowKeyChunk();

    public LongChunk<OrderedRowKeyRanges> asRowKeyRangesChunk();

    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> var1);

    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> var1);

    public boolean isEmpty();

    public long firstRowKey();

    public long lastRowKey();

    public long size();

    default public boolean isContiguous() {
        return this.isEmpty() || this.lastRowKey() - this.firstRowKey() == this.size() - 1L;
    }

    public long getAverageRunLengthEstimate();

    public boolean forEachRowKey(LongAbortableConsumer var1);

    public boolean forEachRowKeyRange(LongRangeAbortableConsumer var1);

    default public void forAllRowKeys(LongConsumer lc) {
        this.forEachRowKey(v -> {
            lc.accept(v);
            return true;
        });
    }

    default public void forAllRowKeyRanges(LongRangeConsumer lrc) {
        this.forEachRowKeyRange((first, last) -> {
            lrc.accept(first, last);
            return true;
        });
    }

    default public void close() {
    }

    public static interface Iterator
    extends SafeCloseable {
        public boolean hasMore();

        public long peekNextKey();

        public RowSequence getNextRowSequenceThrough(long var1);

        public RowSequence getNextRowSequenceWithLength(long var1);

        public boolean advance(long var1);

        default public long advanceAndGetPositionDistance(long nextKey) {
            long initialRelativePosition = this.getRelativePosition();
            this.advance(nextKey);
            return this.getRelativePosition() - initialRelativePosition;
        }

        default public void close() {
        }

        public long getRelativePosition();
    }
}

