/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowSequenceKeyRangesChunkImpl;
import io.deephaven.engine.rowset.impl.RowSequenceRowKeysChunkImpl;
import io.deephaven.engine.rowset.impl.singlerange.SingleRangeRowSequence;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;

public class RowSequenceFactory {
    public static final RowSequence EMPTY = new RowSequence(){

        @Override
        public RowSequence.Iterator getRowSequenceIterator() {
            return EMPTY_ITERATOR;
        }

        @Override
        public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
            return this;
        }

        @Override
        public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
            return this;
        }

        @Override
        public RowSet asRowSet() {
            return RowSetFactory.empty();
        }

        @Override
        public LongChunk<OrderedRowKeys> asRowKeyChunk() {
            return WritableLongChunk.getEmptyChunk();
        }

        @Override
        public LongChunk<OrderedRowKeyRanges> asRowKeyRangesChunk() {
            return WritableLongChunk.getEmptyChunk();
        }

        @Override
        public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
            chunkToFill.setSize(0);
        }

        @Override
        public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
            chunkToFill.setSize(0);
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public long firstRowKey() {
            return -1L;
        }

        @Override
        public long lastRowKey() {
            return -1L;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public boolean isContiguous() {
            return true;
        }

        @Override
        public long getAverageRunLengthEstimate() {
            return 1L;
        }

        @Override
        public boolean forEachRowKey(LongAbortableConsumer lac) {
            return true;
        }

        @Override
        public boolean forEachRowKeyRange(LongRangeAbortableConsumer larc) {
            return true;
        }

        public String toString() {
            return "RowSequence.EMPTY";
        }
    };
    public static final RowSequence.Iterator EMPTY_ITERATOR = new RowSequence.Iterator(){

        @Override
        public boolean hasMore() {
            return false;
        }

        @Override
        public long peekNextKey() {
            return -1L;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKeyInclusive) {
            return EMPTY;
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long numberOfKeys) {
            return EMPTY;
        }

        @Override
        public boolean advance(long nextKey) {
            return false;
        }

        @Override
        public long getRelativePosition() {
            return 0L;
        }
    };

    public static RowSequence wrapRowKeysChunkAsRowSequence(LongChunk<OrderedRowKeys> longChunk) {
        return RowSequenceRowKeysChunkImpl.makeByWrapping(longChunk);
    }

    public static RowSequence wrapKeyRangesChunkAsRowSequence(LongChunk<OrderedRowKeyRanges> longChunk) {
        return RowSequenceKeyRangesChunkImpl.makeByWrapping(longChunk);
    }

    public static RowSequence takeRowKeysChunkAndMakeRowSequence(WritableLongChunk<OrderedRowKeys> longChunk) {
        return RowSequenceRowKeysChunkImpl.makeByTaking(longChunk);
    }

    public static RowSequence takeKeyRangesChunkAndMakeRowSequence(WritableLongChunk<OrderedRowKeyRanges> longChunk) {
        return RowSequenceKeyRangesChunkImpl.makeByTaking(longChunk);
    }

    public static RowSequence forRange(long firstRowKey, long lastRowKey) {
        return new SingleRangeRowSequence(firstRowKey, lastRowKey);
    }
}

