/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import gnu.trove.list.array.TLongArrayList;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongSizedDataStructure;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import org.jetbrains.annotations.NotNull;

public interface RowSet
extends RowSequence,
LongSizedDataStructure,
SafeCloseable,
LogOutputAppendable {
    public static final SearchIterator EMPTY_ITERATOR = new SearchIterator(){

        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public boolean advance(long unused) {
            return false;
        }

        @Override
        public long currentValue() {
            throw new IllegalStateException();
        }

        @Override
        public long nextLong() {
            throw new IllegalStateException();
        }

        @Override
        public long binarySearchValue(TargetComparator targetComparator, int direction) {
            return -1L;
        }
    };

    @Override
    public void close();

    public WritableRowSet copy();

    @Override
    public long size();

    @Override
    public boolean isEmpty();

    default public boolean isNonempty() {
        return !this.isEmpty();
    }

    default public boolean isFlat() {
        return this.isEmpty() || this.lastRowKey() == this.size() - 1L;
    }

    @Override
    public long firstRowKey();

    @Override
    public long lastRowKey();

    default public WritableRowSet invert(RowSet keys) {
        return this.invert(keys, Long.MAX_VALUE);
    }

    public WritableRowSet invert(RowSet var1, long var2);

    public TLongArrayList[] findMissing(RowSet var1);

    @NotNull
    public WritableRowSet intersect(@NotNull RowSet var1);

    default public boolean overlaps(@NotNull RowSet rowSet) {
        return this.intersect(rowSet).isNonempty();
    }

    public boolean overlapsRange(long var1, long var3);

    public boolean subsetOf(@NotNull RowSet var1);

    public WritableRowSet minus(RowSet var1);

    public WritableRowSet union(RowSet var1);

    public WritableRowSet shift(long var1);

    @Override
    public boolean forEachRowKey(LongAbortableConsumer var1);

    @Override
    default public void forAllRowKeys(LongConsumer lc) {
        this.forEachRowKey(v -> {
            lc.accept(v);
            return true;
        });
    }

    default public void toRowKeyArray(long[] vs) {
        this.toRowKeyArray(vs, 0);
    }

    default public void toRowKeyArray(long[] vs, int offset) {
        int[] vi = new int[]{offset};
        this.forEachRowKey(v -> {
            int n = vi[0];
            vi[0] = n + 1;
            vs[n] = v;
            return true;
        });
    }

    public WritableRowSet subSetByPositionRange(long var1, long var3);

    public WritableRowSet subSetByKeyRange(long var1, long var3);

    public WritableRowSet subSetForPositions(RowSequence var1, boolean var2);

    public WritableRowSet subSetForPositions(RowSequence var1);

    public WritableRowSet subSetForReversePositions(RowSequence var1);

    public long get(long var1);

    public void getKeysForPositions(PrimitiveIterator.OfLong var1, LongConsumer var2);

    public long find(long var1);

    @NotNull
    public Iterator iterator();

    public SearchIterator searchIterator();

    public SearchIterator reverseIterator();

    public RangeIterator rangeIterator();

    public boolean containsRange(long var1, long var3);

    public void validate(String var1);

    default public void validate() {
        this.validate(null);
    }

    default public boolean isWritable() {
        return this instanceof WritableRowSet;
    }

    default public WritableRowSet writableCast() {
        return (WritableRowSet)this;
    }

    default public boolean isTracking() {
        return this instanceof TrackingRowSet;
    }

    default public TrackingRowSet trackingCast() {
        return (TrackingRowSet)this;
    }

    public static interface SearchIterator
    extends Iterator {
        public long currentValue();

        public boolean advance(long var1);

        public long binarySearchValue(TargetComparator var1, int var2);
    }

    public static interface Iterator
    extends PrimitiveIterator.OfLong,
    SafeCloseable {
        default public boolean forEachLong(LongAbortableConsumer lc) {
            while (this.hasNext()) {
                long v = this.nextLong();
                boolean wantMore = lc.accept(v);
                if (wantMore) continue;
                return false;
            }
            return true;
        }
    }

    public static interface TargetComparator {
        public int compareTargetTo(long var1, int var3);
    }

    public static interface Evaluator<T extends Comparable<T>> {
        public T value(long var1);
    }

    public static interface RangeIterator
    extends SafeCloseable {
        public static final RangeIterator empty = new RangeIterator(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public void postpone(long v) {
                throw new IllegalStateException("empty iterator.");
            }

            @Override
            public boolean advance(long v) {
                return false;
            }

            @Override
            public long currentRangeStart() {
                return -1L;
            }

            @Override
            public long currentRangeEnd() {
                return -1L;
            }

            @Override
            public long next() {
                return -1L;
            }
        };

        public void close();

        public boolean hasNext();

        public boolean advance(long var1);

        public void postpone(long var1);

        public long currentRangeStart();

        public long currentRangeEnd();

        public long next();
    }
}

