/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import io.deephaven.chunk.IntChunk;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.util.IntChunkLongIterator;
import io.deephaven.chunk.util.LongChunkIterator;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.chunkattributes.RowKeys;
import io.deephaven.util.datastructures.LongRangeIterator;
import java.util.PrimitiveIterator;

public interface RowSetBuilderRandom {
    public WritableRowSet build();

    public void addKey(long var1);

    public void addRange(long var1, long var3);

    default public void addKeys(PrimitiveIterator.OfLong it) {
        while (it.hasNext()) {
            long v = it.nextLong();
            this.addKey(v);
        }
    }

    default public void addRanges(LongRangeIterator it) {
        while (it.hasNext()) {
            it.next();
            this.addRange(it.start(), it.end());
        }
    }

    default public void addRowKeysChunk(LongChunk<? extends RowKeys> chunk) {
        this.addKeys((PrimitiveIterator.OfLong)new LongChunkIterator(chunk));
    }

    default public void addRowKeysChunk(IntChunk<? extends RowKeys> chunk) {
        this.addKeys((PrimitiveIterator.OfLong)new IntChunkLongIterator(chunk));
    }

    default public void addOrderedRowKeysChunk(LongChunk<? extends OrderedRowKeys> chunk) {
        this.addRowKeysChunk(chunk);
    }

    default public void addOrderedRowKeysChunk(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
        this.addKeys((PrimitiveIterator.OfLong)new LongChunkIterator(chunk, offset, length));
    }

    default public void addOrderedRowKeysChunk(IntChunk<? extends OrderedRowKeys> chunk) {
        this.addRowKeysChunk(chunk);
    }

    default public void addRowSet(RowSet rowSet) {
        Helper.add(this, rowSet);
    }

    public static class Helper {
        private static void add(RowSetBuilderRandom builder, RowSet rowSet) {
            RowSet.RangeIterator it = rowSet.rangeIterator();
            while (it.hasNext()) {
                long start = it.next();
                long end = it.currentRangeEnd();
                builder.addRange(start, end);
            }
        }
    }
}

