/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import gnu.trove.procedure.TLongProcedure;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.util.LongChunkIterator;
import io.deephaven.chunk.util.LongChunkRangeIterator;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.util.datastructures.LongRangeConsumer;
import io.deephaven.util.datastructures.LongRangeIterator;
import java.util.PrimitiveIterator;

public interface RowSetBuilderSequential
extends TLongProcedure,
LongRangeConsumer {
    default public void setDomain(long minRowKey, long maxRowKey) {
    }

    public WritableRowSet build();

    public void appendKey(long var1);

    public void appendRange(long var1, long var3);

    default public void appendKeys(PrimitiveIterator.OfLong it) {
        while (it.hasNext()) {
            this.appendKey(it.nextLong());
        }
    }

    default public void appendOrderedRowKeysChunk(LongChunk<OrderedRowKeys> chunk) {
        this.appendOrderedRowKeysChunk(chunk, 0, chunk.size());
    }

    default public void appendOrderedRowKeysChunk(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
        this.appendKeys((PrimitiveIterator.OfLong)new LongChunkIterator(chunk, offset, length));
    }

    default public void appendRanges(LongRangeIterator it) {
        while (it.hasNext()) {
            it.next();
            this.appendRange(it.start(), it.end());
        }
    }

    default public void appendOrderedRowKeyRangesChunk(LongChunk<OrderedRowKeyRanges> chunk) {
        this.appendRanges((LongRangeIterator)new LongChunkRangeIterator(chunk));
    }

    default public boolean execute(long value) {
        this.appendKey(value);
        return true;
    }

    default public void appendRowSequence(RowSequence rowSequence) {
        rowSequence.forAllRowKeyRanges(this::appendRange);
    }

    default public void appendRowSequenceWithOffset(RowSequence rowSequence, long offset) {
        rowSequence.forAllRowKeyRanges((s, e) -> this.appendRange(s + offset, e + offset));
    }
}

