/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import gnu.trove.list.TLongList;
import gnu.trove.procedure.TLongProcedure;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.impl.AdaptiveRowSetBuilderRandom;
import io.deephaven.engine.rowset.impl.BasicRowSetBuilderSequential;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import org.jetbrains.annotations.NotNull;

public abstract class RowSetFactory {
    private RowSetFactory() {
    }

    public static WritableRowSet empty() {
        return new WritableRowSetImpl();
    }

    public static WritableRowSet fromKeys(long ... rowKeys) {
        if (rowKeys.length == 0) {
            return RowSetFactory.empty();
        }
        if (rowKeys.length == 1) {
            return RowSetFactory.fromKeys(rowKeys[0]);
        }
        RowSetBuilderRandom indexBuilder = RowSetFactory.builderRandom();
        for (long rowKey : rowKeys) {
            indexBuilder.addKey(rowKey);
        }
        return indexBuilder.build();
    }

    public static WritableRowSet fromKeys(long rowKey) {
        return RowSetFactory.fromRange(rowKey, rowKey);
    }

    public static RowSet fromKeys(@NotNull TLongList rowKeys) {
        rowKeys.sort();
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        rowKeys.forEach((TLongProcedure)builder);
        return builder.build();
    }

    public static WritableRowSet fromRange(long firstRowKey, long lastRowKey) {
        return new WritableRowSetImpl(SingleRange.make(firstRowKey, lastRowKey));
    }

    public static WritableRowSet flat(long size) {
        return size <= 0L ? RowSetFactory.empty() : RowSetFactory.fromRange(0L, size - 1L);
    }

    public static RowSetBuilderRandom builderRandom() {
        return new AdaptiveRowSetBuilderRandom();
    }

    public static RowSetBuilderSequential builderSequential() {
        return new BasicRowSetBuilderSequential();
    }
}

