/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset;

import gnu.trove.list.TIntList;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.log.LogOutputAppendable;
import io.deephaven.base.verify.Assert;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.io.log.impl.LogOutputStringImpl;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.SafeCloseablePair;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public final class RowSetShiftData
implements Serializable,
LogOutputAppendable {
    private static final int BEGIN_RANGE_ATTR = 0;
    private static final int END_RANGE_ATTR = 1;
    private static final int SHIFT_DELTA_ATTR = 2;
    private static final int NUM_ATTR = 3;
    private final TLongList payload = new TLongArrayList();
    private final TIntList polaritySwapIndices = new TIntArrayList();
    private volatile long cachedEffectiveSize = -1L;
    public static final RowSetShiftData EMPTY = new RowSetShiftData();

    private RowSetShiftData() {
    }

    public int size() {
        return this.payload.size() / 3;
    }

    public long getEffectiveSize() {
        if (this.cachedEffectiveSize < 0L) {
            long cc = 0L;
            int size = this.size();
            for (int idx = 0; idx < size; ++idx) {
                cc += this.getEndRange(idx) - this.getBeginRange(idx) + 1L;
            }
            this.cachedEffectiveSize = cc;
        }
        return this.cachedEffectiveSize;
    }

    public long getEffectiveSizeClamped(long clamp) {
        if (this.cachedEffectiveSize < 0L) {
            long cc = 0L;
            int size = this.size();
            for (int idx = 0; idx < size; ++idx) {
                if ((cc += this.getEndRange(idx) - this.getBeginRange(idx) + 1L) < clamp) continue;
                return clamp;
            }
            this.cachedEffectiveSize = cc;
        }
        return Math.min(clamp, this.cachedEffectiveSize);
    }

    public long getBeginRange(int idx) {
        return this.payload.get(idx * 3 + 0);
    }

    public long getEndRange(int idx) {
        return this.payload.get(idx * 3 + 1);
    }

    public long getShiftDelta(int idx) {
        return this.payload.get(idx * 3 + 2);
    }

    public void validate() {
        int polarOffset = 0;
        int size = this.size();
        for (int idx = 0; idx < size; ++idx) {
            int currShiftSign;
            Assert.leq((long)this.getBeginRange(idx), (String)"getBeginRange(idx)", (long)this.getEndRange(idx), (String)"getEndRange(idx)");
            Assert.neqZero((long)this.getShiftDelta(idx), (String)"getShiftDelta(idx)");
            if (idx == 0) continue;
            Assert.lt((long)this.getEndRange(idx - 1), (String)"getEndRange(idx - 1)", (long)this.getBeginRange(idx), (String)"getBeginRange(idx)");
            long newPrevEnd = this.getEndRange(idx - 1) + this.getShiftDelta(idx - 1);
            long newCurrBegin = this.getBeginRange(idx) + this.getShiftDelta(idx);
            Assert.lt((long)newPrevEnd, (String)"newPrevEnd", (long)newCurrBegin, (String)"newCurrBeing");
            int prevShiftSign = this.getShiftDelta(idx - 1) < 0L ? -1 : 1;
            int n = currShiftSign = this.getShiftDelta(idx) < 0L ? -1 : 1;
            if (prevShiftSign == currShiftSign) continue;
            Assert.gt((int)this.polaritySwapIndices.size(), (String)"polaritySwapIndices.size()", (int)polarOffset, (String)"polarOffset");
            Assert.eq((int)this.polaritySwapIndices.get(polarOffset), (String)"polaritySwapIndices.get(polarOffset)", (int)idx, (String)"idx");
            ++polarOffset;
        }
    }

    public boolean empty() {
        return this.size() == 0;
    }

    public boolean nonempty() {
        return !this.empty();
    }

    public String toString() {
        return this.append((LogOutput)new LogOutputStringImpl()).toString();
    }

    public LogOutput append(LogOutput logOutput) {
        return this.append(logOutput, 200);
    }

    public LogOutput append(LogOutput logOutput, int maxShifts) {
        int count = 0;
        logOutput.append((CharSequence)"{");
        boolean isFirst = true;
        int size = this.size();
        for (int idx = 0; idx < size; ++idx) {
            long shift = this.getShiftDelta(idx);
            logOutput.append((CharSequence)(isFirst ? "" : ",")).append((CharSequence)"[").append(this.getBeginRange(idx)).append((CharSequence)",").append(this.getEndRange(idx)).append((CharSequence)(shift < 0L ? "]" : "]+")).append(shift);
            isFirst = false;
            if (++count < maxShifts) continue;
            logOutput.append((CharSequence)",...");
            break;
        }
        logOutput.append((CharSequence)"}");
        return logOutput;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowSetShiftData)) {
            return false;
        }
        RowSetShiftData shiftData = (RowSetShiftData)obj;
        return shiftData.payload.equals(this.payload);
    }

    public void apply(Callback shiftCallback) {
        int polaritySwapSize = this.polaritySwapIndices.size();
        for (int idx = 0; idx < polaritySwapSize; ++idx) {
            long dir;
            int start = idx == 0 ? 0 : this.polaritySwapIndices.get(idx - 1);
            int end = this.polaritySwapIndices.get(idx) - 1;
            long l = dir = this.getShiftDelta(start) > 0L ? -1L : 1L;
            if (dir < 0L) {
                int tmp = start;
                start = end;
                end = tmp;
            }
            int jdx = start;
            while ((long)jdx != (long)end + dir) {
                shiftCallback.shift(this.getBeginRange(jdx), this.getEndRange(jdx), this.getShiftDelta(jdx));
                jdx = (int)((long)jdx + dir);
            }
        }
    }

    public void unapply(Callback shiftCallback) {
        int polaritySwapSize = this.polaritySwapIndices.size();
        for (int idx = 0; idx < polaritySwapSize; ++idx) {
            long dir;
            int start = idx == 0 ? 0 : this.polaritySwapIndices.get(idx - 1);
            int end = this.polaritySwapIndices.get(idx) - 1;
            long l = dir = this.getShiftDelta(start) > 0L ? 1L : -1L;
            if (dir < 0L) {
                int tmp = start;
                start = end;
                end = tmp;
            }
            int jdx = start;
            while ((long)jdx != (long)end + dir) {
                long delta = this.getShiftDelta(jdx);
                shiftCallback.shift(this.getBeginRange(jdx) + delta, this.getEndRange(jdx) + delta, -delta);
                jdx = (int)((long)jdx + dir);
            }
        }
    }

    public boolean apply(WritableRowSet rowSet) {
        RowSetBuilderSequential toRemove = RowSetFactory.builderSequential();
        RowSetBuilderSequential toInsert = RowSetFactory.builderSequential();
        try (RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();){
            int size = this.size();
            for (int idx = 0; idx < size; ++idx) {
                long beginRange = this.getBeginRange(idx);
                long endRange = this.getEndRange(idx);
                long shiftDelta = this.getShiftDelta(idx);
                if (!rsIt.advance(beginRange)) {
                    break;
                }
                if (endRange < rsIt.peekNextKey()) continue;
                toRemove.appendRange(beginRange, endRange);
                rsIt.getNextRowSequenceThrough(endRange).forAllRowKeyRanges((s, e) -> toInsert.appendRange(s + shiftDelta, e + shiftDelta));
            }
        }
        try (WritableRowSet remove = toRemove.build();){
            WritableRowSet insert = toInsert.build();
            try {
                boolean bl;
                rowSet.remove(remove);
                rowSet.insert(insert);
                boolean bl2 = bl = remove.isNonempty() || insert.isNonempty();
                if (insert != null) {
                    insert.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (insert != null) {
                    try {
                        insert.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public long apply(long keyToShift) {
        for (int shiftIdx = 0; shiftIdx < this.size(); ++shiftIdx) {
            if (this.getBeginRange(shiftIdx) > keyToShift) {
                return keyToShift;
            }
            if (this.getEndRange(shiftIdx) < keyToShift) continue;
            return keyToShift + this.getShiftDelta(shiftIdx);
        }
        return keyToShift;
    }

    public static boolean applyShift(@NotNull WritableRowSet rowSet, long beginRange, long endRange, long shiftDelta) {
        try (WritableRowSet toShift = rowSet.subSetByKeyRange(beginRange, endRange);){
            if (toShift.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            rowSet.removeRange(beginRange, endRange);
            toShift.shiftInPlace(shiftDelta);
            rowSet.insert(toShift);
            boolean bl = true;
            return bl;
        }
    }

    public WritableRowSet unapply(WritableRowSet rowSet) {
        RowSetBuilderSequential toRemove = RowSetFactory.builderSequential();
        RowSetBuilderSequential toInsert = RowSetFactory.builderSequential();
        try (RowSequence.Iterator rsIt = rowSet.getRowSequenceIterator();){
            int size = this.size();
            for (int idx = 0; idx < size; ++idx) {
                long beginRange = this.getBeginRange(idx);
                long endRange = this.getEndRange(idx);
                long shiftDelta = this.getShiftDelta(idx);
                if (!rsIt.advance(beginRange + shiftDelta)) {
                    break;
                }
                toRemove.appendRange(beginRange + shiftDelta, endRange + shiftDelta);
                rsIt.getNextRowSequenceThrough(endRange + shiftDelta).forAllRowKeyRanges((s, e) -> toInsert.appendRange(s - shiftDelta, e - shiftDelta));
            }
        }
        try (WritableRowSet remove = toRemove.build();
             WritableRowSet insert = toInsert.build();){
            rowSet.remove(remove);
            rowSet.insert(insert);
        }
        return rowSet;
    }

    public WritableRowSet unapply(WritableRowSet rowSet, long offset) {
        this.unapply((long beginRange, long endRange, long shiftDelta) -> RowSetShiftData.applyShift(rowSet, beginRange + offset, endRange + offset, shiftDelta));
        return rowSet;
    }

    public static boolean unapplyShift(@NotNull WritableRowSet rowSet, long beginRange, long endRange, long shiftDelta) {
        try (WritableRowSet toShift = rowSet.subSetByKeyRange(beginRange + shiftDelta, endRange + shiftDelta);){
            if (toShift.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            rowSet.removeRange(beginRange + shiftDelta, endRange + shiftDelta);
            toShift.shiftInPlace(-shiftDelta);
            rowSet.insert(toShift);
            boolean bl = true;
            return bl;
        }
    }

    public void forAllInRowSet(RowSet filterRowSet, SingleElementShiftCallback callback) {
        boolean hasReverseShift = false;
        RowSet.SearchIterator it = filterRowSet.reverseIterator();
        block0: for (int ii = this.size() - 1; ii >= 0; --ii) {
            long delta = this.getShiftDelta(ii);
            if (delta < 0L) {
                hasReverseShift = true;
                continue;
            }
            long start = this.getBeginRange(ii);
            long end = this.getEndRange(ii);
            if (!it.advance(end)) break;
            while (it.currentValue() >= start) {
                callback.shift(it.currentValue(), delta);
                if (!it.hasNext()) break block0;
                it.nextLong();
            }
        }
        if (!hasReverseShift) {
            return;
        }
        it = filterRowSet.searchIterator();
        int size = this.size();
        block2: for (int ii = 0; ii < size; ++ii) {
            long delta = this.getShiftDelta(ii);
            if (delta > 0L) continue;
            long start = this.getBeginRange(ii);
            long end = this.getEndRange(ii);
            if (!it.advance(start)) break;
            while (it.currentValue() <= end) {
                callback.shift(it.currentValue(), delta);
                if (!it.hasNext()) break block2;
                it.nextLong();
            }
        }
    }

    public Iterator applyIterator() {
        if (this.empty()) {
            return Iterator.EMPTY;
        }
        return new ApplyIterator();
    }

    public RowSetShiftData intersect(RowSet rowSet) {
        Builder builder = new Builder();
        int size = this.size();
        for (int idx = 0; idx < size; ++idx) {
            if (!rowSet.overlapsRange(this.getBeginRange(idx), this.getEndRange(idx))) continue;
            builder.shiftRange(this.getBeginRange(idx), this.getEndRange(idx), this.getShiftDelta(idx));
        }
        return builder.build();
    }

    public SafeCloseablePair<RowSet, RowSet> extractParallelShiftedRowsFromPostShiftRowSet(RowSet postShiftRowSet) {
        if (this.empty()) {
            return SafeCloseablePair.of((SafeCloseable)RowSetFactory.empty(), (SafeCloseable)RowSetFactory.empty());
        }
        RowSetBuilderSequential preShiftBuilder = RowSetFactory.builderSequential();
        RowSetBuilderSequential postShiftBuilder = RowSetFactory.builderSequential();
        try (RowSequence.Iterator rsIt = postShiftRowSet.getRowSequenceIterator();){
            int size = this.size();
            for (int idx = 0; idx < size; ++idx) {
                long beginRange = this.getBeginRange(idx);
                long endRange = this.getEndRange(idx);
                long shiftDelta = this.getShiftDelta(idx);
                if (!rsIt.advance(beginRange + shiftDelta)) {
                    break;
                }
                rsIt.getNextRowSequenceThrough(endRange + shiftDelta).forAllRowKeyRanges((s, e) -> {
                    preShiftBuilder.appendRange(s - shiftDelta, e - shiftDelta);
                    postShiftBuilder.appendRange(s, e);
                });
            }
        }
        SafeCloseablePair retVal = SafeCloseablePair.of((SafeCloseable)preShiftBuilder.build(), (SafeCloseable)postShiftBuilder.build());
        Assert.eq((long)((RowSet)retVal.first).size(), (String)"retVal.first.size()", (long)((RowSet)retVal.second).size(), (String)"retVal.second.size()");
        return retVal;
    }

    public static final class SmartCoalescingBuilder
    implements SafeCloseable {
        private RowSet preShiftKeys;
        private RowSet.SearchIterator preShiftKeysIteratorForward;
        private RowSet.SearchIterator preShiftKeysIteratorReverse;
        private RowSetShiftData shiftData;
        private int rangeToReverseStart = -1;
        private boolean lastPolarityReversed = false;
        private long nextForwardKey;
        private long nextReverseKey;
        private long interveningKey = -1L;
        private long lastReverseIteratorStart = -1L;

        public SmartCoalescingBuilder(@NotNull RowSet preShiftKeys) {
            this.preShiftKeys = preShiftKeys;
            this.shiftData = new RowSetShiftData();
        }

        public boolean nonempty() {
            return this.shiftData.payload.size() > 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void shiftRange(long beginRange, long endRange, long shiftDelta) {
            boolean polaritySwap;
            long nextInterveningKey;
            boolean reinitializeReverseIterator;
            if (shiftDelta == 0L || endRange < beginRange) {
                return;
            }
            boolean polarityReversed = shiftDelta > 0L;
            boolean polarityChanged = this.lastPolarityReversed != polarityReversed;
            boolean bl = reinitializeReverseIterator = polarityReversed && (polarityChanged || beginRange > this.lastReverseIteratorStart);
            if (polarityChanged || reinitializeReverseIterator) {
                this.interveningKey = -1L;
                if (this.lastPolarityReversed) {
                    this.maybeReverseLastRun();
                    if (this.preShiftKeysIteratorReverse != null) {
                        this.preShiftKeysIteratorReverse.close();
                        this.preShiftKeysIteratorReverse = null;
                    }
                }
            }
            if (reinitializeReverseIterator) {
                this.maybeReverseLastRun();
                Assert.eqNull((Object)this.preShiftKeysIteratorReverse, (String)"preShiftKeysIteratorReverse");
                this.preShiftKeysIteratorReverse = this.preShiftKeys.reverseIterator();
                this.lastReverseIteratorStart = endRange;
                this.nextReverseKey = !this.preShiftKeysIteratorReverse.advance(endRange) ? -1L : this.preShiftKeysIteratorReverse.currentValue();
                this.rangeToReverseStart = this.shiftData.size();
            }
            this.lastPolarityReversed = polarityReversed;
            if (!polarityReversed && this.preShiftKeysIteratorForward == null) {
                this.preShiftKeysIteratorForward = this.preShiftKeys.searchIterator();
                this.nextForwardKey = this.preShiftKeysIteratorForward.hasNext() ? this.preShiftKeysIteratorForward.nextLong() : -1L;
            }
            if (polarityReversed) {
                if (this.nextReverseKey == -1L || this.nextReverseKey < beginRange) {
                    return;
                }
                if (beginRange == 0L || !this.preShiftKeysIteratorReverse.advance(beginRange - 1L)) {
                    this.nextReverseKey = -1L;
                    nextInterveningKey = -1L;
                } else {
                    nextInterveningKey = this.nextReverseKey = this.preShiftKeysIteratorReverse.currentValue();
                }
            } else {
                if (this.nextForwardKey == -1L || this.nextForwardKey > endRange) {
                    return;
                }
                if (endRange == Long.MAX_VALUE || !this.preShiftKeysIteratorForward.advance(endRange + 1L)) {
                    this.nextForwardKey = -1L;
                    nextInterveningKey = -1L;
                } else {
                    nextInterveningKey = this.nextForwardKey = this.preShiftKeysIteratorForward.currentValue();
                }
            }
            int currentRangeIndex = this.shiftData.size() - 1;
            if (currentRangeIndex >= 0 && this.shiftData.getShiftDelta(currentRangeIndex) == shiftDelta) {
                if (polarityReversed) {
                    if (this.interveningKey == -1L || this.interveningKey <= endRange) {
                        long existingBegin = this.shiftData.getBeginRange(currentRangeIndex);
                        long existingEnd = this.shiftData.getEndRange(currentRangeIndex);
                        if (existingBegin >= beginRange) {
                            this.shiftData.payload.set(currentRangeIndex * 3, beginRange);
                            this.interveningKey = nextInterveningKey;
                            return;
                        }
                        if (nextInterveningKey <= existingEnd) {
                            this.shiftData.payload.set(currentRangeIndex * 3 + 1, endRange);
                            this.interveningKey = nextInterveningKey;
                            return;
                        }
                    }
                } else if (this.interveningKey == -1L || this.interveningKey >= beginRange) {
                    this.shiftData.payload.set(currentRangeIndex * 3 + 1, endRange);
                    this.interveningKey = nextInterveningKey;
                    return;
                }
            }
            this.interveningKey = nextInterveningKey;
            this.shiftData.payload.add(beginRange);
            this.shiftData.payload.add(endRange);
            this.shiftData.payload.add(shiftDelta);
            if (currentRangeIndex < 0) {
                return;
            }
            boolean bl2 = polaritySwap = (long)(this.shiftData.getShiftDelta(currentRangeIndex) < 0L ? -1 : 1) * shiftDelta < 0L;
            if (polaritySwap) {
                this.shiftData.polaritySwapIndices.add(this.shiftData.size() - 1);
            }
            if (!polarityReversed) {
                if (beginRange <= this.shiftData.getEndRange(currentRangeIndex)) {
                    throw new IllegalArgumentException("new range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(currentRangeIndex) + "," + this.shiftData.getEndRange(currentRangeIndex) + "]->" + this.shiftData.getShiftDelta(currentRangeIndex));
                }
                if (beginRange + shiftDelta > this.shiftData.getEndRange(currentRangeIndex) + this.shiftData.getShiftDelta(currentRangeIndex)) return;
                throw new IllegalArgumentException("new resulting range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(currentRangeIndex) + "," + this.shiftData.getEndRange(currentRangeIndex) + "]->" + this.shiftData.getShiftDelta(currentRangeIndex));
            } else {
                if (reinitializeReverseIterator) return;
                if (beginRange >= this.shiftData.getEndRange(currentRangeIndex)) {
                    throw new IllegalArgumentException("new range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(currentRangeIndex) + "," + this.shiftData.getEndRange(currentRangeIndex) + "]->" + this.shiftData.getShiftDelta(currentRangeIndex));
                }
                if (beginRange + shiftDelta < this.shiftData.getEndRange(currentRangeIndex) + this.shiftData.getShiftDelta(currentRangeIndex)) return;
                throw new IllegalArgumentException("new resulting range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(currentRangeIndex) + "," + this.shiftData.getEndRange(currentRangeIndex) + "]->" + this.shiftData.getShiftDelta(currentRangeIndex));
            }
        }

        private void maybeReverseLastRun() {
            if (this.rangeToReverseStart >= 0) {
                int runLength = this.shiftData.size() - this.rangeToReverseStart;
                for (int ii = 0; ii < runLength / 2; ++ii) {
                    int firstIdx = (this.rangeToReverseStart + ii) * 3;
                    int lastIdx = (this.rangeToReverseStart + runLength - ii - 1) * 3;
                    long tmpStart = this.shiftData.payload.get(firstIdx);
                    long tmpEnd = this.shiftData.payload.get(firstIdx + 1);
                    long tmpDelta = this.shiftData.payload.get(firstIdx + 2);
                    this.shiftData.payload.set(firstIdx, this.shiftData.payload.get(lastIdx));
                    this.shiftData.payload.set(firstIdx + 1, this.shiftData.payload.get(lastIdx + 1));
                    this.shiftData.payload.set(firstIdx + 2, this.shiftData.payload.get(lastIdx + 2));
                    this.shiftData.payload.set(lastIdx, tmpStart);
                    this.shiftData.payload.set(lastIdx + 1, tmpEnd);
                    this.shiftData.payload.set(lastIdx + 2, tmpDelta);
                }
                this.rangeToReverseStart = -1;
            }
        }

        public RowSetShiftData build() {
            this.maybeReverseLastRun();
            RowSetShiftData result = this.shiftData;
            this.close();
            if (result.empty()) {
                return EMPTY;
            }
            result.polaritySwapIndices.add(result.size());
            return result;
        }

        public void close() {
            this.preShiftKeys.close();
            if (this.preShiftKeysIteratorForward != null) {
                this.preShiftKeysIteratorForward.close();
            }
            if (this.preShiftKeysIteratorReverse != null) {
                this.preShiftKeysIteratorReverse.close();
            }
            this.preShiftKeys = null;
            this.preShiftKeysIteratorForward = null;
            this.preShiftKeysIteratorReverse = null;
            this.shiftData = null;
        }
    }

    public static class Builder {
        private RowSetShiftData shiftData = new RowSetShiftData();

        public boolean nonempty() {
            return this.shiftData.payload.size() > 0;
        }

        public long lastShiftEnd() {
            return this.shiftData.size() > 0 ? this.shiftData.getEndRange(this.shiftData.size() - 1) : -1L;
        }

        public void shiftRange(long beginRange, long endRange, long shiftDelta) {
            if (shiftDelta == 0L || endRange < beginRange) {
                return;
            }
            int prevIdx = this.shiftData.size() - 1;
            if (prevIdx >= 0 && this.shiftData.getShiftDelta(prevIdx) == shiftDelta && this.shiftData.getEndRange(prevIdx) + 1L == beginRange) {
                this.shiftData.payload.set(prevIdx * 3 + 1, endRange);
                return;
            }
            this.shiftData.payload.add(beginRange);
            this.shiftData.payload.add(endRange);
            this.shiftData.payload.add(shiftDelta);
            if (prevIdx < 0) {
                return;
            }
            if ((long)(this.shiftData.getShiftDelta(prevIdx) < 0L ? -1 : 1) * shiftDelta < 0L) {
                this.shiftData.polaritySwapIndices.add(this.shiftData.size() - 1);
            }
            if (beginRange <= this.shiftData.getEndRange(prevIdx)) {
                throw new IllegalArgumentException("new range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(prevIdx) + "," + this.shiftData.getEndRange(prevIdx) + "]->" + this.shiftData.getShiftDelta(prevIdx));
            }
            if (beginRange + shiftDelta <= this.shiftData.getEndRange(prevIdx) + this.shiftData.getShiftDelta(prevIdx)) {
                throw new IllegalArgumentException("new resulting range [" + beginRange + "," + endRange + "]->" + shiftDelta + " overlaps previous [" + this.shiftData.getBeginRange(prevIdx) + "," + this.shiftData.getEndRange(prevIdx) + "]->" + this.shiftData.getShiftDelta(prevIdx));
            }
        }

        public long getMinimumValidBeginForNextDelta(long nextShiftDelta) {
            if (this.shiftData.empty()) {
                return nextShiftDelta < 0L ? -nextShiftDelta : 0L;
            }
            int idx = this.shiftData.size() - 1;
            return Math.max(this.shiftData.getEndRange(idx) + 1L, this.shiftData.getEndRange(idx) + this.shiftData.getShiftDelta(idx) - nextShiftDelta + 1L);
        }

        public RowSetShiftData build() {
            RowSetShiftData retVal = this.shiftData;
            this.shiftData = null;
            if (retVal.empty()) {
                return EMPTY;
            }
            retVal.polaritySwapIndices.add(retVal.size());
            return retVal;
        }

        public void appendShiftData(RowSetShiftData innerShiftData, long prevOffset, long prevCardinality, long currOffset, long currCardinality) {
            long watermarkKey = 0L;
            int innerSize = innerShiftData.size();
            for (int sidx = 0; sidx < innerSize + 1; ++sidx) {
                long nextShiftEnd;
                long nextShiftStart;
                long nextShiftDelta;
                if (sidx < innerSize) {
                    nextShiftDelta = innerShiftData.getShiftDelta(sidx);
                    nextShiftStart = Math.max(innerShiftData.getBeginRange(sidx), nextShiftDelta < 0L ? -nextShiftDelta : 0L);
                    nextShiftEnd = Math.min(Math.min(prevCardinality - 1L, currCardinality - 1L - nextShiftDelta), innerShiftData.getEndRange(sidx));
                } else {
                    nextShiftEnd = nextShiftStart = prevCardinality;
                    nextShiftDelta = 0L;
                }
                long innerEnd = Math.min(prevCardinality - 1L, nextShiftStart - 1L) + (nextShiftDelta < 0L ? nextShiftDelta : 0L);
                this.shiftRange(watermarkKey + prevOffset, innerEnd + prevOffset, currOffset - prevOffset);
                if (sidx >= innerShiftData.size() || nextShiftStart > prevCardinality) break;
                this.shiftRange(nextShiftStart + prevOffset, nextShiftEnd + prevOffset, currOffset - prevOffset + nextShiftDelta);
                watermarkKey = nextShiftEnd + 1L + (nextShiftDelta > 0L ? nextShiftDelta : 0L);
            }
        }

        public void limitPreviousShiftFor(long nextShiftBegin, long nextShiftDelta) {
            while (this.shiftData.nonempty()) {
                int prevIdx = this.shiftData.size() - 1;
                if (nextShiftBegin <= this.shiftData.getEndRange(prevIdx)) {
                    this.shiftData.payload.set(prevIdx * 3 + 1, nextShiftBegin - 1L);
                }
                if (nextShiftBegin + nextShiftDelta <= this.shiftData.getEndRange(prevIdx) + this.shiftData.getShiftDelta(prevIdx)) {
                    this.shiftData.payload.set(prevIdx * 3 + 1, nextShiftBegin + nextShiftDelta - this.shiftData.getShiftDelta(prevIdx) - 1L);
                }
                if (this.shiftData.getEndRange(prevIdx) < this.shiftData.getBeginRange(prevIdx)) {
                    this.shiftData.payload.remove(this.shiftData.payload.size() - 3, 3);
                    int numSwaps = this.shiftData.polaritySwapIndices.size();
                    if (numSwaps <= 0 || this.shiftData.polaritySwapIndices.get(numSwaps - 1) < this.shiftData.size()) continue;
                    this.shiftData.polaritySwapIndices.removeAt(numSwaps - 1);
                    continue;
                }
                return;
            }
        }
    }

    private class ApplyIterator
    implements Iterator {
        int psi = -1;
        int start = -1;
        int end = -1;
        int dir = -1;

        private ApplyIterator() {
        }

        @Override
        public boolean hasNext() {
            boolean remainingSwaps = this.psi < RowSetShiftData.this.polaritySwapIndices.size() - 1;
            boolean remainingValuesInSwap = this.start != this.end;
            return remainingSwaps || remainingValuesInSwap;
        }

        @Override
        public void next() {
            if (this.start == this.end) {
                ++this.psi;
                this.start = this.psi == 0 ? 0 : RowSetShiftData.this.polaritySwapIndices.get(this.psi - 1);
                this.end = RowSetShiftData.this.polaritySwapIndices.get(this.psi) - 1;
                int n = this.dir = RowSetShiftData.this.getShiftDelta(this.start) > 0L ? -1 : 1;
                if (this.dir < 0) {
                    int tmp = this.start;
                    this.start = this.end;
                    this.end = tmp;
                }
            } else {
                this.start += this.dir;
            }
        }

        @Override
        public boolean polarityReversed() {
            return this.dir < 0;
        }

        @Override
        public long beginRange() {
            return RowSetShiftData.this.getBeginRange(this.start);
        }

        @Override
        public long endRange() {
            return RowSetShiftData.this.getEndRange(this.start);
        }

        @Override
        public long shiftDelta() {
            return RowSetShiftData.this.getShiftDelta(this.start);
        }
    }

    public static interface Iterator {
        public static final Iterator EMPTY = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public void next() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long beginRange() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long endRange() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long shiftDelta() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean polarityReversed() {
                throw new UnsupportedOperationException();
            }
        };

        public boolean hasNext();

        public void next();

        public long beginRange();

        public long endRange();

        public long shiftDelta();

        public boolean polarityReversed();
    }

    @FunctionalInterface
    public static interface SingleElementShiftCallback {
        public void shift(long var1, long var3);
    }

    @FunctionalInterface
    public static interface Callback {
        public void shift(long var1, long var3, long var5);
    }
}

