/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.impl.MixedBuilderRandom;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.RowSetCounts;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.datastructures.LongRangeIterator;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;

public class AdaptiveOrderedLongSetBuilderRandom
implements OrderedLongSet.BuilderRandom {
    private static final RowSetCounts rowSetCounts = new RowSetCounts("orderedLongSetBuilderRandom");
    private SortedRanges pendingSr = null;
    private long pendingRangeStart = -1L;
    private long pendingRangeEnd = -1L;
    private MixedBuilderRandom builder = null;

    private OrderedLongSet.BuilderRandom innerBuilder() {
        return this.builder;
    }

    private void setupInnerBuilderEmpty() {
        this.builder = new MixedBuilderRandom(2 * SortedRanges.MAX_CAPACITY);
    }

    private void setInnerBuilderNull() {
        this.builder = null;
    }

    private boolean flushPendingRange() {
        if (this.pendingRangeStart == -1L) {
            return false;
        }
        if (this.innerBuilder() != null) {
            this.innerBuilder().addRange(this.pendingRangeStart, this.pendingRangeEnd);
        } else if (this.pendingSr == null) {
            this.pendingSr = SortedRanges.makeSingleRange(this.pendingRangeStart, this.pendingRangeEnd);
        } else {
            return this.tryFlushToPendingSr();
        }
        this.pendingRangeEnd = -1L;
        this.pendingRangeStart = -1L;
        return true;
    }

    private boolean tryFlushToPendingSr() {
        SortedRanges ans = this.pendingSr.addRangeUnsafe(this.pendingRangeStart, this.pendingRangeEnd);
        if (ans != null) {
            this.pendingSr = ans;
            this.pendingRangeEnd = -1L;
            this.pendingRangeStart = -1L;
            return true;
        }
        this.flushPendingSrToInnerBuilder();
        this.innerBuilder().addRange(this.pendingRangeStart, this.pendingRangeEnd);
        this.pendingRangeEnd = -1L;
        this.pendingRangeStart = -1L;
        return false;
    }

    private void flushPendingSrToInnerBuilder() {
        this.flushSrToInnerBuilder(this.pendingSr);
        this.pendingSr = null;
    }

    private void flushSrToInnerBuilder(SortedRanges sr) {
        this.setupInnerBuilderEmpty();
        sr.forEachLongRange((start, end) -> {
            this.innerBuilder().appendRange(start, end);
            return true;
        });
    }

    private boolean tryMergeToPendingRange(long firstKey, long lastKey) {
        if (this.pendingRangeStart == -1L) {
            this.pendingRangeStart = firstKey;
            this.pendingRangeEnd = lastKey;
            return true;
        }
        if (this.pendingRangeEnd < firstKey - 1L || lastKey < this.pendingRangeStart - 1L) {
            return false;
        }
        this.pendingRangeStart = Math.min(this.pendingRangeStart, firstKey);
        this.pendingRangeEnd = Math.max(this.pendingRangeEnd, lastKey);
        return true;
    }

    private void newKey(long key) {
        this.newRangeSafe(key, key);
    }

    private void newRange(long firstKey, long lastKey) {
        if (firstKey > lastKey) {
            throw new IllegalArgumentException("Illegal range start=" + firstKey + " > end=" + lastKey + ".");
        }
        this.newRangeSafe(firstKey, lastKey);
    }

    private void newRangeSafe(long firstKey, long lastKey) {
        if (this.tryMergeToPendingRange(firstKey, lastKey)) {
            return;
        }
        this.flushPendingRange();
        this.pendingRangeStart = firstKey;
        this.pendingRangeEnd = lastKey;
    }

    @Override
    public OrderedLongSet getOrderedLongSet() {
        OrderedLongSet ans;
        if (this.innerBuilder() == null && this.pendingSr == null) {
            if (this.pendingRangeStart == -1L) {
                AdaptiveOrderedLongSetBuilderRandom.rowSetCounts.emptyCount.sample(1);
                ans = OrderedLongSet.EMPTY;
            } else {
                SingleRange sr = SingleRange.make(this.pendingRangeStart, this.pendingRangeEnd);
                rowSetCounts.sampleSingleRange(sr);
                ans = sr;
                this.pendingRangeStart = -1L;
            }
        } else {
            this.flushPendingRange();
            if (this.innerBuilder() == null) {
                this.pendingSr = this.pendingSr.tryCompactUnsafe(4);
                rowSetCounts.sampleSortedRanges(this.pendingSr);
                ans = this.pendingSr;
                this.pendingSr = null;
            } else {
                ans = this.innerBuilder().getOrderedLongSet();
                this.setInnerBuilderNull();
            }
        }
        return ans;
    }

    @Override
    public void addKey(long rowKey) {
        this.newKey(rowKey);
    }

    public void addKeys(PrimitiveIterator.OfLong it) {
        LongConsumer c = this::addKey;
        it.forEachRemaining(c);
    }

    @Override
    public void addRange(long firstRowKey, long lastRowKey) {
        this.newRange(firstRowKey, lastRowKey);
    }

    public void addRanges(LongRangeIterator it) {
        it.forEachLongRange((start, end) -> {
            this.addRange(start, end);
            return true;
        });
    }

    public void addRowSet(RowSet rowSet) {
        this.flushPendingRange();
        if (rowSet instanceof WritableRowSetImpl) {
            WritableRowSetImpl.addToBuilderFromImpl(this, (WritableRowSetImpl)rowSet);
            return;
        }
        rowSet.forEachRowKeyRange((start, end) -> {
            this.addRange(start, end);
            return true;
        });
    }

    @Override
    public void add(SortedRanges ix, boolean acquire) {
        this.builder.add(ix, acquire);
    }

    @Override
    public void add(RspBitmap ix, boolean acquire) {
        this.builder.add(ix, acquire);
    }
}

