/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.engine.rowset.RowSet;

public class ComplementRangeIterator
implements RowSet.RangeIterator {
    private final RowSet.RangeIterator it;
    private long currStart;
    private long currEnd;
    private long nextStart;
    private long nextEnd;

    public ComplementRangeIterator(RowSet.RangeIterator it) {
        this.it = it;
        this.currStart = -1L;
        this.currEnd = -1L;
        if (!it.hasNext()) {
            this.nextStart = 0L;
            this.nextEnd = Long.MAX_VALUE;
            return;
        }
        it.next();
        this.nextEnd = it.currentRangeStart() - 1L;
        if (this.nextEnd == -1L) {
            if (it.currentRangeEnd() == Long.MAX_VALUE) {
                return;
            }
            this.nextStart = it.currentRangeEnd() + 1L;
            if (it.hasNext()) {
                it.next();
                this.nextEnd = it.currentRangeStart() - 1L;
            } else {
                this.nextEnd = Long.MAX_VALUE;
            }
            return;
        }
        this.nextStart = 0L;
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public boolean hasNext() {
        return this.nextEnd != -1L && this.currEnd != Long.MAX_VALUE;
    }

    @Override
    public boolean advance(long v) {
        if (this.currStart == -1L) {
            if (!this.hasNext()) {
                return false;
            }
            this.next();
        }
        if (v <= this.currStart) {
            return true;
        }
        if (v <= this.currEnd) {
            this.currStart = v;
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        if (v <= this.nextEnd) {
            this.next();
            if (this.currStart < v) {
                this.currStart = v;
            }
            return true;
        }
        boolean valid = this.it.advance(v);
        if (!valid) {
            this.currStart = v;
            this.currEnd = Long.MAX_VALUE;
            this.nextEnd = -1L;
            return true;
        }
        if (v < this.it.currentRangeStart()) {
            this.currStart = v;
            this.currEnd = this.it.currentRangeStart() - 1L;
            if (!this.it.hasNext()) {
                if (this.it.currentRangeEnd() == Long.MAX_VALUE) {
                    this.nextEnd = -1L;
                    return true;
                }
                this.nextStart = this.it.currentRangeEnd() + 1L;
                this.nextEnd = Long.MAX_VALUE;
                return true;
            }
            this.nextStart = this.it.currentRangeEnd() + 1L;
            this.it.next();
            this.nextEnd = this.it.currentRangeStart() - 1L;
            return true;
        }
        if (!this.it.hasNext()) {
            if (this.it.currentRangeEnd() == Long.MAX_VALUE) {
                this.nextEnd = -1L;
                return false;
            }
            this.currStart = this.it.currentRangeEnd() + 1L;
            this.currEnd = Long.MAX_VALUE;
            this.nextEnd = -1L;
            return true;
        }
        this.currStart = this.it.currentRangeEnd() + 1L;
        this.it.next();
        this.currEnd = this.it.currentRangeStart() - 1L;
        if (!this.it.hasNext()) {
            if (this.it.currentRangeEnd() == Long.MAX_VALUE) {
                this.nextEnd = -1L;
                return true;
            }
            this.nextStart = this.it.currentRangeEnd() + 1L;
            this.nextEnd = Long.MAX_VALUE;
            return true;
        }
        this.nextStart = this.it.currentRangeEnd() + 1L;
        this.it.next();
        this.nextEnd = this.it.currentRangeStart() - 1L;
        return true;
    }

    @Override
    public void postpone(long v) {
        this.currStart = v;
    }

    @Override
    public long currentRangeStart() {
        return this.currStart;
    }

    @Override
    public long currentRangeEnd() {
        return this.currEnd;
    }

    @Override
    public long next() {
        this.currStart = this.nextStart;
        this.currEnd = this.nextEnd;
        if (this.it.currentRangeEnd() == Long.MAX_VALUE) {
            this.nextEnd = -1L;
            return this.currStart;
        }
        this.nextStart = this.it.currentRangeEnd() + 1L;
        if (this.it.hasNext()) {
            this.it.next();
            this.nextEnd = this.it.currentRangeStart() - 1L;
        } else {
            this.nextEnd = Long.MAX_VALUE;
        }
        return this.currStart;
    }
}

