/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import gnu.trove.list.array.TShortArrayList;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;

public class ExternalizableRowSetUtils {
    private static final byte SHORT_VALUE = 1;
    private static final byte INT_VALUE = 2;
    private static final byte LONG_VALUE = 3;
    private static final byte BYTE_VALUE = 4;
    private static final byte VALUE_MASK = 7;
    private static final byte OFFSET = 8;
    private static final byte SHORT_ARRAY = 16;
    private static final byte BYTE_ARRAY = 24;
    private static final byte END = 32;
    private static final byte CMD_MASK = 120;

    public static void writeExternalCompressedDeltas(@NotNull DataOutput out, @NotNull RowSet rowSet) throws IOException {
        long offset = 0L;
        TShortArrayList shorts = new TShortArrayList();
        RowSet.RangeIterator it = rowSet.rangeIterator();
        while (it.hasNext()) {
            it.next();
            if (it.currentRangeEnd() == it.currentRangeStart()) {
                offset = ExternalizableRowSetUtils.appendWithOffsetDelta(out, shorts, offset, it.currentRangeStart(), false);
                continue;
            }
            offset = ExternalizableRowSetUtils.appendWithOffsetDelta(out, shorts, offset, it.currentRangeStart(), false);
            offset = ExternalizableRowSetUtils.appendWithOffsetDelta(out, shorts, offset, it.currentRangeEnd(), true);
        }
        ExternalizableRowSetUtils.flushShorts(out, shorts);
        out.writeByte(32);
    }

    private static long appendWithOffsetDelta(@NotNull DataOutput out, @NotNull TShortArrayList shorts, long offset, long value, boolean negate) throws IOException {
        if (value >= offset + 32767L) {
            ExternalizableRowSetUtils.flushShorts(out, shorts);
            long newValue = value - offset;
            ExternalizableRowSetUtils.writeValue(out, (byte)8, negate ? -newValue : newValue);
            return value;
        }
        if (negate) {
            shorts.add((short)(-(value - offset)));
        } else {
            shorts.add((short)(value - offset));
        }
        return value;
    }

    private static void flushShorts(@NotNull DataOutput out, @NotNull TShortArrayList shorts) throws IOException {
        int offset = 0;
        while (offset < shorts.size()) {
            int byteCount = 0;
            while (offset + byteCount < shorts.size() && shorts.getQuick(offset + byteCount) < 127 && shorts.getQuick(offset + byteCount) > -128) {
                ++byteCount;
            }
            if (byteCount > 3 || byteCount + offset == shorts.size()) {
                if (byteCount == 1) {
                    ExternalizableRowSetUtils.writeValue(out, (byte)8, shorts.getQuick(offset));
                } else {
                    ExternalizableRowSetUtils.writeValue(out, (byte)24, byteCount);
                    for (int ii = offset; ii < offset + byteCount; ++ii) {
                        out.writeByte(shorts.getQuick(ii));
                    }
                }
                offset += byteCount;
                continue;
            }
            int shortCount = byteCount;
            int consecutiveBytes = 0;
            while (shortCount + consecutiveBytes + offset < shorts.size()) {
                boolean requiresShort;
                short shortValue = shorts.getQuick(offset + shortCount + consecutiveBytes);
                boolean bl = requiresShort = shortValue >= 127 || shortValue <= -128;
                if (!requiresShort) {
                    ++consecutiveBytes;
                } else {
                    consecutiveBytes = 0;
                    shortCount += consecutiveBytes;
                    ++shortCount;
                }
                if (consecutiveBytes <= 3) continue;
                break;
            }
            if (consecutiveBytes > 0 && consecutiveBytes <= 3 && offset + shortCount + consecutiveBytes == shorts.size()) {
                shortCount += consecutiveBytes;
            }
            if (shortCount >= 2) {
                ExternalizableRowSetUtils.writeValue(out, (byte)16, shortCount);
                for (int ii = offset; ii < offset + shortCount; ++ii) {
                    out.writeShort(shorts.getQuick(ii));
                }
            } else if (shortCount == 1) {
                ExternalizableRowSetUtils.writeValue(out, (byte)8, shorts.getQuick(offset));
            }
            offset += shortCount;
        }
        shorts.resetQuick();
    }

    private static void writeValue(@NotNull DataOutput out, byte command, long value) throws IOException {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            out.writeByte(command | 3);
            out.writeLong(value);
        } else if (value > 32767L || value < -32768L) {
            out.writeByte(command | 2);
            out.writeInt((int)value);
        } else if (value > 127L || value < -128L) {
            out.writeByte(command | 1);
            out.writeShort((short)value);
        } else {
            out.writeByte(command | 4);
            out.writeByte((byte)value);
        }
    }

    public static RowSet readExternalCompressedDelta(@NotNull DataInput in) throws IOException {
        long offset = 0L;
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        MutableLong pending = new MutableLong(-1L);
        LongConsumer consume = v -> {
            long s = pending.longValue();
            if (s == -1L) {
                pending.setValue(v);
            } else if (v < 0L) {
                builder.appendRange(s, -v);
                pending.setValue(-1L);
            } else {
                builder.appendKey(s);
                pending.setValue(v);
            }
        };
        block6: while (true) {
            byte command = in.readByte();
            switch (command & 0x78) {
                case 8: {
                    long value = ExternalizableRowSetUtils.readValue(in, command);
                    long actualValue = offset + (value < 0L ? -value : value);
                    consume.accept(value < 0L ? -actualValue : actualValue);
                    offset = actualValue;
                    break;
                }
                case 16: {
                    long actualValue;
                    int shortCount = (int)ExternalizableRowSetUtils.readValue(in, command);
                    int ii = 0;
                    while (true) {
                        if (ii >= shortCount) continue block6;
                        short shortValue = in.readShort();
                        actualValue = offset + (long)(shortValue < 0 ? -shortValue : shortValue);
                        consume.accept(shortValue < 0 ? -actualValue : actualValue);
                        offset = actualValue;
                        ++ii;
                    }
                }
                case 24: {
                    long actualValue;
                    int byteCount = (int)ExternalizableRowSetUtils.readValue(in, command);
                    int ii = 0;
                    while (true) {
                        if (ii >= byteCount) continue block6;
                        byte byteValue = in.readByte();
                        actualValue = offset + (long)(byteValue < 0 ? -byteValue : byteValue);
                        consume.accept(byteValue < 0 ? -actualValue : actualValue);
                        offset = actualValue;
                        ++ii;
                    }
                }
                case 32: {
                    break block6;
                }
                default: {
                    throw new IllegalStateException("Bad command: " + command);
                }
            }
        }
        if (pending.longValue() >= 0L) {
            builder.appendKey(pending.longValue());
        }
        return builder.build();
    }

    private static long readValue(@NotNull DataInput in, int command) throws IOException {
        long value;
        switch (command & 7) {
            case 3: {
                value = in.readLong();
                break;
            }
            case 2: {
                value = in.readInt();
                break;
            }
            case 1: {
                value = in.readShort();
                break;
            }
            case 4: {
                value = in.readByte();
                break;
            }
            default: {
                throw new IllegalStateException("Bad command: " + command);
            }
        }
        return value;
    }
}

