/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.RangePriorityQueueBuilder;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;

public class MixedBuilderRandom
implements OrderedLongSet.BuilderRandom {
    protected RangePriorityQueueBuilder pqb;
    private OrderedLongSet accumIndex = null;
    private static final int pqSizeThreshold = Configuration.getInstance().getIntegerForClassWithDefault(MixedBuilderRandom.class, "pqSizeThreshold", 0x200000);
    private static final int addAsIndexThreshold = Configuration.getInstance().getIntegerForClassWithDefault(MixedBuilderRandom.class, "addAsIndexThreshold", 65536);

    public MixedBuilderRandom(int pqInitialCapacity) {
        this.pqb = new RangePriorityQueueBuilder(pqInitialCapacity);
    }

    private void merge(OrderedLongSet ix) {
        if (this.accumIndex == null) {
            this.accumIndex = ix;
            return;
        }
        this.accumIndex = this.accumIndex.ixInsert(ix);
        ix.ixRelease();
    }

    private void newPq() {
        this.pqb.reset();
    }

    private void checkPqSize() {
        if (this.pqb.size() < pqSizeThreshold) {
            return;
        }
        OrderedLongSet ix = this.pqb.getOrderedLongSetAndReset();
        this.merge(ix);
        this.newPq();
    }

    @Override
    public void addKey(long key) {
        this.checkPqSize();
        this.pqb.addKey(key);
    }

    @Override
    public void addRange(long startKey, long endKey) {
        this.checkPqSize();
        this.pqb.addRange(startKey, endKey);
    }

    private void addOrderedLongSet(OrderedLongSet ix) {
        if (ix.ixCardinality() >= (long)addAsIndexThreshold) {
            this.merge(ix.ixCowRef());
            return;
        }
        ix.ixForEachLongRange((start, end) -> {
            this.addRange(start, end);
            return true;
        });
    }

    @Override
    public void add(SortedRanges ix, boolean acquire) {
        this.addOrderedLongSet(ix);
    }

    @Override
    public void add(RspBitmap ix, boolean acquire) {
        this.addOrderedLongSet(ix);
    }

    @Override
    public OrderedLongSet getOrderedLongSet() {
        OrderedLongSet ix = this.pqb.getOrderedLongSet();
        this.pqb = null;
        this.merge(ix);
        OrderedLongSet ans = this.accumIndex;
        this.accumIndex = null;
        return ans;
    }
}

