/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.util.LongChunkIterator;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.OrderedLongSetBuilderSequential;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeConsumer;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;

public interface OrderedLongSet {
    public static final OrderedLongSet EMPTY = new OrderedLongSet(){

        @Override
        public OrderedLongSet ixCowRef() {
            return this;
        }

        @Override
        public void ixRelease() {
        }

        @Override
        public int ixRefCount() {
            return 1;
        }

        @Override
        public OrderedLongSet ixInsert(long key) {
            return SingleRange.make(key, key);
        }

        @Override
        public OrderedLongSet ixInsertRange(long startKey, long endKey) {
            return SingleRange.make(startKey, endKey);
        }

        @Override
        public OrderedLongSet ixInsertSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
            return OrderedLongSet.fromChunk(keys, offset, length, false);
        }

        @Override
        public OrderedLongSet ixRemoveSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
            throw new IllegalStateException();
        }

        @Override
        public OrderedLongSet ixAppendRange(long startKey, long endKey) {
            return this.ixInsertRange(startKey, endKey);
        }

        @Override
        public OrderedLongSet ixRemove(long key) {
            return this;
        }

        @Override
        public long ixLastKey() {
            return -1L;
        }

        @Override
        public long ixFirstKey() {
            return -1L;
        }

        @Override
        public boolean ixForEachLong(LongAbortableConsumer lc) {
            return true;
        }

        @Override
        public boolean ixForEachLongRange(LongRangeAbortableConsumer larc) {
            return true;
        }

        @Override
        public OrderedLongSet ixSubindexByPosOnNew(long startPos, long endPos) {
            return this;
        }

        @Override
        public OrderedLongSet ixSubindexByKeyOnNew(long startKey, long endKey) {
            return this;
        }

        @Override
        public long ixGet(long pos) {
            return -1L;
        }

        @Override
        public long ixFind(long key) {
            return -1L;
        }

        @Override
        public void ixGetKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
            while (inputPositions.hasNext()) {
                inputPositions.nextLong();
                outputKeys.accept(-1L);
            }
        }

        @Override
        public RowSet.Iterator ixIterator() {
            return RowSet.EMPTY_ITERATOR;
        }

        @Override
        public RowSet.SearchIterator ixSearchIterator() {
            return RowSet.EMPTY_ITERATOR;
        }

        @Override
        public RowSet.SearchIterator ixReverseIterator() {
            return RowSet.EMPTY_ITERATOR;
        }

        @Override
        public RowSet.RangeIterator ixRangeIterator() {
            return RowSet.RangeIterator.empty;
        }

        @Override
        public long ixCardinality() {
            return 0L;
        }

        @Override
        public boolean ixIsEmpty() {
            return true;
        }

        @Override
        public OrderedLongSet ixUpdate(OrderedLongSet added, OrderedLongSet removed) {
            if (added.ixIsEmpty()) {
                return this;
            }
            return added.ixCowRef();
        }

        @Override
        public OrderedLongSet ixRemove(OrderedLongSet removed) {
            return this;
        }

        @Override
        public OrderedLongSet ixRemoveRange(long startKey, long endKey) {
            return this;
        }

        @Override
        public OrderedLongSet ixRetain(OrderedLongSet toIntersect) {
            return this;
        }

        @Override
        public OrderedLongSet ixRetainRange(long start, long end) {
            return this;
        }

        @Override
        public OrderedLongSet ixIntersectOnNew(OrderedLongSet range) {
            return this;
        }

        @Override
        public boolean ixContainsRange(long start, long end) {
            return false;
        }

        @Override
        public boolean ixOverlaps(OrderedLongSet impl) {
            return false;
        }

        @Override
        public boolean ixOverlapsRange(long start, long end) {
            return false;
        }

        @Override
        public boolean ixSubsetOf(OrderedLongSet impl) {
            return true;
        }

        @Override
        public OrderedLongSet ixMinusOnNew(OrderedLongSet set) {
            return this;
        }

        @Override
        public OrderedLongSet ixUnionOnNew(OrderedLongSet set) {
            return set.ixCowRef();
        }

        @Override
        public OrderedLongSet ixShiftOnNew(long shiftAmount) {
            return this;
        }

        @Override
        public OrderedLongSet ixShiftInPlace(long shiftAmount) {
            return this;
        }

        @Override
        public OrderedLongSet ixInsert(OrderedLongSet added) {
            return added.ixCowRef();
        }

        @Override
        public OrderedLongSet ixInsertWithShift(long shiftAmount, OrderedLongSet other) {
            return other.ixShiftOnNew(shiftAmount);
        }

        @Override
        public RowSequence ixGetRowSequenceByPosition(long startPositionInclusive, long length) {
            return RowSequenceFactory.EMPTY;
        }

        @Override
        public RowSequence ixGetRowSequenceByKeyRange(long startKeyInclusive, long endKeyInclusive) {
            return RowSequenceFactory.EMPTY;
        }

        @Override
        public RowSequence.Iterator ixGetRowSequenceIterator() {
            return RowSequenceFactory.EMPTY_ITERATOR;
        }

        @Override
        public long ixRangesCountUpperBound() {
            return 0L;
        }

        @Override
        public long ixGetAverageRunLengthEstimate() {
            return 1L;
        }

        @Override
        public OrderedLongSet ixInvertOnNew(OrderedLongSet keys, long maximumPosition) {
            return this;
        }

        @Override
        public OrderedLongSet ixCompact() {
            return this;
        }

        @Override
        public void ixValidate(String failmsg) {
        }

        @Override
        public RspBitmap ixToRspOnNew() {
            return new RspBitmap();
        }

        public String toString() {
            return "EMPTY";
        }
    };

    public OrderedLongSet ixCowRef();

    public void ixRelease();

    @VisibleForTesting
    public int ixRefCount();

    public OrderedLongSet ixInsert(long var1);

    public OrderedLongSet ixInsertRange(long var1, long var3);

    @FinalDefault
    default public OrderedLongSet ixInsert(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        if (length <= 1) {
            if (length == 0) {
                return this;
            }
            return this.ixInsert(keys.get(offset));
        }
        int lastOffsetInclusive = offset + length - 1;
        long first = keys.get(offset);
        long last = keys.get(lastOffsetInclusive);
        if (last - first + 1L == (long)length) {
            return this.ixInsertRange(first, last);
        }
        return this.ixInsertSecondHalf(keys, offset, length);
    }

    public OrderedLongSet ixInsertSecondHalf(LongChunk<OrderedRowKeys> var1, int var2, int var3);

    public OrderedLongSet ixInsert(OrderedLongSet var1);

    public OrderedLongSet ixAppendRange(long var1, long var3);

    public OrderedLongSet ixRemove(long var1);

    public OrderedLongSet ixRemoveRange(long var1, long var3);

    @FinalDefault
    default public OrderedLongSet ixRemove(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        if (this.ixIsEmpty()) {
            return this;
        }
        if (length <= 1) {
            if (length == 0) {
                return this;
            }
            return this.ixRemove(keys.get(offset));
        }
        int lastOffsetInclusive = offset + length - 1;
        long first = keys.get(offset);
        long last = keys.get(lastOffsetInclusive);
        if (last - first + 1L == (long)length) {
            return this.ixRemoveRange(first, last);
        }
        return this.ixRemoveSecondHalf(keys, offset, length);
    }

    public OrderedLongSet ixRemoveSecondHalf(LongChunk<OrderedRowKeys> var1, int var2, int var3);

    public OrderedLongSet ixRemove(OrderedLongSet var1);

    public long ixLastKey();

    public long ixFirstKey();

    public boolean ixForEachLong(LongAbortableConsumer var1);

    public boolean ixForEachLongRange(LongRangeAbortableConsumer var1);

    public OrderedLongSet ixSubindexByPosOnNew(long var1, long var3);

    public OrderedLongSet ixSubindexByKeyOnNew(long var1, long var3);

    public long ixGet(long var1);

    public void ixGetKeysForPositions(PrimitiveIterator.OfLong var1, LongConsumer var2);

    public long ixFind(long var1);

    public RowSet.Iterator ixIterator();

    public RowSet.SearchIterator ixSearchIterator();

    public RowSet.SearchIterator ixReverseIterator();

    public RowSet.RangeIterator ixRangeIterator();

    public long ixCardinality();

    public boolean ixIsEmpty();

    public OrderedLongSet ixUpdate(OrderedLongSet var1, OrderedLongSet var2);

    public OrderedLongSet ixRetain(OrderedLongSet var1);

    public OrderedLongSet ixRetainRange(long var1, long var3);

    public OrderedLongSet ixIntersectOnNew(OrderedLongSet var1);

    public boolean ixContainsRange(long var1, long var3);

    public boolean ixOverlaps(OrderedLongSet var1);

    public boolean ixOverlapsRange(long var1, long var3);

    public boolean ixSubsetOf(OrderedLongSet var1);

    public OrderedLongSet ixMinusOnNew(OrderedLongSet var1);

    public OrderedLongSet ixUnionOnNew(OrderedLongSet var1);

    public OrderedLongSet ixShiftOnNew(long var1);

    public OrderedLongSet ixShiftInPlace(long var1);

    public OrderedLongSet ixInsertWithShift(long var1, OrderedLongSet var3);

    public RowSequence ixGetRowSequenceByPosition(long var1, long var3);

    public RowSequence ixGetRowSequenceByKeyRange(long var1, long var3);

    public RowSequence.Iterator ixGetRowSequenceIterator();

    public long ixRangesCountUpperBound();

    public long ixGetAverageRunLengthEstimate();

    public RspBitmap ixToRspOnNew();

    public OrderedLongSet ixInvertOnNew(OrderedLongSet var1, long var2);

    public OrderedLongSet ixCompact();

    public void ixValidate(String var1);

    default public void ixValidate() {
        this.ixValidate(null);
    }

    public static OrderedLongSet fromChunk(LongChunk<OrderedRowKeys> keys, int offset, int length, boolean disposable) {
        if (length == 0) {
            return EMPTY;
        }
        int lastOffsetInclusive = offset + length - 1;
        long first = keys.get(offset);
        long last = keys.get(lastOffsetInclusive);
        if (last - first + 1L == (long)length) {
            return SingleRange.make(first, last);
        }
        OrderedLongSetBuilderSequential builder = new OrderedLongSetBuilderSequential(disposable);
        builder.appendKey(first);
        for (int ki = offset + 1; ki < lastOffsetInclusive; ++ki) {
            builder.appendKey(keys.get(ki));
        }
        builder.appendKey(last);
        return builder.getOrderedLongSet();
    }

    public static OrderedLongSet twoRanges(long s1, long e1, long s2, long e2) {
        SortedRanges sr = SortedRanges.tryMakeForKnownRangeKnownCount(4, s1, e2);
        if (sr != null) {
            sr = sr.appendRangeUnsafe(s1, e1).appendRangeUnsafe(s2, e2).tryCompactUnsafe(4);
            return sr;
        }
        RspBitmap ans = new RspBitmap(s1, e1);
        ans.appendRangeUnsafeNoWriteCheck(s2, e2);
        ans.finishMutationsAndOptimize();
        return ans;
    }

    public static RspBitmap asRspBitmap(OrderedLongSet t) {
        return t instanceof RspBitmap ? (RspBitmap)t : t.ixToRspOnNew();
    }

    public static interface BuilderRandom
    extends BuilderSequential {
        public void addKey(long var1);

        public void addRange(long var1, long var3);

        @Override
        default public void appendKey(long key) {
            this.addKey(key);
        }

        @Override
        default public void appendRange(long firstKey, long lastKey) {
            this.addRange(firstKey, lastKey);
        }

        default public void add(SingleRange ix) {
            this.addRange(ix.ixFirstKey(), ix.ixLastKey());
        }

        public void add(SortedRanges var1, boolean var2);

        public void add(RspBitmap var1, boolean var2);

        @Override
        default public void accept(long firstKey, long lastKey) {
            this.appendRange(firstKey, lastKey);
        }
    }

    public static interface BuilderSequential
    extends LongRangeConsumer {
        public static final boolean check = Configuration.getInstance().getBooleanForClassWithDefault(OrderedLongSet.class, "sequentialBuilderCheck", true);
        public static final String outOfOrderKeyErrorMsg = "Out of order key(s) in sequential builder: ";

        default public void setDomain(long minKey, long maxKey) {
        }

        public OrderedLongSet getOrderedLongSet();

        public void appendKey(long var1);

        public void appendRange(long var1, long var3);

        default public void appendOrderedLongSet(long shiftAmount, OrderedLongSet ix, boolean acquire) {
            ix.ixForEachLongRange((start, last) -> {
                this.appendRange(start + shiftAmount, last + shiftAmount);
                return true;
            });
        }

        default public void appendOrderedRowKeysChunk(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
            LongChunkIterator it = new LongChunkIterator(chunk, offset, length);
            while (it.hasNext()) {
                this.appendKey(it.nextLong());
            }
        }

        default public void accept(long firstKey, long lastKey) {
            this.appendRange(firstKey, lastKey);
        }
    }
}

