/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.RowSetCounts;
import io.deephaven.engine.rowset.impl.RspBitmapBuilderSequential;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.annotations.TestUseOnly;

public class OrderedLongSetBuilderSequential
extends RspBitmapBuilderSequential {
    private SortedRanges pendingSr;
    private static final RowSetCounts rowSetCounts = new RowSetCounts("orderedLongSetBuilderSequential");

    public OrderedLongSetBuilderSequential() {
        this(false);
    }

    public OrderedLongSetBuilderSequential(boolean disposable) {
        super(disposable);
    }

    @Override
    public OrderedLongSet getOrderedLongSet() {
        if (this.pendingStart != -1L) {
            if (this.pendingSr == null && this.pendingContainerKey == -1L && this.rb == null) {
                SingleRange r = SingleRange.make(this.pendingStart, this.pendingEnd);
                rowSetCounts.sampleSingleRange(r);
                return r;
            }
            this.flushPendingRange();
        }
        if (this.pendingSr != null) {
            this.pendingSr = this.pendingSr.tryCompactUnsafe(4);
            rowSetCounts.sampleSortedRanges(this.pendingSr);
            return this.pendingSr;
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (this.rb == null) {
            rowSetCounts.sampleEmpty();
            return OrderedLongSet.EMPTY;
        }
        this.rb.tryCompactUnsafe(4);
        this.rb.finishMutations();
        rowSetCounts.sampleRsp(this.rb);
        RspBitmap ans = this.rb;
        this.rb = null;
        return ans;
    }

    @TestUseOnly
    public RspBitmap getRspBitmap() {
        if (this.pendingStart != -1L) {
            this.flushPendingRange();
        }
        if (this.pendingSr != null) {
            this.flushSrToRsp();
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (this.rb == null) {
            return null;
        }
        this.rb.tryCompactUnsafe(4);
        this.rb.finishMutations();
        RspBitmap ans = this.rb;
        this.rb = null;
        return ans;
    }

    @Override
    public void appendOrderedLongSet(long shiftAmount, OrderedLongSet ix, boolean acquire) {
        if (ix.ixIsEmpty()) {
            return;
        }
        if (!(ix instanceof RspBitmap) || this.rb == null) {
            ix.ixForEachLongRange((start, end) -> {
                this.appendRange(start + shiftAmount, end + shiftAmount);
                return true;
            });
            return;
        }
        if (this.pendingStart != -1L) {
            this.flushPendingRange();
        }
        if (this.pendingSr != null) {
            this.flushSrToRsp();
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (this.rb.isEmpty()) {
            this.rb.ixInsert(ix);
            return;
        }
        this.rb.appendShiftedUnsafeNoWriteCheck(shiftAmount, (RspBitmap)ix, acquire);
    }

    @Override
    protected void flushPendingRange() {
        long pendingStartOnEntry = this.pendingStart;
        this.pendingStart = -1L;
        if (this.pendingContainerKey != -1L || this.rb != null) {
            this.flushRangeToPendingContainer(pendingStartOnEntry, this.pendingEnd);
            return;
        }
        if (this.pendingSr == null) {
            if (this.maxKeyHint != -1L) {
                this.pendingSr = SortedRanges.makeForKnownRange(pendingStartOnEntry, this.maxKeyHint, false);
                this.pendingSr = this.pendingSr.appendRangeUnsafe(pendingStartOnEntry, this.pendingEnd);
            } else {
                this.pendingSr = SortedRanges.makeSingleRange(pendingStartOnEntry, this.pendingEnd);
            }
            return;
        }
        SortedRanges ans = this.pendingSr.appendRangeUnsafe(pendingStartOnEntry, this.pendingEnd);
        if (ans == null) {
            this.flushSrToRsp();
            this.flushRangeToPendingContainer(pendingStartOnEntry, this.pendingEnd);
            return;
        }
        this.pendingSr = ans;
    }

    private void flushSrToRsp() {
        this.pendingSr.forEachLongRange((start, end) -> {
            this.flushRangeToPendingContainer(start, end);
            return true;
        });
        this.pendingSr = null;
    }
}

