/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.impl.MixedBuilderRandom;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.OrderedLongSetBuilderSequential;

public class RangePriorityQueueBuilder {
    private static final int doublingAllocThreshold = Configuration.getInstance().getIntegerForClassWithDefault(MixedBuilderRandom.class, "doublingAllocThreshold", 131072);
    private static final int linearAllocStep = Configuration.getInstance().getIntegerForClassWithDefault(MixedBuilderRandom.class, "linearAllocStep", 131072);
    private long[] start;
    private long[] end;
    private int lastEntered = -1;
    private int size = 0;

    RangePriorityQueueBuilder(int initialCapacity) {
        this.start = new long[initialCapacity + 1];
        this.end = new long[initialCapacity + 1];
    }

    void reset() {
        this.lastEntered = -1;
        this.size = 0;
    }

    private boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    private void ensureCapacityFor(int lastIndex) {
        int newCapacity;
        int minCapacity = lastIndex + 1;
        if (minCapacity < this.start.length) {
            return;
        }
        for (newCapacity = this.start.length; newCapacity < minCapacity && newCapacity < doublingAllocThreshold; newCapacity = 2 * newCapacity) {
        }
        if (newCapacity < minCapacity) {
            int delta = minCapacity - doublingAllocThreshold;
            int steps = (delta + linearAllocStep - 1) / linearAllocStep;
            newCapacity = doublingAllocThreshold + steps * linearAllocStep;
        }
        long[] newStart = new long[newCapacity];
        System.arraycopy(this.start, 1, newStart, 1, this.size);
        this.start = newStart;
        long[] newEnd = new long[newCapacity];
        System.arraycopy(this.end, 1, newEnd, 1, this.size);
        this.end = newEnd;
    }

    private void enter(long startKey, long endKey) {
        if (this.lastEntered >= 1 && endKey >= this.start[this.lastEntered] - 1L && startKey <= this.end[this.lastEntered] + 1L) {
            if (endKey > this.end[this.lastEntered]) {
                this.end[this.lastEntered] = endKey;
            }
            if (startKey < this.start[this.lastEntered]) {
                this.start[this.lastEntered] = startKey;
                this.fixUp(this.lastEntered);
            }
            return;
        }
        int newSize = this.size + 1;
        this.ensureCapacityFor(newSize);
        this.start[newSize] = startKey;
        this.end[newSize] = endKey;
        this.lastEntered = this.size = newSize;
        this.fixUp(this.size);
    }

    private long topStart() {
        return this.start[1];
    }

    private long topEnd() {
        return this.end[1];
    }

    int rangeCount() {
        return this.size;
    }

    private boolean removeTop() {
        if (this.size == 0) {
            return false;
        }
        if (--this.size > 0) {
            this.start[1] = this.start[this.size + 1];
            this.end[1] = this.end[this.size + 1];
            this.fixDown(1);
        }
        return true;
    }

    private void fixUp(int itemIndex) {
        if (itemIndex > 1) {
            long itemStartKey = this.start[itemIndex];
            long itemEndKey = this.end[itemIndex];
            int parentIndex = itemIndex >> 1;
            long parent = this.start[parentIndex];
            if (itemStartKey < parent) {
                this.start[itemIndex] = parent;
                this.end[itemIndex] = this.end[parentIndex];
                itemIndex = parentIndex;
                parentIndex = itemIndex >> 1;
                while (itemIndex > 1 && itemStartKey < (parent = this.start[parentIndex])) {
                    this.start[itemIndex] = parent;
                    this.end[itemIndex] = this.end[parentIndex];
                    itemIndex = parentIndex;
                    parentIndex = itemIndex >> 1;
                }
                this.start[itemIndex] = itemStartKey;
                this.end[itemIndex] = itemEndKey;
                this.lastEntered = itemIndex;
            }
        }
    }

    private void fixDown(int itemIndex) {
        int childIndex = itemIndex << 1;
        if (childIndex <= this.size) {
            long child2;
            long itemStartKey = this.start[itemIndex];
            long itmEndKey = this.end[itemIndex];
            long child = this.start[childIndex];
            if (childIndex < this.size && (child2 = this.start[childIndex + 1]) < child) {
                child = child2;
                ++childIndex;
            }
            if (child < itemStartKey) {
                this.start[itemIndex] = child;
                this.end[itemIndex] = this.end[childIndex];
                itemIndex = childIndex;
                childIndex = itemIndex << 1;
                while (childIndex <= this.size) {
                    child = this.start[childIndex];
                    if (childIndex < this.size && (child2 = this.start[childIndex + 1]) < child) {
                        child = child2;
                        ++childIndex;
                    }
                    if (child >= itemStartKey) break;
                    this.start[itemIndex] = child;
                    this.end[itemIndex] = this.end[childIndex];
                    itemIndex = childIndex;
                    childIndex = itemIndex << 1;
                }
                this.start[itemIndex] = itemStartKey;
                this.end[itemIndex] = itmEndKey;
            }
        }
    }

    private void populateSequentialBuilder(OrderedLongSet.BuilderSequential sequentialBuilder) {
        long lastEnd = -1L;
        while (!this.isEmpty()) {
            long firstKey = this.topStart();
            long lastKey = this.topEnd();
            this.removeTop();
            if (lastKey <= lastEnd) continue;
            if (firstKey <= lastEnd) {
                firstKey = lastEnd + 1L;
            }
            sequentialBuilder.appendRange(firstKey, lastKey);
            lastEnd = lastKey;
        }
        this.reset();
    }

    private OrderedLongSet getOrderedLongSetInternal() {
        OrderedLongSetBuilderSequential sequentialBuilder = new OrderedLongSetBuilderSequential();
        this.populateSequentialBuilder(sequentialBuilder);
        return sequentialBuilder.getOrderedLongSet();
    }

    public OrderedLongSet getOrderedLongSet() {
        OrderedLongSet ix = this.getOrderedLongSetInternal();
        this.end = null;
        this.start = null;
        return ix;
    }

    public OrderedLongSet getOrderedLongSetAndReset() {
        OrderedLongSet ix = this.getOrderedLongSetInternal();
        this.reset();
        return ix;
    }

    public void addKey(long key) {
        this.enter(key, key);
    }

    public void addRange(long firstKey, long lastKey) {
        if (firstKey > lastKey) {
            return;
        }
        this.enter(firstKey, lastKey);
    }
}

