/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.util.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class RefCountedCow<T> {
    private static final boolean debug = Configuration.getInstance().getBooleanForClassWithDefault(RefCountedCow.class, "debug", false);
    private static final AtomicIntegerFieldUpdater<RefCountedCow> REFCOUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(RefCountedCow.class, "refCount");
    private volatile int refCount = 1;

    private int getAndIncrementRefCount() {
        return REFCOUNT_UPDATER.getAndIncrement(this);
    }

    private int decrementAndGetRefCount() {
        return REFCOUNT_UPDATER.decrementAndGet(this);
    }

    private int getRefCount() {
        return this.refCount;
    }

    public final void acquire() {
        this.notifyBeforeAcquire();
        int prev = this.getAndIncrementRefCount();
        if (debug) {
            Assert.geqZero((int)prev, (String)"prev");
        }
    }

    public final T cowRef() {
        this.acquire();
        return this.self();
    }

    public final int release() {
        int count = this.decrementAndGetRefCount();
        if (debug) {
            Assert.geqZero((int)count, (String)"prev");
        }
        this.notifyAfterRelease();
        return count;
    }

    @VisibleForTesting
    public final int refCount() {
        return this.getRefCount();
    }

    public abstract T deepCopy();

    protected abstract T self();

    protected void notifyBeforeAcquire() {
    }

    protected void notifyAfterRelease() {
    }

    public T getWriteRef() {
        int count = this.getRefCount();
        if (debug) {
            Assert.gtZero((int)count, (String)"count");
        }
        return count > 1 ? this.deepCopy() : this.self();
    }

    protected boolean canWrite() {
        return this.getRefCount() <= 1;
    }
}

