/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.SizeException;

public class RowKeyChunkUtils {
    public static WritableLongChunk<OrderedRowKeyRanges> convertToOrderedKeyRanges(LongChunk<OrderedRowKeys> chunk) {
        return RowKeyChunkUtils.convertToOrderedKeyRanges(chunk, Integer.MAX_VALUE);
    }

    @VisibleForTesting
    public static WritableLongChunk<OrderedRowKeyRanges> convertToOrderedKeyRanges(LongChunk<OrderedRowKeys> chunk, long maxChunkSize) {
        if (chunk.size() == 0) {
            return WritableLongChunk.makeWritableChunk((int)0);
        }
        long numRanges = 1L;
        for (int idx = 1; idx < chunk.size(); ++idx) {
            if (chunk.get(idx - 1) + 1L == chunk.get(idx)) continue;
            ++numRanges;
        }
        long newSize = numRanges * 2L;
        if (newSize > maxChunkSize) {
            throw new SizeException("Cannot expand RowKeys Chunk into KeyRanges Chunk.", newSize, maxChunkSize);
        }
        WritableLongChunk newChunk = WritableLongChunk.makeWritableChunk((int)((int)newSize));
        RowKeyChunkUtils.convertToOrderedKeyRanges(chunk, (WritableLongChunk<OrderedRowKeyRanges>)newChunk);
        return newChunk;
    }

    public static void convertToOrderedKeyRanges(LongChunk<OrderedRowKeys> chunk, WritableLongChunk<OrderedRowKeyRanges> dest) {
        int destOffset = 0;
        if (chunk.size() == 0) {
            dest.setSize(destOffset);
            return;
        }
        int srcOffset = 0;
        dest.set(destOffset++, chunk.get(srcOffset));
        ++srcOffset;
        while (srcOffset < chunk.size()) {
            if (chunk.get(srcOffset - 1) + 1L != chunk.get(srcOffset)) {
                dest.set(destOffset++, chunk.get(srcOffset - 1));
                dest.set(destOffset++, chunk.get(srcOffset));
            }
            ++srcOffset;
        }
        dest.set(destOffset++, chunk.get(srcOffset - 1));
        dest.setSize(destOffset);
    }

    public static LongChunk<OrderedRowKeys> convertToOrderedKeyIndices(LongChunk<OrderedRowKeyRanges> chunk) {
        return RowKeyChunkUtils.convertToOrderedKeyIndices(0, chunk);
    }

    public static LongChunk<OrderedRowKeys> convertToOrderedKeyIndices(int srcOffset, LongChunk<OrderedRowKeyRanges> chunk) {
        srcOffset += srcOffset % 2;
        long numElements = 0L;
        for (int idx = 0; idx < chunk.size(); idx += 2) {
            numElements += chunk.get(idx + 1) - chunk.get(idx) + 1L;
        }
        if (numElements < 0L || numElements > Integer.MAX_VALUE) {
            throw new SizeException("Cannot expand OrderedRowKeyRanges Chunk into OrderedRowKeys Chunk.", numElements, Integer.MAX_VALUE);
        }
        WritableLongChunk newChunk = WritableLongChunk.makeWritableChunk((int)((int)numElements));
        RowKeyChunkUtils.convertToOrderedKeyIndices(srcOffset, chunk, (WritableLongChunk<OrderedRowKeys>)newChunk, 0);
        return newChunk;
    }

    public static void convertToOrderedKeyIndices(int srcOffset, LongChunk<OrderedRowKeyRanges> chunk, WritableLongChunk<OrderedRowKeys> dest, int destOffset) {
        srcOffset += srcOffset & 1;
        int idx = srcOffset;
        while (idx + 1 < chunk.size() && destOffset < dest.size()) {
            long start = chunk.get(idx);
            long range = chunk.get(idx + 1) - start + 1L;
            for (long jdx = 0L; jdx < range && destOffset < dest.size(); ++jdx) {
                dest.set(destOffset++, start + jdx);
            }
            idx += 2;
        }
        dest.setSize(destOffset);
    }
}

