/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;

public abstract class RowSequenceAsChunkImpl
implements RowSequence {
    private WritableLongChunk<OrderedRowKeys> keyIndicesChunk;
    private boolean keyIndicesChunkInvalidated;
    private WritableLongChunk<OrderedRowKeyRanges> keyRangesChunk;
    private boolean keyRangesChunkInvalidated;

    private void makeKeyIndicesChunk() {
        int isize = this.intSize();
        this.keyIndicesChunk = WritableLongChunk.makeWritableChunk((int)isize);
    }

    protected long runsUpperBound() {
        long size = this.size();
        long range = this.lastRowKey() - this.firstRowKey() + 1L;
        long holesUpperBound = range - size;
        long runsUpperBound = 1L + holesUpperBound;
        return runsUpperBound;
    }

    private int sizeForRangesChunk() {
        long runsUpperBound = this.runsUpperBound();
        if (runsUpperBound <= 1024L) {
            return 2 * (int)runsUpperBound;
        }
        long rangesCount = this.rangesCountUpperBound();
        return 2 * (int)rangesCount;
    }

    private void makeKeyRangesChunk(int size) {
        WritableLongChunk chunk;
        this.keyRangesChunk = chunk = WritableLongChunk.makeWritableChunk((int)size);
    }

    @Override
    public final LongChunk<OrderedRowKeys> asRowKeyChunk() {
        if (this.size() == 0L) {
            return LongChunk.getEmptyChunk();
        }
        if (this.keyIndicesChunk == null || this.keyIndicesChunkInvalidated) {
            if (this.keyIndicesChunk != null) {
                if ((long)this.keyIndicesChunk.capacity() >= this.size()) {
                    this.keyIndicesChunk.setSize(this.keyIndicesChunk.capacity());
                    this.fillRowKeyChunk(this.keyIndicesChunk);
                } else {
                    this.keyIndicesChunk.close();
                    this.keyIndicesChunk = null;
                }
            }
            if (this.keyIndicesChunk == null) {
                this.makeKeyIndicesChunk();
                this.fillRowKeyChunk(this.keyIndicesChunk);
            }
            this.keyIndicesChunkInvalidated = false;
        }
        return this.keyIndicesChunk;
    }

    @Override
    public final LongChunk<OrderedRowKeyRanges> asRowKeyRangesChunk() {
        if (this.size() == 0L) {
            return LongChunk.getEmptyChunk();
        }
        if (this.keyRangesChunk == null || this.keyRangesChunkInvalidated) {
            int size = this.sizeForRangesChunk();
            if (this.keyRangesChunk != null) {
                if (this.keyRangesChunk.capacity() >= size) {
                    this.fillRowKeyRangesChunk(this.keyRangesChunk);
                } else {
                    this.keyRangesChunk.close();
                    this.keyRangesChunk = null;
                }
            }
            if (this.keyRangesChunk == null) {
                this.makeKeyRangesChunk(size);
                this.fillRowKeyRangesChunk(this.keyRangesChunk);
            }
            this.keyRangesChunkInvalidated = false;
        }
        return this.keyRangesChunk;
    }

    @Override
    public abstract long lastRowKey();

    public abstract long rangesCountUpperBound();

    @Override
    public void close() {
        this.closeRowSequenceAsChunkImpl();
    }

    protected final void closeRowSequenceAsChunkImpl() {
        if (this.keyIndicesChunk != null) {
            this.keyIndicesChunk.close();
            this.keyIndicesChunk = null;
        }
        if (this.keyRangesChunk != null) {
            this.keyRangesChunk.close();
            this.keyRangesChunk = null;
        }
    }

    protected final void invalidateRowSequenceAsChunkImpl() {
        this.keyIndicesChunkInvalidated = true;
        this.keyRangesChunkInvalidated = true;
    }
}

