/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.OrderedChunkUtils;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.SizeException;

public class RowSequenceKeyRangesChunkImpl
implements RowSequence {
    private final long minKeyValue;
    private final long maxKeyValue;
    private final LongChunk<OrderedRowKeyRanges> backingChunk;
    private WritableLongChunk<OrderedRowKeyRanges> toReleaseChunk;
    private WritableLongChunk<OrderedRowKeys> asKeyIndicesChunk;
    private WritableLongChunk<OrderedRowKeyRanges> asKeyRangesChunk;
    private long cachedSize = 0L;

    private RowSequenceKeyRangesChunkImpl(LongChunk<OrderedRowKeyRanges> backingChunk, WritableLongChunk<OrderedRowKeyRanges> toReleaseChunk) {
        this.minKeyValue = 0L;
        this.maxKeyValue = Long.MAX_VALUE;
        this.backingChunk = backingChunk;
        this.toReleaseChunk = toReleaseChunk;
        if (backingChunk.size() % 2 != 0) {
            throw new IllegalArgumentException("the backingChunk.size() must be a multiple of two (" + backingChunk.size() + " % 2 != 0)");
        }
    }

    private RowSequenceKeyRangesChunkImpl(WritableLongChunk<OrderedRowKeyRanges> backingChunkToOwn) {
        this((LongChunk<OrderedRowKeyRanges>)backingChunkToOwn, backingChunkToOwn);
    }

    public static RowSequenceKeyRangesChunkImpl makeByTaking(WritableLongChunk<OrderedRowKeyRanges> backingChunkToOwn) {
        return new RowSequenceKeyRangesChunkImpl(backingChunkToOwn);
    }

    private RowSequenceKeyRangesChunkImpl(LongChunk<OrderedRowKeyRanges> backingChunk) {
        this(backingChunk, null);
    }

    public static RowSequenceKeyRangesChunkImpl makeByWrapping(LongChunk<OrderedRowKeyRanges> backingChunk) {
        return new RowSequenceKeyRangesChunkImpl(backingChunk);
    }

    private RowSequenceKeyRangesChunkImpl(LongChunk<OrderedRowKeyRanges> backingChunk, WritableLongChunk<OrderedRowKeyRanges> toReleaseChunk, long minKeyValue, long maxKeyValue) {
        this.minKeyValue = minKeyValue;
        this.maxKeyValue = maxKeyValue;
        this.backingChunk = backingChunk;
        this.toReleaseChunk = toReleaseChunk;
        if (backingChunk.size() % 2 != 0) {
            throw new IllegalArgumentException("the backingChunk.size() must be a multiple of two (" + backingChunk.size() + " % 2 != 0)");
        }
        if (backingChunk.size() > 0) {
            if (this.minKeyValue > backingChunk.get(1)) {
                throw new IllegalArgumentException("minKeyValue is only allowed to apply to first range in chunk (" + this.minKeyValue + " is > " + backingChunk.get(1) + ")");
            }
            if (this.maxKeyValue < backingChunk.get(backingChunk.size() - 2)) {
                throw new IllegalArgumentException("maxKeyValue is only allowed to apply to last range in chunk (" + this.maxKeyValue + " is < " + backingChunk.get(backingChunk.size() - 2) + ")");
            }
        }
    }

    private RowSequenceKeyRangesChunkImpl(LongChunk<OrderedRowKeyRanges> backingChunk, long minKeyValue, long maxKeyValue) {
        this(backingChunk, null, minKeyValue, maxKeyValue);
    }

    private RowSequenceKeyRangesChunkImpl(WritableLongChunk<OrderedRowKeyRanges> backingChunkToOwn, long minKeyValue, long maxKeyValue) {
        this((LongChunk<OrderedRowKeyRanges>)backingChunkToOwn, backingChunkToOwn, minKeyValue, maxKeyValue);
    }

    @Override
    public RowSequence.Iterator getRowSequenceIterator() {
        return new Iterator();
    }

    @Override
    public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        if (length <= 0L) {
            return RowSequenceFactory.EMPTY;
        }
        OffsetHelper helper = new OffsetHelper();
        if (!helper.advanceInPositionSpace(startPositionInclusive)) {
            return RowSequenceFactory.EMPTY;
        }
        int newStartOffset = helper.offset;
        long newMinKeyValue = helper.currKeyValue;
        helper.advanceInPositionSpace(length - 1L);
        int newLen = Math.min(this.backingChunk.size(), helper.offset + 2) - newStartOffset;
        long newMaxKeyValue = helper.currKeyValue;
        if (newLen == 0) {
            return RowSequenceFactory.EMPTY;
        }
        return new RowSequenceKeyRangesChunkImpl((LongChunk<OrderedRowKeyRanges>)this.backingChunk.slice(newStartOffset, newLen), newMinKeyValue, newMaxKeyValue);
    }

    @Override
    public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        int newLen;
        startRowKeyInclusive = Math.max(startRowKeyInclusive, this.minKeyValue);
        endRowKeyInclusive = Math.min(endRowKeyInclusive, this.maxKeyValue);
        int newStartOffset = OrderedChunkUtils.findInChunk(this.backingChunk, (long)startRowKeyInclusive);
        newStartOffset -= newStartOffset % 2;
        int newEndOffset = OrderedChunkUtils.findInChunk(this.backingChunk, (long)endRowKeyInclusive);
        if ((newEndOffset += newEndOffset % 2) < this.backingChunk.size() && this.backingChunk.get(newEndOffset) == endRowKeyInclusive) {
            newEndOffset += 2;
        }
        if ((newLen = newEndOffset - newStartOffset) == 0) {
            return RowSequenceFactory.EMPTY;
        }
        return new RowSequenceKeyRangesChunkImpl((LongChunk<OrderedRowKeyRanges>)this.backingChunk.slice(newStartOffset, newLen), startRowKeyInclusive, endRowKeyInclusive);
    }

    @Override
    public RowSet asRowSet() {
        if (this.backingChunk.size() == 0) {
            return RowSetFactory.empty();
        }
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        long chunkFirst = this.backingChunk.get(0);
        long chunkLast = this.backingChunk.get(this.backingChunk.size() - 1);
        boolean specialStart = this.minKeyValue > chunkFirst;
        boolean specialEnd = this.maxKeyValue < chunkLast;
        builder.setDomain(specialStart ? this.minKeyValue : chunkFirst, specialEnd ? this.maxKeyValue : chunkLast);
        if (specialStart || specialEnd && this.backingChunk.size() == 2) {
            builder.appendRange(Math.max(this.minKeyValue, this.backingChunk.get(0)), Math.min(this.maxKeyValue, this.backingChunk.get(1)));
        }
        int startOffset = specialStart ? 2 : 0;
        int innerLength = this.backingChunk.size() - startOffset - (specialEnd ? 2 : 0);
        if (innerLength > 0) {
            builder.appendOrderedRowKeyRangesChunk((LongChunk<OrderedRowKeyRanges>)this.backingChunk.slice(startOffset, innerLength));
        }
        if (specialEnd && this.backingChunk.size() > 2) {
            builder.appendRange(this.backingChunk.get(this.backingChunk.size() - 2), Math.min(this.maxKeyValue, this.backingChunk.get(this.backingChunk.size() - 1)));
        }
        return builder.build();
    }

    @Override
    public LongChunk<OrderedRowKeys> asRowKeyChunk() {
        if (this.backingChunk.size() <= 0) {
            return LongChunk.getEmptyChunk();
        }
        if (this.asKeyIndicesChunk == null) {
            long chunkSize = this.size();
            if (chunkSize > Integer.MAX_VALUE) {
                throw new SizeException("Cannot create LongChunk<OrderedRowKeys>; too many values.", this.size(), Integer.MAX_VALUE);
            }
            this.asKeyIndicesChunk = WritableLongChunk.makeWritableChunk((int)Math.toIntExact(chunkSize));
            this.fillRowKeyChunk(this.asKeyIndicesChunk);
        }
        return this.asKeyIndicesChunk;
    }

    @Override
    public LongChunk<OrderedRowKeyRanges> asRowKeyRangesChunk() {
        if (this.backingChunk.size() <= 0) {
            return LongChunk.getEmptyChunk();
        }
        if (this.asKeyRangesChunk == null) {
            this.asKeyRangesChunk = WritableLongChunk.makeWritableChunk((int)this.backingChunk.size());
            this.backingChunk.copyToChunk(0, this.asKeyRangesChunk, 0, this.backingChunk.size());
            this.asKeyRangesChunk.set(0, Math.max(this.minKeyValue, this.asKeyRangesChunk.get(0)));
            this.asKeyRangesChunk.set(this.backingChunk.size() - 1, Math.min(this.maxKeyValue, this.asKeyRangesChunk.get(this.backingChunk.size() - 1)));
        }
        return this.asKeyRangesChunk;
    }

    @Override
    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        chunkToFill.setSize(0);
        this.perKeyIndex(v -> {
            chunkToFill.add(v);
            return true;
        });
    }

    @Override
    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        int newSize = this.backingChunk.size();
        newSize -= newSize & 1;
        this.backingChunk.copyToChunk(0, chunkToFill, 0, newSize);
        chunkToFill.setSize(newSize);
        chunkToFill.set(0, Math.max(this.minKeyValue, chunkToFill.get(0)));
        chunkToFill.set(newSize - 1, Math.min(this.maxKeyValue, chunkToFill.get(newSize - 1)));
    }

    @Override
    public boolean isEmpty() {
        return this.backingChunk.size() == 0;
    }

    @Override
    public long firstRowKey() {
        return this.backingChunk.size() == 0 ? -1L : Math.max(this.minKeyValue, this.backingChunk.get(0));
    }

    @Override
    public long lastRowKey() {
        int sz = this.backingChunk.size();
        return sz == 0 ? -1L : Math.min(this.maxKeyValue, this.backingChunk.get(sz - 1));
    }

    @Override
    public long size() {
        if (this.cachedSize > 0L) {
            return this.cachedSize;
        }
        int idx = 0;
        while (idx + 1 < this.backingChunk.size()) {
            long start = Math.max(this.minKeyValue, this.backingChunk.get(idx));
            this.cachedSize += Math.min(this.maxKeyValue, this.backingChunk.get(idx + 1)) - start + 1L;
            idx += 2;
        }
        if (this.cachedSize < 0L) {
            this.cachedSize = Long.MAX_VALUE;
        }
        return this.cachedSize;
    }

    @Override
    public long getAverageRunLengthEstimate() {
        int numRanges = this.backingChunk.size() / 2;
        return numRanges == 0 ? 1L : Math.max(1L, this.size() / (long)numRanges);
    }

    private boolean forEachInRange(long start, long endInclusive, LongAbortableConsumer lc) {
        for (long v = start; v <= endInclusive; ++v) {
            if (lc.accept(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachRowKey(LongAbortableConsumer lc) {
        long e;
        long s;
        int i;
        if (this.backingChunk.size() == 0) {
            return true;
        }
        long s0 = this.backingChunk.get(0);
        long e0 = this.backingChunk.get(1);
        if (this.backingChunk.size() == 2) {
            return this.forEachInRange(Math.max(this.minKeyValue, s0), Math.min(this.maxKeyValue, e0), lc);
        }
        if (!this.forEachInRange(Math.max(this.minKeyValue, s0), e0, lc)) {
            return false;
        }
        for (i = 2; i < this.backingChunk.size() - 2; i += 2) {
            s = this.backingChunk.get(i);
            if (this.forEachInRange(s, e = this.backingChunk.get(i + 1), lc)) continue;
            return false;
        }
        s = this.backingChunk.get(i);
        e = this.backingChunk.get(i + 1);
        return this.forEachInRange(s, Math.min(this.maxKeyValue, e), lc);
    }

    @Override
    public boolean forEachRowKeyRange(LongRangeAbortableConsumer lrac) {
        long e;
        long s;
        int i;
        if (this.backingChunk.size() == 0) {
            return true;
        }
        long s0 = this.backingChunk.get(0);
        long e0 = this.backingChunk.get(1);
        if (this.backingChunk.size() == 2) {
            return lrac.accept(Math.max(this.minKeyValue, s0), Math.min(this.maxKeyValue, e0));
        }
        if (!lrac.accept(Math.max(this.minKeyValue, s0), e0)) {
            return false;
        }
        for (i = 2; i < this.backingChunk.size() - 2; i += 2) {
            s = this.backingChunk.get(i);
            if (lrac.accept(s, e = this.backingChunk.get(i + 1))) continue;
            return false;
        }
        s = this.backingChunk.get(i);
        e = this.backingChunk.get(i + 1);
        return lrac.accept(s, Math.min(this.maxKeyValue, e));
    }

    @Override
    public void close() {
        if (this.toReleaseChunk != null) {
            this.toReleaseChunk.close();
            this.toReleaseChunk = null;
        }
        if (this.asKeyIndicesChunk != null) {
            this.asKeyIndicesChunk.close();
            this.asKeyIndicesChunk = null;
        }
        if (this.asKeyRangesChunk != null) {
            this.asKeyRangesChunk.close();
            this.asKeyRangesChunk = null;
        }
    }

    private void perKeyIndex(LongAbortableConsumer consumer) {
        int idx = 0;
        while (idx + 1 < this.backingChunk.size()) {
            boolean overflowed;
            long start = Math.max(this.minKeyValue, this.backingChunk.get(idx));
            long range = Math.min(this.maxKeyValue, this.backingChunk.get(idx + 1)) - start + 1L;
            boolean bl = overflowed = range < 0L;
            if (overflowed) {
                range = Long.MAX_VALUE;
            }
            for (long jdx = 0L; jdx < range; ++jdx) {
                if (consumer.accept(start + jdx)) continue;
                return;
            }
            if (overflowed) {
                consumer.accept(Long.MAX_VALUE);
            }
            idx += 2;
        }
    }

    private class Iterator
    implements RowSequence.Iterator {
        private final OffsetHelper helper;
        private int cachedRelativePositionOffset;
        private long cachedRelativePosition;
        private RowSequenceKeyRangesChunkImpl pendingClose;

        private Iterator() {
            this.helper = new OffsetHelper();
            this.cachedRelativePositionOffset = 0;
            this.cachedRelativePosition = 0L;
        }

        private void tryClosePendingClose() {
            if (this.pendingClose != null) {
                this.pendingClose.close();
                this.pendingClose = null;
            }
        }

        @Override
        public final void close() {
            this.tryClosePendingClose();
        }

        @Override
        public boolean hasMore() {
            return !this.helper.isEmpty();
        }

        @Override
        public long peekNextKey() {
            return this.helper.currKeyValue;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKeyInclusive) {
            int newLen;
            int newEndOffset;
            this.tryClosePendingClose();
            int newStartOffset = this.helper.offset;
            long newMinKeyValue = this.helper.currKeyValue;
            this.advance(maxKeyInclusive);
            if (this.helper.currKeyValue == maxKeyInclusive) {
                this.helper.advanceInPositionSpace(1L);
            }
            if ((newEndOffset = this.helper.offset) < RowSequenceKeyRangesChunkImpl.this.backingChunk.size() && RowSequenceKeyRangesChunkImpl.this.backingChunk.get(newEndOffset) <= maxKeyInclusive) {
                newEndOffset += 2;
            }
            if ((newLen = newEndOffset - newStartOffset) == 0) {
                return RowSequenceFactory.EMPTY;
            }
            this.pendingClose = new RowSequenceKeyRangesChunkImpl((LongChunk<OrderedRowKeyRanges>)RowSequenceKeyRangesChunkImpl.this.backingChunk.slice(newStartOffset, newLen), newMinKeyValue, maxKeyInclusive);
            return this.pendingClose;
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long numberOfKeys) {
            this.tryClosePendingClose();
            if (numberOfKeys <= 0L) {
                return RowSequenceFactory.EMPTY;
            }
            int newStartOffset = this.helper.offset;
            long newMinKeyValue = this.helper.currKeyValue;
            this.helper.advanceInPositionSpace(numberOfKeys - 1L);
            int newLen = Math.min(RowSequenceKeyRangesChunkImpl.this.backingChunk.size(), this.helper.offset + 2) - newStartOffset;
            long newMaxKeyValue = this.helper.currKeyValue;
            this.helper.advanceInPositionSpace(1L);
            if (newLen == 0) {
                return RowSequenceFactory.EMPTY;
            }
            this.pendingClose = new RowSequenceKeyRangesChunkImpl((LongChunk<OrderedRowKeyRanges>)RowSequenceKeyRangesChunkImpl.this.backingChunk.slice(newStartOffset, newLen), newMinKeyValue, newMaxKeyValue);
            return this.pendingClose;
        }

        @Override
        public boolean advance(long nextKey) {
            boolean hasMore;
            nextKey = Math.max(this.helper.currKeyValue, nextKey);
            int newEndOffset = OrderedChunkUtils.findInChunk(RowSequenceKeyRangesChunkImpl.this.backingChunk, (long)nextKey, (int)this.helper.offset, (int)RowSequenceKeyRangesChunkImpl.this.backingChunk.size());
            this.helper.offset = newEndOffset - newEndOffset % 2;
            boolean bl = hasMore = this.helper.offset < RowSequenceKeyRangesChunkImpl.this.backingChunk.size();
            if (hasMore) {
                this.helper.currKeyValue = Math.max(nextKey, RowSequenceKeyRangesChunkImpl.this.backingChunk.get(this.helper.offset));
            }
            return hasMore;
        }

        @Override
        public long getRelativePosition() {
            if (this.helper.offset >= RowSequenceKeyRangesChunkImpl.this.backingChunk.size()) {
                long pos = this.cachedRelativePosition;
                for (int idx = this.cachedRelativePositionOffset; idx < RowSequenceKeyRangesChunkImpl.this.backingChunk.size(); idx += 2) {
                    long rangeStart = RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx);
                    long rangeEnd = RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx + 1);
                    if (rangeEnd <= RowSequenceKeyRangesChunkImpl.this.maxKeyValue) {
                        long d = rangeEnd - rangeStart + 1L;
                        this.cachedRelativePosition += d;
                        this.cachedRelativePositionOffset = idx + 2;
                        pos += d;
                        continue;
                    }
                    pos += RowSequenceKeyRangesChunkImpl.this.maxKeyValue - rangeStart + 1L;
                }
                return pos + 1L;
            }
            long pos = this.cachedRelativePosition;
            for (int idx = this.cachedRelativePositionOffset; idx <= this.helper.offset; idx += 2) {
                long rangeStart = RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx);
                long rangeEnd = RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx + 1);
                if (rangeEnd <= this.helper.currKeyValue) {
                    long d = rangeEnd - rangeStart + 1L;
                    this.cachedRelativePosition += d;
                    this.cachedRelativePositionOffset = idx + 2;
                    pos += d;
                    continue;
                }
                pos += this.helper.currKeyValue - rangeStart + 1L;
            }
            return pos;
        }
    }

    private class OffsetHelper {
        public int offset = 0;
        public long currKeyValue;

        private OffsetHelper() {
            this.currKeyValue = Math.max(RowSequenceKeyRangesChunkImpl.this.backingChunk.get(this.offset), RowSequenceKeyRangesChunkImpl.this.minKeyValue);
        }

        boolean advanceInPositionSpace(long numberOfKeys) {
            int idx = this.offset;
            while (idx + 1 < RowSequenceKeyRangesChunkImpl.this.backingChunk.size()) {
                boolean overflowed;
                long start = Math.max(this.currKeyValue, RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx));
                long range = Math.min(RowSequenceKeyRangesChunkImpl.this.maxKeyValue, RowSequenceKeyRangesChunkImpl.this.backingChunk.get(idx + 1)) - start + 1L;
                boolean bl = overflowed = range < 0L;
                if (range > numberOfKeys || overflowed) {
                    this.offset = idx;
                    this.currKeyValue = start + numberOfKeys;
                    return true;
                }
                numberOfKeys -= range;
                idx += 2;
            }
            this.offset = RowSequenceKeyRangesChunkImpl.this.backingChunk.size();
            this.currKeyValue = RowSequenceKeyRangesChunkImpl.this.maxKeyValue;
            return false;
        }

        boolean isEmpty() {
            return this.offset >= RowSequenceKeyRangesChunkImpl.this.backingChunk.size() || this.currKeyValue > RowSequenceKeyRangesChunkImpl.this.maxKeyValue;
        }
    }
}

