/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.OrderedChunkUtils;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowKeyChunkUtils;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;

public class RowSequenceRowKeysChunkImpl
implements RowSequence {
    private final LongChunk<OrderedRowKeys> backingChunk;
    private final WritableLongChunk<OrderedRowKeys> toReleaseChunk;
    private WritableLongChunk<OrderedRowKeyRanges> asRangesChunk = null;

    private RowSequenceRowKeysChunkImpl(LongChunk<OrderedRowKeys> backingChunk) {
        this.backingChunk = backingChunk;
        this.toReleaseChunk = null;
    }

    public static RowSequenceRowKeysChunkImpl makeByWrapping(LongChunk<OrderedRowKeys> backingChunk) {
        return new RowSequenceRowKeysChunkImpl(backingChunk);
    }

    private RowSequenceRowKeysChunkImpl(WritableLongChunk<OrderedRowKeys> backingChunk) {
        this.toReleaseChunk = backingChunk;
        this.backingChunk = this.toReleaseChunk;
    }

    public static RowSequenceRowKeysChunkImpl makeByTaking(WritableLongChunk<OrderedRowKeys> backingChunkToOwn) {
        return new RowSequenceRowKeysChunkImpl(backingChunkToOwn);
    }

    @Override
    public final RowSequence.Iterator getRowSequenceIterator() {
        return new Iterator();
    }

    @Override
    public final RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        int newStartOffset = Math.toIntExact(Math.min((long)this.backingChunk.size(), startPositionInclusive));
        int newLen = Math.toIntExact(Math.min((long)(this.backingChunk.size() - newStartOffset), length));
        if (newLen == 0) {
            return RowSequenceFactory.EMPTY;
        }
        return new RowSequenceRowKeysChunkImpl((LongChunk<OrderedRowKeys>)this.backingChunk.slice(newStartOffset, newLen));
    }

    @Override
    public final RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        int newStartOffset = this.findLowerBoundOfKey(startRowKeyInclusive, 0);
        int newLen = this.findFirstIndexAfterKey(endRowKeyInclusive, newStartOffset) - newStartOffset;
        if (newLen == 0) {
            return RowSequenceFactory.EMPTY;
        }
        return new RowSequenceRowKeysChunkImpl((LongChunk<OrderedRowKeys>)this.backingChunk.slice(newStartOffset, newLen));
    }

    @Override
    public final RowSet asRowSet() {
        int size = this.backingChunk.size();
        if (size == 0) {
            return RowSetFactory.empty();
        }
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        builder.setDomain(this.backingChunk.get(0), this.backingChunk.get(size - 1));
        builder.appendOrderedRowKeysChunk(this.backingChunk);
        return builder.build();
    }

    @Override
    public final LongChunk<OrderedRowKeys> asRowKeyChunk() {
        return this.backingChunk;
    }

    @Override
    public final LongChunk<OrderedRowKeyRanges> asRowKeyRangesChunk() {
        if (this.backingChunk.size() == 0) {
            return LongChunk.getEmptyChunk();
        }
        if (this.asRangesChunk != null) {
            return this.asRangesChunk;
        }
        this.asRangesChunk = RowKeyChunkUtils.convertToOrderedKeyRanges(this.backingChunk);
        return this.asRangesChunk;
    }

    @Override
    public final void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        int newSize = Math.toIntExact(this.size());
        this.backingChunk.copyToChunk(0, chunkToFill, 0, newSize);
        chunkToFill.setSize(newSize);
    }

    @Override
    public final void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        RowKeyChunkUtils.convertToOrderedKeyRanges(this.backingChunk, chunkToFill);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public long firstRowKey() {
        return this.backingChunk.size() > 0 ? this.backingChunk.get(0) : -1L;
    }

    @Override
    public long lastRowKey() {
        int sz = this.backingChunk.size();
        return sz > 0 ? this.backingChunk.get(sz - 1) : -1L;
    }

    @Override
    public final long size() {
        return this.backingChunk.size();
    }

    @Override
    public long getAverageRunLengthEstimate() {
        long first = this.firstRowKey();
        long last = this.lastRowKey();
        long range = last - first + 1L;
        Assert.leq((long)first, (String)"first", (long)last, (String)"last");
        long numMinHoles = range - this.size();
        return this.size() == 0L ? 1L : Math.max(1L, this.size() / (numMinHoles + 1L));
    }

    @Override
    public boolean forEachRowKey(LongAbortableConsumer lc) {
        for (int i = 0; i < this.backingChunk.size(); ++i) {
            if (lc.accept(this.backingChunk.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachRowKeyRange(LongRangeAbortableConsumer lc) {
        long pendingStart = -2L;
        long pendingEnd = -2L;
        for (int i = 0; i < this.backingChunk.size(); ++i) {
            long v = this.backingChunk.get(i);
            if (pendingStart == -2L) {
                pendingStart = pendingEnd = v;
                continue;
            }
            if (pendingEnd + 1L == v) {
                pendingEnd = v;
                continue;
            }
            if (!lc.accept(pendingStart, pendingEnd)) {
                return false;
            }
            pendingStart = pendingEnd = v;
        }
        if (pendingStart != -2L) {
            return lc.accept(pendingStart, pendingEnd);
        }
        return true;
    }

    private int findLowerBoundOfKey(long key, int offset) {
        int off;
        for (off = OrderedChunkUtils.findInChunk(this.backingChunk, (long)key, (int)offset, (int)this.backingChunk.size()); off > 0 && this.backingChunk.get(off - 1) == key; --off) {
        }
        return off;
    }

    private int findFirstIndexAfterKey(long key, int offset) {
        int off;
        for (off = OrderedChunkUtils.findInChunk(this.backingChunk, (long)key, (int)offset, (int)this.backingChunk.size()); off < this.backingChunk.size() && this.backingChunk.get(off) == key; ++off) {
        }
        return off;
    }

    @Override
    public void close() {
        if (this.asRangesChunk != null) {
            this.asRangesChunk.close();
            this.asRangesChunk = null;
        }
        if (this.toReleaseChunk != null) {
            this.toReleaseChunk.close();
        }
    }

    private class Iterator
    implements RowSequence.Iterator {
        private int iteratorOffset = 0;
        private RowSequenceRowKeysChunkImpl pendingClose;

        private Iterator() {
        }

        private void tryClosePendingClose() {
            if (this.pendingClose != null) {
                this.pendingClose.close();
                this.pendingClose = null;
            }
        }

        @Override
        public final void close() {
            this.tryClosePendingClose();
        }

        @Override
        public final boolean hasMore() {
            return this.iteratorOffset < RowSequenceRowKeysChunkImpl.this.backingChunk.size();
        }

        @Override
        public long peekNextKey() {
            return this.hasMore() ? RowSequenceRowKeysChunkImpl.this.backingChunk.get(this.iteratorOffset) : -1L;
        }

        @Override
        public final RowSequence getNextRowSequenceThrough(long maxKey) {
            this.tryClosePendingClose();
            int newEndOffset = RowSequenceRowKeysChunkImpl.this.findFirstIndexAfterKey(maxKey, this.iteratorOffset);
            int newLen = newEndOffset - this.iteratorOffset;
            if (newLen == 0) {
                return RowSequenceFactory.EMPTY;
            }
            this.pendingClose = new RowSequenceRowKeysChunkImpl((LongChunk<OrderedRowKeys>)RowSequenceRowKeysChunkImpl.this.backingChunk.slice(this.iteratorOffset, newLen));
            this.iteratorOffset = newEndOffset;
            return this.pendingClose;
        }

        @Override
        public final RowSequence getNextRowSequenceWithLength(long numberOfKeys) {
            this.tryClosePendingClose();
            int newLen = Math.toIntExact(Math.min(numberOfKeys, (long)(RowSequenceRowKeysChunkImpl.this.backingChunk.size() - this.iteratorOffset)));
            if (newLen == 0) {
                return RowSequenceFactory.EMPTY;
            }
            this.pendingClose = new RowSequenceRowKeysChunkImpl((LongChunk<OrderedRowKeys>)RowSequenceRowKeysChunkImpl.this.backingChunk.slice(this.iteratorOffset, newLen));
            this.iteratorOffset += newLen;
            return this.pendingClose;
        }

        @Override
        public final boolean advance(long nextKey) {
            this.iteratorOffset = RowSequenceRowKeysChunkImpl.this.findLowerBoundOfKey(nextKey, this.iteratorOffset);
            return this.hasMore();
        }

        @Override
        public long getRelativePosition() {
            return this.iteratorOffset;
        }
    }
}

