/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.IntStartLongDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.LongStartIntDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.ShortStartShortDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.metrics.IntCounterMetric;
import io.deephaven.util.metrics.LongCounterLog2HistogramMetric;
import io.deephaven.util.metrics.LongCounterMetric;
import io.deephaven.util.metrics.MetricsManager;
import java.util.function.LongConsumer;

public final class RowSetCounts {
    public final IntCounterMetric emptyCount;
    public final IntCounterMetric shortShortSingleRangeCount;
    public final IntCounterMetric longLongSingleRangeCount;
    public final IntCounterMetric intLongSingleRangeCount;
    public final IntCounterMetric longIntSingleRangeCount;
    public final IntCounterMetric sortedRangesCount;
    public final LongCounterLog2HistogramMetric sortedRangesRowSetCardinality;
    public final LongCounterLog2HistogramMetric sortedRangesRowSetBytesUnused;
    public final LongCounterLog2HistogramMetric sortedRangesRowSetBytesAllocated;
    public final IntCounterMetric rspCount;
    public final LongCounterLog2HistogramMetric rspRowSetCardinality;
    public final LongCounterLog2HistogramMetric rspParallelArraysSizeUsed;
    public final LongCounterLog2HistogramMetric rspParallelArraysSizeUnused;
    public final LongCounterLog2HistogramMetric rspArrayContainersBytesUnused;
    public final LongCounterLog2HistogramMetric rspArrayContainersBytesAllocated;
    public final LongCounterLog2HistogramMetric rspArrayContainersCardinality;
    public final LongCounterMetric rspArrayContainersCount;
    public final LongCounterLog2HistogramMetric rspBitmapContainersBytesUnused;
    public final LongCounterLog2HistogramMetric rspBitmapContainersBytesAllocated;
    public final LongCounterLog2HistogramMetric rspBitmapContainersCardinality;
    public final LongCounterMetric rspBitmapContainersCount;
    public final LongCounterLog2HistogramMetric rspRunContainersBytesUnused;
    public final LongCounterLog2HistogramMetric rspRunContainersBytesAllocated;
    public final LongCounterLog2HistogramMetric rspRunContainersCardinality;
    public final LongCounterMetric rspRunContainersCount;
    public final LongCounterLog2HistogramMetric rspRunContainersRunsCount;
    public final LongCounterMetric rspSingleRangeContainersCount;
    public final LongCounterLog2HistogramMetric rspSingleRangeContainerCardinality;
    public final LongCounterMetric rspTwoValuesContainerCount;
    public final LongCounterMetric rspSingletonContainersCount;
    public final LongCounterLog2HistogramMetric rspFullBlockSpansCount;
    public final LongCounterLog2HistogramMetric rspFullBlockSpansLen;

    public RowSetCounts(String prefix) {
        this.emptyCount = new IntCounterMetric(prefix + "EmptyCount");
        this.shortShortSingleRangeCount = new IntCounterMetric(prefix + "ShortShortSingleRangeCount");
        this.longLongSingleRangeCount = new IntCounterMetric(prefix + "LongLongSingleRangeCount");
        this.intLongSingleRangeCount = new IntCounterMetric(prefix + "IntLongSingleRangeCount");
        this.longIntSingleRangeCount = new IntCounterMetric(prefix + "LongIntSingleRangeCount");
        this.sortedRangesCount = new IntCounterMetric(prefix + "SortedRangesCount");
        this.sortedRangesRowSetCardinality = new LongCounterLog2HistogramMetric(prefix + "SortedRangesRowSetCardinality");
        this.sortedRangesRowSetBytesUnused = new LongCounterLog2HistogramMetric(prefix + "SortedRangesRowSetBytesUnused");
        this.sortedRangesRowSetBytesAllocated = new LongCounterLog2HistogramMetric(prefix + "SortedRangesRowSetBytesAllocated");
        this.rspCount = new IntCounterMetric(prefix + "RspCount");
        this.rspRowSetCardinality = new LongCounterLog2HistogramMetric(prefix + "RspRowSetCardinality");
        this.rspParallelArraysSizeUsed = new LongCounterLog2HistogramMetric(prefix + "RspParallelArraysSizeUsed");
        this.rspParallelArraysSizeUnused = new LongCounterLog2HistogramMetric(prefix + "RspParallelArraysSizeUnused");
        this.rspArrayContainersBytesUnused = new LongCounterLog2HistogramMetric(prefix + "RspArrayContainersBytesUnused");
        this.rspArrayContainersBytesAllocated = new LongCounterLog2HistogramMetric(prefix + "RspArrayContainersBytesAllocated");
        this.rspArrayContainersCardinality = new LongCounterLog2HistogramMetric(prefix + "RspArrayContainersCardinality");
        this.rspArrayContainersCount = new LongCounterMetric(prefix + "RspArrayContainersCount");
        this.rspBitmapContainersBytesUnused = new LongCounterLog2HistogramMetric(prefix + "RspBitmapContainersBytesUnused");
        this.rspBitmapContainersBytesAllocated = new LongCounterLog2HistogramMetric(prefix + "RspBitmapContainersBytesAllocated");
        this.rspBitmapContainersCardinality = new LongCounterLog2HistogramMetric(prefix + "RspBitmapContainersCardinality");
        this.rspBitmapContainersCount = new LongCounterMetric(prefix + "RspBitmapContainersCount");
        this.rspRunContainersBytesUnused = new LongCounterLog2HistogramMetric(prefix + "RspRunContainersBytesUnused");
        this.rspRunContainersBytesAllocated = new LongCounterLog2HistogramMetric(prefix + "RspRunContainersBytesAllocated");
        this.rspRunContainersCardinality = new LongCounterLog2HistogramMetric(prefix + "RspRunContainersCardinality");
        this.rspRunContainersCount = new LongCounterMetric(prefix + "RspRunContainersCount");
        this.rspRunContainersRunsCount = new LongCounterLog2HistogramMetric(prefix + "RspRunContainersRunCount");
        this.rspSingleRangeContainersCount = new LongCounterMetric(prefix + "RspSingleRangeContainersCount");
        this.rspSingleRangeContainerCardinality = new LongCounterLog2HistogramMetric(prefix + "RspSingleRangeContainerCardinality");
        this.rspTwoValuesContainerCount = new LongCounterMetric(prefix + "RspTwoValuesContainerCount");
        this.rspSingletonContainersCount = new LongCounterMetric(prefix + "RspSingletonContainersCount");
        this.rspFullBlockSpansCount = new LongCounterLog2HistogramMetric(prefix + "RspFullBlockSpansCount");
        this.rspFullBlockSpansLen = new LongCounterLog2HistogramMetric(prefix + "RspFullBlockSpansLen");
    }

    public void sampleRsp(RspBitmap rb) {
        if (!MetricsManager.enabled) {
            return;
        }
        this.rspRowSetCardinality.sample(rb.getCardinality());
        this.rspCount.sample(1);
        rb.sampleMetrics((LongConsumer)this.rspParallelArraysSizeUsed, (LongConsumer)this.rspParallelArraysSizeUnused, (LongConsumer)this.rspArrayContainersBytesAllocated, (LongConsumer)this.rspArrayContainersBytesUnused, (LongConsumer)this.rspArrayContainersCardinality, (LongConsumer)this.rspArrayContainersCount, (LongConsumer)this.rspBitmapContainersBytesAllocated, (LongConsumer)this.rspBitmapContainersBytesUnused, (LongConsumer)this.rspBitmapContainersCardinality, (LongConsumer)this.rspBitmapContainersCount, (LongConsumer)this.rspRunContainersBytesAllocated, (LongConsumer)this.rspRunContainersBytesUnused, (LongConsumer)this.rspRunContainersCardinality, (LongConsumer)this.rspRunContainersCount, (LongConsumer)this.rspRunContainersRunsCount, (LongConsumer)this.rspSingleRangeContainersCount, (LongConsumer)this.rspSingleRangeContainerCardinality, (LongConsumer)this.rspSingletonContainersCount, (LongConsumer)this.rspTwoValuesContainerCount, (LongConsumer)this.rspFullBlockSpansCount, (LongConsumer)this.rspFullBlockSpansLen);
    }

    public void sampleSingleRange(SingleRange sr) {
        if (!MetricsManager.enabled) {
            return;
        }
        if (sr instanceof ShortStartShortDeltaSingleRange) {
            this.shortShortSingleRangeCount.sample(1);
            return;
        }
        if (sr instanceof LongStartIntDeltaSingleRange) {
            this.longIntSingleRangeCount.sample(1);
            return;
        }
        if (sr instanceof IntStartLongDeltaSingleRange) {
            this.intLongSingleRangeCount.sample(1);
            return;
        }
        this.longLongSingleRangeCount.sample(1);
    }

    public void sampleSortedRanges(SortedRanges sr) {
        if (!MetricsManager.enabled) {
            return;
        }
        this.sortedRangesCount.sample(1);
        this.sortedRangesRowSetCardinality.sample(sr.getCardinality());
        long allocated = sr.bytesAllocated();
        this.sortedRangesRowSetBytesAllocated.sample(allocated);
        this.sortedRangesRowSetBytesUnused.sample(allocated - (long)sr.bytesUsed());
    }

    public void sampleEmpty() {
        if (!MetricsManager.enabled) {
            return;
        }
        this.emptyCount.sample(1);
    }
}

