/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import gnu.trove.list.array.TLongArrayList;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.util.datastructures.LongRangeConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableLong;

public class RowSetUtils {
    static String toString(RowSet rowSet, int maxRanges) {
        int count = 0;
        StringBuilder result = new StringBuilder("{");
        boolean isFirst = true;
        try (RowSet.RangeIterator it = rowSet.rangeIterator();){
            while (it.hasNext()) {
                it.next();
                result.append(isFirst ? "" : ",").append(it.currentRangeStart()).append((String)(it.currentRangeEnd() != it.currentRangeStart() ? "-" + it.currentRangeEnd() : ""));
                isFirst = false;
                if (count++ <= maxRanges) continue;
                result.append("...");
                break;
            }
        }
        result.append("}");
        return result.toString();
    }

    public static void fillKeyIndicesChunk(RowSet index, WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        chunkToFill.setSize(0);
        index.forEachRowKey(v -> {
            chunkToFill.add(v);
            return true;
        });
    }

    public static void fillKeyRangesChunk(RowSet index, WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        chunkToFill.setSize(0);
        index.forAllRowKeyRanges((start, end) -> {
            chunkToFill.add(start);
            chunkToFill.add(end);
        });
    }

    static TLongArrayList[] findMissing(RowSet base, RowSet keys) {
        TLongArrayList indices = new TLongArrayList();
        TLongArrayList counts = new TLongArrayList();
        int countIndex = -1;
        long currentCount = 0L;
        long lastPos = -2L;
        RowSet.RangeIterator iterator = keys.rangeIterator();
        while (iterator.hasNext()) {
            iterator.next();
            long currentRangeStart = iterator.currentRangeStart();
            long key = base.find(currentRangeStart);
            Assert.ltZero((long)key, (String)"key");
            if (-key - 1L == lastPos) {
                counts.set(countIndex, currentCount += iterator.currentRangeEnd() - currentRangeStart + 1L);
                continue;
            }
            lastPos = -key - 1L;
            indices.add(lastPos);
            currentCount = iterator.currentRangeEnd() - currentRangeStart + 1L;
            counts.add(currentCount);
            ++countIndex;
        }
        return new TLongArrayList[]{indices, counts};
    }

    public static LogOutput append(LogOutput logOutput, RowSet.RangeIterator it) {
        int count = 0;
        logOutput.append((CharSequence)"{");
        boolean isFirst = true;
        while (it.hasNext()) {
            it.next();
            if (!isFirst) {
                logOutput.append((CharSequence)",");
            }
            logOutput.append(it.currentRangeStart());
            if (it.currentRangeEnd() != it.currentRangeStart()) {
                logOutput.append((CharSequence)"-").append(it.currentRangeEnd());
            }
            isFirst = false;
            if (count++ <= 200) continue;
            logOutput.append((CharSequence)"...");
            break;
        }
        logOutput.append((CharSequence)"}");
        return logOutput;
    }

    static boolean equalsDeepImpl(RowSet index, RowSet other) {
        RowSet.RangeIterator it1 = other.rangeIterator();
        RowSet.RangeIterator it2 = index.rangeIterator();
        while (it1.hasNext() && it2.hasNext()) {
            it1.next();
            it2.next();
            if (it1.currentRangeStart() == it2.currentRangeStart() && it1.currentRangeEnd() == it2.currentRangeEnd()) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    static boolean equals(RowSet index, Object other) {
        if (!(other instanceof RowSet)) {
            return false;
        }
        RowSet otherRowSet = (RowSet)other;
        return index.size() == otherRowSet.size() && RowSetUtils.equalsDeepImpl(index, otherRowSet);
    }

    public static long rangeSearch(long begin, long end, Comparator comp) {
        long mid;
        long i = begin;
        if (comp.directionToTargetFrom(i) <= 0) {
            return i;
        }
        long j = end;
        if (comp.directionToTargetFrom(j) >= 0) {
            return j;
        }
        while (true) {
            int c;
            if ((c = comp.directionToTargetFrom(mid = (i + j) / 2L)) < 0) {
                if (j == mid || j - i <= 1L) {
                    return i;
                }
                j = mid;
                continue;
            }
            if (c <= 0) break;
            if (i == mid || j - i <= 1L) {
                return mid;
            }
            i = mid;
        }
        return mid;
    }

    public static void forAllInvertedLongRanges(RowSet sourceRowSet, RowSet destRowSet, LongRangeConsumer lrc) {
        MutableBoolean hasPending = new MutableBoolean();
        MutableLong pendingStart = new MutableLong(-1L);
        MutableLong pendingEnd = new MutableLong(-1L);
        RowSequence.Iterator sourceProbe = sourceRowSet.getRowSequenceIterator();
        MutableLong sourceOffset = new MutableLong();
        destRowSet.forAllRowKeyRanges((start, end) -> {
            long sourceStart = sourceOffset.getValue() + sourceProbe.advanceAndGetPositionDistance(start);
            long sourceEnd = sourceStart + sourceProbe.advanceAndGetPositionDistance(end);
            if (!hasPending.booleanValue()) {
                pendingStart.setValue(sourceStart);
                pendingEnd.setValue(sourceEnd);
                hasPending.setValue(true);
            } else if (pendingEnd.longValue() + 1L == sourceStart) {
                pendingEnd.setValue(sourceEnd);
            } else {
                lrc.accept(pendingStart.longValue(), pendingEnd.longValue());
                pendingStart.setValue(sourceStart);
                pendingEnd.setValue(sourceEnd);
            }
            sourceOffset.setValue(sourceEnd);
        });
        if (hasPending.booleanValue()) {
            lrc.accept(pendingStart.longValue(), pendingEnd.longValue());
        }
    }

    public static class CombinedRangeIterator
    implements RowSet.RangeIterator {
        private final RowSet.RangeIterator it1;
        private final RowSet.RangeIterator it2;
        private long it1CurrStart;
        private long it1CurrEnd;
        private long it2CurrStart;
        private long it2CurrEnd;
        private long currStart = -1L;
        private long currEnd = -1L;
        private RangeMembership currMembership = null;

        public CombinedRangeIterator(RowSet.RangeIterator it1, RowSet.RangeIterator it2) {
            this.it1 = it1;
            this.it2 = it2;
            this.it1CurrStart = -1L;
            this.it1CurrEnd = -1L;
            this.it2CurrStart = -1L;
            this.it2CurrEnd = -1L;
        }

        @Override
        public boolean hasNext() {
            if (this.it1CurrStart == -1L && this.it1CurrEnd != -2L) {
                this.primeIter1();
            }
            if (this.it2CurrStart == -1L && this.it2CurrEnd != -2L) {
                this.primeIter2();
            }
            return this.it1CurrEnd != -2L || this.it2CurrEnd != -2L;
        }

        private void primeIter1() {
            if (this.it1.hasNext()) {
                this.it1.next();
                this.it1CurrStart = this.it1.currentRangeStart();
                this.it1CurrEnd = this.it1.currentRangeEnd();
            } else {
                this.it1CurrEnd = -2L;
            }
        }

        private void primeIter2() {
            if (this.it2.hasNext()) {
                this.it2.next();
                this.it2CurrStart = this.it2.currentRangeStart();
                this.it2CurrEnd = this.it2.currentRangeEnd();
            } else {
                this.it2CurrEnd = -2L;
            }
        }

        @Override
        public long next() {
            if (this.it1CurrStart != -1L) {
                if (this.it2CurrStart != -1L) {
                    if (this.it1CurrEnd < this.it2CurrStart) {
                        this.currMembership = RangeMembership.FIRST_ONLY;
                        this.currStart = this.it1CurrStart;
                        this.currEnd = this.it1CurrEnd;
                        this.it1CurrStart = -1L;
                    } else if (this.it2CurrEnd < this.it1CurrStart) {
                        this.currMembership = RangeMembership.SECOND_ONLY;
                        this.currStart = this.it2CurrStart;
                        this.currEnd = this.it2CurrEnd;
                        this.it2CurrStart = -1L;
                    } else {
                        boolean it1WasEnd;
                        boolean it2WasEnd;
                        boolean it2WasStart;
                        boolean it1WasStart;
                        if (this.it1CurrStart < this.it2CurrStart) {
                            this.currMembership = RangeMembership.FIRST_ONLY;
                            this.currStart = this.it1CurrStart;
                            this.currEnd = this.it2CurrStart - 1L;
                            it1WasStart = true;
                            it2WasStart = false;
                            it2WasEnd = false;
                            it1WasEnd = false;
                        } else if (this.it2CurrStart < this.it1CurrStart) {
                            this.currMembership = RangeMembership.SECOND_ONLY;
                            this.currStart = this.it2CurrStart;
                            this.currEnd = this.it1CurrStart - 1L;
                            it1WasStart = false;
                            it2WasStart = true;
                            it2WasEnd = false;
                            it1WasEnd = false;
                        } else {
                            this.currMembership = RangeMembership.BOTH;
                            this.currStart = this.it1CurrStart;
                            it2WasStart = true;
                            it1WasStart = true;
                            if (this.it1CurrEnd < this.it2CurrEnd) {
                                this.currEnd = this.it1CurrEnd;
                                it1WasEnd = true;
                                it2WasEnd = false;
                            } else if (this.it2CurrEnd < this.it1CurrEnd) {
                                this.currEnd = this.it2CurrEnd;
                                it1WasEnd = false;
                                it2WasEnd = true;
                            } else {
                                this.currEnd = this.it2CurrEnd;
                                it1WasEnd = true;
                                it2WasEnd = true;
                            }
                        }
                        if (it1WasStart) {
                            this.it1CurrStart = it1WasEnd ? -1L : this.currEnd + 1L;
                        }
                        if (it2WasStart) {
                            this.it2CurrStart = it2WasEnd ? -1L : this.currEnd + 1L;
                        }
                    }
                } else {
                    this.currMembership = RangeMembership.FIRST_ONLY;
                    this.currStart = this.it1CurrStart;
                    this.currEnd = this.it1CurrEnd;
                    this.it1CurrStart = -1L;
                }
            } else {
                if (this.it2CurrStart == -1L) {
                    throw new IllegalStateException("Internal invariant violated");
                }
                this.currMembership = RangeMembership.SECOND_ONLY;
                this.currStart = this.it2CurrStart;
                this.currEnd = this.it2CurrEnd;
                this.it2CurrStart = -1L;
            }
            return this.currStart;
        }

        @Override
        public void close() {
            this.it1.close();
            this.it2.close();
        }

        @Override
        public long currentRangeStart() {
            return this.currStart;
        }

        @Override
        public long currentRangeEnd() {
            return this.currEnd;
        }

        public RangeMembership currentRangeMembership() {
            return this.currMembership;
        }

        @Override
        public boolean advance(long notUsed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void postpone(long notUsed) {
            throw new UnsupportedOperationException();
        }

        public static enum RangeMembership {
            FIRST_ONLY(1),
            SECOND_ONLY(2),
            BOTH(3);

            private final int membershipBits;

            private RangeMembership(int membershipBits) {
                this.membershipBits = membershipBits;
            }

            public int membershipBits() {
                return this.membershipBits;
            }

            public boolean hasFirst() {
                return (this.membershipBits & 1) != 0;
            }

            public boolean hasSecond() {
                return (this.membershipBits & 2) != 0;
            }
        }
    }

    public static interface Comparator {
        public int directionToTargetFrom(long var1);
    }
}

