/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.util.LongChunkIterator;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.rsp.DisposableRspBitmap;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.rsp.container.Container;

public class RspBitmapBuilderSequential
implements OrderedLongSet.BuilderSequential {
    protected final boolean disposable;
    protected long pendingStart = -1L;
    protected long pendingEnd = -1L;
    protected long pendingContainerKey = -1L;
    protected Container pendingContainer;
    protected RspBitmap rb;
    protected long maxKeyHint = -1L;

    public RspBitmapBuilderSequential() {
        this(false);
    }

    public RspBitmapBuilderSequential(boolean disposable) {
        this.disposable = disposable;
    }

    @Override
    public void setDomain(long minRowKey, long maxRowKey) {
        this.maxKeyHint = maxRowKey == -1L ? -1L : maxRowKey;
    }

    @Override
    public OrderedLongSet getOrderedLongSet() {
        if (this.pendingStart != -1L) {
            this.flushPendingRange();
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (this.rb == null) {
            return OrderedLongSet.EMPTY;
        }
        this.rb.tryCompactUnsafe(4);
        this.rb.finishMutations();
        RspBitmap ans = this.rb;
        this.rb = null;
        return ans;
    }

    @Override
    public void appendKey(long rowKey) {
        if (this.pendingStart != -1L) {
            if (check && rowKey <= this.pendingEnd) {
                throw new IllegalArgumentException("Out of order key(s) in sequential builder: last=" + this.pendingEnd + " while appending value=" + rowKey);
            }
            if (this.pendingEnd + 1L == rowKey) {
                this.pendingEnd = rowKey;
                return;
            }
            this.flushPendingRange();
        }
        this.pendingStart = this.pendingEnd = rowKey;
    }

    @Override
    public void appendRange(long rangeFirstRowKey, long rangeLastRowKey) {
        if (RspArray.debug && rangeFirstRowKey > rangeLastRowKey) {
            throw new IllegalArgumentException("start (= " + rangeFirstRowKey + ") > end (= " + rangeLastRowKey + ")");
        }
        if (this.pendingStart != -1L) {
            if (check && rangeFirstRowKey <= this.pendingEnd) {
                throw new IllegalArgumentException("Out of order key(s) in sequential builder: last=" + this.pendingEnd + " while appending range start=" + rangeFirstRowKey + ", end=" + rangeLastRowKey);
            }
            if (this.pendingEnd + 1L == rangeFirstRowKey) {
                this.pendingEnd = rangeLastRowKey;
                return;
            }
            this.flushPendingRange();
        }
        this.pendingStart = rangeFirstRowKey;
        this.pendingEnd = rangeLastRowKey;
    }

    @Override
    public void appendOrderedLongSet(long shiftAmount, OrderedLongSet ix, boolean acquire) {
        if (ix.ixIsEmpty()) {
            return;
        }
        if (!(ix instanceof RspBitmap) || this.rb == null) {
            ix.ixForEachLongRange((start, end) -> {
                this.appendRange(start + shiftAmount, end + shiftAmount);
                return true;
            });
            return;
        }
        if (this.pendingStart != -1L) {
            this.flushPendingRange();
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (this.rb.isEmpty()) {
            this.rb.ixInsert(ix);
            return;
        }
        this.rb.appendShiftedUnsafeNoWriteCheck(shiftAmount, (RspBitmap)ix, acquire);
    }

    @Override
    public void appendOrderedRowKeysChunk(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (this.rb != null) {
            this.appendKeyChunkRb(chunk, offset, length);
        } else {
            this.appendKeyChunk(chunk, offset, length);
        }
    }

    private void appendKeyChunkRb(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
        if (this.pendingStart != -1L) {
            this.flushPendingRange();
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (length == 1) {
            this.rb.appendUnsafeNoWriteCheck(chunk.get(offset));
            return;
        }
        int lastOffsetInclusive = offset + length - 1;
        long first = chunk.get(offset);
        long last = chunk.get(lastOffsetInclusive);
        if (last - first + 1L == (long)length) {
            this.rb.appendRangeUnsafeNoWriteCheck(first, last);
            return;
        }
        this.rb.addValuesUnsafeNoWriteCheck(chunk, offset, length);
    }

    private void appendKeyChunk(LongChunk<OrderedRowKeys> chunk, int offset, int length) {
        if (length == 1) {
            this.appendKey(chunk.get(offset));
            return;
        }
        int lastOffsetInclusive = offset + length - 1;
        long first = chunk.get(offset);
        long last = chunk.get(lastOffsetInclusive);
        if (last - first + 1L == (long)length) {
            this.appendRange(first, last);
            return;
        }
        LongChunkIterator it = new LongChunkIterator(chunk, offset, length);
        while (it.hasNext()) {
            this.appendKey(it.nextLong());
        }
    }

    protected void flushPendingRange() {
        long pendingStartOnEntry = this.pendingStart;
        this.pendingStart = -1L;
        this.flushRangeToPendingContainer(pendingStartOnEntry, this.pendingEnd);
    }

    protected void flushRangeToPendingContainer(long start, long end) {
        int endingContainerEnd;
        long endingContainerKey;
        long midFullBlockSpanLen;
        long midFullBlockSpanKey;
        int initialContainerEnd;
        int initialContainerStart;
        long initialContainerKey;
        boolean singleBlock;
        long highStart = RspBitmap.highBits(start);
        int lowStart = RspArray.lowBitsAsInt(start);
        long highEnd = RspBitmap.highBits(end);
        int lowEnd = RspArray.lowBitsAsInt(end);
        boolean bl = singleBlock = highStart == highEnd;
        if (singleBlock) {
            long pendingContainerBlockKey = RspBitmap.highBits(this.pendingContainerKey);
            if (this.pendingContainerKey != -1L && pendingContainerBlockKey == highStart) {
                if (this.pendingContainer == null) {
                    this.pendingContainer = RspBitmap.containerForLowValueAndRange(RspBitmap.lowBitsAsInt(this.pendingContainerKey), lowStart, lowEnd);
                    this.pendingContainerKey = RspBitmap.highBits(this.pendingContainerKey);
                } else {
                    this.pendingContainer = this.pendingContainer.iappend(lowStart, lowEnd + 1);
                }
                return;
            }
            if (this.pendingContainerKey != -1L) {
                if (check && this.pendingContainerKey > highStart) {
                    throw new IllegalStateException("Out of order key(s) in sequential builder: last=" + end + " while appending value=" + this.pendingContainer.last());
                }
                this.flushPendingContainer();
            }
            if (lowStart == 0 && lowEnd == 65535) {
                this.ensureRb();
                this.rb.appendFullBlockSpanUnsafeNoWriteCheck(highStart, 1L);
                return;
            }
            if (start == end) {
                this.pendingContainerKey = start;
                this.pendingContainer = null;
            } else {
                this.pendingContainerKey = highStart;
                this.pendingContainer = Container.rangeOfOnes((int)lowStart, (int)(lowEnd + 1));
            }
            return;
        }
        if (lowStart > 0) {
            initialContainerKey = highStart;
            initialContainerStart = lowStart;
            initialContainerEnd = 65535;
        } else {
            initialContainerKey = -1L;
            initialContainerStart = 0;
            initialContainerEnd = 0;
        }
        long slen = (highEnd - highStart >> 16) - 1L;
        if (lowStart == 0) {
            ++slen;
        }
        if (lowEnd == 65535) {
            ++slen;
        }
        if (slen > 0L) {
            midFullBlockSpanKey = lowStart == 0 ? highStart : highStart + 65536L;
            midFullBlockSpanLen = slen;
        } else {
            midFullBlockSpanKey = -1L;
            midFullBlockSpanLen = 0L;
        }
        if (lowEnd < 65535) {
            endingContainerKey = highEnd;
            endingContainerEnd = lowEnd;
        } else {
            endingContainerKey = -1L;
            endingContainerEnd = 0;
        }
        if (initialContainerKey != -1L) {
            if (this.pendingContainerKey != -1L && RspBitmap.highBits(this.pendingContainerKey) == initialContainerKey) {
                if (this.pendingContainer == null) {
                    this.pendingContainer = RspBitmap.containerForLowValueAndRange(RspBitmap.lowBitsAsInt(this.pendingContainerKey), initialContainerStart, initialContainerEnd);
                    this.pendingContainerKey = RspBitmap.highBits(this.pendingContainerKey);
                } else {
                    this.pendingContainer = this.pendingContainer.iappend(initialContainerStart, initialContainerEnd + 1);
                }
                this.flushPendingContainer();
            } else {
                if (this.pendingContainerKey != -1L) {
                    this.flushPendingContainer();
                }
                Container initialContainer = Container.rangeOfOnes((int)initialContainerStart, (int)(initialContainerEnd + 1));
                this.ensureRb();
                this.rb.appendContainerUnsafeNoWriteCheck(initialContainerKey, initialContainer);
            }
        }
        if (this.pendingContainerKey != -1L) {
            this.flushPendingContainer();
        }
        if (midFullBlockSpanKey != -1L) {
            this.ensureRb();
            this.rb.appendFullBlockSpanUnsafeNoWriteCheck(midFullBlockSpanKey, midFullBlockSpanLen);
        }
        if (endingContainerKey != -1L) {
            this.pendingContainerKey = endingContainerKey;
            this.pendingContainer = Container.rangeOfOnes((int)0, (int)(endingContainerEnd + 1));
        }
    }

    private void ensureRb() {
        if (this.rb == null) {
            this.rb = this.disposable ? new DisposableRspBitmap() : new RspBitmap();
        }
    }

    protected void flushPendingContainer() {
        this.ensureRb();
        if (this.pendingContainer != null) {
            this.pendingContainer = this.pendingContainer.runOptimize();
        }
        this.rb.appendContainerUnsafeNoWriteCheck(this.pendingContainerKey, this.pendingContainer);
        this.pendingContainerKey = -1L;
        this.pendingContainer = null;
    }
}

