/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowSequenceAsChunkImpl;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import org.apache.commons.lang3.mutable.MutableInt;

public class ShiftedRowSequence
extends RowSequenceAsChunkImpl
implements RowSequence {
    private long shiftAmount;
    private RowSequence wrappedOK;

    public static RowSequence wrap(RowSequence toWrap, long shiftAmount) {
        if (toWrap instanceof ShiftedRowSequence) {
            ShiftedRowSequence orig = (ShiftedRowSequence)toWrap;
            toWrap = orig.wrappedOK;
            shiftAmount += orig.shiftAmount;
        }
        return shiftAmount == 0L ? toWrap : new ShiftedRowSequence(toWrap, shiftAmount);
    }

    private ShiftedRowSequence(RowSequence wrappedOK, long shiftAmount) {
        Assert.assertion((!(wrappedOK instanceof ShiftedRowSequence) ? 1 : 0) != 0, (String)"Wrapped Ordered Indices must not be a ShiftedRowSequence");
        this.shiftAmount = shiftAmount;
        this.wrappedOK = wrappedOK;
    }

    public ShiftedRowSequence() {
        this.shiftAmount = 0L;
        this.wrappedOK = null;
    }

    public RowSequence reset(RowSequence toWrap, long shiftAmount) {
        if (toWrap instanceof ShiftedRowSequence) {
            ShiftedRowSequence orig = (ShiftedRowSequence)toWrap;
            this.shiftAmount = shiftAmount + orig.shiftAmount;
            this.wrappedOK = orig.wrappedOK;
        } else {
            this.shiftAmount = shiftAmount;
            this.wrappedOK = toWrap;
        }
        this.invalidateRowSequenceAsChunkImpl();
        return this;
    }

    public final void clear() {
        this.shiftAmount = 0L;
        this.wrappedOK = null;
        this.invalidateRowSequenceAsChunkImpl();
    }

    @Override
    public Iterator getRowSequenceIterator() {
        return new Iterator();
    }

    @Override
    public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        return ShiftedRowSequence.wrap(this.wrappedOK.getRowSequenceByPosition(startPositionInclusive, length), this.shiftAmount);
    }

    @Override
    public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        return ShiftedRowSequence.wrap(this.wrappedOK.getRowSequenceByKeyRange(startRowKeyInclusive - this.shiftAmount, endRowKeyInclusive - this.shiftAmount), this.shiftAmount);
    }

    @Override
    public RowSet asRowSet() {
        try (RowSet wrappedAsRowSet = this.wrappedOK.asRowSet();){
            WritableRowSet writableRowSet = wrappedAsRowSet.shift(this.shiftAmount);
            return writableRowSet;
        }
    }

    @Override
    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        this.wrappedOK.fillRowKeyChunk(chunkToFill);
        this.shiftIndicesChunk(chunkToFill);
    }

    @Override
    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        this.wrappedOK.fillRowKeyRangesChunk(chunkToFill);
        this.shiftKeyRangesChunk(chunkToFill);
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedOK.isEmpty();
    }

    @Override
    public long firstRowKey() {
        return this.wrappedOK.firstRowKey() + this.shiftAmount;
    }

    @Override
    public long lastRowKey() {
        return this.wrappedOK.lastRowKey() + this.shiftAmount;
    }

    @Override
    public long size() {
        return this.wrappedOK.size();
    }

    @Override
    public long getAverageRunLengthEstimate() {
        return this.wrappedOK.getAverageRunLengthEstimate();
    }

    @Override
    public boolean forEachRowKey(LongAbortableConsumer consumer) {
        return this.wrappedOK.forEachRowKey(ii -> consumer.accept(ii + this.shiftAmount));
    }

    @Override
    public boolean forEachRowKeyRange(LongRangeAbortableConsumer consumer) {
        return this.wrappedOK.forEachRowKeyRange((s, e) -> consumer.accept(s + this.shiftAmount, e + this.shiftAmount));
    }

    @Override
    public void close() {
        this.closeRowSequenceAsChunkImpl();
        this.clear();
    }

    @Override
    public long rangesCountUpperBound() {
        MutableInt mi = new MutableInt(0);
        this.wrappedOK.forAllRowKeyRanges((start, end) -> mi.increment());
        return mi.intValue();
    }

    private void shiftIndicesChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        for (int ii = 0; ii < chunkToFill.size(); ++ii) {
            chunkToFill.set(ii, chunkToFill.get(ii) + this.shiftAmount);
        }
    }

    private void shiftKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        for (int ii = 0; ii < chunkToFill.size(); ++ii) {
            chunkToFill.set(ii, chunkToFill.get(ii) + this.shiftAmount);
        }
    }

    private class Iterator
    implements RowSequence.Iterator {
        RowSequence.Iterator wrappedIt;
        ShiftedRowSequence reusableOK;

        private Iterator() {
            this.wrappedIt = ShiftedRowSequence.this.wrappedOK.getRowSequenceIterator();
            this.reusableOK = new ShiftedRowSequence(null, ShiftedRowSequence.this.shiftAmount);
        }

        @Override
        public void close() {
            if (this.reusableOK != null) {
                this.reusableOK.close();
                this.reusableOK = null;
                this.wrappedIt.close();
                this.wrappedIt = null;
            }
        }

        @Override
        public boolean hasMore() {
            return this.wrappedIt.hasMore();
        }

        @Override
        public long peekNextKey() {
            return this.wrappedIt.peekNextKey() + ShiftedRowSequence.this.shiftAmount;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKeyInclusive) {
            this.reusableOK.reset(this.wrappedIt.getNextRowSequenceThrough(maxKeyInclusive - ShiftedRowSequence.this.shiftAmount), ShiftedRowSequence.this.shiftAmount);
            return this.reusableOK;
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long numberOfKeys) {
            this.reusableOK.reset(this.wrappedIt.getNextRowSequenceWithLength(numberOfKeys), ShiftedRowSequence.this.shiftAmount);
            return this.reusableOK;
        }

        @Override
        public boolean advance(long nextKey) {
            return this.wrappedIt.advance(nextKey - ShiftedRowSequence.this.shiftAmount);
        }

        @Override
        public long getRelativePosition() {
            return this.wrappedIt.getRelativePosition();
        }
    }
}

