/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import io.deephaven.engine.context.ExecutionContext;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.TrackingRowSet;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.updategraph.LogicalClock;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class TrackingWritableRowSetImpl
extends WritableRowSetImpl
implements TrackingWritableRowSet {
    private final LogicalClock clock = ExecutionContext.getContext().getUpdateGraph().clock();
    private final WritableRowSetImpl prev = new UnmodifiableRowSetImpl();
    private transient OrderedLongSet prevInnerSet = OrderedLongSet.EMPTY;
    private volatile transient long changeTimeStep = -1L;
    private volatile transient TrackingRowSet.Indexer indexer;

    public TrackingWritableRowSetImpl() {
        this(OrderedLongSet.EMPTY);
    }

    public TrackingWritableRowSetImpl(OrderedLongSet innerSet) {
        super(innerSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderedLongSet checkAndGetPrev() {
        if (this.clock.currentStep() == this.changeTimeStep) {
            return this.prevInnerSet;
        }
        TrackingWritableRowSetImpl trackingWritableRowSetImpl = this;
        synchronized (trackingWritableRowSetImpl) {
            long currentClockStep = this.clock.currentStep();
            if (currentClockStep == this.changeTimeStep) {
                return this.prevInnerSet;
            }
            this.prevInnerSet.ixRelease();
            this.prevInnerSet = this.getInnerSet().ixCowRef();
            this.prev.assign(this.prevInnerSet.ixCowRef());
            this.changeTimeStep = currentClockStep;
            return this.prevInnerSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <INDEXER_TYPE extends TrackingRowSet.Indexer> INDEXER_TYPE indexer(@NotNull Function<TrackingRowSet, INDEXER_TYPE> indexerFactory) {
        TrackingRowSet.Indexer localIndexer = this.indexer;
        if (localIndexer == null) {
            TrackingWritableRowSetImpl trackingWritableRowSetImpl = this;
            synchronized (trackingWritableRowSetImpl) {
                localIndexer = this.indexer;
                if (localIndexer == null) {
                    this.indexer = localIndexer = (TrackingRowSet.Indexer)indexerFactory.apply(this);
                }
            }
        }
        return (INDEXER_TYPE)localIndexer;
    }

    @Override
    public void preMutationHook() {
        this.checkAndGetPrev();
    }

    @Override
    protected void postMutationHook() {
        TrackingRowSet.Indexer localIndexer = this.indexer;
        if (localIndexer != null) {
            localIndexer.rowSetChanged();
        }
    }

    @Override
    public TrackingWritableRowSet toTracking() {
        throw new UnsupportedOperationException("Already tracking! You must copy() before toTracking()");
    }

    @Override
    public void close() {
        this.prevInnerSet.ixRelease();
        this.prevInnerSet = null;
        this.changeTimeStep = -1L;
        this.indexer = null;
        super.close();
    }

    @Override
    public void initializePreviousValue() {
        this.prevInnerSet.ixRelease();
        this.prevInnerSet = OrderedLongSet.EMPTY;
        this.changeTimeStep = -1L;
    }

    @Override
    public long sizePrev() {
        return this.checkAndGetPrev().ixCardinality();
    }

    @Override
    public WritableRowSet copyPrev() {
        return new WritableRowSetImpl(this.checkAndGetPrev().ixCowRef());
    }

    @Override
    public RowSet prev() {
        this.checkAndGetPrev();
        return this.prev;
    }

    @Override
    public long getPrev(long rowPosition) {
        if (rowPosition < 0L) {
            return -1L;
        }
        return this.checkAndGetPrev().ixGet(rowPosition);
    }

    @Override
    public long findPrev(long rowKey) {
        return this.checkAndGetPrev().ixFind(rowKey);
    }

    @Override
    public long firstRowKeyPrev() {
        return this.checkAndGetPrev().ixFirstKey();
    }

    @Override
    public long lastRowKeyPrev() {
        return this.checkAndGetPrev().ixLastKey();
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException {
        super.readExternal(in);
        this.initializePreviousValue();
    }

    private static class UnmodifiableRowSetImpl
    extends WritableRowSetImpl {
        @Override
        public final void preMutationHook() {
            throw new UnsupportedOperationException("Unmodifiable view must never be mutated");
        }

        @Override
        public final void postMutationHook() {
            throw new UnsupportedOperationException("Unmodifiable view must never be mutated");
        }

        @Override
        public final void close() {
            throw new UnsupportedOperationException("Unmodifiable view must never be closed");
        }
    }
}

