/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl;

import gnu.trove.list.array.TLongArrayList;
import io.deephaven.base.log.LogOutput;
import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.LongChunk;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetBuilderRandom;
import io.deephaven.engine.rowset.RowSetBuilderSequential;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.TrackingWritableRowSet;
import io.deephaven.engine.rowset.WritableRowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.ExternalizableRowSetUtils;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.RowSequenceAsChunkImpl;
import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.TrackingWritableRowSetImpl;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.commons.lang3.mutable.MutableLong;
import org.jetbrains.annotations.NotNull;

public class WritableRowSetImpl
extends RowSequenceAsChunkImpl
implements WritableRowSet,
Externalizable {
    private static final long serialVersionUID = 1L;
    private OrderedLongSet innerSet;

    public WritableRowSetImpl() {
        this(OrderedLongSet.EMPTY);
    }

    public WritableRowSetImpl(OrderedLongSet innerSet) {
        this.innerSet = Objects.requireNonNull(innerSet);
    }

    @VisibleForTesting
    public final OrderedLongSet getInnerSet() {
        return this.innerSet;
    }

    @Override
    public final WritableRowSet copy() {
        return new WritableRowSetImpl(this.innerSet.ixCowRef());
    }

    @Override
    public TrackingWritableRowSet toTracking() {
        TrackingWritableRowSetImpl result = new TrackingWritableRowSetImpl(this.innerSet);
        this.innerSet = null;
        this.closeRowSequenceAsChunkImpl();
        return result;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void close() {
        this.innerSet.ixRelease();
        this.innerSet = null;
        this.closeRowSequenceAsChunkImpl();
    }

    @VisibleForTesting
    final int refCount() {
        return this.innerSet.ixRefCount();
    }

    protected void preMutationHook() {
    }

    protected void postMutationHook() {
    }

    @Override
    public void resetTo(@NotNull RowSet other) {
        OrderedLongSet otherInnerSet = WritableRowSetImpl.getInnerSet(other);
        this.preMutationHook();
        this.assign(otherInnerSet.ixCowRef());
        this.postMutationHook();
    }

    void assign(OrderedLongSet maybeNewImpl) {
        this.invalidateRowSequenceAsChunkImpl();
        if (maybeNewImpl == this.innerSet) {
            return;
        }
        this.innerSet.ixRelease();
        this.innerSet = maybeNewImpl;
    }

    @Override
    public final void insert(long key) {
        this.preMutationHook();
        this.assign(this.innerSet.ixInsert(key));
        this.postMutationHook();
    }

    @Override
    public final void insertRange(long startKey, long endKey) {
        this.preMutationHook();
        this.assign(this.innerSet.ixInsertRange(startKey, endKey));
        this.postMutationHook();
    }

    @Override
    public final void insert(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        Assert.leq((int)(offset + length), (String)"offset + length", (int)keys.size(), (String)"keys.size()");
        this.preMutationHook();
        this.assign(this.innerSet.ixInsert(keys, offset, length));
        this.postMutationHook();
    }

    @Override
    public final void insert(RowSet added) {
        this.preMutationHook();
        this.assign(this.innerSet.ixInsert(WritableRowSetImpl.getInnerSet(added)));
        this.postMutationHook();
    }

    @Override
    public final void remove(long key) {
        this.preMutationHook();
        this.assign(this.innerSet.ixRemove(key));
        this.postMutationHook();
    }

    @Override
    public final void removeRange(long start, long end) {
        this.preMutationHook();
        this.assign(this.innerSet.ixRemoveRange(start, end));
        this.postMutationHook();
    }

    @Override
    public final void remove(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        Assert.leq((int)(offset + length), (String)"offset + length", (int)keys.size(), (String)"keys.size()");
        this.preMutationHook();
        this.assign(this.innerSet.ixRemove(keys, offset, length));
        this.postMutationHook();
    }

    @Override
    public final void remove(RowSet removed) {
        this.preMutationHook();
        this.assign(this.innerSet.ixRemove(WritableRowSetImpl.getInnerSet(removed)));
        this.postMutationHook();
    }

    @Override
    public final void update(RowSet added, RowSet removed) {
        this.preMutationHook();
        this.assign(this.innerSet.ixUpdate(WritableRowSetImpl.getInnerSet(added), WritableRowSetImpl.getInnerSet(removed)));
        this.postMutationHook();
    }

    @Override
    public final void retain(RowSet rowSetToIntersect) {
        this.preMutationHook();
        this.assign(this.innerSet.ixRetain(WritableRowSetImpl.getInnerSet(rowSetToIntersect)));
        this.postMutationHook();
    }

    @Override
    public final void retainRange(long startRowKey, long endRowKey) {
        this.preMutationHook();
        this.assign(this.innerSet.ixRetainRange(startRowKey, endRowKey));
        this.postMutationHook();
    }

    @Override
    public final void clear() {
        this.preMutationHook();
        this.assign(OrderedLongSet.EMPTY);
        this.postMutationHook();
    }

    @Override
    public final void shiftInPlace(long shiftAmount) {
        this.preMutationHook();
        this.assign(this.innerSet.ixShiftInPlace(shiftAmount));
        this.postMutationHook();
    }

    @Override
    public final void insertWithShift(long shiftAmount, RowSet other) {
        this.preMutationHook();
        this.assign(this.innerSet.ixInsertWithShift(shiftAmount, WritableRowSetImpl.getInnerSet(other)));
        this.postMutationHook();
    }

    @Override
    public final void compact() {
        this.assign(this.innerSet.ixCompact());
    }

    @Override
    public final long size() {
        return this.innerSet.ixCardinality();
    }

    @Override
    public final boolean isEmpty() {
        return this.innerSet.ixIsEmpty();
    }

    @Override
    public final long firstRowKey() {
        return this.innerSet.ixFirstKey();
    }

    @Override
    public final long lastRowKey() {
        return this.innerSet.ixLastKey();
    }

    @Override
    public final long rangesCountUpperBound() {
        return this.innerSet.ixRangesCountUpperBound();
    }

    @Override
    public final RowSequence.Iterator getRowSequenceIterator() {
        return this.innerSet.ixGetRowSequenceIterator();
    }

    @Override
    public final RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        return this.innerSet.ixGetRowSequenceByPosition(startPositionInclusive, length);
    }

    @Override
    public final RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        return this.innerSet.ixGetRowSequenceByKeyRange(startRowKeyInclusive, endRowKeyInclusive);
    }

    @Override
    public final RowSet asRowSet() {
        return this.copy();
    }

    @Override
    public final WritableRowSet invert(RowSet keys, long maximumPosition) {
        return new WritableRowSetImpl(this.innerSet.ixInvertOnNew(WritableRowSetImpl.getInnerSet(keys), maximumPosition));
    }

    @Override
    public final TLongArrayList[] findMissing(RowSet keys) {
        return RowSetUtils.findMissing(this, keys);
    }

    @Override
    @NotNull
    public final WritableRowSet intersect(@NotNull RowSet range) {
        return new WritableRowSetImpl(this.innerSet.ixIntersectOnNew(WritableRowSetImpl.getInnerSet(range)));
    }

    @Override
    public final boolean overlaps(@NotNull RowSet range) {
        return this.innerSet.ixOverlaps(WritableRowSetImpl.getInnerSet(range));
    }

    @Override
    public final boolean overlapsRange(long start, long end) {
        return this.innerSet.ixOverlapsRange(start, end);
    }

    @Override
    public final boolean subsetOf(@NotNull RowSet other) {
        return this.innerSet.ixSubsetOf(WritableRowSetImpl.getInnerSet(other));
    }

    @Override
    public final WritableRowSet minus(RowSet indexToRemove) {
        if (indexToRemove == this) {
            return RowSetFactory.empty();
        }
        return new WritableRowSetImpl(this.innerSet.ixMinusOnNew(WritableRowSetImpl.getInnerSet(indexToRemove)));
    }

    @Override
    public final WritableRowSet union(RowSet indexToAdd) {
        if (indexToAdd == this) {
            return this.copy();
        }
        return new WritableRowSetImpl(this.innerSet.ixUnionOnNew(WritableRowSetImpl.getInnerSet(indexToAdd)));
    }

    @Override
    public final WritableRowSet shift(long shiftAmount) {
        return new WritableRowSetImpl(this.innerSet.ixShiftOnNew(shiftAmount));
    }

    @Override
    public final void validate(String failMsg) {
        this.innerSet.ixValidate(failMsg);
        long totalSize = 0L;
        Object m = failMsg == null ? "" : failMsg + " ";
        try (RowSet.RangeIterator it = this.rangeIterator();){
            long lastEnd = Long.MIN_VALUE;
            while (it.hasNext()) {
                it.next();
                long start = it.currentRangeStart();
                long end = it.currentRangeEnd();
                Assert.assertion((start >= 0L ? 1 : 0) != 0, (String)((String)m + "start >= 0"), (Object)start, (String)"start", (Object)this, (String)"rowSet");
                Assert.assertion((end >= start ? 1 : 0) != 0, (String)((String)m + "end >= start"), (Object)start, (String)"start", (Object)end, (String)"end", (Object)this, (String)"rowSet");
                Assert.assertion((start > lastEnd ? 1 : 0) != 0, (String)((String)m + "start > lastEnd"), (Object)start, (String)"start", (Object)lastEnd, (String)"lastEnd", (Object)this, (String)"rowSet");
                Assert.assertion((start > lastEnd + 1L ? 1 : 0) != 0, (String)((String)m + "start > lastEnd + 1"), (Object)start, (String)"start", (Object)lastEnd, (String)"lastEnd", (Object)this, (String)"rowSet");
                lastEnd = end;
                totalSize += end - start + 1L;
            }
        }
        Assert.eq((long)totalSize, (String)((String)m + "totalSize"), (long)this.size(), (String)"size()");
    }

    @Override
    public final boolean forEachRowKey(LongAbortableConsumer lc) {
        return this.innerSet.ixForEachLong(lc);
    }

    @Override
    public final boolean forEachRowKeyRange(LongRangeAbortableConsumer larc) {
        return this.innerSet.ixForEachLongRange(larc);
    }

    @Override
    public final WritableRowSet subSetByPositionRange(long startPos, long endPos) {
        return new WritableRowSetImpl(this.innerSet.ixSubindexByPosOnNew(startPos, endPos));
    }

    @Override
    public final WritableRowSet subSetByKeyRange(long startKey, long endKey) {
        return new WritableRowSetImpl(this.innerSet.ixSubindexByKeyOnNew(startKey, endKey));
    }

    @Override
    public final WritableRowSet subSetForPositions(RowSequence posRowSequence, boolean reversed) {
        if (reversed) {
            return this.subSetForReversePositions(posRowSequence);
        }
        return this.subSetForPositions(posRowSequence);
    }

    @Override
    public final WritableRowSet subSetForPositions(RowSequence positions) {
        if (positions.isEmpty()) {
            return RowSetFactory.empty();
        }
        if (positions.isContiguous()) {
            return this.subSetByPositionRange(positions.firstRowKey(), positions.lastRowKey() + 1L);
        }
        MutableLong currentOffset = new MutableLong();
        RowSequence.Iterator iter = this.getRowSequenceIterator();
        RowSetBuilderSequential builder = RowSetFactory.builderSequential();
        positions.forEachRowKeyRange((start, end) -> {
            if (currentOffset.longValue() < start) {
                iter.getNextRowSequenceWithLength(start - currentOffset.longValue());
                currentOffset.setValue(start);
            }
            if (!iter.hasMore()) {
                return false;
            }
            iter.getNextRowSequenceWithLength(end + 1L - currentOffset.longValue()).forAllRowKeyRanges(builder::appendRange);
            currentOffset.setValue(end + 1L);
            return iter.hasMore();
        });
        return builder.build();
    }

    @Override
    public final WritableRowSet subSetForReversePositions(RowSequence positions) {
        if (positions.isEmpty()) {
            return RowSetFactory.empty();
        }
        long lastRowPosition = this.size() - 1L;
        if (positions.size() == positions.lastRowKey() - positions.firstRowKey() + 1L) {
            long forwardEnd = lastRowPosition - positions.firstRowKey();
            if (forwardEnd < 0L) {
                return RowSetFactory.empty();
            }
            long forwardStart = Math.max(lastRowPosition - positions.lastRowKey(), 0L);
            try (RowSequence forwardPositions = RowSequenceFactory.forRange(forwardStart, forwardEnd);){
                WritableRowSet writableRowSet = this.subSetForPositions(forwardPositions);
                return writableRowSet;
            }
        }
        RowSetBuilderRandom builder = RowSetFactory.builderRandom();
        positions.forEachRowKeyRange((start, end) -> {
            long forwardEnd = lastRowPosition - start;
            if (forwardEnd < 0L) {
                return false;
            }
            long forwardStart = Math.max(lastRowPosition - end, 0L);
            builder.addRange(forwardStart, forwardEnd);
            return forwardStart != 0L;
        });
        try (WritableRowSet forwardPositions = builder.build();){
            WritableRowSet writableRowSet = this.subSetForPositions(forwardPositions);
            return writableRowSet;
        }
    }

    @Override
    public final long get(long rowPosition) {
        return this.innerSet.ixGet(rowPosition);
    }

    @Override
    public final void getKeysForPositions(PrimitiveIterator.OfLong positions, LongConsumer outputKeys) {
        this.innerSet.ixGetKeysForPositions(positions, outputKeys);
    }

    @Override
    public final long find(long key) {
        return this.innerSet.ixFind(key);
    }

    @Override
    @NotNull
    public final RowSet.Iterator iterator() {
        return this.innerSet.ixIterator();
    }

    @Override
    public final RowSet.SearchIterator searchIterator() {
        return this.innerSet.ixSearchIterator();
    }

    @Override
    public final RowSet.SearchIterator reverseIterator() {
        return this.innerSet.ixReverseIterator();
    }

    @Override
    public final RowSet.RangeIterator rangeIterator() {
        return this.innerSet.ixRangeIterator();
    }

    @Override
    public final long getAverageRunLengthEstimate() {
        return this.innerSet.ixGetAverageRunLengthEstimate();
    }

    @Override
    public final boolean containsRange(long start, long end) {
        return this.innerSet.ixContainsRange(start, end);
    }

    @Override
    public final void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        RowSetUtils.fillKeyIndicesChunk(this, chunkToFill);
    }

    @Override
    public final void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        RowSetUtils.fillKeyRangesChunk(this, chunkToFill);
    }

    public LogOutput append(LogOutput logOutput) {
        return RowSetUtils.append(logOutput, this.rangeIterator());
    }

    public String toString() {
        return RowSetUtils.toString(this, 200);
    }

    public String toString(int maxRanges) {
        return RowSetUtils.toString(this, maxRanges);
    }

    public final boolean equals(Object obj) {
        return RowSetUtils.equals(this, obj);
    }

    @Override
    public final void writeExternal(@NotNull ObjectOutput out) throws IOException {
        ExternalizableRowSetUtils.writeExternalCompressedDeltas(out, this);
    }

    @Override
    public void readExternal(@NotNull ObjectInput in) throws IOException {
        try (RowSet readRowSet = ExternalizableRowSetUtils.readExternalCompressedDelta(in);){
            this.assign(WritableRowSetImpl.getInnerSet(readRowSet).ixCowRef());
        }
    }

    public void writeImpl(ObjectOutput out) throws IOException {
        out.writeObject(this.innerSet);
    }

    public static void addToBuilderFromImpl(OrderedLongSet.BuilderRandom builder, WritableRowSetImpl rowSet) {
        if (rowSet.innerSet instanceof SingleRange) {
            builder.add((SingleRange)rowSet.innerSet);
            return;
        }
        if (rowSet.innerSet instanceof SortedRanges) {
            builder.add((SortedRanges)rowSet.innerSet, true);
            return;
        }
        RspBitmap idxImpl = (RspBitmap)rowSet.innerSet;
        builder.add(idxImpl, true);
    }

    protected static OrderedLongSet getInnerSet(RowSet rowSet) {
        if (rowSet instanceof WritableRowSetImpl) {
            return ((WritableRowSetImpl)rowSet).getInnerSet();
        }
        throw new UnsupportedOperationException("Unexpected RowSet type " + rowSet.getClass());
    }
}

