/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;

public class IndexRangeIteratorView
implements SearchRangeIterator {
    private RowSet.RangeIterator it;
    private final long offset;
    private final long rangesEnd;
    private long itStart;
    private long itEnd;
    private int start;
    private int end;
    private int nextStart;
    private int nextEnd;
    private boolean nextValid;
    private boolean noMore;
    private boolean itFinished;

    public IndexRangeIteratorView(RowSet.RangeIterator it, long offset, long rangesEnd) {
        this.it = it;
        this.offset = offset;
        this.rangesEnd = rangesEnd;
        this.itStart = it.currentRangeStart();
        this.itEnd = it.currentRangeEnd();
        if (this.itStart < offset) {
            this.nextValid = false;
            return;
        }
        this.noMore = false;
        this.itFinished = false;
        this.computeNext();
    }

    private void setTerminated() {
        this.it = null;
        this.nextValid = false;
    }

    private void computeNext() {
        if (this.noMore || this.itStart >= this.rangesEnd) {
            this.setTerminated();
            return;
        }
        this.nextValid = true;
        this.nextStart = (int)(this.itStart - this.offset);
        if (this.itEnd >= this.rangesEnd) {
            this.nextEnd = (int)(this.rangesEnd - this.offset);
            this.itStart = this.rangesEnd;
            this.it.postpone(this.itStart);
            this.noMore = true;
            return;
        }
        this.nextEnd = (int)(this.itEnd - this.offset) + 1;
        if (this.it.hasNext()) {
            this.it.next();
            this.itStart = this.it.currentRangeStart();
            this.itEnd = this.it.currentRangeEnd();
            this.noMore = false;
            return;
        }
        this.itFinished = true;
        this.noMore = true;
    }

    public boolean hasNext() {
        return this.nextValid;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public void next() {
        this.start = this.nextStart;
        this.end = this.nextEnd;
        this.computeNext();
    }

    public boolean advance(int v) {
        throw new UnsupportedOperationException("advance is not supported on RangeIteratorView");
    }

    public boolean search(ContainerUtil.TargetComparator comp) {
        throw new UnsupportedOperationException("search is not supported on RangeIteratorView");
    }

    public boolean underlyingIterFinished() {
        return this.itFinished;
    }
}

