/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.base.verify.Assert;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.RefCountedCow;
import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.rsp.RspIterator;
import io.deephaven.engine.rowset.impl.rsp.RspRangeBatchIterator;
import io.deephaven.engine.rowset.impl.rsp.RspRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.RspReverseIterator;
import io.deephaven.engine.rowset.impl.rsp.RspRowSequence;
import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.SingleRangeContainer;
import io.deephaven.engine.rowset.impl.rsp.container.TwoValuesContainer;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesInt;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import java.util.PrimitiveIterator;
import java.util.function.IntToLongFunction;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class RspArray<T extends RspArray>
extends RefCountedCow<T> {
    public static final boolean debug = Configuration.getInstance().getBooleanForClassWithDefault(RspArray.class, "debug", false);
    private static final int doublingAllocThreshold = Configuration.getInstance().getIntegerForClassWithDefault(RspArray.class, "doublingAllocThreshold", 1024);
    private static final int linearAllocStep = Configuration.getInstance().getIntegerForClassWithDefault(RspArray.class, "linearAllocStep", 1024);
    private static final int logarithmicAllocGrowthRate = Configuration.getInstance().getIntegerForClassWithDefault(RspArray.class, "logarithmicAllocGrowthRate", 4);
    static final int accNullThreshold = Configuration.getInstance().getIntegerForClassWithDefault(RspArray.class, "accNullThreshold", 8);
    public static final int BLOCK_SIZE = 65536;
    public static final int BLOCK_LAST = 65535;
    public static final int BITS_PER_BLOCK;
    protected long[] spanInfos;
    protected Object[] spans;
    int size;
    public static final Object FULL_BLOCK_SPAN_MARKER;
    private static final long SPANINFO_ARRAYCONTAINER_SHARED_BITMASK = 32768L;
    private static final long SPANINFO_ARRAYCONTAINER_CARDINALITY_BITMASK = 32767L;
    long[] acc;
    int cardData;
    static final int INITIAL_CAPACITY = 1;
    protected static final ThreadLocal<WorkData> workDataPerThread;
    private static boolean debugValidateEnabled;

    protected boolean shareContainers() {
        return true;
    }

    protected abstract T make(RspArray var1, int var2, long var3, int var5, long var6);

    protected abstract T make();

    public static long highBits(long val) {
        return val & 0xFFFFFFFFFFFF0000L;
    }

    public static short lowBits(long val) {
        return (short)(val & 0xFFFFL);
    }

    public static int lowBitsAsInt(long val) {
        return (int)(val & 0xFFFFL);
    }

    public static long divBlockSize(long v) {
        return v / 65536L;
    }

    public static int modBlockSize(long v) {
        return (int)(v & 0xFFFFL);
    }

    @VisibleForTesting
    long[] getKeys() {
        long[] out = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            out[i] = RspArray.spanInfoToKey(this.getSpanInfo(i));
        }
        return out;
    }

    int getSize() {
        return this.size;
    }

    @VisibleForTesting
    Object[] getSpans() {
        return this.spans;
    }

    protected final long getSpanInfo(int i) {
        return this.spanInfos[i];
    }

    protected static long spanInfoToKey(long spanInfo) {
        return RspArray.highBits(spanInfo);
    }

    protected final long getKey(int i) {
        return RspArray.spanInfoToKey(this.spanInfos[i]);
    }

    protected final long getSingletonSpanValue(int i) {
        return this.spanInfos[i];
    }

    protected static long spanInfoToSingletonSpanValue(long spanInfo) {
        return spanInfo;
    }

    protected final void setSingletonSpanRaw(int i, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value=" + value);
        }
        this.spans[i] = null;
        this.spanInfos[i] = value;
    }

    protected final void setSingletonSpan(int i, long value) {
        this.setSingletonSpanRaw(i, value);
        this.modifiedSpan(i);
    }

    protected final void applyKeyOffset(int i, long offset) {
        int n = i;
        this.spanInfos[n] = this.spanInfos[n] + offset;
    }

    protected void setFullBlockSpanRaw(int i, long key, long flen) {
        RspArray.setFullBlockSpanRaw(i, this.spanInfos, this.spans, key, flen);
    }

    protected static void setFullBlockSpanRaw(int i, long[] spanInfos, Object[] spans, long key, long flen) {
        if (key < 0L || flen <= 0L) {
            throw new IllegalArgumentException("i=" + i + ", key=" + key + ", flen=" + flen);
        }
        long lowflen = RspArray.lowBitsAsInt(flen);
        if (lowflen == flen) {
            spanInfos[i] = key | lowflen;
            spans[i] = FULL_BLOCK_SPAN_MARKER;
            return;
        }
        spanInfos[i] = key;
        spans[i] = flen;
    }

    protected void setFullBlockSpan(int i, long key, long flen) {
        this.setFullBlockSpanRaw(i, key, flen);
        this.modifiedSpan(i);
    }

    public static long getPackedInfoLowBits(ArrayContainer ac) {
        long sharedBit = ac.isShared() ? 32768L : 0L;
        long cardinalityBits = 0x7FFFL & (long)ac.getCardinality();
        return sharedBit | cardinalityBits;
    }

    protected static void setContainerSpanRaw(long[] spanInfos, Object[] spans, int i, long key, Container container) {
        if (container instanceof ArrayContainer) {
            ArrayContainer ac = (ArrayContainer)container;
            spanInfos[i] = key | RspArray.getPackedInfoLowBits(ac);
            spans[i] = ac.getContent();
            return;
        }
        spanInfos[i] = key;
        spans[i] = container;
    }

    protected void setContainerSpanRaw(int i, long key, Container container) {
        RspArray.setContainerSpanRaw(this.spanInfos, this.spans, i, key, container);
    }

    protected void appendSharedContainer(RspArray other, long otherSpanInfo, Container container) {
        if (this.size > 0) {
            this.tryOptimizeContainer(this.size - 1);
        }
        this.ensureSizeCanGrowBy(1);
        this.setSharedContainerRaw(this.size, other, otherSpanInfo, container);
        ++this.size;
    }

    protected void appendSharedContainerMaybePacked(RspArray other, int otherIdx, long otherSpanInfo, Object otherContainer) {
        if (this.size > 0) {
            this.tryOptimizeContainer(this.size - 1);
        }
        this.ensureSizeCanGrowBy(1);
        this.setSharedContainerMaybePackedRaw(this.size, other, otherIdx, otherSpanInfo, otherContainer);
        ++this.size;
    }

    protected void setSharedContainerMaybePackedRaw(int i, RspArray src, int srcIdx, long srcSpanInfo, Object srcContainer) {
        if (srcContainer instanceof short[]) {
            int n = srcIdx;
            long l = src.spanInfos[n] | 0x8000L;
            src.spanInfos[n] = l;
            this.spanInfos[i] = l;
            this.spans[i] = srcContainer;
            return;
        }
        this.setContainerSpanRaw(i, srcSpanInfo, src.shareContainer((Container)srcContainer));
    }

    protected void insertSharedContainer(int i, RspArray other, long otherSpanInfo, Container otherContainer) {
        this.open(i);
        this.setSharedContainerRaw(i, other, otherSpanInfo, otherContainer);
        this.modifiedSpan(i);
    }

    protected void setSharedContainerRaw(int i, RspArray other, long key, Container container) {
        this.setContainerSpanRaw(i, key, other.shareContainer(container));
    }

    protected void copyKeyAndSpanStealingContainers(int srcIdx, long[] srcSpanInfos, Object[] srcSpans, int dstIdx, long[] dstSpanInfos, Object[] dstSpans) {
        dstSpanInfos[dstIdx] = srcSpanInfos[srcIdx];
        dstSpans[dstIdx] = srcSpans[srcIdx];
    }

    protected void copyKeyAndSpanMaybeSharing(long shiftAmount, RspArray src, int srcIdx, long[] dstSpanInfos, Object[] dstSpans, int dstIdx, boolean tryShare) {
        Object span = src.spans[srcIdx];
        if (tryShare && src.shareContainers()) {
            if (span instanceof short[]) {
                int n = srcIdx;
                src.spanInfos[n] = src.spanInfos[n] | 0x8000L;
            } else if (span instanceof Container) {
                Container c = (Container)span;
                c.setCopyOnWrite();
            }
        }
        dstSpanInfos[dstIdx] = src.spanInfos[srcIdx] + shiftAmount;
        dstSpans[dstIdx] = span;
    }

    protected void copyKeyAndSpanMaybeSharing(RspArray src, int srcIdx, long[] dstSpanInfos, Object[] dstSpans, int dstIdx) {
        this.copyKeyAndSpanMaybeSharing(0L, src, srcIdx, dstSpanInfos, dstSpans, dstIdx, true);
    }

    protected void setContainerSpan(int i, long key, Container c) {
        this.setContainerSpanRaw(i, key, c);
        this.modifiedSpan(i);
    }

    protected void setContainerSpan(Container oldContainer, int i, long key, Container newContainer) {
        if (oldContainer != newContainer || oldContainer instanceof ArrayContainer) {
            this.setContainerSpanRaw(i, key, newContainer);
        }
        this.modifiedSpan(i);
    }

    protected static boolean isSingletonSpan(Object o) {
        return o == null;
    }

    RspArray() {
        this.spanInfos = new long[1];
        this.spans = new Object[1];
        this.acc = null;
        this.cardData = 0;
        this.size = 0;
    }

    void setCardDataFor(long cardinality) {
        int intCard = (int)cardinality;
        this.cardData = cardinality != (long)intCard ? -1 : intCard;
    }

    RspArray(long start, long end) {
        long sHigh = RspArray.highBits(start);
        long eHigh = RspArray.highBits(end);
        int sLow = RspArray.lowBitsAsInt(start);
        int eLow = RspArray.lowBitsAsInt(end);
        long cardinality = end - start + 1L;
        if (sHigh == eHigh) {
            this.acc = null;
            this.setCardDataFor(cardinality);
            this.size = 1;
            this.spanInfos = new long[1];
            this.spans = new Object[1];
            if (cardinality == 1L) {
                this.setSingletonSpan(0, start);
            } else if (cardinality == 65536L) {
                this.setFullBlockSpanRaw(0, sHigh, 1L);
            } else {
                this.setContainerSpanRaw(0, sHigh, Container.rangeOfOnes((int)sLow, (int)(eLow + 1)));
            }
            return;
        }
        if (sLow == 0) {
            if (eLow == 65535) {
                this.spanInfos = new long[1];
                this.spans = new Object[1];
                this.setFullBlockSpanRaw(0, sHigh, RspArray.distanceInBlocks(sHigh, eHigh) + 1L);
                this.acc = null;
                this.setCardDataFor(cardinality);
                this.size = 1;
                return;
            }
            this.spanInfos = new long[2];
            this.spans = new Object[2];
            this.setFullBlockSpanRaw(0, sHigh, RspArray.distanceInBlocks(sHigh, eHigh));
            if (eLow == 0) {
                this.setSingletonSpan(1, end);
            } else {
                this.setContainerSpanRaw(1, eHigh, Container.rangeOfOnes((int)0, (int)(eLow + 1)));
            }
            this.acc = null;
            this.setCardDataFor(cardinality);
            this.size = 2;
            return;
        }
        if (eLow == 65535) {
            this.spanInfos = new long[2];
            this.spans = new Object[2];
            if (sLow == 65535) {
                this.setSingletonSpan(0, start);
            } else {
                this.setContainerSpanRaw(0, sHigh, Container.rangeOfOnes((int)sLow, (int)65536));
            }
            this.setFullBlockSpanRaw(1, RspArray.nextKey(sHigh), RspArray.distanceInBlocks(sHigh, eHigh));
            this.acc = null;
            this.setCardDataFor(cardinality);
            this.size = 2;
            return;
        }
        long nextKey = RspArray.nextKey(sHigh);
        long midflen = RspArray.distanceInBlocks(nextKey, eHigh);
        if (midflen == 0L) {
            this.spanInfos = new long[2];
            this.spans = new Object[2];
            if (sLow == 65535) {
                this.setSingletonSpan(0, start);
            } else {
                this.setContainerSpanRaw(0, sHigh, Container.rangeOfOnes((int)sLow, (int)65536));
            }
            if (eLow == 0) {
                this.setSingletonSpan(1, end);
            } else {
                this.setContainerSpanRaw(1, eHigh, Container.rangeOfOnes((int)0, (int)(eLow + 1)));
            }
            this.acc = null;
            this.setCardDataFor(cardinality);
            this.size = 2;
            return;
        }
        this.spanInfos = new long[3];
        this.spans = new Object[3];
        if (sLow == 65535) {
            this.setSingletonSpan(0, start);
        } else {
            this.setContainerSpanRaw(0, sHigh, Container.rangeOfOnes((int)sLow, (int)65536));
        }
        this.setFullBlockSpanRaw(1, nextKey, midflen);
        if (eLow == 0) {
            this.setSingletonSpan(2, end);
        } else {
            this.setContainerSpanRaw(2, eHigh, Container.rangeOfOnes((int)0, (int)(eLow + 1)));
        }
        this.acc = null;
        this.setCardDataFor(cardinality);
        this.size = 3;
    }

    Container shareContainer(Container c) {
        if (c != null && this.shareContainers()) {
            c.setCopyOnWrite();
        }
        return c;
    }

    protected RspArray(RspArray other) {
        this.copySharingSpansFrom(other, 0L);
    }

    private void copySharingSpansFrom(RspArray other, long shiftAmount) {
        int newSize = other.size >= 2 && other.size < other.spanInfos.length / 2 ? other.spanInfos.length / 2 : other.spanInfos.length;
        this.spanInfos = new long[newSize];
        this.spans = new Object[newSize];
        for (int i = 0; i < other.size; ++i) {
            this.copyKeyAndSpanMaybeSharing(shiftAmount, other, i, this.spanInfos, this.spans, i, true);
        }
        if (other.acc != null) {
            this.acc = new long[newSize];
            System.arraycopy(other.acc, 0, this.acc, 0, other.size);
        } else {
            this.acc = null;
        }
        this.cardData = other.cardData;
        this.size = other.size;
    }

    private void maybeSetAcc(int i, long accumCard) {
        if (this.acc == null) {
            return;
        }
        this.acc[i] = accumCard;
    }

    public RspArray(RspArray src, int startIdx, int endIdx) {
        this.size = endIdx - startIdx + 1;
        this.spanInfos = new long[this.size];
        this.spans = new Object[this.size];
        long srcAccBeforeStart = -1L;
        if (this.size > accNullThreshold) {
            this.acc = new long[this.size];
            if (src.acc == null) {
                this.cardData = -1;
            } else {
                srcAccBeforeStart = startIdx == 0 ? 0L : src.acc[startIdx - 1];
                this.cardData = this.size - 1;
            }
        } else {
            this.acc = null;
        }
        for (int i = 0; i < this.size; ++i) {
            Object span;
            int isrc = startIdx + i;
            if (srcAccBeforeStart != -1L) {
                this.acc[i] = src.acc[isrc] - srcAccBeforeStart;
            }
            this.spanInfos[i] = src.spanInfos[isrc];
            this.spans[i] = span = src.spans[isrc];
            if (span == null || span == FULL_BLOCK_SPAN_MARKER) continue;
            if (span instanceof short[]) {
                int n = i;
                this.spanInfos[n] = this.spanInfos[n] | 0x8000L;
                continue;
            }
            ((Container)span).setCopyOnWrite();
        }
        if (this.acc == null) {
            this.ensureCardData(false);
        } else if (src.acc == null) {
            this.ensureCardinalityCache(false);
        }
        this.ifDebugValidate();
    }

    public RspArray(RspArray src, int startIdx, long startOffset, int endIdx, long endOffset) {
        int isrc;
        long keyForFirstBlock;
        boolean firstSpanIsFull;
        int startSplitInitialContainerCard = 0;
        long startSplitIntermediateFullBlockSpanLen = 0L;
        long startSplitIntermediateFullBlockSpanCard = 0L;
        int startSplitEndingContainerCard = 0;
        Object firstSpan = src.spans[startIdx];
        int sz = endIdx - startIdx + 1;
        long firstSpanInfo = src.spanInfos[startIdx];
        long startIdxKey = RspArray.spanInfoToKey(firstSpanInfo);
        long flenFirstSpan = RspArray.getFullBlockSpanLen(firstSpanInfo, firstSpan);
        if (flenFirstSpan == 0L) {
            firstSpanIsFull = false;
            keyForFirstBlock = startIdxKey;
        } else {
            long resultingCardFromFirstSpan;
            firstSpanIsFull = true;
            long startKey = startIdxKey + startOffset;
            keyForFirstBlock = RspArray.highBits(startKey);
            if (endIdx <= startIdx) {
                resultingCardFromFirstSpan = endOffset - startOffset + 1L;
                long singleIdxEndKey = RspArray.highBits(startIdxKey + endOffset);
                if (singleIdxEndKey == keyForFirstBlock) {
                    this.size = 1;
                    this.spanInfos = new long[1];
                    this.spans = new Object[1];
                    if (resultingCardFromFirstSpan == 65536L) {
                        this.setFullBlockSpanRaw(0, keyForFirstBlock, 1L);
                    } else {
                        int containerStart = (int)(startOffset & 0xFFFFL);
                        int containerEndInclusive = (int)(endOffset & 0xFFFFL);
                        if (containerStart == containerEndInclusive) {
                            this.setSingletonSpanRaw(0, startKey);
                        } else {
                            Container c = Container.rangeOfOnes((int)containerStart, (int)(containerEndInclusive + 1));
                            this.setContainerSpanRaw(0, keyForFirstBlock, c);
                        }
                    }
                    this.acc = null;
                    this.setCardDataFor(resultingCardFromFirstSpan);
                    this.ifDebugValidate();
                    return;
                }
            } else {
                resultingCardFromFirstSpan = flenFirstSpan * 65536L - startOffset;
            }
            int n = 0;
            long startOffsetModBlockSize = RspArray.modBlockSize(startOffset);
            if (startOffsetModBlockSize == 0L) {
                startSplitInitialContainerCard = 0;
            } else {
                startSplitInitialContainerCard = (int)(65536L - startOffsetModBlockSize);
                ++n;
            }
            long remainingCard = resultingCardFromFirstSpan - (long)startSplitInitialContainerCard;
            startSplitIntermediateFullBlockSpanLen = RspArray.divBlockSize(remainingCard);
            if (startSplitIntermediateFullBlockSpanLen > 0L) {
                ++n;
            }
            startSplitEndingContainerCard = RspArray.modBlockSize(remainingCard);
            startSplitIntermediateFullBlockSpanCard = remainingCard - (long)startSplitEndingContainerCard;
            if (startSplitEndingContainerCard > 0) {
                ++n;
            }
            sz += n - 1;
        }
        boolean lastSpanIsFull = false;
        long deltaLast = 0L;
        int copyLastIdx = endIdx;
        if (endIdx > startIdx && endOffset < src.getSpanCardinalityAtIndexMaybeAcc(endIdx) - 1L) {
            copyLastIdx = endIdx - 1;
            long lastSpanInfo = src.spanInfos[endIdx];
            Object lastSpan = src.spans[endIdx];
            long flenLastSpan = RspArray.getFullBlockSpanLen(lastSpanInfo, lastSpan);
            if (flenLastSpan > 0L) {
                lastSpanIsFull = true;
                deltaLast = endOffset + 1L;
                if (deltaLast > 65536L) {
                    ++sz;
                }
            }
        }
        this.size = sz;
        this.spanInfos = new long[this.size];
        this.spans = new Object[this.size];
        if (this.size > accNullThreshold) {
            this.acc = new long[this.size];
            this.cardData = this.size - 1;
        } else {
            this.acc = null;
        }
        int i = 0;
        long accSum = 0L;
        WorkDataHolder wd = new WorkDataHolder();
        if (firstSpanIsFull) {
            Container c;
            long nextKey = keyForFirstBlock;
            if (startSplitInitialContainerCard > 0) {
                if (startSplitInitialContainerCard == 1) {
                    this.setSingletonSpanRaw(0, nextKey | 0xFFFFL);
                } else {
                    c = Container.rangeOfOnes((int)(65536 - startSplitInitialContainerCard), (int)65536);
                    this.setContainerSpanRaw(0, nextKey, c);
                }
                nextKey = RspArray.nextKey(nextKey);
                accSum = startSplitInitialContainerCard;
                this.maybeSetAcc(0, accSum);
                i = 1;
            }
            if (startSplitIntermediateFullBlockSpanLen > 0L) {
                this.setFullBlockSpanRaw(i, nextKey, startSplitIntermediateFullBlockSpanLen);
                nextKey = RspArray.highBits(nextKey + startSplitIntermediateFullBlockSpanCard);
                this.maybeSetAcc(i, accSum += startSplitIntermediateFullBlockSpanCard);
                ++i;
            }
            if (startSplitEndingContainerCard > 0) {
                if (startSplitEndingContainerCard == 1) {
                    this.setSingletonSpanRaw(i, nextKey);
                } else {
                    c = Container.rangeOfOnes((int)0, (int)startSplitEndingContainerCard);
                    this.setContainerSpanRaw(i, nextKey, c);
                }
                accSum += (long)startSplitEndingContainerCard;
                if (this.acc != null) {
                    this.acc[i] = accSum;
                } else {
                    this.setCardDataFor(accSum);
                }
                this.ifDebugValidate();
                return;
            }
            isrc = startIdx + 1;
        } else if (startOffset != 0L || endIdx <= startIdx && endOffset < 65535L) {
            Object spanSrc = src.spans[startIdx];
            if (RspArray.isSingletonSpan(spanSrc)) {
                if (startOffset != 0L) {
                    throw new IllegalArgumentException("startOffset=" + startOffset + " and span at startIdx has a single element.");
                }
                this.setSingletonSpanRaw(0, src.getSingletonSpanValue(startIdx));
                accSum = 1L;
                this.maybeSetAcc(0, 1L);
            } else {
                try (SpanView res = wd.get().borrowSpanView(src, startIdx);){
                    int card;
                    Container csrc = res.getContainer();
                    if (endIdx <= startIdx && endOffset + 1L < (long)(card = (int)src.getSpanCardinalityAtIndexMaybeAcc(startIdx))) {
                        if (startOffset == endOffset) {
                            this.setSingletonSpanRaw(0, startIdxKey | (long)RspArray.unsignedShortToInt(csrc.select((int)startOffset)));
                        } else {
                            Container c = csrc.select((int)startOffset, (int)(endOffset + 1L));
                            this.setContainerSpanRaw(0, startIdxKey, c);
                        }
                        accSum = endOffset - startOffset + 1L;
                        if (this.acc != null) {
                            this.acc[0] = accSum;
                        } else {
                            this.setCardDataFor(accSum);
                        }
                        this.ifDebugValidate();
                        return;
                    }
                    int startOffsetInt = (int)startOffset;
                    card = (int)src.getSpanCardinalityAtIndexMaybeAcc(startIdx);
                    if (startOffsetInt + 1 == card) {
                        this.setSingletonSpanRaw(0, startIdxKey | (long)RspArray.unsignedShortToInt(csrc.select(startOffsetInt)));
                    } else {
                        Container c = csrc.select(startOffsetInt, card);
                        this.setContainerSpanRaw(0, startIdxKey, c);
                    }
                    accSum = (long)card - startOffset;
                    this.maybeSetAcc(0, accSum);
                }
            }
            i = 1;
            isrc = startIdx + 1;
        } else {
            i = 0;
            isrc = startIdx;
            accSum = 0L;
        }
        if (endIdx <= startIdx && i > 0) {
            if (this.acc == null) {
                this.setCardDataFor(accSum);
            }
            this.ifDebugValidate();
            return;
        }
        while (isrc <= copyLastIdx) {
            this.copyKeyAndSpanMaybeSharing(src, isrc, this.spanInfos, this.spans, i);
            this.maybeSetAcc(i, accSum += src.getSpanCardinalityAtIndexMaybeAcc(isrc));
            ++i;
            ++isrc;
        }
        if (isrc > endIdx) {
            if (this.acc == null) {
                this.setCardDataFor(accSum);
            }
            this.ifDebugValidate();
            return;
        }
        long srcSpanInfo = src.spanInfos[isrc];
        long srcKey = RspArray.spanInfoToKey(srcSpanInfo);
        if (lastSpanIsFull) {
            if (deltaLast >= 65536L) {
                long flen = RspArray.divBlockSize(deltaLast);
                int delta = RspArray.modBlockSize(deltaLast);
                this.setFullBlockSpanRaw(i, srcKey, flen);
                this.maybeSetAcc(i, accSum += flen * 65536L);
                ++i;
                if (delta > 0) {
                    long nextKey = srcKey + flen * 65536L;
                    if (delta == 1) {
                        this.setSingletonSpanRaw(i, nextKey);
                    } else {
                        Container c = Container.rangeOfOnes((int)0, (int)delta);
                        this.setContainerSpanRaw(i, nextKey, c);
                    }
                    this.maybeSetAcc(i, accSum += (long)delta);
                }
            } else {
                int ce = (int)deltaLast;
                if (ce == 1) {
                    this.setSingletonSpanRaw(i, srcKey);
                } else {
                    this.setContainerSpanRaw(i, srcKey, Container.rangeOfOnes((int)0, (int)ce));
                }
                this.maybeSetAcc(i, accSum += deltaLast);
            }
        } else {
            long card = endOffset + 1L;
            Object srcSpan = src.spans[isrc];
            if (!RspArray.isSingletonSpan(srcSpan)) {
                try (SpanView res = wd.get().borrowSpanView(src, isrc, srcSpanInfo, srcSpan);){
                    Container csrc = res.getContainer();
                    if (endOffset == 0L) {
                        this.setSingletonSpanRaw(i, srcKey | (long)csrc.first());
                    } else {
                        Container c = csrc.select(0, (int)card);
                        this.setContainerSpanRaw(i, srcKey, c);
                    }
                    this.maybeSetAcc(i, accSum += card);
                }
            } else {
                throw new IllegalStateException("endIdx=" + endIdx + ", endOffset=" + endOffset + ", key=" + srcKey);
            }
        }
        if (this.acc == null) {
            this.setCardDataFor(accSum);
        }
        this.ifDebugValidate();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public long firstValue() {
        return this.firstValueAtIndex(0);
    }

    public long firstValueAtIndex(int i) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i);){
            if (view.isSingletonSpan()) {
                long l = view.getSingletonSpanValue();
                return l;
            }
            long k = view.getKey();
            if (view.isFullBlockSpan()) {
                long l = k;
                return l;
            }
            long l = k | (long)view.getContainer().first();
            return l;
        }
    }

    public long keyForFirstBlock() {
        return this.getKey(0);
    }

    public long keyForLastBlock() {
        Object span = this.spans[this.size - 1];
        long spanInfo = this.spanInfos[this.size - 1];
        long key = RspArray.spanInfoToKey(spanInfo);
        long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
        if (flen > 0L) {
            return key + (flen - 1L) * 65536L;
        }
        return key;
    }

    public long lastValue() {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, this.size - 1);){
            if (view.isSingletonSpan()) {
                long l = view.getSingletonSpanValue();
                return l;
            }
            long flen = view.getFullBlockSpanLen();
            long key = view.getKey();
            if (flen > 0L) {
                long l = key + 65536L * flen - 1L;
                return l;
            }
            long l = key | (long)view.getContainer().last();
            return l;
        }
    }

    public RspRangeIterator getRangeIterator() {
        return new RspRangeIterator(new SpanCursorForwardImpl(this));
    }

    public RspRangeBatchIterator getRangeBatchIterator(long initialSeek, long maxCount) {
        return new RspRangeBatchIterator(new SpanCursorForwardImpl(this), initialSeek, maxCount);
    }

    public RspIterator getIterator() {
        return new RspIterator(new SpanCursorForwardImpl(this));
    }

    public RspReverseIterator getReverseIterator() {
        return new RspReverseIterator(new SpanCursorBackwardImpl(this));
    }

    private int targetCapacityForSize(int sz) {
        if (sz < 1024) {
            return 1 << 31 - Integer.numberOfLeadingZeros(sz - 1);
        }
        if ((sz & 3) == 0) {
            return sz;
        }
        return 5 * (sz / 4);
    }

    protected void ensureSizeCanGrowBy(int n) {
        int newCapacity;
        int minCapacity = this.size + n;
        if (minCapacity <= this.spanInfos.length) {
            return;
        }
        int n2 = newCapacity = this.size == 0 ? 1 : this.size;
        while (newCapacity < minCapacity && newCapacity < doublingAllocThreshold) {
            newCapacity = 2 * newCapacity;
        }
        while (newCapacity < minCapacity) {
            int rawStep = Math.max(linearAllocStep, newCapacity >> logarithmicAllocGrowthRate);
            newCapacity += rawStep + 1023 & 0xFFFFFC00;
        }
        this.realloc(newCapacity);
    }

    private void realloc(int newCapacity) {
        long[] newSpanInfos = new long[newCapacity];
        System.arraycopy(this.spanInfos, 0, newSpanInfos, 0, this.size);
        this.spanInfos = newSpanInfos;
        Object[] newSpans = new Object[newCapacity];
        System.arraycopy(this.spans, 0, newSpans, 0, this.size);
        this.spans = newSpans;
        if (this.acc != null) {
            long[] newAcc = new long[newCapacity];
            System.arraycopy(this.acc, 0, newAcc, 0, this.size);
            this.acc = newAcc;
        }
    }

    public void tryCompactUnsafe(int compactFactor) {
        if (compactFactor == 0 ? this.size == this.spanInfos.length : this.spanInfos.length - this.size <= this.spanInfos.length >> compactFactor) {
            return;
        }
        this.realloc(this.size);
    }

    public void tryCompact(int compactFactor) {
        if (!this.canWrite()) {
            return;
        }
        this.tryCompactUnsafe(compactFactor);
    }

    public int keySearch(int startPos, long key) {
        return this.keySearch(startPos, this.size, key);
    }

    public int keySearch(int startPos, int endPosExclusive, long key) {
        long blockKey = RspArray.highBits(key);
        if (endPosExclusive == 0 || this.getKey(endPosExclusive - 1) == blockKey) {
            return endPosExclusive - 1;
        }
        return RspArray.unsignedBinarySearch(this::getKey, startPos, endPosExclusive, blockKey);
    }

    public static boolean isFullBlockSpan(Object s) {
        return s == FULL_BLOCK_SPAN_MARKER || s instanceof Long;
    }

    public static boolean isContainer(Object s) {
        return s instanceof short[] || s instanceof Container;
    }

    @VisibleForTesting
    long getFullBlockSpanLenAt(int i) {
        long spanInfo = this.spanInfos[i];
        Object span = this.spans[i];
        return RspArray.getFullBlockSpanLen(spanInfo, span);
    }

    public static long getFullBlockSpanLen(long spanInfo, Object span) {
        if (span == FULL_BLOCK_SPAN_MARKER) {
            return spanInfo & 0xFFFFL;
        }
        if (span instanceof Long) {
            return (Long)span;
        }
        return 0L;
    }

    public int getSpanIndex(long key) {
        return this.getSpanIndex(0, key);
    }

    public int getSpanIndex(int fromIndex, long key) {
        return this.getSpanIndex(fromIndex, this.size, key);
    }

    public int getSpanIndex(int fromIndex, int endIndexExclusive, long key) {
        int i = this.keySearch(fromIndex, endIndexExclusive, key);
        if (i >= 0) {
            return i;
        }
        int preIdx = -i - 2;
        if (preIdx < fromIndex) {
            return i;
        }
        long preSpanInfo = this.spanInfos[preIdx];
        Object preSpan = this.spans[preIdx];
        long flen = RspArray.getFullBlockSpanLen(preSpanInfo, preSpan);
        if (flen == 0L) {
            return i;
        }
        long preKey = RspArray.spanInfoToKey(preSpanInfo);
        if (RspArray.distanceInBlocks(preKey, key) < flen) {
            return preIdx;
        }
        return i;
    }

    public int searchSpanIndex(int startPos, RowSetUtils.Comparator comp) {
        int i = this.binarySearchKeys(startPos, this.size, comp);
        if (i < 0 && (i = -i - 2) < startPos) {
            return startPos;
        }
        return i;
    }

    public long getSpanCardinalityAtIndexMaybeAcc(int i) {
        if (this.acc != null) {
            return this.getSpanCardinalityFromAccAtIndex(i);
        }
        return this.getSpanCardinalityAtIndex(i);
    }

    public long getSpanCardinalityAtIndex(int i) {
        return this.getSpanCardinalityAtIndex(i, false);
    }

    public long getSpanCardinalityAtIndex(int i, boolean optimizeContainers) {
        long spanInfo = this.spanInfos[i];
        Object span = this.spans[i];
        long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
        if (flen > 0L) {
            return 65536L * flen;
        }
        if (RspArray.isSingletonSpan(span)) {
            return 1L;
        }
        if (span instanceof short[]) {
            return spanInfo & 0x7FFFL;
        }
        Container c = (Container)span;
        if (optimizeContainers) {
            c = c.runOptimize();
            this.spans[i] = c;
        }
        return c.getCardinality();
    }

    boolean isCardinalityCached() {
        if (this.acc != null) {
            return this.cardData == this.size - 1;
        }
        return this.cardData >= 0;
    }

    void ensureCardinalityCache() {
        this.ensureCardinalityCache(false);
    }

    T forceAcc() {
        if (this.acc != null) {
            return (T)((RspArray)this.self());
        }
        RspArray ref = (RspArray)this.getWriteRef();
        ref.acc = new long[ref.spanInfos.length];
        ref.cardData = ref.size - 1;
        long card = 0L;
        for (int i = 0; i < ref.size; ++i) {
            ref.acc[i] = card += ref.getSpanCardinalityAtIndex(i);
        }
        return (T)ref;
    }

    void ensureCardData(boolean optimizeContainers) {
        this.acc = null;
        long c = 0L;
        for (int i = 0; i < this.size; ++i) {
            if ((c += this.getSpanCardinalityAtIndex(i, optimizeContainers)) <= Integer.MAX_VALUE) continue;
            this.cardData = -1;
            return;
        }
        this.cardData = (int)c;
    }

    void ensureCardinalityCache(boolean optimizeContainers) {
        long cardinality;
        if (this.size == 0) {
            this.acc = null;
            this.cardData = 0;
            this.ifDebugValidate();
            return;
        }
        if (this.size <= accNullThreshold) {
            this.ensureCardData(optimizeContainers);
            return;
        }
        if (this.acc == null) {
            this.acc = new long[this.spanInfos.length];
            this.cardData = -1;
        }
        long l = cardinality = this.cardData >= 0 ? this.acc[this.cardData] : 0L;
        while (this.cardData < this.size - 1) {
            ++this.cardData;
            long c = this.getSpanCardinalityAtIndex(this.cardData, optimizeContainers);
            this.acc[this.cardData] = cardinality += c;
        }
        this.ifDebugValidate();
    }

    private static Container maybeOptimize(Container c) {
        if (RspArray.shouldOptimize(c)) {
            return c.runOptimize();
        }
        return c;
    }

    private static boolean shouldOptimize(Container c) {
        int bytesUsed = c.bytesUsed();
        int bytesOverhead = c.bytesAllocated() - bytesUsed;
        if (bytesOverhead > bytesUsed) {
            return true;
        }
        if (!(c instanceof ArrayContainer) && !(c instanceof BitmapContainer)) {
            return false;
        }
        int card = c.getCardinality();
        if (card == 0) {
            throw new IllegalStateException("Zero cardinality container:" + c.toString());
        }
        int range = c.last() - c.first() + 1;
        int runsMinusOneUpperBound = Math.min(card - 1, range - card);
        return runsMinusOneUpperBound < 16;
    }

    void ensureAccAndOptimize() {
        this.ensureCardinalityCache(true);
    }

    private long calculateCardinality() {
        long c = 0L;
        for (int i = 0; i < this.size; ++i) {
            c += this.getSpanCardinalityAtIndex(i);
        }
        return c;
    }

    public long getCardinality() {
        if (this.acc != null) {
            return this.size == 0 ? 0L : this.acc[this.size - 1];
        }
        if (this.cardData >= 0) {
            return this.cardData;
        }
        return this.calculateCardinality();
    }

    void modifiedSpan(int i) {
        if (this.acc != null) {
            this.cardData = Math.min(i - 1, this.cardData);
            return;
        }
        this.cardData = -1;
    }

    void modifiedLastSpan() {
        if (this.acc != null) {
            this.cardData = Math.min(this.size - 2, this.cardData);
            return;
        }
        this.cardData = -1;
    }

    long getFullBlocksCount() {
        long tflen = 0L;
        for (int i = 0; i < this.size; ++i) {
            Object span = this.spans[i];
            long spanInfo = this.spanInfos[i];
            tflen += RspArray.getFullBlockSpanLen(spanInfo, span);
        }
        return tflen;
    }

    public static long nextKey(long key) {
        return key + 65536L;
    }

    public static long distanceInBlocks(long blockKeyStart, long blockKeyEnd) {
        return blockKeyEnd - blockKeyStart >> 16;
    }

    private void arrayCopies(int src, int dst, int n) {
        System.arraycopy(this.spanInfos, src, this.spanInfos, dst, n);
        System.arraycopy(this.spans, src, this.spans, dst, n);
    }

    private void compact() {
        if (this.size >= this.spans.length) {
            return;
        }
        this.realloc(this.size);
    }

    private void checkCompact() {
        int thresholdSize;
        if (this.size < 2 || this.size > (thresholdSize = this.spans.length / 2)) {
            return;
        }
        this.realloc(thresholdSize);
    }

    private void collapseRange(int idst, int isrc) {
        int newSize = this.size - (isrc - idst);
        int thresholdSize = 0;
        if (newSize > 2 && newSize < (thresholdSize = this.spans.length / 2)) {
            Object[] newSpans = new Object[thresholdSize];
            System.arraycopy(this.spans, 0, newSpans, 0, idst);
            System.arraycopy(this.spans, isrc, newSpans, idst, this.size - isrc);
            this.spans = newSpans;
            long[] newSpanInfos = new long[thresholdSize];
            System.arraycopy(this.spanInfos, 0, newSpanInfos, 0, idst);
            System.arraycopy(this.spanInfos, isrc, newSpanInfos, idst, this.size - isrc);
            this.spanInfos = newSpanInfos;
            if (this.acc != null && thresholdSize > accNullThreshold) {
                long[] newAcc = new long[thresholdSize];
                System.arraycopy(this.acc, 0, newAcc, 0, idst);
                this.acc = newAcc;
            } else {
                this.acc = null;
                this.cardData = -1;
            }
            this.size = newSize;
            return;
        }
        this.arrayCopies(isrc, idst, this.size - isrc);
        for (int j = newSize; j <= this.size - 1; ++j) {
            this.spans[j] = null;
        }
        this.size = newSize;
        this.checkCompact();
    }

    public int setOrInsertFullBlockSpanAtIndex(int newSpanIdx, long newSpanKey, long newSpanFlen, MutableObject<SortedRanges> madeNullSpansMu) {
        long leftKey;
        long keyDistance;
        long leftSpanLen;
        int leftIdx;
        long leftSpanInfo;
        long key;
        Object span;
        long spanInfo;
        long spanLen;
        int idxForFirstKeyBigger;
        int ii;
        long newflen = newSpanFlen;
        if (newSpanIdx < 0) {
            ii = -(newSpanIdx + 1);
            if (ii == this.size) {
                this.appendFullBlockSpan(newSpanKey, newSpanFlen);
                return this.size;
            }
            idxForFirstKeyBigger = ii;
        } else {
            ii = newSpanIdx;
            idxForFirstKeyBigger = ii + 1;
        }
        int lastIdx = 0;
        if (idxForFirstKeyBigger >= this.size) {
            lastIdx = ii;
        } else {
            long rightSpanLastKey;
            long rightLen;
            long rightSpanInfo;
            long rightKey;
            long newSpanLastKey = newSpanKey + (newSpanFlen - 1L) * 65536L;
            int j = this.getSpanIndex(idxForFirstKeyBigger, newSpanLastKey);
            int idxForLastKeyInsideNewSpan = j >= 0 ? j : -j - 2;
            boolean rightDone = false;
            int idxForFirstKeyOutsideNewSpan = idxForLastKeyInsideNewSpan + 1;
            if (idxForFirstKeyOutsideNewSpan < this.size && (rightKey = RspArray.spanInfoToKey(rightSpanInfo = this.spanInfos[idxForFirstKeyOutsideNewSpan])) - newSpanLastKey <= 65536L && (rightLen = RspArray.getFullBlockSpanLen(rightSpanInfo, this.spans[idxForFirstKeyOutsideNewSpan])) > 0L && (rightSpanLastKey = RspArray.getKeyForLastBlockInFullSpan(rightKey, rightLen)) > newSpanLastKey) {
                newflen += RspArray.distanceInBlocks(newSpanLastKey, rightSpanLastKey);
                rightDone = true;
                lastIdx = idxForFirstKeyOutsideNewSpan;
            }
            if (!rightDone) {
                long spanKey;
                long spanLastKey;
                long spanInfo2;
                long len;
                if (idxForLastKeyInsideNewSpan >= 0 && (len = RspArray.getFullBlockSpanLen(spanInfo2 = this.spanInfos[idxForLastKeyInsideNewSpan], this.spans[idxForLastKeyInsideNewSpan])) > 0L && (spanLastKey = RspArray.getKeyForLastBlockInFullSpan(spanKey = RspArray.spanInfoToKey(spanInfo2), len)) > newSpanLastKey) {
                    newflen += RspArray.distanceInBlocks(newSpanLastKey, spanLastKey);
                }
                lastIdx = idxForLastKeyInsideNewSpan;
            }
        }
        long firstKey = newSpanKey;
        int firstIdx = ii;
        if (newSpanIdx >= 0 && (spanLen = RspArray.getFullBlockSpanLen(spanInfo = this.spanInfos[ii], span = this.spans[ii])) > 0L && RspArray.uLessOrEqual(key = RspArray.spanInfoToKey(spanInfo), firstKey)) {
            long d1 = RspArray.distanceInBlocks(key, firstKey);
            newflen = RspArray.uMax(spanLen, newflen + d1);
            firstKey = key;
        }
        if (ii > 0 && (leftSpanInfo = this.spanInfos[leftIdx = ii - 1]) != -1L && (leftSpanLen = RspArray.getFullBlockSpanLen(leftSpanInfo, this.spans[leftIdx])) > 0L && leftSpanLen >= (keyDistance = RspArray.distanceInBlocks(leftKey = RspArray.spanInfoToKey(leftSpanInfo), newSpanKey))) {
            firstKey = leftKey;
            firstIdx = leftIdx;
            newflen += keyDistance;
        }
        if (firstIdx > lastIdx) {
            this.ensureSizeCanGrowBy(1);
            this.arrayCopies(firstIdx, firstIdx + 1, this.size - firstIdx);
            ++this.size;
            lastIdx = firstIdx;
        }
        this.modifiedSpan(firstIdx);
        if (lastIdx == firstIdx) {
            this.setFullBlockSpanRaw(firstIdx, firstKey, newflen);
            return firstIdx;
        }
        if (madeNullSpansMu == null) {
            this.setFullBlockSpanRaw(firstIdx, firstKey, newflen);
            this.collapseRange(firstIdx + 1, lastIdx + 1);
            return firstIdx;
        }
        this.markIndexRangeAsRemoved(madeNullSpansMu, firstIdx, lastIdx - 1);
        this.setFullBlockSpanRaw(lastIdx, firstKey, newflen);
        return lastIdx;
    }

    private boolean tryMergeLeftFullBlockSpan(int idx, long k, long slen) {
        long leftKey;
        long keyDistance;
        if (idx < 1) {
            return false;
        }
        int leftIdx = idx - 1;
        long leftSpanInfo = this.spanInfos[leftIdx];
        long leftSpanLen = RspArray.getFullBlockSpanLen(leftSpanInfo, this.spans[leftIdx]);
        if (leftSpanLen > 0L && leftSpanLen == (keyDistance = RspArray.distanceInBlocks(leftKey = RspArray.spanInfoToKey(leftSpanInfo), k))) {
            this.setFullBlockSpan(leftIdx, leftKey, leftSpanLen + slen);
            return true;
        }
        return false;
    }

    public void setLastFullBlockSpan(long k, long slen) {
        if (this.tryMergeLeftFullBlockSpan(this.size - 1, k, slen)) {
            this.spans[this.size - 1] = null;
            --this.size;
            this.checkCompact();
            return;
        }
        this.setFullBlockSpan(this.size - 1, k, slen);
    }

    private void tryOptimizeContainer(int i) {
        short[] contents;
        Object o = this.spans[i];
        if (o instanceof short[] && ((contents = (short[])o).length < 3 || contents.length > 12)) {
            long spanInfo = this.spanInfos[i];
            try (SpanView res = workDataPerThread.get().borrowSpanView(this, i, spanInfo, contents);){
                Container c = res.getContainer();
                Container prevContainer = c.runOptimize();
                if (prevContainer != c) {
                    this.setContainerSpanRaw(i, RspArray.spanInfoToKey(spanInfo), prevContainer);
                }
                return;
            }
        }
        if (!(o instanceof Container)) {
            return;
        }
        Container prevContainer = (Container)o;
        this.spans[i] = prevContainer.runOptimize();
    }

    public void appendSingletonSpan(long v) {
        if (this.size > 0) {
            this.tryOptimizeContainer(this.size - 1);
        }
        this.ensureSizeCanGrowBy(1);
        this.setSingletonSpanRaw(this.size, v);
        ++this.size;
    }

    public void appendContainer(long k, Container c) {
        if (this.size > 0) {
            this.tryOptimizeContainer(this.size - 1);
        }
        this.ensureSizeCanGrowBy(1);
        this.setContainerSpanRaw(this.size, k, c);
        ++this.size;
    }

    public void appendFullBlockSpan(long k, long slen) {
        if (this.tryMergeLeftFullBlockSpan(this.size, k, slen)) {
            return;
        }
        if (this.size > 0) {
            this.tryOptimizeContainer(this.size - 1);
        }
        this.ensureSizeCanGrowBy(1);
        this.setFullBlockSpanRaw(this.size, k, slen);
        if (this.isCardinalityCached()) {
            long deltaCard = slen * 65536L;
            if (this.acc != null) {
                long c = this.size == 0 ? 0L : this.acc[this.size - 1];
                this.acc[this.size] = c + deltaCard;
            } else {
                this.setCardDataFor((long)this.cardData + deltaCard);
            }
        }
        ++this.size;
    }

    private void open(int i) {
        this.ensureSizeCanGrowBy(1);
        int dstPos = i + 1;
        int n = this.size - i;
        this.arrayCopies(i, dstPos, n);
        ++this.size;
    }

    public void insertFullBlockSpanAtIndex(int i, long key, long flen) {
        this.open(i);
        this.setFullBlockSpan(i, key, flen);
    }

    public void insertSingletonAtIndex(int i, long value) {
        this.open(i);
        this.setSingletonSpan(i, value);
    }

    public void insertContainerAtIndex(int i, long key, Container c) {
        this.open(i);
        this.setContainerSpan(i, key, c);
    }

    public void removeSpanAtIndex(int i) {
        this.collapseRange(i, i + 1);
        this.modifiedSpan(i);
    }

    public void replaceSpanAtIndex(int i, ArraysBuf buf) {
        this.ensureSizeCanGrowBy(buf.size - 1);
        int dstPos = i + buf.size;
        int srcPos = i + 1;
        int count = this.size - srcPos;
        this.arrayCopies(srcPos, dstPos, count);
        for (int j = 0; j < buf.size; ++j) {
            this.spanInfos[i + j] = buf.spanInfos[j];
            this.spans[i + j] = buf.spans[j];
        }
        this.size += buf.size - 1;
        this.modifiedSpan(i);
    }

    static int unsignedBinarySearch(IntToLongFunction fun, int fromIndex, int toIndex, long k) {
        int x;
        if (toIndex > 0 && Long.compareUnsigned(fun.applyAsLong(toIndex - 1), k) < 0) {
            return -toIndex - 1;
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low + 8 <= high) {
            int middleIndex = low + high >>> 1;
            long middleValue = fun.applyAsLong(middleIndex);
            int comp = Long.compareUnsigned(middleValue, k);
            if (comp < 0) {
                low = middleIndex + 1;
                continue;
            }
            if (comp > 0) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        for (x = low; x <= high; ++x) {
            long val = fun.applyAsLong(x);
            if (Long.compareUnsigned(val, k) < 0) continue;
            if (val != k) break;
            return x;
        }
        return -(x + 1);
    }

    public int binarySearchKeys(int fromIndex, int toIndex, RowSetUtils.Comparator comp) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int middleIndex = (low + high) / 2;
            long middleValue = this.firstValueAtIndex(middleIndex);
            int c = comp.directionToTargetFrom(middleValue);
            if (c < 0) {
                high = middleIndex - 1;
                continue;
            }
            if (c > 0) {
                low = middleIndex + 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public static long unsignedShortToLong(short x) {
        return (long)x & 0xFFFFL;
    }

    public static int unsignedShortToInt(short x) {
        return x & 0xFFFF;
    }

    public static long paste(long highBits, short lowBits) {
        return highBits | RspArray.unsignedShortToLong(lowBits);
    }

    private int getIndexForRankWithAcc(int fromIndex, long pos) {
        long posp1 = pos + 1L;
        int i = RspArray.unsignedBinarySearch(j -> this.acc[j], fromIndex, this.size, posp1);
        return i < 0 ? -i - 1 : i;
    }

    private int getIndexForRankNoAcc(int fromIndex, long pos, MutableLong prevCardMu) {
        long prevCard;
        int i;
        block3: {
            i = fromIndex;
            long posp1 = pos + 1L;
            long card = prevCardMu == null ? 0L : prevCardMu.longValue();
            do {
                prevCard = card;
                if (posp1 <= (card += this.getSpanCardinalityAtIndex(i))) break block3;
            } while (++i != this.size);
            if (prevCardMu != null) {
                prevCardMu.setValue(prevCard);
            }
            return this.size;
        }
        if (prevCardMu != null) {
            prevCardMu.setValue(prevCard);
        }
        return i;
    }

    public long get(long pos) {
        long prevCard;
        int rankIndex;
        long cardinality;
        if (pos < 0L) {
            return -1L;
        }
        if (this.isCardinalityCached() && pos >= (cardinality = this.getCardinality())) {
            return -1L;
        }
        if (this.acc != null && this.cardData == this.size - 1) {
            rankIndex = this.getIndexForRankWithAcc(0, pos);
            prevCard = this.cardinalityBeforeWithAcc(rankIndex);
        } else {
            MutableLong prevCardMu = new MutableLong(0L);
            rankIndex = this.getIndexForRankNoAcc(0, pos, prevCardMu);
            if (rankIndex == this.size) {
                return -1L;
            }
            prevCard = prevCardMu.longValue();
        }
        return this.get(rankIndex, pos - prevCard);
    }

    public void getKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
        MutableLong prevCardMu;
        int fromIndex = 0;
        long cardinality = this.isCardinalityCached() ? this.getCardinality() : -1L;
        MutableLong mutableLong = prevCardMu = this.acc == null ? new MutableLong(0L) : null;
        while (inputPositions.hasNext()) {
            long prevCardinality;
            long pos = inputPositions.nextLong();
            if (pos < 0L || cardinality != -1L && pos >= cardinality) {
                outputKeys.accept(-1L);
                while (inputPositions.hasNext()) {
                    inputPositions.nextLong();
                    outputKeys.accept(-1L);
                }
                return;
            }
            if (this.acc != null) {
                fromIndex = this.getIndexForRankWithAcc(fromIndex, pos);
                prevCardinality = this.cardinalityBeforeWithAcc(fromIndex);
            } else {
                if ((fromIndex = this.getIndexForRankNoAcc(fromIndex, pos, prevCardMu)) == this.size) {
                    outputKeys.accept(-1L);
                    while (inputPositions.hasNext()) {
                        inputPositions.nextLong();
                        outputKeys.accept(-1L);
                    }
                    return;
                }
                prevCardinality = prevCardMu.longValue();
            }
            long key = this.get(fromIndex, pos - prevCardinality);
            outputKeys.accept(key);
        }
    }

    long get(int idx, long offset) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, idx);){
            if (view.isSingletonSpan()) {
                if (offset != 0L) {
                    throw new IllegalArgumentException("Invalid offset=" + offset + " for rowSet=" + idx);
                }
                long l = view.getSingletonSpanValue();
                return l;
            }
            long flen = view.getFullBlockSpanLen();
            long highBits = view.getKey();
            if (flen > 0L) {
                long l = highBits + offset;
                return l;
            }
            int sv = (int)offset;
            if ((long)sv != offset) {
                throw new IllegalArgumentException("Invalid offset=" + offset + " for rowSet=" + idx);
            }
            short lowBits = view.getContainer().select(sv);
            long l = RspArray.paste(highBits, lowBits);
            return l;
        }
    }

    final long cardinalityBeforeWithAcc(int i) {
        return i > 0 ? this.acc[i - 1] : 0L;
    }

    final long cardinalityBeforeMaybeAcc(int idx) {
        return this.cardinalityBeforeMaybeAcc(idx, 0, 0L);
    }

    final long cardinalityBeforeNoAcc(int idx, int knownIdx, long knownBeforeCard) {
        long card = knownBeforeCard;
        for (int i = knownIdx; i < idx; ++i) {
            card += this.getSpanCardinalityAtIndex(i);
        }
        return card;
    }

    final long cardinalityBeforeMaybeAcc(int idx, int knownIdx, long knownBeforeCard) {
        if (this.acc != null) {
            return this.cardinalityBeforeWithAcc(idx);
        }
        return this.cardinalityBeforeNoAcc(idx, knownIdx, knownBeforeCard);
    }

    final long cardinalityBeforeMaybeAcc(int idx, BeforeCardContext ctx) {
        if (this.acc != null) {
            return this.cardinalityBeforeWithAcc(idx);
        }
        long card = this.cardinalityBeforeNoAcc(idx, ctx.knownIdx, ctx.knownBeforeCard);
        ctx.knownIdx = idx;
        ctx.knownBeforeCard = card;
        return card;
    }

    final long getSpanCardinalityFromAccAtIndex(int i) {
        return this.acc[i] - this.cardinalityBeforeWithAcc(i);
    }

    boolean findOrNext(int startIdx, int endIdxExclusive, long val, FindOutput out) {
        int ki = this.getSpanIndex(startIdx, endIdxExclusive, RspArray.highBits(val));
        if (ki < 0) {
            int i = ~ki;
            if (i <= startIdx) {
                return false;
            }
            out.setResult(i, 0L);
            return true;
        }
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, ki);){
            if (view.isSingletonSpan()) {
                long singletonValue = view.getSingletonSpanValue();
                if (val < singletonValue) {
                    if (ki == startIdx) {
                        boolean bl = false;
                        return bl;
                    }
                    out.setResult(ki, 0L);
                } else if (val == singletonValue) {
                    out.setResult(ki, 0L);
                } else {
                    out.setResult(ki + 1, 0L);
                }
                boolean bl = true;
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            if (flen > 0L) {
                long key = view.getKey();
                out.setResult(ki, val - key);
                boolean bl = true;
                return bl;
            }
            Container c = view.getContainer();
            int cf = c.find(RspArray.lowBits(val));
            if (cf >= 0) {
                out.setResult(ki, cf);
                boolean bl = true;
                return bl;
            }
            int j = ~cf;
            long spanCard = c.getCardinality();
            if ((long)j == spanCard) {
                out.setResult(ki + 1, 0L);
                boolean bl = true;
                return bl;
            }
            if (j == 0 && ki == startIdx) {
                boolean bl = false;
                return bl;
            }
            out.setResult(ki, j);
            boolean bl = true;
            return bl;
        }
    }

    boolean findOrPrev(int startIdx, int endIdxExclusive, long val, FindOutput out) {
        int ki = this.getSpanIndex(startIdx, endIdxExclusive, RspArray.highBits(val));
        if (ki < 0) {
            int i = ~ki;
            if (i <= startIdx) {
                return false;
            }
            out.setResult(i - 1, this.getSpanCardinalityAtIndexMaybeAcc(i - 1) - 1L);
            return true;
        }
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, ki);){
            if (view.isSingletonSpan()) {
                long singletonValue = view.getSingletonSpanValue();
                if (val < singletonValue) {
                    if (ki == startIdx) {
                        boolean bl = false;
                        return bl;
                    }
                    out.setResult(ki - 1, this.getSpanCardinalityAtIndexMaybeAcc(ki - 1) - 1L);
                } else {
                    out.setResult(ki, 0L);
                }
                boolean bl = true;
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            if (flen > 0L) {
                long k = view.getKey();
                out.setResult(ki, val - k);
                boolean bl = true;
                return bl;
            }
            int cf = view.getContainer().find(RspArray.lowBits(val));
            if (cf >= 0) {
                out.setResult(ki, cf);
                boolean bl = true;
                return bl;
            }
            int j = ~cf;
            if (j == 0) {
                if (ki == startIdx) {
                    boolean bl = false;
                    return bl;
                }
                out.setResult(ki - 1, this.getSpanCardinalityAtIndexMaybeAcc(ki - 1) - 1L);
                boolean bl = true;
                return bl;
            }
            out.setResult(ki, j - 1);
            boolean bl = true;
            return bl;
        }
    }

    long find(int startIdx, long val) {
        int ki = this.getSpanIndex(startIdx, RspArray.highBits(val));
        if (ki < 0) {
            int i = -ki - 1;
            if (i == 0) {
                return -1L;
            }
            long prevAcc = this.cardinalityBeforeMaybeAcc(i);
            return -prevAcc - 1L;
        }
        long prevAcc = this.cardinalityBeforeMaybeAcc(ki);
        return this.findInSpan(ki, val, prevAcc);
    }

    long findInSpan(int idx, long val, long prevAcc) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, idx);){
            if (view.isSingletonSpan()) {
                long singletonValue = view.getSingletonSpanValue();
                if (val == singletonValue) {
                    long l = prevAcc;
                    return l;
                }
                if (val < singletonValue) {
                    long l = prevAcc ^ 0xFFFFFFFFFFFFFFFFL;
                    return l;
                }
                long l = prevAcc + 1L ^ 0xFFFFFFFFFFFFFFFFL;
                return l;
            }
            long flen = view.getFullBlockSpanLen();
            if (flen > 0L) {
                long k = view.getKey();
                long l = prevAcc + val - k;
                return l;
            }
            int cf = view.getContainer().find(RspArray.lowBits(val));
            if (cf >= 0) {
                long l = prevAcc + (long)cf;
                return l;
            }
            long l = -prevAcc + (long)cf;
            return l;
        }
    }

    public long find(long val) {
        this.ifDebugValidateNoAssert();
        return this.find(0, val);
    }

    public boolean subsetOf(RspArray other) {
        if (this.size == 0) {
            return true;
        }
        if (other.size == 0) {
            return false;
        }
        if (this.isCardinalityCached() && other.isCardinalityCached() && this.getCardinality() > other.getCardinality()) {
            return false;
        }
        return RspArray.subsetOf(this, other);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean subsetOf(RspArray r1, RspArray r2) {
        int p2 = 0;
        WorkData wd = workDataPerThread.get();
        int i1 = 0;
        while (i1 < r1.size) {
            block46: {
                try (SpanView view1 = wd.borrowSpanView(r1, i1);){
                    long k1 = view1.getKey();
                    long flen1 = view1.getFullBlockSpanLen();
                    int i2 = r2.getSpanIndex(p2, k1);
                    if (i2 < 0) {
                        boolean bl = false;
                        return bl;
                    }
                    try (SpanView view2 = wd.borrowSpanView(r2, i2);){
                        long flen2 = view2.getFullBlockSpanLen();
                        if (flen1 > 0L) {
                            if (flen2 == 0L) {
                                boolean bl = false;
                                return bl;
                            }
                            long kend1 = RspArray.getKeyForLastBlockInSpan(k1, flen1);
                            long k2 = view2.getKey();
                            long kend2 = RspArray.getKeyForLastBlockInSpan(k2, flen2);
                            if (RspArray.uLess(kend2, kend1)) {
                                boolean bl = false;
                                return bl;
                            }
                            if (kend2 == kend1 && ++p2 >= r2.size) {
                                boolean bl = i1 == r1.size - 1;
                                return bl;
                            }
                            break block46;
                        }
                        if (flen2 > 0L) break block46;
                        if (view1.isSingletonSpan()) {
                            long v1 = view1.getSingletonSpanValue();
                            if (view2.isSingletonSpan()) {
                                long v2 = view2.getSingletonSpanValue();
                                if (v1 != v2) {
                                    boolean bl = false;
                                    return bl;
                                }
                            } else if (!view2.getContainer().contains(RspArray.lowBits(v1))) {
                                boolean bl = false;
                                return bl;
                            }
                        } else {
                            Container c2;
                            if (view2.isSingletonSpan()) {
                                boolean v1 = false;
                                return v1;
                            }
                            Container c1 = view1.getContainer();
                            if (!c1.subsetOf(c2 = view2.getContainer())) {
                                boolean bl = false;
                                return bl;
                            }
                        }
                        if (++p2 >= r2.size) {
                            boolean bl = i1 == r1.size - 1;
                            return bl;
                        }
                    }
                }
            }
            ++i1;
        }
        return true;
    }

    public boolean containsRange(long start, long end) {
        long sHigh = RspArray.highBits(start);
        int si = this.getSpanIndex(sHigh);
        if (si < 0) {
            return false;
        }
        long eHigh = RspArray.highBits(end);
        int ei = this.getSpanIndex(si, eHigh);
        if (ei < 0) {
            return false;
        }
        long pendingStart = start;
        long pendingEnd = end;
        WorkData wd = workDataPerThread.get();
        for (int i = si; i <= ei; ++i) {
            try (SpanView view = wd.borrowSpanView(this, i);){
                long blockLast;
                int cend;
                int cstart;
                long ki = view.getKey();
                if (ki > pendingStart) {
                    boolean bl = false;
                    return bl;
                }
                if (view.isSingletonSpan()) {
                    long v1 = view.getSingletonSpanValue();
                    if (pendingStart != v1) {
                        boolean bl = false;
                        return bl;
                    }
                    if (pendingEnd == pendingStart) {
                        boolean bl = true;
                        return bl;
                    }
                    if (RspArray.lowBitsAsInt(pendingStart) != 65535) {
                        boolean bl = false;
                        return bl;
                    }
                    ++pendingStart;
                    continue;
                }
                long slen = view.getFullBlockSpanLen();
                if (slen > 0L) {
                    long spanLast = ki + slen * 65536L - 1L;
                    if (spanLast >= pendingEnd) {
                        boolean bl = true;
                        return bl;
                    }
                    pendingStart = spanLast + 1L;
                    continue;
                }
                Container c = view.getContainer();
                if (!c.contains(cstart = (int)(pendingStart - ki), (cend = (int)(Math.min(pendingEnd, blockLast = ki + 65535L) - ki)) + 1)) {
                    boolean bl = false;
                    return bl;
                }
                if (blockLast >= pendingEnd) {
                    boolean bl = true;
                    return bl;
                }
                pendingStart = blockLast + 1L;
                continue;
            }
        }
        return true;
    }

    public boolean overlaps(RspArray other) {
        if (this.size == 0 || other.size == 0) {
            return false;
        }
        return this.size < other.size ? RspArray.overlaps(this, other) : RspArray.overlaps(other, this);
    }

    private static long getKeyForLastBlockInSpan(long spanStartKey, long flen) {
        long additionalBlocksAfterFirst = flen > 1L ? flen - 1L : 0L;
        return spanStartKey + additionalBlocksAfterFirst * 65536L;
    }

    private static long getKeyForLastBlockInFullSpan(long spanKey, long flen) {
        return spanKey + (flen - 1L) * 65536L;
    }

    public boolean overlapsRange(long first, long last) {
        return this.overlapsRange(0, first, last) >= 0;
    }

    public int overlapsRange(int iStart, long start, long end) {
        long keyBlock;
        long startHighBits = RspArray.highBits(start);
        int i = this.getSpanIndex(iStart, startHighBits);
        if (i < 0 && (i ^= 0xFFFFFFFF) >= this.size) {
            return ~i;
        }
        long endHighBits = RspArray.highBits(end);
        if (endHighBits < (keyBlock = this.getKey(i))) {
            return ~i;
        }
        WorkData wd = workDataPerThread.get();
        while (true) {
            long sk = Math.max(start, keyBlock);
            long ek = Math.min(end, keyBlock + 65535L);
            if (sk == keyBlock && ek == keyBlock + 65535L) {
                return i;
            }
            SpanView view = wd.borrowSpanView(this, i);
            try {
                if (view.isSingletonSpan()) {
                    long v = view.getSingletonSpanValue();
                    if (start <= v && v <= end) {
                        int n = i;
                        return n;
                    }
                } else {
                    int cend;
                    int cstart;
                    long slen = view.getFullBlockSpanLen();
                    if (slen > 0L) {
                        int n = i;
                        return n;
                    }
                    Container c = view.getContainer();
                    if (c.overlapsRange(cstart = RspArray.lowBitsAsInt(sk), cend = RspArray.lowBitsAsInt(ek) + 1)) {
                        int n = i;
                        return n;
                    }
                }
                if (++i >= this.size) {
                    int n = ~i;
                    return n;
                }
                keyBlock = this.getKey(i);
                if (endHighBits >= keyBlock) continue;
                int n = ~(i - 1);
                return n;
            }
            finally {
                if (view == null) continue;
                view.close();
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean overlaps(RspArray r1, RspArray r2) {
        if (r1.keyForLastBlock() < r2.keyForFirstBlock()) return false;
        if (r2.keyForLastBlock() < r1.keyForFirstBlock()) {
            return false;
        }
        int p2 = 0;
        WorkData wd = workDataPerThread.get();
        int i1 = 0;
        while (i1 < r1.size) {
            block51: {
                try (SpanView view1 = wd.borrowSpanView(r1, i1);){
                    long k1 = view1.getKey();
                    long flen1 = view1.getFullBlockSpanLen();
                    int i2 = r2.getSpanIndex(p2, k1);
                    if (i2 >= 0) {
                        if (flen1 > 0L) {
                            boolean bl = true;
                            return bl;
                        }
                        try (SpanView view2 = wd.borrowSpanView(r2, i2);){
                            long flen2 = view2.getFullBlockSpanLen();
                            if (flen2 > 0L) {
                                boolean bl = true;
                                return bl;
                            }
                            if (view1.isSingletonSpan()) {
                                long v1 = view1.getSingletonSpanValue();
                                if (view2.isSingletonSpan()) {
                                    long v2 = view2.getSingletonSpanValue();
                                    if (v1 == v2) {
                                        boolean bl = true;
                                        return bl;
                                    }
                                } else {
                                    Container c2 = view2.getContainer();
                                    if (c2.contains(RspArray.lowBits(v1))) {
                                        boolean bl = true;
                                        return bl;
                                    }
                                }
                            } else if (view2.isSingletonSpan()) {
                                long v2 = view2.getSingletonSpanValue();
                                Container c1 = view1.getContainer();
                                if (c1.contains(RspArray.lowBits(v2))) {
                                    boolean bl = true;
                                    return bl;
                                }
                            } else {
                                Container c2;
                                Container c1 = view1.getContainer();
                                if (c1.overlaps(c2 = view2.getContainer())) {
                                    boolean bl = true;
                                    return bl;
                                }
                            }
                            if (++p2 >= r2.size) {
                                boolean bl = false;
                                return bl;
                            }
                            break block51;
                        }
                    }
                    if (flen1 > 0L) {
                        long k1Blocklast = k1 + (flen1 - 1L) * 65536L;
                        int j2 = r2.getSpanIndex(p2, k1Blocklast);
                        if (j2 >= 0) {
                            boolean bl = true;
                            return bl;
                        }
                        if (i2 != j2) {
                            boolean bl = true;
                            return bl;
                        }
                        p2 = -i2 - 1;
                        if (p2 >= r2.size) {
                            boolean bl = false;
                            return bl;
                        }
                    } else {
                        p2 = -i2 - 1;
                        if (p2 >= r2.size) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            ++i1;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private int orEqualsSpan(long shiftAmount, RspArray other, int otherIdx, int startPos, MutableObject<SortedRanges> sortedRangesMu, WorkData wd) {
        otherSpan = other.spans[otherIdx];
        otherSpanInfo = other.getSpanInfo(otherIdx) + shiftAmount;
        otherView = wd.borrowSpanView(other, otherIdx, otherSpanInfo, otherSpan);
        try {
            block42: {
                block43: {
                    block41: {
                        block39: {
                            block40: {
                                otherKey = otherView.getKey();
                                otherflen = otherView.getFullBlockSpanLen();
                                orIdx = this.getSpanIndex(startPos, otherKey);
                                if (otherflen > 0L) {
                                    var18_17 = j = this.setOrInsertFullBlockSpanAtIndex(orIdx, otherKey, otherflen, sortedRangesMu);
                                    return var18_17;
                                }
                                if (orIdx < 0) {
                                    i = -orIdx - 1;
                                    if (i >= this.size) {
                                        if (otherView.isSingletonSpan()) {
                                            this.appendSingletonSpan(otherView.getSingletonSpanValue());
                                        } else {
                                            otherContainer = otherView.getContainer();
                                            this.appendSharedContainer(other, otherKey, otherContainer);
                                        }
                                        otherContainer = this.size;
                                        return otherContainer;
                                    }
                                    if (otherView.isSingletonSpan()) {
                                        this.insertSingletonAtIndex(i, otherView.getSingletonSpanValue());
                                    } else {
                                        otherContainer = otherView.getContainer();
                                        this.insertSharedContainer(i, other, otherKey, otherContainer);
                                    }
                                    otherContainer = i + 1;
                                    return otherContainer;
                                }
                                ourView = wd.borrowSpanView(this, orIdx);
                                try {
                                    flen = ourView.getFullBlockSpanLen();
                                    if (flen <= 0L) break block39;
                                    ki = ourView.getKey();
                                    lastKey = RspArray.getKeyForLastBlockInSpan(ki, flen);
                                    if (!RspArray.uGreater(lastKey, otherKey)) break block40;
                                    var24_31 = orIdx;
                                    if (ourView != null) {
                                        ourView.close();
                                    }
                                    return var24_31;
                                }
                                catch (Throwable var18_23) {
                                    if (ourView != null) {
                                        try {
                                            ourView.close();
                                        }
                                        catch (Throwable var19_42) {
                                            var18_23.addSuppressed(var19_42);
                                        }
                                    }
                                    throw var18_23;
                                }
                            }
                            var24_32 = orIdx + 1;
                            if (ourView != null) {
                                ourView.close();
                            }
                            return var24_32;
                        }
                        if (!ourView.isSingletonSpan()) ** GOTO lbl80
                        orIdxValue = ourView.getSingletonSpanValue();
                        if (!otherView.isSingletonSpan()) ** GOTO lbl77
                        otherValue = otherView.getSingletonSpanValue();
                        if (otherValue != orIdxValue) break block41;
                        var25_39 = orIdx + 1;
                        if (ourView != null) {
                            ourView.close();
                        }
                        return var25_39;
                    }
                    if (otherValue < orIdxValue) {
                        v1 = RspArray.lowBits(otherValue);
                        v2 = RspArray.lowBits(orIdxValue);
                    } else {
                        v1 = RspArray.lowBits(orIdxValue);
                        v2 = RspArray.lowBits(otherValue);
                    }
                    orResultContainer = Container.twoValues((short)v1, (short)v2);
                    break block43;
lbl77:
                    // 1 sources

                    orContainer = otherView.getContainer();
                    orResultContainer = orContainer.set(RspArray.lowBits(orIdxValue));
                    break block43;
lbl80:
                    // 1 sources

                    c = ourView.getContainer();
                    if (otherView.isSingletonSpan()) {
                        otherValue = otherView.getSingletonSpanValue();
                        orResultContainer = c.iset(RspArray.lowBits(otherValue));
                    } else {
                        orContainer = otherView.getContainer();
                        orResultContainer = c.ior(orContainer);
                    }
                }
                if (!orResultContainer.isAllOnes()) break block42;
                var22_29 = j = this.setOrInsertFullBlockSpanAtIndex(orIdx, otherKey, 1L, sortedRangesMu);
                if (ourView != null) {
                    ourView.close();
                }
                return var22_29;
            }
            copt = RspArray.maybeOptimize(orResultContainer);
            this.setContainerSpan(orIdx, otherKey, copt);
            var22_30 = orIdx + 1;
            if (ourView != null) {
                ourView.close();
            }
            return var22_30;
        }
        finally {
            if (otherView != null) {
                otherView.close();
            }
        }
    }

    public void orEqualsUnsafeNoWriteCheck(RspArray other) {
        this.orEqualsShiftedUnsafeNoWriteCheck(0L, other);
    }

    public void orEqualsShiftedUnsafeNoWriteCheck(long shiftAmount, RspArray other) {
        if (other.size == 0) {
            return;
        }
        if (this.size == 0) {
            this.copySharingSpansFrom(other, shiftAmount);
            return;
        }
        if (this.tryAppendShiftedUnsafeNoWriteCheck(shiftAmount, other, false)) {
            return;
        }
        WorkData wd = workDataPerThread.get();
        int[] idxPairs = wd.getIntArray();
        int idxPairsCount = 0;
        SortedRanges secondPassSkips = wd.getSortedRanges();
        boolean tryAddToSecondPassSkips = true;
        int startPos = 0;
        for (int otherIdx = 0; otherIdx < other.size; ++otherIdx) {
            long kSpan;
            long kSpanLast;
            Object span;
            long spanInfo;
            long flen;
            Object otherSpan = other.spans[otherIdx];
            if (RspArray.isFullBlockSpan(otherSpan)) continue;
            long otherSpanKey = shiftAmount + other.getKey(otherIdx);
            int i = RspArray.unsignedBinarySearch(this::getKey, startPos, this.size, otherSpanKey);
            if (i >= 0) {
                startPos = i + 1;
                continue;
            }
            if ((i ^= 0xFFFFFFFF) == this.size) break;
            if (tryAddToSecondPassSkips) {
                SortedRanges sr = secondPassSkips.appendUnsafe(otherIdx);
                if (sr == null) {
                    tryAddToSecondPassSkips = false;
                } else {
                    secondPassSkips = sr;
                }
            }
            startPos = i;
            if (i > 0 && (flen = RspArray.getFullBlockSpanLen(spanInfo = this.spanInfos[i - 1], span = this.spans[i - 1])) > 0L && (kSpanLast = RspArray.getKeyForLastBlockInSpan(kSpan = RspArray.spanInfoToKey(spanInfo), flen)) >= otherSpanKey) continue;
            if (idxPairsCount + 2 > idxPairs.length) {
                int[] newArr = idxPairs.length + 3 < 1024 ? new int[2 * idxPairs.length + 3] : new int[idxPairs.length + 1024];
                wd.setIntArray(newArr);
                System.arraycopy(idxPairs, 0, newArr, 0, idxPairsCount);
                idxPairs = newArr;
            }
            idxPairs[idxPairsCount++] = otherIdx;
            idxPairs[idxPairsCount++] = i;
        }
        if (idxPairsCount > 0) {
            boolean accWasNull;
            boolean inPlace = true;
            Object[] newSpans = this.spans;
            long[] newSpanInfos = this.spanInfos;
            long[] newAcc = this.acc;
            int deltaSpans = idxPairsCount / 2;
            int newSize = this.size + deltaSpans;
            boolean bl = accWasNull = this.acc == null;
            if (newSize > this.spanInfos.length) {
                inPlace = false;
                newSpans = new Object[newSize];
                newSpanInfos = new long[newSize];
                if (accWasNull) {
                    this.cardData = -1;
                }
                newAcc = newSize > accNullThreshold ? new long[newSize] : null;
            }
            int lastMoveRangeIdx = this.size - 1;
            int dstIdx = newSize - 1;
            while (idxPairsCount > 0) {
                int thisIdx = idxPairs[--idxPairsCount];
                int otherIdx = idxPairs[--idxPairsCount];
                for (int i = lastMoveRangeIdx; i >= thisIdx; --i) {
                    this.copyKeyAndSpanStealingContainers(i, this.spanInfos, this.spans, dstIdx, newSpanInfos, newSpans);
                    --dstIdx;
                }
                this.copyKeyAndSpanMaybeSharing(shiftAmount, other, otherIdx, newSpanInfos, newSpans, dstIdx, true);
                --dstIdx;
                lastMoveRangeIdx = thisIdx - 1;
            }
            if (!inPlace) {
                for (int i = lastMoveRangeIdx; i >= 0; --i) {
                    this.copyKeyAndSpanStealingContainers(i, this.spanInfos, this.spans, dstIdx, newSpanInfos, newSpans);
                    --dstIdx;
                }
                this.spanInfos = newSpanInfos;
                this.spans = newSpans;
                if (lastMoveRangeIdx >= 0 && !accWasNull && newAcc != null) {
                    System.arraycopy(this.acc, 0, newAcc, 0, lastMoveRangeIdx + 1);
                }
                this.acc = newAcc;
            }
            this.modifiedSpan(idxPairs[1]);
            this.size = newSize;
        }
        startPos = 0;
        RowSet.Iterator skipsIter = secondPassSkips.getIterator();
        int nextSkip = !skipsIter.hasNext() ? -1 : (int)skipsIter.nextLong();
        MutableObject<SortedRanges> sortedRangesMu = this.getWorkSortedRangesMutableObject(wd);
        for (int otherIdx = 0; otherIdx < other.size; ++otherIdx) {
            if (nextSkip == otherIdx) {
                if (!skipsIter.hasNext()) {
                    nextSkip = -1;
                    continue;
                }
                nextSkip = (int)skipsIter.nextLong();
                continue;
            }
            startPos = this.orEqualsSpan(shiftAmount, other, otherIdx, startPos, sortedRangesMu, wd);
        }
        this.collectRemovedIndicesIfAny(sortedRangesMu);
    }

    protected void markIndexAsRemoved(MutableObject<SortedRanges> madeNullSpansMu, int index) {
        this.spanInfos[index] = -1L;
        this.modifiedSpan(index);
        SortedRanges madeNullSpans = (SortedRanges)madeNullSpansMu.getValue();
        if (madeNullSpans != null) {
            madeNullSpans = madeNullSpans.appendUnsafe(index);
            madeNullSpansMu.setValue((Object)madeNullSpans);
        }
    }

    protected void markIndexRangeAsRemoved(MutableObject<SortedRanges> madeNullSpansMu, int iFirst, int iLast) {
        for (int i = iFirst; i <= iLast; ++i) {
            this.spanInfos[i] = -1L;
        }
        this.modifiedSpan(iFirst);
        SortedRanges madeNullSpans = (SortedRanges)madeNullSpansMu.getValue();
        if (madeNullSpans != null) {
            madeNullSpans = madeNullSpans.appendRangeUnsafe(iFirst, iLast);
            madeNullSpansMu.setValue((Object)madeNullSpans);
        }
    }

    protected void collectRemovedIndicesIfAny(MutableObject<SortedRanges> madeNullSpansMu) {
        SortedRanges madeNullSpans = (SortedRanges)madeNullSpansMu.getValue();
        if (madeNullSpans == null || madeNullSpans.getCardinality() > 0L) {
            this.collectRemovedIndicesUnsafeNoWriteCheck(madeNullSpans);
        }
    }

    protected MutableObject<SortedRanges> getWorkSortedRangesMutableObject(WorkData wd) {
        SortedRangesInt madeNullSpans = wd.getMadeNullSortedRanges();
        return new MutableObject((Object)madeNullSpans);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int andNotEqualsSpan(int startPos, RspArray other, int otherIdx, MutableObject<SortedRanges> madeNullSpansMu, WorkData wd) {
        try (SpanView otherView = wd.borrowSpanView(other, otherIdx);){
            long flenAtIdxEnd;
            long keyAtIdxEnd;
            int j;
            long removeKey = otherView.getKey();
            long removeflen = otherView.getFullBlockSpanLen();
            if (removeflen == 0L) {
                int i = this.getSpanIndex(startPos, removeKey);
                if (i < 0) {
                    int n = ~i;
                    return n;
                }
                try (SpanView ourView = wd.borrowSpanView(this, i);){
                    Container result;
                    long flen = ourView.getFullBlockSpanLen();
                    if (flen > 0L) {
                        long keyNotContainer;
                        Container notContainer;
                        Object notContainerPre;
                        if (otherView.isSingletonSpan()) {
                            long singletonValue = otherView.getSingletonSpanValue();
                            int v = RspArray.lowBitsAsInt(singletonValue);
                            notContainerPre = v == 0 ? Container.singleRange((int)1, (int)65536) : (v == 65535 ? Container.singleRange((int)0, (int)65535) : new RunContainer(0, v, v + 1, 65536));
                        } else {
                            Container rc = otherView.getContainer();
                            notContainerPre = rc.not(0, 65536);
                        }
                        if (notContainerPre.isSingleElement()) {
                            notContainer = null;
                            keyNotContainer = removeKey | (long)notContainerPre.first();
                        } else {
                            notContainer = RspArray.maybeOptimize(notContainerPre);
                            keyNotContainer = removeKey;
                        }
                        long firstKey = this.getKey(i);
                        long endKey = firstKey + 65536L * (flen - 1L);
                        if (RspArray.uLess(firstKey, removeKey)) {
                            ArraysBuf buf;
                            if (RspArray.uLess(removeKey, endKey)) {
                                buf = wd.getArraysBuf(3);
                                buf.pushFullBlockSpan(firstKey, RspArray.distanceInBlocks(firstKey, removeKey));
                                buf.pushContainer(keyNotContainer, notContainer);
                                buf.pushFullBlockSpan(removeKey + 65536L, RspArray.distanceInBlocks(removeKey, endKey));
                                this.replaceSpanAtIndex(i, buf);
                            } else {
                                buf = wd.getArraysBuf(2);
                                buf.pushFullBlockSpan(firstKey, RspArray.distanceInBlocks(firstKey, removeKey));
                                buf.pushContainer(keyNotContainer, notContainer);
                                this.replaceSpanAtIndex(i, buf);
                            }
                            int buf2 = i + 2;
                            return buf2;
                        }
                        if (RspArray.uLess(removeKey, endKey)) {
                            ArraysBuf buf = wd.getArraysBuf(2);
                            buf.pushContainer(keyNotContainer, notContainer);
                            buf.pushFullBlockSpan(removeKey + 65536L, RspArray.distanceInBlocks(removeKey, endKey));
                            this.replaceSpanAtIndex(i, buf);
                        } else if (notContainer == null) {
                            this.setSingletonSpan(i, keyNotContainer);
                        } else {
                            this.setContainerSpan(i, keyNotContainer, notContainer);
                        }
                        int n = i + 1;
                        return n;
                    }
                    if (ourView.isSingletonSpan()) {
                        long firstValue = ourView.getSingletonSpanValue();
                        if (otherView.isSingletonSpan()) {
                            if (otherView.getSingletonSpanValue() == firstValue) {
                                this.markIndexAsRemoved(madeNullSpansMu, i);
                            }
                            int keyNotContainer = i + 1;
                            return keyNotContainer;
                        }
                        Container removeContainer = otherView.getContainer();
                        if (removeContainer.contains(RspArray.lowBits(firstValue))) {
                            this.markIndexAsRemoved(madeNullSpansMu, i);
                        }
                        int n = i + 1;
                        return n;
                    }
                    Container container = ourView.getContainer();
                    if (otherView.isSingletonSpan()) {
                        long v = otherView.getSingletonSpanValue();
                        result = container.iunset(RspArray.lowBits(v));
                    } else {
                        Container removed = otherView.getContainer();
                        result = container.iandNot(removed);
                    }
                    if (result.isEmpty()) {
                        this.markIndexAsRemoved(madeNullSpansMu, i);
                        int removed = i + 1;
                        return removed;
                    }
                    long firstKey = ourView.getKey();
                    if (result.isSingleElement()) {
                        this.setSingletonSpan(i, firstKey | (long)result.first());
                    } else {
                        Container c3 = RspArray.maybeOptimize(result);
                        this.setContainerSpan(container, i, firstKey, c3);
                    }
                    int c3 = i + 1;
                    return c3;
                }
            }
            int idxBegin = this.getSpanIndex(startPos, removeKey);
            if (idxBegin < 0 && (idxBegin = -idxBegin - 1) >= this.size) {
                int ourView = this.size;
                return ourView;
            }
            long removeLastKey = removeKey + 65536L * (removeflen - 1L);
            int idxEnd = removeLastKey == removeKey ? idxBegin : ((j = this.getSpanIndex(idxBegin + 1, removeLastKey)) >= 0 ? j : -j - 2);
            long spanInfoAtIdxBegin = this.spanInfos[idxBegin];
            long keyAtIdxBegin = RspArray.spanInfoToKey(spanInfoAtIdxBegin);
            if (keyAtIdxBegin > removeLastKey) {
                int c3 = idxBegin;
                return c3;
            }
            Object spanAtIdxBegin = this.spans[idxBegin];
            long flenAtIdxBegin = RspArray.getFullBlockSpanLen(spanInfoAtIdxBegin, spanAtIdxBegin);
            if (idxBegin == idxEnd) {
                keyAtIdxEnd = keyAtIdxBegin;
                flenAtIdxEnd = flenAtIdxBegin;
            } else {
                Object spanAtIdxEnd = this.spans[idxEnd];
                long spanInfoAtIdxEnd = this.spanInfos[idxEnd];
                keyAtIdxEnd = RspArray.spanInfoToKey(spanInfoAtIdxEnd);
                flenAtIdxEnd = RspArray.getFullBlockSpanLen(spanInfoAtIdxEnd, spanAtIdxEnd);
            }
            int dst = idxBegin;
            if (RspArray.uLess(keyAtIdxBegin, removeKey)) {
                dst = idxBegin + 1;
                if (flenAtIdxBegin > 0L) {
                    long newflen = RspArray.distanceInBlocks(keyAtIdxBegin, removeKey);
                    this.setFullBlockSpan(idxBegin, keyAtIdxBegin, newflen);
                }
            }
            int src = idxEnd + 1;
            long blockKeyAtIdxEnd = RspArray.highBits(keyAtIdxEnd);
            long lastKeyAtIdxEnd = RspArray.getKeyForLastBlockInSpan(blockKeyAtIdxEnd, flenAtIdxEnd);
            if (RspArray.uLess(removeLastKey, lastKeyAtIdxEnd)) {
                long nextKey = RspArray.nextKey(removeLastKey);
                long newflen = RspArray.distanceInBlocks(removeLastKey, lastKeyAtIdxEnd);
                if (idxEnd >= dst) {
                    this.setFullBlockSpan(idxEnd, nextKey, newflen);
                    src = idxEnd;
                } else {
                    this.insertFullBlockSpanAtIndex(dst, nextKey, newflen);
                    src = dst;
                }
            }
            if (dst < src) {
                this.markIndexRangeAsRemoved(madeNullSpansMu, dst, src - 1);
            }
            int n = src;
            return n;
        }
    }

    public void andNotEqualsUnsafeNoWriteCheck(RspArray other) {
        if (this.isEmpty() || other.isEmpty()) {
            return;
        }
        long keyForFirstBlock = this.keyForFirstBlock();
        if (other.keyForLastBlock() < keyForFirstBlock || this.keyForLastBlock() < other.keyForFirstBlock()) {
            return;
        }
        int startPos = 0;
        int firstKey = other.getSpanIndex(0, keyForFirstBlock);
        if (firstKey < 0) {
            firstKey = -firstKey - 1;
        }
        WorkData wd = workDataPerThread.get();
        MutableObject<SortedRanges> madeNullSpansMu = this.getWorkSortedRangesMutableObject(wd);
        for (int andNotIdx = firstKey; andNotIdx < other.size && (startPos = this.andNotEqualsSpan(startPos, other, andNotIdx, madeNullSpansMu, wd)) < this.size; ++andNotIdx) {
        }
        this.collectRemovedIndicesIfAny(madeNullSpansMu);
    }

    private void collectRemovedIndicesUnsafeNoWriteCheck(SortedRanges madeNullSpans) {
        long k;
        if (madeNullSpans == null) {
            this.compactRemovedUnsafeNoWriteCheck();
            return;
        }
        RowSet.RangeIterator it = madeNullSpans.getRangeIterator();
        if (!it.hasNext()) {
            return;
        }
        it.next();
        long dst = it.currentRangeStart();
        do {
            long j = it.currentRangeEnd() + 1L;
            if (!it.hasNext()) {
                k = this.size;
            } else {
                it.next();
                k = it.currentRangeStart();
            }
            long n = k - j;
            this.arrayCopies((int)j, (int)dst, (int)n);
            dst += n;
        } while (k != (long)this.size);
        this.size = (int)dst;
        this.tryCompactUnsafe(4);
    }

    private void compactRemovedUnsafeNoWriteCheck() {
        int i;
        for (i = this.cardData + 1; i < this.size && this.getSpanInfo(i) != -1L; ++i) {
        }
        if (i == this.size) {
            return;
        }
        int dst = i;
        do {
            int k;
            int j;
            for (j = i + 1; j < this.size && this.getSpanInfo(j) == -1L; ++j) {
            }
            if (j == this.size) break;
            for (k = j + 1; k < this.size && this.getSpanInfo(k) != -1L; ++k) {
            }
            int n = k - j;
            this.arrayCopies(j, dst, n);
            dst += n;
            for (i = k; i < this.size && this.getSpanInfo(i) != -1L; ++i) {
            }
        } while (i != this.size);
        this.size = dst;
        this.tryCompactUnsafe(4);
    }

    /*
     * Unable to fully structure code
     */
    private int andEqualsSpan(RspArray other, int otherIdx, int startPos, MutableObject<SortedRanges> madeNullSpansMu, WorkData wd) {
        otherView = wd.borrowSpanView(other, otherIdx);
        try {
            block55: {
                block56: {
                    block54: {
                        block53: {
                            block52: {
                                block51: {
                                    andflen = otherView.getFullBlockSpanLen();
                                    andKey = otherView.getKey();
                                    if (andflen > 0L) {
                                        andLastKey = RspArray.getKeyForLastBlockInSpan(andKey, andflen);
                                        andLastKeyIdx = this.keySearch(startPos, andLastKey);
                                        if (andLastKeyIdx >= 0) {
                                            var14_15 = andLastKeyIdx + 1;
                                            return var14_15;
                                        }
                                        var14_16 = -andLastKeyIdx - 1;
                                        return var14_16;
                                    }
                                    andIdx = this.getSpanIndex(startPos, andKey);
                                    if (andIdx < 0) {
                                        var12_18 = -andIdx - 1;
                                        return var12_18;
                                    }
                                    ourView = wd.borrowSpanView(this, andIdx);
                                    try {
                                        flen = ourView.getFullBlockSpanLen();
                                        if (flen <= 0L) break block51;
                                        ourKey = ourView.getKey();
                                        lastKey = RspArray.getKeyForLastBlockInSpan(ourKey, flen);
                                        if (RspArray.uLess(ourKey, andKey)) {
                                            if (RspArray.uLess(andKey, lastKey)) {
                                                buf = wd.getArraysBuf(3);
                                                buf.pushFullBlockSpan(ourKey, RspArray.distanceInBlocks(ourKey, andKey));
                                                if (otherView.isSingletonSpan()) {
                                                    buf.pushSingletonSpan(otherView.getSingletonSpanValue());
                                                } else {
                                                    buf.pushSharedContainer(other, andKey, otherView.getContainer());
                                                }
                                                buf.pushFullBlockSpan(RspArray.nextKey(andKey), RspArray.distanceInBlocks(andKey, lastKey));
                                                this.replaceSpanAtIndex(andIdx, buf);
                                            } else {
                                                buf = wd.getArraysBuf(2);
                                                buf.pushFullBlockSpan(ourKey, RspArray.distanceInBlocks(ourKey, andKey));
                                                if (otherView.isSingletonSpan()) {
                                                    buf.pushSingletonSpan(ourView.getSingletonSpanValue());
                                                } else {
                                                    buf.pushSharedContainer(other, andKey, otherView.getContainer());
                                                }
                                                this.replaceSpanAtIndex(andIdx, buf);
                                            }
                                        } else if (RspArray.uLess(andKey, lastKey)) {
                                            buf = wd.getArraysBuf(2);
                                            if (otherView.isSingletonSpan()) {
                                                buf.pushSingletonSpan(otherView.getSingletonSpanValue());
                                            } else {
                                                buf.pushSharedContainer(other, andKey, otherView.getContainer());
                                            }
                                            buf.pushFullBlockSpan(RspArray.nextKey(andKey), RspArray.distanceInBlocks(andKey, lastKey));
                                            this.replaceSpanAtIndex(andIdx, buf);
                                        } else if (otherView.isSingletonSpan()) {
                                            this.setSingletonSpan(andIdx, otherView.getSingletonSpanValue());
                                        } else {
                                            this.setSharedContainerRaw(andIdx, other, andKey, otherView.getContainer());
                                        }
                                        buf = andIdx + 1;
                                        if (ourView != null) {
                                            ourView.close();
                                        }
                                        return buf;
                                    }
                                    catch (Throwable var13_14) {
                                        if (ourView != null) {
                                            try {
                                                ourView.close();
                                            }
                                            catch (Throwable var14_17) {
                                                var13_14.addSuppressed(var14_17);
                                            }
                                        }
                                        throw var13_14;
                                    }
                                }
                                result = null;
                                ourContainer = null;
                                if (!ourView.isSingletonSpan()) ** GOTO lbl95
                                ourValue = ourView.getSingletonSpanValue();
                                if (!otherView.isSingletonSpan()) ** GOTO lbl86
                                andSpanValue = otherView.getSingletonSpanValue();
                                if (andSpanValue != ourValue) break block52;
                                var21_35 = andIdx + 1;
                                if (ourView != null) {
                                    ourView.close();
                                }
                                return var21_35;
                            }
                            break block53;
lbl86:
                            // 1 sources

                            ac = otherView.getContainer();
                            if (!ac.contains(RspArray.lowBits(ourValue))) break block53;
                            var20_36 = andIdx + 1;
                            if (ourView != null) {
                                ourView.close();
                            }
                            return var20_36;
                        }
                        ** GOTO lbl111
lbl95:
                        // 1 sources

                        ourContainer = ourView.getContainer();
                        if (!otherView.isSingletonSpan()) ** GOTO lbl107
                        andSpanValue = otherView.getSingletonSpanValue();
                        if (!ourContainer.contains(RspArray.lowBits(andSpanValue))) break block54;
                        this.setSingletonSpan(andIdx, andSpanValue);
                        var19_33 = andIdx + 1;
                        if (ourView != null) {
                            ourView.close();
                        }
                        return var19_33;
                    }
                    break block56;
lbl107:
                    // 1 sources

                    ac = otherView.getContainer();
                    result = ourContainer.iand(ac);
                    if (result.isEmpty()) {
                        result = null;
                    }
                }
                if (result != null) break block55;
                this.markIndexAsRemoved(madeNullSpansMu, andIdx);
                ac = andIdx + 1;
                if (ourView != null) {
                    ourView.close();
                }
                return ac;
            }
            if (result.isSingleElement()) {
                this.setSingletonSpan(andIdx, andKey | (long)result.first());
            } else {
                c3 = RspArray.maybeOptimize(result);
                this.setContainerSpan(ourContainer, andIdx, andKey, c3);
            }
            var17_28 = andIdx + 1;
            if (ourView != null) {
                ourView.close();
            }
            return var17_28;
        }
        finally {
            if (otherView != null) {
                otherView.close();
            }
        }
    }

    public void andEqualsUnsafeNoWriteCheck(RspArray other) {
        WorkData wd = workDataPerThread.get();
        int maxNewCapacity = this.size + other.size;
        ArraysBuf buf = wd.getArraysBuf(maxNewCapacity);
        int startPos = 0;
        block0: for (int andIdx = 0; andIdx < other.size && startPos < this.size; ++andIdx) {
            int lastIdx;
            Object andSpan = other.spans[andIdx];
            long andSpanInfo = other.spanInfos[andIdx];
            long andSpanKey = RspArray.spanInfoToKey(andSpanInfo);
            long andflen = RspArray.getFullBlockSpanLen(andSpanInfo, andSpan);
            long andLastKey = RspArray.getKeyForLastBlockInSpan(andSpanKey, andflen);
            int firstIdx = this.getSpanIndex(startPos, andSpanKey);
            if (firstIdx < 0 && (firstIdx = -firstIdx - 1) == this.size) break;
            if (andSpanKey == andLastKey || firstIdx == this.size - 1) {
                lastIdx = firstIdx;
            } else {
                lastIdx = this.getSpanIndex(firstIdx + 1, andLastKey);
                if (lastIdx < 0) {
                    lastIdx = -lastIdx - 2;
                }
            }
            int i = firstIdx;
            do {
                long spanInfo;
                long spanKey;
                if (RspArray.uGreater(spanKey = RspArray.spanInfoToKey(spanInfo = this.spanInfos[i]), andLastKey)) {
                    startPos = i;
                    continue block0;
                }
                Object span = this.spans[i];
                long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
                if (flen > 0L) {
                    long lastKey = RspArray.getKeyForLastBlockInSpan(spanKey, flen);
                    if (!RspArray.uGreaterOrEqual(lastKey, andSpanKey)) continue;
                    long newKey = RspArray.uMax(andSpanKey, spanKey);
                    long newLen = flen - RspArray.distanceInBlocks(spanKey, newKey);
                    boolean bail = false;
                    if (RspArray.uGreater(lastKey, andLastKey)) {
                        newLen -= RspArray.distanceInBlocks(andLastKey, lastKey);
                        bail = true;
                    }
                    RspArray.setFullBlockSpanRaw(buf.size, buf.spanInfos, buf.spans, newKey, newLen);
                    ++buf.size;
                    if (!bail) continue;
                    startPos = i;
                    continue block0;
                }
                if (!RspArray.uGreaterOrEqual(spanKey, andSpanKey)) continue;
                buf.spanInfos[buf.size] = spanInfo;
                buf.spans[buf.size] = span;
                ++buf.size;
            } while (++i <= lastIdx);
            startPos = i;
        }
        int maxWaste = 7;
        this.size = buf.size;
        if (buf.capacity() - buf.size > 7) {
            this.spanInfos = new long[buf.size];
            this.spans = new Object[buf.size];
            if (buf.size > accNullThreshold) {
                this.acc = new long[buf.size];
            }
            System.arraycopy(buf.spanInfos, 0, this.spanInfos, 0, buf.size);
            System.arraycopy(buf.spans, 0, this.spans, 0, buf.size);
        } else {
            long[] oldSpanInfos = this.spanInfos;
            Object[] oldSpans = this.spans;
            if (buf.capacity() != this.spanInfos.length && buf.capacity() > accNullThreshold) {
                this.acc = new long[buf.capacity()];
            }
            this.spanInfos = buf.spanInfos;
            this.spans = buf.spans;
            buf.swap(oldSpanInfos, oldSpans);
        }
        this.cardData = -1;
        startPos = 0;
        MutableObject<SortedRanges> madeNullSpansMu = this.getWorkSortedRangesMutableObject(wd);
        for (int otherIdx = 0; otherIdx < other.size && (startPos = this.andEqualsSpan(other, otherIdx, startPos, madeNullSpansMu, wd)) < this.size; ++otherIdx) {
        }
        this.collectRemovedIndicesIfAny(madeNullSpansMu);
    }

    public void applyKeyOffset(long offset) {
        for (int i = 0; i < this.size; ++i) {
            this.applyKeyOffset(i, offset);
        }
    }

    private void appendSpanIntersectionByKeyRange(RspArray r, int i, long start, long end) {
        long resultEnd;
        long spanInfo = this.spanInfos[i];
        Object span = this.spans[i];
        long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
        if (flen > 0L) {
            long keyAfterMid;
            long nextHiBits;
            long key = RspArray.spanInfoToKey(spanInfo);
            long sLastPlusOne = key + 65536L * flen;
            long resultStart = RspArray.uMax(key, start);
            if (RspArray.uGreaterOrEqual(resultStart, sLastPlusOne)) {
                return;
            }
            long resultEnd2 = RspArray.uMin(sLastPlusOne - 1L, end);
            if (RspArray.highBits(resultStart) == resultStart) {
                nextHiBits = resultStart;
            } else {
                long resultStartHiBits = RspArray.highBits(resultStart);
                if (RspArray.uLess(resultEnd2, resultStartHiBits + 65535L)) {
                    int ce;
                    int cs = RspArray.lowBitsAsInt(resultStart);
                    if (cs == (ce = RspArray.lowBitsAsInt(resultEnd2))) {
                        r.appendSingletonSpan(resultStart);
                    } else {
                        r.appendContainer(resultStartHiBits, Container.rangeOfOnes((int)cs, (int)(ce + 1)));
                    }
                    return;
                }
                int cs = RspArray.lowBitsAsInt(resultStart);
                if (cs == 65535) {
                    r.appendSingletonSpan(resultStart);
                } else {
                    r.appendContainer(resultStartHiBits, Container.rangeOfOnes((int)cs, (int)65536));
                }
                nextHiBits = RspArray.nextKey(resultStartHiBits);
            }
            long resultEndHiBits = RspArray.highBits(resultEnd2);
            long midflen = RspArray.distanceInBlocks(nextHiBits, resultEndHiBits);
            if (midflen > 0L) {
                r.appendFullBlockSpan(nextHiBits, midflen);
                keyAfterMid = nextHiBits + midflen * 65536L;
            } else {
                keyAfterMid = nextHiBits;
            }
            if (RspArray.uGreaterOrEqual(resultEnd2, keyAfterMid)) {
                int e = RspArray.lowBitsAsInt(resultEnd2);
                if (e == 65535) {
                    r.appendFullBlockSpan(keyAfterMid, 1L);
                } else if (e == 0) {
                    r.appendSingletonSpan(keyAfterMid);
                } else {
                    r.appendContainer(keyAfterMid, Container.rangeOfOnes((int)0, (int)(e + 1)));
                }
            }
            return;
        }
        if (RspArray.isSingletonSpan(span)) {
            long v = RspArray.spanInfoToSingletonSpanValue(spanInfo);
            if (start <= v && v <= end) {
                r.appendSingletonSpan(v);
            }
            return;
        }
        long key = RspArray.spanInfoToKey(spanInfo);
        long blockLast = key + 65535L;
        if (RspArray.uLess(end, key) || RspArray.uGreater(start, blockLast)) {
            return;
        }
        long resultStart = RspArray.uMax(key, start);
        if (RspArray.uLess(end, blockLast)) {
            resultEnd = end;
        } else {
            if (resultStart == key) {
                r.appendSharedContainerMaybePacked(this, i, key, span);
                return;
            }
            resultEnd = blockLast;
        }
        int rStart = (int)(resultStart - key);
        int rEndExclusive = (int)(resultEnd - key) + 1;
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i, spanInfo, span);){
            Container c = view.getContainer();
            Container result = c.andRange(rStart, rEndExclusive);
            if (result.isEmpty()) {
                return;
            }
            if (result.isSingleElement()) {
                r.appendSingletonSpan(key | (long)result.first());
                return;
            }
            r.appendContainer(key, RspArray.maybeOptimize(result));
        }
    }

    boolean forEachLongInSpanWithOffsetAndMaxCount(int i, long offset, LongAbortableConsumer lc, long maxCount) {
        MutableLong n = new MutableLong(0L);
        this.forEachLongInSpanWithOffset(i, offset, v -> {
            if (!lc.accept(v)) {
                return false;
            }
            n.increment();
            return n.longValue() < maxCount;
        });
        return n.longValue() >= maxCount;
    }

    boolean forEachLongInSpanWithOffset(int i, long offset, LongAbortableConsumer lc) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i);){
            boolean wantMore;
            if (view.isSingletonSpan()) {
                long v2 = view.getSingletonSpanValue();
                boolean bl = lc.accept(v2);
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            long key = view.getKey();
            if (flen > 0L) {
                long oneAfterLast = key + flen * 65536L;
                for (long v3 = key + offset; v3 < oneAfterLast; ++v3) {
                    boolean wantMore2 = lc.accept(v3);
                    if (wantMore2) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            Container c = view.getContainer();
            boolean bl = wantMore = c.forEach((int)offset, v -> lc.accept(key | RspArray.unsignedShortToLong(v)));
            return bl;
        }
    }

    boolean forEachLongInSpanWithMaxCount(int i, LongAbortableConsumer lc, long maxCount) {
        MutableLong n = new MutableLong(0L);
        this.forEachLongInSpan(i, v -> {
            if (!lc.accept(v)) {
                return false;
            }
            n.increment();
            return n.longValue() < maxCount;
        });
        return n.longValue() >= maxCount;
    }

    boolean forEachLongInSpan(int i, LongAbortableConsumer lc) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i);){
            boolean wantMore;
            if (view.isSingletonSpan()) {
                long v2 = view.getSingletonSpanValue();
                boolean bl = lc.accept(v2);
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            long key = view.getKey();
            if (flen > 0L) {
                long oneAfterLast = key + flen * 65536L;
                for (long v3 = key; v3 < oneAfterLast; ++v3) {
                    boolean wantMore2 = lc.accept(v3);
                    if (wantMore2) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            Container c = view.getContainer();
            boolean bl = wantMore = c.forEach(v -> lc.accept(key | RspArray.unsignedShortToLong(v)));
            return bl;
        }
    }

    public boolean forEachLong(LongAbortableConsumer lc) {
        for (int i = 0; i < this.size; ++i) {
            if (this.forEachLongInSpan(i, lc)) continue;
            return false;
        }
        return true;
    }

    public boolean forEachLongRangeInSpanWithOffsetAndMaxCardinality(int i, long offset, long maxCardinality, LongRangeAbortableConsumer larc) {
        if (maxCardinality <= 0L) {
            return true;
        }
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i);){
            if (view.isSingletonSpan()) {
                if (offset != 0L) {
                    throw new IllegalArgumentException("offset=" + offset + " and single key span.");
                }
                long v = view.getSingletonSpanValue();
                boolean bl = larc.accept(v, v);
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            long key = view.getKey();
            if (flen > 0L) {
                long end = key + flen * 65536L - 1L;
                long start = key + offset;
                long d = end - start + 1L;
                if (d > maxCardinality) {
                    end = start + maxCardinality - 1L;
                }
                boolean bl = larc.accept(start, end);
                return bl;
            }
            long remaining = maxCardinality;
            int bufSz = 10;
            short[] buf = new short[10];
            Container c = view.getContainer();
            SearchRangeIterator ri = c.getShortRangeIterator((int)offset);
            while (ri.hasNext()) {
                int nRanges = ri.next(buf, 0, 5);
                for (int j = 0; j < 2 * nRanges; j += 2) {
                    long start = key | RspArray.unsignedShortToLong(buf[j]);
                    long end = key | RspArray.unsignedShortToLong(buf[j + 1]);
                    long delta = end - start + 1L;
                    if (delta > remaining) {
                        delta = remaining;
                        end = start + remaining - 1L;
                    }
                    if (!larc.accept(start, end)) {
                        boolean bl = false;
                        return bl;
                    }
                    if ((remaining -= delta) > 0L) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return true;
    }

    boolean forEachLongRangeInSpanWithOffset(int i, long offset, LongRangeAbortableConsumer larc) {
        try (SpanView view = workDataPerThread.get().borrowSpanView(this, i);){
            if (view.isSingletonSpan()) {
                if (offset != 0L) {
                    throw new IllegalArgumentException("offset=" + offset + " and single key span.");
                }
                long v = view.getSingletonSpanValue();
                boolean bl = larc.accept(v, v);
                return bl;
            }
            long flen = view.getFullBlockSpanLen();
            long key = view.getKey();
            if (flen > 0L) {
                long oneAfterLast = key + flen * 65536L;
                boolean bl = larc.accept(key + offset, oneAfterLast - 1L);
                return bl;
            }
            int bufSz = 10;
            short[] buf = new short[10];
            Container c = view.getContainer();
            SearchRangeIterator ri = c.getShortRangeIterator((int)offset);
            while (ri.hasNext()) {
                int nRanges = ri.next(buf, 0, 5);
                for (int j = 0; j < 2 * nRanges; j += 2) {
                    long end;
                    long start = key | RspArray.unsignedShortToLong(buf[j]);
                    if (larc.accept(start, end = key | RspArray.unsignedShortToLong(buf[j + 1]))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    static LongRangeAbortableConsumer makeAdjacentRangesCollapsingWrapper(long[] pendingRange, LongRangeAbortableConsumer lrac) {
        pendingRange[0] = -2L;
        pendingRange[1] = -2L;
        LongRangeAbortableConsumer wrapper = (start, end) -> {
            if (pendingRange[0] == -2L) {
                pendingRange[0] = start;
                pendingRange[1] = end;
                return true;
            }
            if (pendingRange[1] + 1L == start) {
                pendingRange[1] = end;
                return true;
            }
            boolean wantsMore = lrac.accept(pendingRange[0], pendingRange[1]);
            pendingRange[0] = start;
            pendingRange[1] = end;
            return wantsMore;
        };
        return wrapper;
    }

    public boolean forEachLongRange(LongRangeAbortableConsumer lrac) {
        if (this.size == 0) {
            return true;
        }
        if (this.size == 1) {
            return this.forEachLongRangeInSpanWithOffset(0, 0L, lrac);
        }
        long[] pendingRange = new long[2];
        LongRangeAbortableConsumer wrapper = RspArray.makeAdjacentRangesCollapsingWrapper(pendingRange, lrac);
        for (int i = 0; i < this.size; ++i) {
            if (this.forEachLongRangeInSpanWithOffset(i, 0L, wrapper)) continue;
            return false;
        }
        if (pendingRange[0] != -2L) {
            return lrac.accept(pendingRange[0], pendingRange[1]);
        }
        return true;
    }

    protected T subrangeByKeyInternal(long start, long end) {
        T r = this.make();
        long startHiBits = RspArray.highBits(start);
        int ikstart = this.getSpanIndex(startHiBits);
        if (ikstart < 0 && (ikstart = -ikstart - 1) >= this.size) {
            return r;
        }
        long endHighBits = RspArray.highBits(end);
        int ikend = this.getSpanIndex(endHighBits);
        if (ikend < 0 && (ikend = -ikend - 2) < 0) {
            return r;
        }
        for (int i = ikstart; i <= ikend; ++i) {
            this.appendSpanIntersectionByKeyRange((RspArray)r, i, start, end);
        }
        return r;
    }

    protected T subrangeByPosInternal(long firstPos, long lastPos) {
        long endOffset;
        int endIdx;
        long cardBeforeStart;
        int startIdx;
        MutableLong prevCardMu;
        long effectiveLastPos;
        if (this.isCardinalityCached()) {
            long cardinality = this.getCardinality();
            if (firstPos >= cardinality) {
                return null;
            }
            long arrLast = cardinality - 1L;
            if (lastPos >= arrLast) {
                if (firstPos == 0L) {
                    return (T)((RspArray)this.cowRef());
                }
                effectiveLastPos = arrLast;
            } else {
                effectiveLastPos = lastPos;
            }
        } else {
            effectiveLastPos = lastPos;
        }
        if (this.acc != null) {
            prevCardMu = null;
            startIdx = this.getIndexForRankWithAcc(0, firstPos);
            cardBeforeStart = this.cardinalityBeforeWithAcc(startIdx);
        } else {
            prevCardMu = new MutableLong(0L);
            startIdx = this.getIndexForRankNoAcc(0, firstPos, prevCardMu);
            if (startIdx == this.size) {
                return null;
            }
            cardBeforeStart = prevCardMu.longValue();
        }
        if (this.acc != null) {
            endIdx = this.getIndexForRankWithAcc(startIdx, effectiveLastPos);
            long cardBeforeEnd = this.cardinalityBeforeWithAcc(endIdx);
            endOffset = effectiveLastPos - cardBeforeEnd;
        } else {
            int ansIdx = this.getIndexForRankNoAcc(startIdx, effectiveLastPos, prevCardMu);
            if (ansIdx == this.size) {
                endIdx = this.size - 1;
                endOffset = this.getSpanCardinalityAtIndex(endIdx) - 1L;
            } else {
                endIdx = ansIdx;
                long cardBeforeEnd = prevCardMu.longValue();
                endOffset = effectiveLastPos - cardBeforeEnd;
            }
        }
        long startOffset = firstPos - cardBeforeStart;
        return this.make(this, startIdx, startOffset, endIdx, endOffset);
    }

    private static void setToRangeOfOnesMinusRangeForKey(ArraysBuf buf, long kHigh, long rsStart, long rsEnd) {
        int crsStart = (int)(rsStart - kHigh);
        int crsEnd = (int)(rsEnd - kHigh);
        if (crsStart > 0) {
            if (crsEnd < 65535) {
                buf.pushContainer(kHigh, Container.twoRanges((int)0, (int)crsStart, (int)(crsEnd + 1), (int)65536));
                return;
            }
            if (crsStart == 1) {
                buf.pushSingletonSpan(kHigh);
                return;
            }
            buf.pushContainer(kHigh, Container.singleRange((int)0, (int)crsStart));
            return;
        }
        if (debug && crsEnd >= 65535) {
            throw new IllegalStateException("crsEnd=" + crsEnd);
        }
        if (crsEnd + 1 == 65535) {
            buf.pushSingletonSpan(kHigh | 0xFFFFL);
            return;
        }
        buf.pushContainer(kHigh, Container.rangeOfOnes((int)(crsEnd + 1), (int)65536));
    }

    private int removeRangeInSpan(int i, long spanInfo, long key, long start, long end, MutableObject<SortedRanges> madeNullSpansMu, WorkData wd) {
        Object span = this.spans[i];
        try (SpanView view = wd.borrowSpanView(this, i, spanInfo, span);){
            long flen = view.getFullBlockSpanLen();
            if (flen > 0L) {
                long posSpanFirstKey;
                long posflen;
                long sLastPlusOne = key + 65536L * flen;
                long rsStart = RspArray.uMax(key, start);
                if (RspArray.uGreaterOrEqual(rsStart, sLastPlusOne)) {
                    int n = i;
                    return n;
                }
                long rsEnd = RspArray.uMin(sLastPlusOne - 1L, end);
                long kStart = RspArray.highBits(rsStart);
                long kEnd = RspArray.highBits(rsEnd);
                ArraysBuf buf = wd.getArraysBuf(4);
                int returnValue = ~i;
                long preflen = RspArray.distanceInBlocks(key, kStart);
                if (preflen > 0L) {
                    buf.pushFullBlockSpan(key, preflen);
                }
                if (kStart == kEnd) {
                    if (rsEnd - rsStart < 65535L) {
                        RspArray.setToRangeOfOnesMinusRangeForKey(buf, kStart, rsStart, rsEnd);
                        returnValue = i + buf.size - 1;
                    }
                } else {
                    long c1End = Math.min(kEnd, RspArray.nextKey(kStart)) - 1L;
                    if (rsStart != kStart || c1End - rsStart < 65535L) {
                        RspArray.setToRangeOfOnesMinusRangeForKey(buf, kStart, rsStart, c1End);
                        returnValue = i + buf.size - 1;
                    }
                    if (rsEnd - kEnd < 65535L) {
                        RspArray.setToRangeOfOnesMinusRangeForKey(buf, kEnd, kEnd, rsEnd);
                        returnValue = i + buf.size - 1;
                    }
                }
                if ((posflen = RspArray.distanceInBlocks(posSpanFirstKey = RspArray.nextKey(kEnd), sLastPlusOne)) > 0L) {
                    buf.pushFullBlockSpan(posSpanFirstKey, posflen);
                }
                if (buf.size > 0) {
                    this.replaceSpanAtIndex(i, buf);
                    int n = returnValue;
                    return n;
                }
                this.markIndexAsRemoved(madeNullSpansMu, i);
                int n = ~(i + 1);
                return n;
            }
            Container result = null;
            Container ourContainer = null;
            if (view.isSingletonSpan()) {
                long v = view.getSingletonSpanValue();
                if (v < start || end < v) {
                    int rsEnd = i;
                    return rsEnd;
                }
            } else {
                int rEnd;
                int rStart;
                long resultStart = RspArray.uMax(key, start);
                long resultEnd = RspArray.uMin(key + 65535L, end);
                ourContainer = view.getContainer();
                result = ourContainer.iremove(rStart = (int)(resultStart - key), rEnd = (int)(resultEnd - key) + 1);
                if (result.isEmpty()) {
                    result = null;
                }
            }
            if (result == null) {
                this.markIndexAsRemoved(madeNullSpansMu, i);
                int resultStart = ~(i + 1);
                return resultStart;
            }
            if (result.isSingleElement()) {
                this.setSingletonSpan(i, key | (long)result.first());
            } else {
                Container c3 = RspArray.maybeOptimize(result);
                this.setContainerSpan(ourContainer, i, key, c3);
            }
            int n = i;
            return n;
        }
    }

    public void removeRangeUnsafeNoWriteCheck(long start, long end) {
        WorkData wd = workDataPerThread.get();
        MutableObject<SortedRanges> madeNullSpansMu = this.getWorkSortedRangesMutableObject(wd);
        this.removeRange(0, start, end, madeNullSpansMu, wd);
        this.collectRemovedIndicesIfAny(madeNullSpansMu);
    }

    private int removeRange(int fromIdx, long start, long end, MutableObject<SortedRanges> madeNullSpansMu, WorkData wd) {
        long spanInfo;
        long blockKey;
        long startHiBits = RspArray.highBits(start);
        int i = this.getSpanIndex(fromIdx, startHiBits);
        if (i < 0 && (i = -i - 1) >= this.size) {
            return i;
        }
        long kEnd = RspArray.highBits(end);
        int last = i;
        while (i < this.size && (blockKey = RspArray.spanInfoToKey(spanInfo = this.getSpanInfo(i))) <= kEnd) {
            if ((i = this.removeRangeInSpan(i, spanInfo, blockKey, start, end, madeNullSpansMu, wd)) >= 0) {
                last = i++;
                continue;
            }
            last = i ^= 0xFFFFFFFF;
        }
        return last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRangesUnsafeNoWriteCheck(RowSet.RangeIterator rit) {
        try {
            WorkData wd = workDataPerThread.get();
            MutableObject<SortedRanges> madeNullSpansMu = this.getWorkSortedRangesMutableObject(wd);
            int i = 0;
            while (rit.hasNext()) {
                long end;
                rit.next();
                long start = rit.currentRangeStart();
                if ((i = this.removeRange(i, start, end = rit.currentRangeEnd(), madeNullSpansMu, wd)) < this.size) continue;
                break;
            }
            this.collectRemovedIndicesIfAny(madeNullSpansMu);
        }
        finally {
            rit.close();
        }
    }

    boolean tryAppendShiftedUnsafeNoWriteCheck(long shiftAmount, RspArray other, boolean acquire) {
        Object otherFirstSpan;
        long otherflen;
        if (debug && (this.size == 0 || other.size == 0)) {
            throw new IllegalArgumentException("Append called for empty argument: size=" + this.size + ", other.size=" + other.size);
        }
        long otherFirstSpanInfo = other.spanInfos[0];
        long firstOtherBlockKey = RspArray.spanInfoToKey(otherFirstSpanInfo) + shiftAmount;
        long ourLastSpanInfo = this.spanInfos[this.size - 1];
        Object ourLastSpan = this.spans[this.size - 1];
        long ourflen = RspArray.getFullBlockSpanLen(ourLastSpanInfo, ourLastSpan);
        long ourLastKey = RspArray.spanInfoToKey(ourLastSpanInfo);
        long ourLastBlockKey = ourLastKey + (ourflen == 0L ? 0L : (ourflen - 1L) * 65536L);
        if (firstOtherBlockKey <= ourLastBlockKey) {
            return false;
        }
        int firstOtherSpan = 0;
        if (ourLastBlockKey + 65536L == firstOtherBlockKey && ourflen > 0L && (otherflen = RspArray.getFullBlockSpanLen(otherFirstSpanInfo, otherFirstSpan = other.spans[0])) > 0L) {
            this.setFullBlockSpan(this.size - 1, ourLastKey, ourflen + otherflen);
            firstOtherSpan = 1;
        }
        this.ensureSizeCanGrowBy(other.size - firstOtherSpan);
        if (!acquire) {
            for (int i = firstOtherSpan; i < other.size; ++i) {
                int pos = this.size + i - firstOtherSpan;
                this.copyKeyAndSpanMaybeSharing(shiftAmount, other, i, this.spanInfos, this.spans, pos, !acquire);
            }
        }
        this.size += other.size - firstOtherSpan;
        return true;
    }

    public static long uMax(long k1, long k2) {
        return RspArray.uGreater(k1, k2) ? k1 : k2;
    }

    public static long uMin(long k1, long k2) {
        return RspArray.uLess(k1, k2) ? k1 : k2;
    }

    public static boolean uLess(long k1, long k2) {
        return Long.compareUnsigned(k1, k2) < 0;
    }

    public static boolean uLessOrEqual(long k1, long k2) {
        return Long.compareUnsigned(k1, k2) <= 0;
    }

    public static boolean uGreater(long k1, long k2) {
        return Long.compareUnsigned(k1, k2) > 0;
    }

    public static boolean uGreaterOrEqual(long k1, long k2) {
        return Long.compareUnsigned(k1, k2) >= 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.valuesToString());
        sb.append(" -- RspArray{");
        boolean first = true;
        for (int i = 0; i < this.size; ++i) {
            if (!first) {
                sb.append(" ,");
            }
            sb.append("[ ");
            long sInfo = this.spanInfos[i];
            long k = RspArray.spanInfoToKey(sInfo);
            sb.append(String.format("0x%X", k >> 16));
            sb.append(", ");
            Object s = this.spans[i];
            if (RspArray.isSingletonSpan(s)) {
                sb.append('n');
            } else {
                long flen = RspArray.getFullBlockSpanLen(sInfo, s);
                sb.append(flen);
            }
            sb.append(" ]");
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    void ifDebugValidateNoAssert() {
        if (debugValidateEnabled && debug) {
            this.validate("", false, false);
        }
    }

    void ifDebugValidate() {
        if (debugValidateEnabled && debug) {
            this.validate("", true, false);
        }
    }

    boolean validate() {
        return this.validate("", false, false);
    }

    void validate(String s) {
        this.validate(s, true, false);
    }

    boolean validate(String strArg, boolean doAssert, boolean isUnsafe) {
        long cardinality;
        String str = strArg == null ? "" : strArg;
        boolean firstTime = true;
        long lastSpanLastBlockKey = 0L;
        boolean lastSpanWasFullBlock = false;
        int refCount = this.refCount();
        if (refCount <= 0) {
            String m = str + ": invalid refCount=" + refCount;
            if (doAssert) {
                Assert.assertion((boolean)false, (String)m);
            }
            return false;
        }
        if (this.cardData < -1 || this.acc != null && this.cardData > this.size - 1) {
            String m = str + ": invalid cardData=" + this.cardData + " (size=" + this.size + ")";
            if (doAssert) {
                Assert.assertion((boolean)false, (String)m);
            }
            return false;
        }
        WorkData wd = workDataPerThread.get();
        for (int i = 0; i < this.size; ++i) {
            try (SpanView view = wd.borrowSpanView(this, i);){
                long sInfo = view.getSpanInfo();
                long k = view.getKey();
                if (k < 0L) {
                    if (doAssert) {
                        String m = str + ": i=" + i + ", k=" + k;
                        Assert.assertion((boolean)false, (String)m);
                    }
                    boolean m = false;
                    return m;
                }
                Object s = this.spans[i];
                if (s != null && s != FULL_BLOCK_SPAN_MARKER && !(s instanceof short[]) && (sInfo & 0xFFFFL) != 0L) {
                    if (doAssert) {
                        String m = str + ": lower 16 bits of spanInfo non-zero i=" + i + ", sInfo=" + sInfo;
                        Assert.assertion((boolean)false, (String)m);
                    }
                    boolean m = false;
                    return m;
                }
                if (!firstTime && !RspArray.uLess(lastSpanLastBlockKey, k)) {
                    if (doAssert) {
                        String m = str + ": non-increasing key found i=" + i + ", k=" + k + ", lastSpanLastBlockKey=" + lastSpanLastBlockKey + ", size=" + this.size;
                        Assert.assertion((boolean)false, (String)m);
                    }
                    boolean m = false;
                    return m;
                }
                long flen = view.getFullBlockSpanLen();
                if (flen > 0L) {
                    if (lastSpanWasFullBlock && k - lastSpanLastBlockKey <= 65536L) {
                        if (doAssert) {
                            String m = str + ": consecutive full block spans found i=" + i + ", size=" + this.size;
                            Assert.assertion((boolean)false, (String)m);
                        }
                        boolean m = false;
                        return m;
                    }
                    lastSpanWasFullBlock = true;
                } else {
                    if (s != null) {
                        if (!(s instanceof Container) && !(s instanceof short[])) {
                            if (doAssert) {
                                String m = str + ": can't cast s=" + s + " of class " + s.getClass().getSimpleName() + " to Container or short[] when !(flen > 0).";
                                Assert.assertion((boolean)false, (String)m);
                            }
                            boolean m = false;
                            return m;
                        }
                        Container c = view.getContainer();
                        if (c.isEmpty()) {
                            if (doAssert) {
                                String m = str + ": empty RB container found i=" + i + ", size=" + this.size;
                                Assert.assertion((boolean)false, (String)m);
                            }
                            boolean m = false;
                            return m;
                        }
                        if (c.isAllOnes()) {
                            if (doAssert) {
                                String m = str + ": full RB container found i=" + i + ", size=" + this.size;
                                Assert.assertion((boolean)false, (String)m);
                            }
                            boolean m = false;
                            return m;
                        }
                        if (c.isSingleElement()) {
                            if (doAssert) {
                                String m = str + ": singleton container found i=" + i + ", type=" + c.getClass().getSimpleName();
                                Assert.assertion((boolean)false, (String)m);
                            }
                            boolean m = false;
                            return m;
                        }
                    }
                    lastSpanWasFullBlock = false;
                }
                if (this.acc != null) {
                    long c;
                    long prevCard;
                    long dCard;
                    int lastIndexForAccValidation;
                    int n = lastIndexForAccValidation = isUnsafe ? this.cardData : this.size - 1;
                    if (i <= lastIndexForAccValidation && (dCard = this.acc[i] - (prevCard = i == 0 ? 0L : this.acc[i - 1])) != (c = this.getSpanCardinalityAtIndex(i))) {
                        String m = str + ": acc cardinality mismatch, isUnsafe=" + isUnsafe + " at i=" + i + ", prevCard=" + prevCard + ", dCard=" + dCard + ", c=" + c + ", size=" + this.size;
                        Assert.assertion((boolean)false, (String)m);
                    }
                }
                lastSpanLastBlockKey = RspArray.getKeyForLastBlockInSpan(k, flen);
                firstTime = false;
                continue;
            }
        }
        if (this.acc == null && this.cardData >= 0 && (cardinality = this.calculateCardinality()) != (long)this.cardData) {
            String m = str + ": acc == null && cardData (=" + this.cardData + ") != cardinality (=" + cardinality + ")";
            Assert.assertion((boolean)false, (String)m);
        }
        return true;
    }

    public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        long endOffset;
        long cardBeforeEnd;
        int endIdx;
        long cardBeforeStart;
        int startIdx;
        MutableLong prevCardMu;
        long endPositionInclusive;
        if (startPositionInclusive < 0L) {
            throw new IllegalArgumentException("startPositionInclusive=" + startPositionInclusive + " should be >=0.");
        }
        if (this.isCardinalityCached()) {
            long cardinality = this.getCardinality();
            if (startPositionInclusive >= cardinality) {
                return RowSequenceFactory.EMPTY;
            }
            endPositionInclusive = Math.min(startPositionInclusive + length, cardinality) - 1L;
        } else {
            endPositionInclusive = startPositionInclusive + length;
        }
        if (this.acc != null) {
            prevCardMu = null;
            startIdx = this.getIndexForRankWithAcc(0, startPositionInclusive);
            cardBeforeStart = this.cardinalityBeforeWithAcc(startIdx);
        } else {
            prevCardMu = new MutableLong(0L);
            startIdx = this.getIndexForRankNoAcc(0, startPositionInclusive, prevCardMu);
            if (startIdx == this.size) {
                return RowSequenceFactory.EMPTY;
            }
            cardBeforeStart = prevCardMu.longValue();
        }
        if (this.acc != null) {
            endIdx = this.getIndexForRankWithAcc(startIdx, endPositionInclusive);
            cardBeforeEnd = this.cardinalityBeforeWithAcc(endIdx);
            endOffset = endPositionInclusive - cardBeforeEnd;
        } else {
            int ansIdx = this.getIndexForRankNoAcc(startIdx, endPositionInclusive, prevCardMu);
            cardBeforeEnd = prevCardMu.longValue();
            if (ansIdx == this.size) {
                endIdx = this.size - 1;
                endOffset = this.getSpanCardinalityAtIndex(endIdx) - 1L;
            } else {
                endIdx = ansIdx;
                endOffset = endPositionInclusive - cardBeforeEnd;
            }
        }
        long startOffset = startPositionInclusive - cardBeforeStart;
        return new RspRowSequence(this, startIdx, startOffset, cardBeforeStart, endIdx, endOffset, cardBeforeEnd);
    }

    public RowSequence getRowSequenceByKeyRange(long startValueInclusive, long endValueInclusive) {
        if (this.isEmpty() || endValueInclusive < startValueInclusive) {
            return RowSequenceFactory.EMPTY;
        }
        long lastSpanCardinality = this.getSpanCardinalityAtIndexMaybeAcc(this.size - 1);
        return this.getRowSequenceByKeyRangeConstrainedToIndexAndOffsetRange(startValueInclusive, endValueInclusive, 0, 0L, 0L, this.size - 1, lastSpanCardinality - 1L);
    }

    public RspRowSequence asRowSequence() {
        if (this.isEmpty()) {
            throw new IllegalStateException("Cannot convert to ordered keys an empty array");
        }
        long lastSpanCard = this.getSpanCardinalityAtIndexMaybeAcc(this.size - 1);
        return new RspRowSequence(this, 0, 0L, 0L, this.size - 1, lastSpanCard - 1L, this.getCardinality() - lastSpanCard);
    }

    RowSequence getRowSequenceByKeyRangeConstrainedToIndexAndOffsetRange(long startValue, long endValue, int startIdx, long startOffsetIn, long cardBeforeStartIdx, int endIdx, long endOffsetIn) {
        long startOffsetOut;
        long absoluteEndPos;
        boolean endKeyIdxWasNegative;
        long startKey = RspArray.highBits(startValue);
        int startKeyIdx = this.getSpanIndex(startIdx, startKey);
        if (startKeyIdx < 0 && (startKeyIdx = -startKeyIdx - 1) >= this.size) {
            return RowSequenceFactory.EMPTY;
        }
        long endKey = RspArray.highBits(endValue);
        int endKeyIdx = this.getSpanIndex(startKeyIdx, endKey);
        boolean bl = endKeyIdxWasNegative = endKeyIdx < 0;
        if (endKeyIdxWasNegative) {
            endKeyIdx = -endKeyIdx - 2;
        }
        BeforeCardContext beforeCardCtx = this.acc == null ? new BeforeCardContext(startIdx, cardBeforeStartIdx) : null;
        long cardBeforeStartKeyIdx = this.cardinalityBeforeMaybeAcc(startKeyIdx, beforeCardCtx);
        long absoluteStartPos = this.findInSpan(startKeyIdx, startValue, cardBeforeStartKeyIdx);
        if (absoluteStartPos < 0L && (absoluteStartPos = -absoluteStartPos - 1L) == this.getCardinality()) {
            return RowSequenceFactory.EMPTY;
        }
        long cardBeforeEndKeyIdx = this.cardinalityBeforeMaybeAcc(endKeyIdx, beforeCardCtx);
        if (endKeyIdxWasNegative) {
            absoluteEndPos = cardBeforeEndKeyIdx + this.getSpanCardinalityAtIndexMaybeAcc(endKeyIdx) - 1L;
        } else {
            absoluteEndPos = this.findInSpan(endKeyIdx, endValue, cardBeforeEndKeyIdx);
            if (absoluteEndPos < 0L) {
                if ((absoluteEndPos = -absoluteEndPos - 2L) < 0L) {
                    return RowSequenceFactory.EMPTY;
                }
                long totalCardAtEndKeyIdx = cardBeforeEndKeyIdx + this.getSpanCardinalityAtIndexMaybeAcc(endKeyIdx);
                long lastValidPos = totalCardAtEndKeyIdx - 1L;
                if (absoluteEndPos > lastValidPos) {
                    absoluteEndPos = lastValidPos;
                }
            }
        }
        long relativeStartOffset = absoluteStartPos - cardBeforeStartKeyIdx;
        long spanCardAtStartKeyIdx = this.getSpanCardinalityAtIndexMaybeAcc(startKeyIdx);
        if (relativeStartOffset >= spanCardAtStartKeyIdx) {
            ++startKeyIdx;
            cardBeforeStartKeyIdx += spanCardAtStartKeyIdx;
            relativeStartOffset = 0L;
        }
        if (startKeyIdx > startIdx || relativeStartOffset >= startOffsetIn) {
            startOffsetOut = relativeStartOffset;
        } else {
            startKeyIdx = startIdx;
            cardBeforeStartKeyIdx = cardBeforeStartIdx;
            startOffsetOut = startOffsetIn;
        }
        long relativeEndOffset = absoluteEndPos - cardBeforeEndKeyIdx;
        long endOffsetOut = endKeyIdx < endIdx || relativeEndOffset <= endOffsetIn ? relativeEndOffset : endOffsetIn;
        return new RspRowSequence(this, startKeyIdx, startOffsetOut, cardBeforeStartKeyIdx, endKeyIdx, endOffsetOut, cardBeforeEndKeyIdx);
    }

    public RowSequence.Iterator getRowSequenceIterator() {
        if (this.isEmpty()) {
            return RowSequenceFactory.EMPTY_ITERATOR;
        }
        return new RspRowSequence.Iterator(this.asRowSequence());
    }

    public long getAverageRunLengthEstimate() {
        if (this.isEmpty()) {
            return 1L;
        }
        return this.getAverageRunLengthEstimate(0, this.size - 1);
    }

    public long getAverageRunLengthEstimate(int startIdx, int endIdx) {
        if (this.acc != null) {
            long nRanges;
            long sz = this.acc[endIdx] - this.cardinalityBeforeWithAcc(startIdx);
            if (sz < (nRanges = this.rangesCountUpperBound(startIdx, endIdx))) {
                return 1L;
            }
            return sz / nRanges;
        }
        if (this.cardData >= 0 && this.cardData <= 32) {
            return 1L;
        }
        long card = 0L;
        long nRanges = 0L;
        for (int i = startIdx; i <= endIdx; ++i) {
            int containerCard;
            Object span = this.spans[i];
            if (RspArray.isSingletonSpan(span)) {
                ++card;
                ++nRanges;
                continue;
            }
            long spanInfo = this.spanInfos[i];
            long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
            if (flen > 0L) {
                card += flen * 65536L;
                ++nRanges;
                continue;
            }
            if (span instanceof short[]) {
                long containerCard2 = spanInfo & 0x7FFFL;
                card += containerCard2;
                nRanges += containerCard2;
                continue;
            }
            if (span instanceof ArrayContainer) {
                ArrayContainer container = (ArrayContainer)span;
                containerCard = container.getCardinality();
                card += (long)containerCard;
                nRanges += (long)containerCard;
                continue;
            }
            if (span instanceof BitmapContainer) {
                BitmapContainer bc = (BitmapContainer)span;
                containerCard = bc.getCardinality();
                card += (long)containerCard;
                nRanges += (long)Math.max(1, containerCard / 3);
                continue;
            }
            Container c = (Container)span;
            card += (long)c.getCardinality();
            nRanges += (long)c.numberOfRanges();
        }
        double estimate = (double)card / (double)nRanges;
        if (estimate < 1.0) {
            return 1L;
        }
        return Math.round(estimate);
    }

    public long rangesCountUpperBound() {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.rangesCountUpperBound(0, this.size - 1);
    }

    public long rangesCountUpperBound(int startIdx, int endIdx) {
        long nRanges = 0L;
        for (int idx = startIdx; idx <= endIdx; ++idx) {
            long card;
            long sInfo = this.spanInfos[idx];
            Object s = this.spans[idx];
            long slen = RspArray.getFullBlockSpanLen(sInfo, s);
            if (slen > 0L) {
                ++nRanges;
                continue;
            }
            if (RspArray.isSingletonSpan(s)) {
                ++nRanges;
                continue;
            }
            if (s instanceof RunContainer) {
                nRanges += (long)((RunContainer)s).numberOfRanges();
                continue;
            }
            if (s instanceof SingleRangeContainer) {
                ++nRanges;
                continue;
            }
            if (s instanceof TwoValuesContainer) {
                nRanges += 2L;
                continue;
            }
            if (s instanceof short[]) {
                card = sInfo & 0x7FFFL;
                nRanges += card;
                continue;
            }
            card = ((Container)s).getCardinality();
            nRanges += card;
        }
        return nRanges;
    }

    public String valuesToString() {
        StringBuilder sb = new StringBuilder(Integer.toString(this.refCount()));
        sb.append(" { ");
        if (this.isEmpty()) {
            sb.append("}");
            return sb.toString();
        }
        boolean first = true;
        int maxRanges = 500;
        try (RspRangeIterator rit = this.getRangeIterator();){
            for (int range = 0; rit.hasNext() && range < 500; ++range) {
                long e;
                long s;
                rit.next();
                if (!first) {
                    sb.append(",");
                }
                if ((s = rit.start()) == (e = rit.end())) {
                    sb.append(s);
                } else {
                    sb.append(rit.start()).append("-").append(rit.end());
                }
                first = false;
            }
            if (rit.hasNext()) {
                sb.append(" ...");
            }
        }
        sb.append(" }");
        return sb.toString();
    }

    public double containerOverhead() {
        if (this.size <= 0) {
            return 0.0;
        }
        long used = 0L;
        long allocated = 0L;
        for (int i = 0; i < this.size; ++i) {
            Object o = this.spans[i];
            if (o instanceof short[]) {
                used += this.spanInfos[i] & 0x7FFFL;
                allocated += (long)((short[])o).length;
                continue;
            }
            if (!(o instanceof Container)) continue;
            Container c = (Container)o;
            used += (long)c.bytesUsed();
            allocated += (long)c.bytesAllocated();
        }
        return (double)(allocated - used) / (double)allocated;
    }

    public void sampleMetrics(LongConsumer rspParallelArraysSizeUsed, LongConsumer rspParallelArraysSizeUnused, LongConsumer arrayContainersBytesAllocated, LongConsumer arrayContainersBytesUnused, LongConsumer arrayContainersCardinality, LongConsumer arrayContainersCount, LongConsumer bitmapContainersBytesAllocated, LongConsumer bitmapContainersBytesUnused, LongConsumer bitmapContainersCardinality, LongConsumer bitmapContainersCount, LongConsumer runContainersBytesAllocated, LongConsumer runContainersBytesUnused, LongConsumer runContainersCardinality, LongConsumer runContainersCount, LongConsumer runContainersRunsCount, LongConsumer singleRangeContainersCount, LongConsumer singleRangeContainerCardinality, LongConsumer singletonContainersCount, LongConsumer twoValuesContainerCount, LongConsumer fullBlockSpansCount, LongConsumer fullBlockSpansLen) {
        rspParallelArraysSizeUsed.accept(this.size);
        rspParallelArraysSizeUnused.accept(this.spanInfos.length - this.size);
        long fullBlockSpansCountAcc = 0L;
        long fullBlockSpansLenAcc = 0L;
        for (int i = 0; i < this.size; ++i) {
            long allocated;
            Object o = this.spans[i];
            if (RspArray.isSingletonSpan(o)) {
                singletonContainersCount.accept(1L);
                continue;
            }
            if (o instanceof short[]) {
                arrayContainersCount.accept(1L);
                long card = this.spanInfos[i] & 0x7FFFL;
                arrayContainersCardinality.accept(card);
                long allocated2 = ((short[])o).length;
                arrayContainersBytesAllocated.accept(allocated2);
                arrayContainersBytesUnused.accept(allocated2 - card);
                continue;
            }
            if (!(o instanceof Container)) {
                ++fullBlockSpansCountAcc;
                fullBlockSpansLenAcc += RspArray.getFullBlockSpanLen(this.spanInfos[i], o);
                continue;
            }
            Container c = (Container)o;
            if (c instanceof ArrayContainer) {
                arrayContainersCount.accept(1L);
                arrayContainersCardinality.accept(c.getCardinality());
                allocated = c.bytesAllocated();
                arrayContainersBytesAllocated.accept(allocated);
                arrayContainersBytesUnused.accept(allocated - (long)c.bytesUsed());
                continue;
            }
            if (c instanceof RunContainer) {
                runContainersCount.accept(1L);
                runContainersCardinality.accept(c.getCardinality());
                allocated = c.bytesAllocated();
                runContainersBytesAllocated.accept(allocated);
                runContainersBytesUnused.accept(allocated - (long)c.bytesUsed());
                runContainersRunsCount.accept(c.numberOfRanges());
                continue;
            }
            if (c instanceof BitmapContainer) {
                bitmapContainersCount.accept(1L);
                bitmapContainersCardinality.accept(c.getCardinality());
                allocated = c.bytesAllocated();
                bitmapContainersBytesAllocated.accept(allocated);
                bitmapContainersBytesUnused.accept(allocated - (long)c.bytesUsed());
                continue;
            }
            if (c instanceof SingleRangeContainer) {
                singleRangeContainersCount.accept(1L);
                singleRangeContainerCardinality.accept(c.getCardinality());
                continue;
            }
            if (c instanceof TwoValuesContainer) {
                twoValuesContainerCount.accept(1L);
                continue;
            }
            throw new IllegalStateException("unknown Container subtype");
        }
        fullBlockSpansCount.accept(fullBlockSpansCountAcc);
        fullBlockSpansLen.accept(fullBlockSpansLenAcc);
    }

    protected final OrderedLongSet tryCompact() {
        if (this.size == 0) {
            return OrderedLongSet.EMPTY;
        }
        long card = this.getCardinality();
        long last = this.lastValue();
        long first = this.firstValue();
        if (this.size == 1) {
            long range = last - first;
            if (range == card - 1L) {
                return SingleRange.make(this.firstValue(), this.lastValue());
            }
        } else if (card > (long)SortedRanges.LONG_DENSE_MAX_CAPACITY) {
            return null;
        }
        SortedRanges sr = SortedRanges.tryMakeForKnownRangeUnknownMaxCapacity(SortedRanges.LONG_DENSE_MAX_CAPACITY, first, last, true);
        try (RspRangeIterator it = this.getRangeIterator();){
            while (it.hasNext()) {
                it.next();
                if ((sr = sr.appendRange(it.start(), it.end())) != null) continue;
                OrderedLongSet orderedLongSet = null;
                return orderedLongSet;
            }
        }
        if (sr != null) {
            sr = sr.tryCompactUnsafe(0);
        }
        return sr;
    }

    static {
        Assert.assertion((0 <= logarithmicAllocGrowthRate && logarithmicAllocGrowthRate < 32 ? 1 : 0) != 0, (String)"RspArray.logarithmicAllocGrowthRate must be >= 0 and < 32");
        BITS_PER_BLOCK = Integer.numberOfTrailingZeros(65536);
        Assert.assertion((Integer.bitCount(65536) == 1 ? 1 : 0) != 0, (String)"RspArray.BITS_PER_BLOCK should be a power of 2.");
        Assert.assertion((boolean)true, (String)"BLOCK_LAST is not a bitmask.");
        FULL_BLOCK_SPAN_MARKER = new Object(){

            public String toString() {
                return "full block span";
            }
        };
        workDataPerThread = ThreadLocal.withInitial(WorkData::new);
        debugValidateEnabled = false;
    }

    protected static class ArraysBuf {
        private static final int CAPACITY_FLOOR = 4;
        private long[] spanInfos;
        private Object[] spans;
        private int size;

        ArraysBuf(int minCapacity) {
            int capacity = Math.max(minCapacity, 4);
            this.spanInfos = new long[capacity];
            this.spans = new Object[capacity];
            this.size = 0;
        }

        void reset(int minCapacity) {
            if (minCapacity > this.capacity()) {
                int capacity = Math.max(minCapacity, 4);
                this.spanInfos = new long[capacity];
                this.spans = new Object[capacity];
            }
            this.size = 0;
        }

        int capacity() {
            if (this.spanInfos == null) {
                return 0;
            }
            return this.spanInfos.length;
        }

        void swap(long[] spanInfos, Object[] spans) {
            if (spanInfos.length >= 4) {
                this.spanInfos = spanInfos;
                this.spans = spans;
                return;
            }
            this.spanInfos = null;
            this.spans = null;
        }

        void pushSharedContainer(RspArray other, long key, Container c) {
            RspArray.setContainerSpanRaw(this.spanInfos, this.spans, this.size, key, other.shareContainer(c));
        }

        void pushContainer(long key, Container container) {
            this.spanInfos[this.size] = key;
            this.spans[this.size] = container;
            ++this.size;
        }

        void pushSingletonSpan(long value) {
            this.spanInfos[this.size] = value;
            this.spans[this.size] = null;
            ++this.size;
        }

        void pushFullBlockSpan(long key, long flen) {
            RspArray.setFullBlockSpanRaw(this.size, this.spanInfos, this.spans, key, flen);
            ++this.size;
        }
    }

    private static final class WorkDataHolder {
        private WorkData wd = null;

        private WorkDataHolder() {
        }

        public WorkData get() {
            if (this.wd == null) {
                this.wd = workDataPerThread.get();
            }
            return this.wd;
        }
    }

    static final class WorkData
    implements SpanViewRecycler {
        private static final SpanView[] ZERO_LENGTH_SPAN_VIEW_ARRAY = new SpanView[0];
        private int[] intArray;
        private SortedRangesInt sortedRangesInt;
        private SortedRangesInt madeNullSortedRanges;
        private ArraysBuf rspArraysBuf;
        private SpanView[] spanViewStack = ZERO_LENGTH_SPAN_VIEW_ARRAY;
        private int stackEnd = 0;
        private int stackGrowAmount = 0;

        WorkData() {
        }

        int[] getIntArray() {
            if (this.intArray == null) {
                this.intArray = new int[61];
            }
            return this.intArray;
        }

        void setIntArray(int[] arr) {
            this.intArray = arr;
        }

        SortedRangesInt getSortedRanges() {
            if (this.sortedRangesInt == null) {
                this.sortedRangesInt = new SortedRangesInt(Math.max(16384, SortedRanges.INT_DENSE_MAX_CAPACITY), 0L);
            }
            this.sortedRangesInt.clear();
            return this.sortedRangesInt;
        }

        SortedRangesInt getMadeNullSortedRanges() {
            if (this.madeNullSortedRanges == null) {
                this.madeNullSortedRanges = new SortedRangesInt(Math.max(16384, SortedRanges.INT_DENSE_MAX_CAPACITY), 0L);
            }
            this.madeNullSortedRanges.clear();
            return this.madeNullSortedRanges;
        }

        ArraysBuf getArraysBuf(int minCapacity) {
            if (this.rspArraysBuf == null) {
                this.rspArraysBuf = new ArraysBuf(minCapacity);
            } else {
                this.rspArraysBuf.reset(minCapacity);
            }
            return this.rspArraysBuf;
        }

        public SpanView borrowSpanView(RspArray arr, int arrIdx, long spanInfo, Object span) {
            SpanView sv = this.borrowSpanView();
            sv.init(arr, arrIdx, spanInfo, span);
            return sv;
        }

        public SpanView borrowSpanView(RspArray arr, int arrIdx) {
            SpanView sv = this.borrowSpanView();
            sv.init(arr, arrIdx);
            return sv;
        }

        public SpanView borrowSpanView() {
            if (this.stackEnd == 0) {
                ++this.stackGrowAmount;
                return new SpanView(this);
            }
            return this.spanViewStack[--this.stackEnd];
        }

        @Override
        public void returnSpanView(SpanView sv) {
            if (this.stackGrowAmount != 0) {
                this.spanViewStack = new SpanView[this.spanViewStack.length + this.stackGrowAmount];
                this.stackGrowAmount = 0;
            }
            this.spanViewStack[this.stackEnd++] = sv;
        }
    }

    static interface SpanViewRecycler {
        public void returnSpanView(SpanView var1);
    }

    static class BeforeCardContext {
        public int knownIdx;
        public long knownBeforeCard;

        public BeforeCardContext(int knownIdx, long knownBeforeCard) {
            this.knownIdx = knownIdx;
            this.knownBeforeCard = knownBeforeCard;
        }
    }

    @FunctionalInterface
    static interface FindOutput {
        public void setResult(int var1, long var2);
    }

    private static class SpanCursorBackwardImpl
    implements SpanCursor {
        private RspArray ra;
        private int si;

        public SpanCursorBackwardImpl(RspArray ra, int si) {
            ra.acquire();
            this.ra = ra;
            this.si = si;
        }

        public SpanCursorBackwardImpl(RspArray ra) {
            this(ra, ra.size);
        }

        @Override
        public long spanInfo() {
            return this.ra.spanInfos[this.si];
        }

        @Override
        public Object span() {
            return this.ra.spans[this.si];
        }

        @Override
        public boolean hasNext() {
            return this.si > 0;
        }

        @Override
        public void next() {
            --this.si;
        }

        private boolean advanceSecondHalf(int i) {
            if (i >= 0) {
                this.si = i;
                return true;
            }
            int j = ~i - 1;
            if (j >= 0) {
                this.si = j;
                return true;
            }
            this.si = 0;
            return false;
        }

        @Override
        public boolean advance(long key) {
            int i = this.ra.getSpanIndex(0, this.si, RspArray.highBits(key));
            return this.advanceSecondHalf(i);
        }

        @Override
        public void release() {
            if (this.ra == null) {
                return;
            }
            this.ra.release();
            this.ra = null;
        }

        @Override
        public RspArray arr() {
            return this.ra;
        }

        @Override
        public int arrIdx() {
            return this.si;
        }
    }

    static class SpanCursorForwardImpl
    implements SpanCursorForward {
        private RspArray ra;
        private int si;

        public SpanCursorForwardImpl(RspArray ra, int si) {
            ra.acquire();
            this.ra = ra;
            this.si = si - 1;
        }

        public SpanCursorForwardImpl(RspArray ra) {
            this(ra, 0);
        }

        @Override
        public SpanCursorForwardImpl copy() {
            return new SpanCursorForwardImpl(this.ra, this.si);
        }

        @Override
        public long spanInfo() {
            return this.ra.spanInfos[this.si];
        }

        @Override
        public Object span() {
            return this.ra.spans[this.si];
        }

        @Override
        public void prev() {
            --this.si;
        }

        @Override
        public boolean hasNext() {
            return this.si < this.ra.size - 1;
        }

        @Override
        public void next() {
            ++this.si;
        }

        private boolean advanceSecondHalf(int i) {
            if (i >= 0) {
                this.si = i;
                return true;
            }
            this.si = -i - 1;
            return this.si < this.ra.size;
        }

        @Override
        public boolean advance(long key) {
            int i = this.ra.getSpanIndex(this.si, RspArray.highBits(key));
            return this.advanceSecondHalf(i);
        }

        @Override
        public void search(RowSetUtils.Comparator comp) {
            this.si = this.ra.searchSpanIndex(this.si, comp);
        }

        @Override
        public void release() {
            if (this.ra == null) {
                return;
            }
            this.ra.release();
            this.ra = null;
        }

        @Override
        public RspArray arr() {
            return this.ra;
        }

        @Override
        public int arrIdx() {
            return this.si;
        }
    }

    public static interface SpanCursorForward
    extends SpanCursor {
        public void prev();

        public void search(RowSetUtils.Comparator var1);

        public SpanCursorForward copy();
    }

    public static interface SpanCursor {
        default public long spanKey() {
            return RspArray.spanInfoToKey(this.spanInfo());
        }

        public long spanInfo();

        public Object span();

        public void next();

        public boolean hasNext();

        public boolean advance(long var1);

        public void release();

        public RspArray arr();

        public int arrIdx();
    }

    protected static final class SpanView
    extends ArrayContainer
    implements AutoCloseable {
        private final SpanViewRecycler recycler;
        private RspArray<?> arr;
        private int arrIdx;
        private long spanInfo;
        private Object span;

        public SpanView(SpanViewRecycler recycler) {
            super(null, 0, false);
            this.recycler = recycler;
        }

        public Container getContainer() {
            if (this.span instanceof short[]) {
                this.shared = (this.spanInfo & 0x8000L) != 0L;
                this.cardinality = (int)(this.spanInfo & 0x7FFFL);
                this.content = (short[])this.span;
                return this;
            }
            this.shared = false;
            this.cardinality = 0;
            this.content = null;
            return (Container)this.span;
        }

        public boolean isFullBlockSpan() {
            return RspArray.isFullBlockSpan(this.span);
        }

        public long getFullBlockSpanLen() {
            return RspArray.getFullBlockSpanLen(this.spanInfo, this.span);
        }

        public boolean isSingletonSpan() {
            return RspArray.isSingletonSpan(this.span);
        }

        public long getSingletonSpanValue() {
            return RspArray.spanInfoToSingletonSpanValue(this.spanInfo);
        }

        public long getKey() {
            return RspArray.spanInfoToKey(this.spanInfo);
        }

        public long getSpanInfo() {
            return this.spanInfo;
        }

        public void init(RspArray<?> arr, int arrIdx) {
            this.init(arr, arrIdx, arr.spanInfos[arrIdx], arr.spans[arrIdx]);
        }

        public void init(RspArray<?> arr, int arrIdx, long spanInfo, Object span) {
            this.arr = arr;
            this.arrIdx = arrIdx;
            this.spanInfo = spanInfo;
            this.span = span;
        }

        protected void onCopyOnWrite() {
            int n = this.arrIdx;
            this.arr.spanInfos[n] = this.arr.spanInfos[n] | 0x8000L;
        }

        public void reset() {
            this.content = null;
            this.arr = null;
            this.span = null;
        }

        @Override
        public void close() {
            this.reset();
            if (this.recycler != null) {
                this.recycler.returnSpanView(this);
            }
        }
    }
}

