/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.chunk.LongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.OrderedLongSetBuilderSequential;
import io.deephaven.engine.rowset.impl.RowSetCounts;
import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.rsp.IndexRangeIteratorView;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.RspIterator;
import io.deephaven.engine.rowset.impl.rsp.RspRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.RspReverseIterator;
import io.deephaven.engine.rowset.impl.rsp.container.ArrayContainer;
import io.deephaven.engine.rowset.impl.rsp.container.BitmapContainer;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.RangeConsumer;
import io.deephaven.engine.rowset.impl.rsp.container.RangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.RunContainer;
import io.deephaven.engine.rowset.impl.rsp.container.SingleRangeContainer;
import io.deephaven.engine.rowset.impl.rsp.container.TwoValuesContainer;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.annotations.VisibleForTesting;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeConsumer;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;

public class RspBitmap
extends RspArray<RspBitmap>
implements OrderedLongSet {
    public RspBitmap() {
    }

    public RspBitmap(long start, long end) {
        super(start, end);
    }

    private RspBitmap(RspBitmap other) {
        super(other);
    }

    public RspBitmap(RspArray src, int startIdx, long startOffset, int endIdx, long endOffset) {
        super(src, startIdx, startOffset, endIdx, endOffset);
    }

    public RspBitmap(RspArray src, int startIdx, int endIdx) {
        super(src, startIdx, endIdx);
    }

    public static RspBitmap makeEmpty() {
        return new RspBitmap();
    }

    public static RspBitmap makeSingleRange(long start, long end) {
        return new RspBitmap(start, end);
    }

    public static RspBitmap makeSingle(long v) {
        return RspBitmap.makeSingleRange(v, v);
    }

    @Override
    protected final RspBitmap make(RspArray src, int startIdx, long startOffset, int endIdx, long endOffset) {
        return new RspBitmap(src, startIdx, startOffset, endIdx, endOffset);
    }

    @Override
    protected final RspBitmap make() {
        return new RspBitmap();
    }

    @Override
    protected RspBitmap self() {
        return this;
    }

    @Override
    public RspBitmap deepCopy() {
        return new RspBitmap(this);
    }

    public RspBitmap writeCheck() {
        return (RspBitmap)this.getWriteRef();
    }

    @VisibleForTesting
    RspArray getKvs() {
        return this;
    }

    private static short lowBitsAsShort(long val) {
        return (short)(val & 0xFFFFL);
    }

    @VisibleForTesting
    RspBitmap addValues(long ... values) {
        RspBitmap rb = this;
        for (long value : values) {
            rb = rb.add(value);
        }
        return rb;
    }

    public long first() {
        return this.firstValue();
    }

    public long last() {
        return this.lastValue();
    }

    static Container containerForTwoValues(long v1, long v2) {
        if (v1 == v2) {
            return null;
        }
        if (v1 < v2) {
            return Container.twoValues((short)RspBitmap.lowBitsAsShort(v1), (short)RspBitmap.lowBitsAsShort(v2));
        }
        return Container.twoValues((short)RspBitmap.lowBitsAsShort(v2), (short)RspBitmap.lowBitsAsShort(v1));
    }

    public RspBitmap addValuesUnsafe(LongChunk<OrderedRowKeys> values, int offset, int length) {
        RspBitmap rb = this.writeCheck();
        rb.addValuesUnsafeNoWriteCheck(values, offset, length);
        return rb;
    }

    public void addValuesUnsafeNoWriteCheck(LongChunk<OrderedRowKeys> values, int offset, int length) {
        RspArray.WorkData wd = (RspArray.WorkData)workDataPerThread.get();
        MutableObject<SortedRanges> sortedRangesMu = this.getWorkSortedRangesMutableObject(wd);
        int spanIndex = 0;
        try (RspArray.SpanView ourView = wd.borrowSpanView();){
            int lengthFromThisSpan;
            for (int vi = 0; vi < length; vi += lengthFromThisSpan) {
                long value = values.get(vi + offset);
                long highBits = RspBitmap.highBits(value);
                lengthFromThisSpan = RspBitmap.countContiguousHighBitsMatches(values, vi + offset + 1, length - vi - 1, highBits) + 1;
                int spanIndexRaw = this.getSpanIndex(spanIndex, highBits);
                Container container = null;
                boolean existing = false;
                if (spanIndexRaw < 0) {
                    spanIndex = ~spanIndexRaw;
                } else {
                    spanIndex = spanIndexRaw;
                    long existingSpanInfo = this.spanInfos[spanIndex];
                    Object existingSpan = this.spans[spanIndex];
                    if (RspBitmap.getFullBlockSpanLen(existingSpanInfo, existingSpan) >= 1L) continue;
                    ourView.init(this, spanIndex, existingSpanInfo, existingSpan);
                    container = ourView.getContainer();
                    existing = true;
                }
                Container result = this.createOrUpdateContainerForValues(values, vi + offset, lengthFromThisSpan, existing, spanIndex, container);
                if (result != null && result.isAllOnes()) {
                    spanIndex = this.setOrInsertFullBlockSpanAtIndex(spanIndexRaw, highBits, 1L, sortedRangesMu);
                    continue;
                }
                if (!existing) {
                    if (result == null) {
                        this.insertSingletonAtIndex(spanIndex, value);
                        continue;
                    }
                    this.insertContainerAtIndex(spanIndex, highBits, result);
                    continue;
                }
                this.setContainerSpan(container, spanIndex, highBits, result);
            }
        }
        this.collectRemovedIndicesIfAny(sortedRangesMu);
    }

    private static int countContiguousHighBitsMatches(LongChunk<OrderedRowKeys> values, int offset, int length, long highBits) {
        for (int vi = 0; vi < length; ++vi) {
            if (RspBitmap.highBits(values.get(vi + offset)) == highBits) continue;
            return vi;
        }
        return length;
    }

    private Container createOrUpdateContainerForValues(@NotNull LongChunk<OrderedRowKeys> values, int offset, int length, boolean existing, int keyIdx, Container container) {
        long firstValue = values.get(offset);
        if (length == 1) {
            if (!existing) {
                return null;
            }
            if (container == null) {
                long right;
                long left;
                long singletonValue = this.getSingletonSpanValue(keyIdx);
                if (firstValue == singletonValue) {
                    return null;
                }
                if (firstValue < singletonValue) {
                    left = firstValue;
                    right = singletonValue;
                } else {
                    left = singletonValue;
                    right = firstValue;
                }
                if (left + 1L == right) {
                    int start = RspBitmap.lowBitsAsInt(left);
                    int end = RspBitmap.lowBitsAsInt(right);
                    return new SingleRangeContainer(start, end + 1);
                }
                short leftLow = RspBitmap.lowBitsAsShort(left);
                short rightLow = RspBitmap.lowBitsAsShort(right);
                return new TwoValuesContainer(leftLow, rightLow);
            }
            short firstValueLowBits = RspBitmap.lowBitsAsShort(firstValue);
            return container.iset(firstValueLowBits);
        }
        long lastValue = values.get(offset + length - 1);
        if (lastValue - firstValue + 1L == (long)length) {
            if (!existing) {
                return Container.singleRange((int)RspBitmap.lowBitsAsInt(firstValue), (int)(RspBitmap.lowBitsAsInt(lastValue) + 1));
            }
            if (container == null) {
                return new RunContainer(RspBitmap.lowBitsAsInt(firstValue), RspBitmap.lowBitsAsInt(lastValue) + 1).iset(RspBitmap.lowBitsAsShort(this.getSingletonSpanValue(keyIdx)));
            }
            return container.iadd(RspBitmap.lowBitsAsInt(firstValue), RspBitmap.lowBitsAsInt(lastValue) + 1);
        }
        if (length == 2) {
            if (!existing) {
                return Container.twoValues((short)RspBitmap.lowBitsAsShort(firstValue), (short)RspBitmap.lowBitsAsShort(lastValue));
            }
            if (container == null) {
                return new ArrayContainer(3).iset(RspBitmap.lowBitsAsShort(firstValue)).iset(RspBitmap.lowBitsAsShort(lastValue)).iset(RspBitmap.lowBitsAsShort(this.spanInfos[keyIdx]));
            }
            return container.iset(RspBitmap.lowBitsAsShort(firstValue)).iset(RspBitmap.lowBitsAsShort(lastValue));
        }
        if (!existing) {
            return RspBitmap.makeValuesContainer(values, offset, length).runOptimize();
        }
        if (container == null) {
            container = Container.singleton((short)RspBitmap.lowBitsAsShort(this.spanInfos[keyIdx]));
        }
        return RspBitmap.addValuesToContainer(values, offset, length, container);
    }

    private static Container makeValuesContainer(LongChunk<OrderedRowKeys> values, int offset, int length) {
        if (length <= 3835) {
            short[] valuesArray = new short[length];
            for (int vi = 0; vi < length; ++vi) {
                valuesArray[vi] = RspBitmap.lowBitsAsShort(values.get(vi + offset));
            }
            return new ArrayContainer(valuesArray);
        }
        BitmapContainer bitmapContainer = new BitmapContainer();
        for (int vi = 0; vi < length; ++vi) {
            bitmapContainer.iset(RspBitmap.lowBitsAsShort(values.get(vi + offset)));
        }
        return bitmapContainer;
    }

    private static Container addValuesToContainer(LongChunk<OrderedRowKeys> values, int offset, int length, Container container) {
        if (container.getCardinality() <= length / 2) {
            return RspBitmap.makeValuesContainer(values, offset, length).ior(container);
        }
        for (int vi = 0; vi < length; ++vi) {
            container = container.iset(RspBitmap.lowBitsAsShort(values.get(vi + offset)));
        }
        return container;
    }

    public RspBitmap add(long val) {
        RspBitmap rb = this.addUnsafe(val);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap addUnsafe(long val) {
        RspBitmap rb = this.writeCheck();
        rb.addUnsafeNoWriteCheck(val);
        return rb;
    }

    public void addUnsafeNoWriteCheck(long val) {
        int index = this.getSpanIndex(val);
        if (index < 0) {
            this.insertSingletonAtIndex(~index, val);
            return;
        }
        try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, index);){
            Container result;
            long flen = view.getFullBlockSpanLen();
            if (flen > 0L) {
                return;
            }
            Container container = null;
            if (view.isSingletonSpan()) {
                long single = view.getSingletonSpanValue();
                result = RspBitmap.containerForTwoValues(single, val);
                if (result == null) {
                    return;
                }
            } else {
                container = view.getContainer();
                result = container.iset(RspBitmap.lowBitsAsShort(val));
            }
            long key = view.getKey();
            if (result.isAllOnes()) {
                this.setOrInsertFullBlockSpanAtIndex(index, key, 1L, null);
            } else {
                this.setContainerSpan(container, index, key, result);
            }
        }
    }

    public void appendRangeUnsafeNoWriteCheck(long sHigh, long start, long end) {
        this.appendRangeUnsafeNoWriteCheck(sHigh, start, RspBitmap.highBits(end), end);
    }

    private void appendRangeUnsafeNoWriteCheck(long sHigh, long start, long eHigh, long end) {
        int sLow = RspBitmap.lowBitsAsInt(start);
        int eLow = RspBitmap.lowBitsAsInt(end);
        if (sHigh == eHigh) {
            this.singleBlockAppendRange(sHigh, start, sLow, eLow);
            return;
        }
        this.singleBlockAppendRange(sHigh, start, sLow, 65535);
        long sHighNext = RspArray.nextKey(sHigh);
        if (sHighNext == eHigh) {
            if (eLow == 65535) {
                this.appendFullBlockSpan(sHighNext, 1L);
            } else if (eLow == 0) {
                this.appendSingletonSpan(sHighNext);
            } else {
                this.appendContainer(sHighNext, Container.rangeOfOnes((int)0, (int)(eLow + 1)));
            }
            return;
        }
        if (eLow < 65535) {
            this.appendFullBlockSpan(sHighNext, RspArray.distanceInBlocks(sHighNext, eHigh));
            if (eLow == 0) {
                this.appendSingletonSpan(eHigh);
            } else {
                this.appendContainer(eHigh, Container.rangeOfOnes((int)0, (int)(eLow + 1)));
            }
            return;
        }
        this.appendFullBlockSpan(sHighNext, RspArray.distanceInBlocks(sHighNext, eHigh) + 1L);
    }

    public RspBitmap appendRange(long start, long end) {
        RspBitmap rb = this.appendRangeUnsafe(start, end);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap appendRangeUnsafe(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("bad range start=" + start + " > end=" + end + ".");
        }
        long sHigh = RspBitmap.highBits(start);
        RspBitmap rb = this.writeCheck();
        rb.appendRangeUnsafeNoWriteCheck(sHigh, start, end);
        return rb;
    }

    public void appendRangeUnsafeNoWriteCheck(long start, long end) {
        this.appendRangeUnsafeNoWriteCheck(RspBitmap.highBits(start), start, end);
    }

    public void appendContainerUnsafeNoWriteCheck(long k, Container c) {
        if (c != null) {
            if (c.isAllOnes()) {
                this.appendFullBlockSpan(k, 1L);
                return;
            }
            if (c.isSingleElement()) {
                long value = k | (long)c.first();
                this.appendSingletonSpan(value);
                return;
            }
        }
        this.appendContainer(k, c);
    }

    public void appendFullBlockSpanUnsafeNoWriteCheck(long k, long slen) {
        this.appendFullBlockSpan(k, slen);
    }

    public RspBitmap append(long v) {
        RspBitmap rb = this.appendUnsafe(v);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap appendUnsafe(long v) {
        RspBitmap rb = this.writeCheck();
        rb.appendUnsafeNoWriteCheck(v);
        return rb;
    }

    public void appendUnsafeNoWriteCheck(long v) {
        long sHigh = RspBitmap.highBits(v);
        short low = RspBitmap.lowBits(v);
        long keyForLastBlock = 0L;
        if (this.isEmpty() || (keyForLastBlock = this.keyForLastBlock()) < sHigh) {
            this.appendSingletonSpan(v);
            return;
        }
        if (keyForLastBlock != sHigh) {
            throw new IllegalArgumentException("Can't append v=" + v + " when keyForLastBlock=" + keyForLastBlock);
        }
        int lastIndex = this.size - 1;
        try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, lastIndex);){
            Container result;
            if (view.getFullBlockSpanLen() > 0L) {
                return;
            }
            Container container = null;
            if (view.isSingletonSpan()) {
                long single = view.getSingletonSpanValue();
                if (single == v) {
                    return;
                }
                result = single < v ? Container.twoValues((short)RspBitmap.lowBitsAsShort(single), (short)RspBitmap.lowBitsAsShort(v)) : Container.twoValues((short)RspBitmap.lowBitsAsShort(v), (short)RspBitmap.lowBitsAsShort(single));
            } else {
                container = view.getContainer();
                result = container.iset(low);
            }
            if (result.isAllOnes()) {
                this.setLastFullBlockSpan(sHigh, 1L);
                return;
            }
            this.setContainerSpan(container, lastIndex, sHigh, result);
        }
    }

    private int singleBlockAddRange(int startPos, long startHighBits, long start, int startLowBits, int endLowBits) {
        Container result;
        int endExclusive = endLowBits + 1;
        int i = this.getSpanIndex(startPos, start);
        if (endExclusive - startLowBits == 65536) {
            return this.setOrInsertFullBlockSpanAtIndex(i, startHighBits, 1L, null);
        }
        if (i < 0) {
            int j = -i - 1;
            if (startLowBits == endLowBits) {
                this.insertSingletonAtIndex(j, start);
            } else {
                this.insertContainerAtIndex(j, startHighBits, Container.rangeOfOnes((int)startLowBits, (int)endExclusive));
            }
            return j;
        }
        Object span = this.spans[i];
        if (RspArray.isFullBlockSpan(span)) {
            return i;
        }
        Container container = null;
        RspArray.SpanView view = null;
        if (RspBitmap.isSingletonSpan(span)) {
            long single = this.getSingletonSpanValue(i);
            int keyLowAsInt = RspBitmap.lowBitsAsInt(single);
            if (startLowBits == endLowBits && startLowBits == keyLowAsInt) {
                return i;
            }
            if (keyLowAsInt + 1 < startLowBits) {
                result = new RunContainer(keyLowAsInt, keyLowAsInt + 1, startLowBits, endExclusive);
            } else if (keyLowAsInt + 1 == startLowBits) {
                if (endExclusive - keyLowAsInt == 65536) {
                    return this.setOrInsertFullBlockSpanAtIndex(i, startHighBits, 1L, null);
                }
                result = Container.singleRange((int)keyLowAsInt, (int)endExclusive);
            } else if (endLowBits + 1 < keyLowAsInt) {
                result = new RunContainer(startLowBits, endExclusive, keyLowAsInt, keyLowAsInt + 1);
            } else if (endLowBits + 1 == keyLowAsInt) {
                if (keyLowAsInt + 1 - startLowBits == 65536) {
                    return this.setOrInsertFullBlockSpanAtIndex(i, startHighBits, 1L, null);
                }
                result = Container.singleRange((int)startLowBits, (int)(keyLowAsInt + 1));
            } else {
                result = Container.singleRange((int)startLowBits, (int)endExclusive);
            }
        } else {
            view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, i, this.spanInfos[i], span);
            container = view.getContainer();
            result = container.iadd(startLowBits, endExclusive);
            if (result.isAllOnes()) {
                view.close();
                return this.setOrInsertFullBlockSpanAtIndex(i, startHighBits, 1L, null);
            }
        }
        try (RspArray.SpanView ensureViewIsClosedIfNotNull = view;){
            this.setContainerSpan(container, i, startHighBits, result);
            int n = i;
            return n;
        }
    }

    private int singleBlockAppendRange(long kHigh, long k, int start, int end) {
        int endExclusive = end + 1;
        long keyForLastBlock = 0L;
        if (this.isEmpty() || (keyForLastBlock = this.keyForLastBlock()) < kHigh) {
            int pos = this.size();
            if (start == end) {
                this.appendSingletonSpan(k);
            } else {
                if (endExclusive - start == 65536) {
                    int insertIdx = -pos - 1;
                    return this.setOrInsertFullBlockSpanAtIndex(insertIdx, kHigh, 1L, null);
                }
                this.appendContainer(kHigh, Container.rangeOfOnes((int)start, (int)endExclusive));
            }
            return pos;
        }
        if (keyForLastBlock == kHigh) {
            int pos = this.size() - 1;
            Object span = this.spans[pos];
            if (!RspArray.isFullBlockSpan(span)) {
                Container container = null;
                try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, pos, this.spanInfos[pos], span);){
                    Container result;
                    if (view.isSingletonSpan()) {
                        long single = view.getSingletonSpanValue();
                        result = RspBitmap.containerForLowValueAndRange(RspBitmap.lowBitsAsInt(single), start, end);
                    } else {
                        container = view.getContainer();
                        result = container.iadd(start, endExclusive);
                    }
                    if (result != null && result.isAllOnes()) {
                        int n = this.setOrInsertFullBlockSpanAtIndex(pos, kHigh, 1L, null);
                        return n;
                    }
                    this.setContainerSpan(container, pos, kHigh, result);
                }
            }
            return pos;
        }
        throw new IllegalArgumentException("Can't append range (k=" + k + ", start=" + start + ", end=" + end + ") when keyForLastBlock=" + keyForLastBlock);
    }

    public static Container containerForLowValueAndRange(int val, int start, int end) {
        if (end == start) {
            return RspBitmap.containerForTwoValues(val, start);
        }
        if (val + 1 < start) {
            return new RunContainer(val, val + 1, start, end + 1);
        }
        if (val + 1 == start) {
            return Container.singleRange((int)val, (int)(end + 1));
        }
        if (end + 1 < val) {
            return new RunContainer(start, end + 1, val, val + 1);
        }
        if (end + 1 == val) {
            return Container.singleRange((int)start, (int)(val + 1));
        }
        return Container.singleRange((int)start, (int)(end + 1));
    }

    public RspBitmap addRangeExclusiveEnd(long start, long end) {
        return this.addRange(start, end - 1L);
    }

    public RspBitmap addRange(long start, long end) {
        RspBitmap rb = this.addRangeUnsafe(start, end);
        rb.finishMutations();
        return rb;
    }

    private int getSetOrInsertIdx(int startIdx, long keyToInsert) {
        long startIdxSpanInfo = this.spanInfos[startIdx];
        Object startIdxSpan = this.spans[startIdx];
        if (RspBitmap.getFullBlockSpanLen(startIdxSpanInfo, startIdxSpan) > 1L) {
            return startIdx;
        }
        int i = startIdx + 1;
        if (i >= this.size() || this.getKey(i) > keyToInsert) {
            return -i - 1;
        }
        return i;
    }

    public RspBitmap addRangeUnsafe(long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("bad range start=" + start + " > end=" + end + ".");
        }
        RspBitmap rb = this.writeCheck();
        rb.addRangeUnsafeNoWriteCheck(0, start, end);
        return rb;
    }

    public void addRangeUnsafeNoWriteCheck(long first, long last) {
        this.addRangeUnsafeNoWriteCheck(0, first, last);
    }

    public int addRangeUnsafeNoWriteCheck(int fromIdx, long start, long end) {
        if (start > end) {
            throw new IllegalArgumentException("bad range start=" + start + " > end=" + end + ".");
        }
        long sHigh = RspBitmap.highBits(start);
        boolean kvsIsEmpty = this.isEmpty();
        if (kvsIsEmpty || sHigh >= this.keyForLastBlock()) {
            this.appendRangeUnsafeNoWriteCheck(sHigh, start, end);
            return this.size - 1;
        }
        long eHigh = RspBitmap.highBits(end);
        int sLow = RspBitmap.lowBitsAsInt(start);
        int eLow = RspBitmap.lowBitsAsInt(end);
        if (sHigh == eHigh) {
            return this.singleBlockAddRange(fromIdx, sHigh, start, sLow, eLow);
        }
        int i = this.singleBlockAddRange(fromIdx, sHigh, start, sLow, 65535);
        long sHighNext = RspArray.nextKey(sHigh);
        int idxForFull = this.getSetOrInsertIdx(i, sHighNext);
        if (sHighNext == eHigh) {
            i = eLow == 65535 ? this.setOrInsertFullBlockSpanAtIndex(idxForFull, sHighNext, 1L, null) : this.singleBlockAddRange(i, sHighNext, sHighNext, 0, eLow);
            return i;
        }
        if (eLow < 65535) {
            int j = this.setOrInsertFullBlockSpanAtIndex(idxForFull, sHighNext, RspArray.distanceInBlocks(sHighNext, eHigh), null);
            return this.singleBlockAddRange(j, eHigh, eHigh, 0, eLow);
        }
        return this.setOrInsertFullBlockSpanAtIndex(idxForFull, sHighNext, RspArray.distanceInBlocks(sHighNext, eHigh) + 1L, null);
    }

    public void addRangesUnsafeNoWriteCheck(RowSet.RangeIterator rit) {
        try {
            int i = 0;
            while (rit.hasNext()) {
                rit.next();
                if ((i = this.addRangeUnsafeNoWriteCheck(i, rit.currentRangeStart(), rit.currentRangeEnd())) != -1) continue;
                return;
            }
        }
        finally {
            rit.close();
        }
    }

    public boolean contains(long val) {
        long key = RspBitmap.highBits(val);
        int i = this.getSpanIndex(key);
        if (i < 0) {
            return false;
        }
        Object span = this.spans[i];
        if (RspArray.isFullBlockSpan(span)) {
            return true;
        }
        try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, i, this.spanInfos[i], span);){
            if (view.isSingletonSpan()) {
                boolean bl = view.getSingletonSpanValue() == val;
                return bl;
            }
            boolean bl = view.getContainer().contains(RspBitmap.lowBitsAsShort(val));
            return bl;
        }
    }

    public RspBitmap remove(long val) {
        RspBitmap rb = this.removeUnsafe(val);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap removeUnsafe(long val) {
        long key = RspBitmap.highBits(val);
        int i = this.getSpanIndex(key);
        if (i < 0) {
            return this;
        }
        RspBitmap rb = this.writeCheck();
        rb.removeUnsafeNoWriteCheck(val, key, i);
        return rb;
    }

    public RspBitmap removeUnsafeNoWriteCheck(long val) {
        long key = RspBitmap.highBits(val);
        int i = this.getSpanIndex(key);
        if (i >= 0) {
            this.removeUnsafeNoWriteCheck(val, key, i);
        }
        return this;
    }

    public void removeUnsafeNoWriteCheck(long val, long blockKey, int i) {
        Container c;
        long spanInfo = this.spanInfos[i];
        Object s = this.spans[i];
        long flen = RspArray.getFullBlockSpanLen(spanInfo, s);
        if (flen == 0L) {
            if (RspBitmap.isSingletonSpan(s)) {
                long single = RspBitmap.spanInfoToSingletonSpanValue(spanInfo);
                if (val == single) {
                    this.removeSpanAtIndex(i);
                }
            } else {
                try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView(this, i, spanInfo, s);){
                    Container orig = view.getContainer();
                    Container result = orig.iunset(RspBitmap.lowBitsAsShort(val));
                    if (result.isSingleElement()) {
                        this.setSingletonSpan(i, blockKey | (long)result.first());
                    } else if (result.isEmpty()) {
                        this.removeSpanAtIndex(i);
                    } else {
                        this.setContainerSpan(orig, i, blockKey, result);
                    }
                }
            }
            return;
        }
        long spanStartKey = RspBitmap.spanInfoToKey(spanInfo);
        long spanEndKey = spanStartKey + 65536L * flen;
        int low = RspBitmap.lowBitsAsInt(val);
        long singletonValue = 0L;
        if (low == 0) {
            c = Container.rangeOfOnes((int)1, (int)65536);
        } else if (low == 65535) {
            c = Container.rangeOfOnes((int)0, (int)65535);
        } else {
            Container c2;
            boolean preStart = false;
            int preEnd = low;
            int posStart = low + 1;
            int posEnd = 65536;
            if (65536 - posStart > preEnd - 0) {
                c2 = Container.rangeOfOnes((int)posStart, (int)65536);
                c2 = c2.iadd(0, preEnd);
            } else {
                c2 = Container.rangeOfOnes((int)0, (int)preEnd);
                c2 = c2.iadd(posStart, 65536);
            }
            if (c2.isSingleElement()) {
                singletonValue = blockKey | (long)c2.first();
                c = null;
            } else {
                c = c2;
            }
        }
        long preflen = RspArray.distanceInBlocks(spanStartKey, blockKey);
        long posSpanFirstKey = RspArray.nextKey(blockKey);
        long posflen = RspArray.distanceInBlocks(posSpanFirstKey, spanEndKey);
        if (preflen > 0L) {
            if (posflen > 0L) {
                RspArray.ArraysBuf buf = ((RspArray.WorkData)workDataPerThread.get()).getArraysBuf(3);
                buf.pushFullBlockSpan(spanStartKey, preflen);
                if (c == null) {
                    buf.pushSingletonSpan(singletonValue);
                } else {
                    buf.pushContainer(blockKey, c);
                }
                buf.pushFullBlockSpan(posSpanFirstKey, posflen);
                this.replaceSpanAtIndex(i, buf);
                return;
            }
            RspArray.ArraysBuf buf = ((RspArray.WorkData)workDataPerThread.get()).getArraysBuf(2);
            buf.pushFullBlockSpan(spanStartKey, preflen);
            if (c == null) {
                buf.pushSingletonSpan(singletonValue);
            } else {
                buf.pushContainer(blockKey, c);
            }
            this.replaceSpanAtIndex(i, buf);
            return;
        }
        if (posflen > 0L) {
            RspArray.ArraysBuf buf = ((RspArray.WorkData)workDataPerThread.get()).getArraysBuf(2);
            if (c == null) {
                buf.pushSingletonSpan(singletonValue);
            } else {
                buf.pushContainer(blockKey, c);
            }
            buf.pushFullBlockSpan(posSpanFirstKey, posflen);
            this.replaceSpanAtIndex(i, buf);
            return;
        }
        if (c == null) {
            this.setSingletonSpan(i, singletonValue);
        } else {
            this.setContainerSpan(i, blockKey, c);
        }
    }

    public RspBitmap removeRange(long start, long end) {
        if (this.isEmpty() || this.last() < start || end < this.first()) {
            return this;
        }
        RspBitmap rb = this.removeRangeUnsafe(start, end);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap removeRangeUnsafe(long start, long end) {
        RspBitmap rb = this.writeCheck();
        rb.removeRangeUnsafeNoWriteCheck(start, end);
        return rb;
    }

    private static RspBitmap orImpl(RspBitmap r1, RspBitmap r2) {
        RspBitmap r;
        if (r1.size > r2.size) {
            r = r1.deepCopy();
            r.orEquals(r2);
        } else {
            r = r2.deepCopy();
            r.orEquals(r1);
        }
        return r;
    }

    public static RspBitmap or(RspBitmap b1, RspBitmap b2) {
        RspBitmap rb = RspBitmap.orImpl(b1, b2);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap orEquals(RspBitmap other) {
        RspBitmap rb = this.orEqualsUnsafe(other);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap orEqualsShifted(long shiftAmount, RspBitmap other) {
        RspBitmap rb = this.orEqualsShiftedUnsafe(shiftAmount, other);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap orEqualsUnsafe(RspBitmap other) {
        return this.orEqualsShiftedUnsafe(0L, other);
    }

    public RspBitmap orEqualsShiftedUnsafe(long shiftAmount, RspBitmap other) {
        if (other.isEmpty()) {
            return this;
        }
        RspBitmap rb = this.writeCheck();
        rb.orEqualsShiftedUnsafeNoWriteCheck(shiftAmount, other);
        return rb;
    }

    public void appendShiftedUnsafeNoWriteCheck(long shiftAmount, RspArray other, boolean acquire) {
        if ((shiftAmount & 0xFFFFL) == 0L && this.tryAppendShiftedUnsafeNoWriteCheck(shiftAmount, other, acquire)) {
            return;
        }
        if (this.lastValue() >= other.firstValue() + shiftAmount) {
            throw new IllegalArgumentException("Cannot append rowSet with shiftAmount=" + shiftAmount + ", firstRowKey=" + other.firstValue() + " when our lastValue=" + this.lastValue());
        }
        other.forEachLongRange((start, end) -> {
            this.appendRangeUnsafeNoWriteCheck(start + shiftAmount, end + shiftAmount);
            return true;
        });
    }

    private static RspBitmap andImpl(RspBitmap r1, RspBitmap r2) {
        if (r1.isEmpty() || r2.isEmpty()) {
            return new RspBitmap();
        }
        if (r1.size < r2.size) {
            RspBitmap r = r1.deepCopy();
            r.andEquals(r2);
            return r;
        }
        RspBitmap r = r2.deepCopy();
        r.andEquals(r1);
        return r;
    }

    public static RspBitmap and(RspBitmap b1, RspBitmap b2) {
        RspBitmap rb = RspBitmap.andImpl(b1, b2);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap andEquals(RspBitmap other) {
        RspBitmap rb = this.andEqualsUnsafe(other);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap andEqualsUnsafe(RspBitmap other) {
        RspBitmap rb = this.writeCheck();
        rb.andEqualsUnsafeNoWriteCheck(other);
        return rb;
    }

    public static RspBitmap andNotImpl(RspBitmap r1, RspBitmap r2) {
        RspBitmap r;
        Object r2Span;
        Object r1Span;
        long r2SpanInfo;
        long r1SpanInfo;
        int startIndex;
        int minLen = Math.min(r1.size, r2.size);
        for (startIndex = 0; startIndex < minLen && (r1SpanInfo = r1.spanInfos[startIndex]) == (r2SpanInfo = r2.spanInfos[startIndex]) && ((r1Span = r1.spans[startIndex]) == (r2Span = r2.spans[startIndex]) || r1Span instanceof Long && r2Span instanceof Long && ((Long)r1Span).longValue() == ((Long)r2Span).longValue()); ++startIndex) {
        }
        if (startIndex == 0) {
            r = r1.deepCopy();
        } else {
            if (startIndex == r1.size) {
                return RspBitmap.makeEmpty();
            }
            r = new RspBitmap(r1, startIndex, r1.size - 1);
        }
        r.andNotEqualsUnsafeNoWriteCheck(r2);
        return r;
    }

    public static RspBitmap andNot(RspBitmap b1, RspBitmap b2) {
        RspBitmap rb = RspBitmap.andNotImpl(b1, b2);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap update(RspBitmap added, RspBitmap removed) {
        RspBitmap rb = this.updateUnsafe(added, removed);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap updateUnsafe(RspBitmap added, RspBitmap removed) {
        if (debug && added.overlaps(removed)) {
            throw new IllegalArgumentException("rowSet update: added overlaps with removed.");
        }
        RspBitmap rb = this.writeCheck();
        rb.updateUnsafeNoWriteCheck(added, removed);
        return rb;
    }

    public void updateUnsafeNoWriteCheck(RspBitmap added, RspBitmap removed) {
        this.andNotEqualsUnsafeNoWriteCheck(removed);
        this.orEqualsUnsafeNoWriteCheck(added);
    }

    public RspBitmap andNotEquals(RspBitmap other) {
        RspBitmap rb = this.andNotEqualsUnsafe(other);
        rb.finishMutations();
        return rb;
    }

    public RspBitmap andNotEqualsUnsafe(RspBitmap other) {
        if (other.isEmpty()) {
            return this;
        }
        RspBitmap rb = this.writeCheck();
        rb.andNotEqualsUnsafeNoWriteCheck(other);
        return rb;
    }

    public RspBitmap applyOffset(long offset) {
        return this.applyOffsetImpl(offset, this::self, this::writeCheck);
    }

    public RspBitmap applyOffsetNoWriteCheck(long offset) {
        return this.applyOffsetImpl(offset, this::self, this::self);
    }

    public RspBitmap applyOffsetOnNew(long offset) {
        return this.applyOffsetImpl(offset, this::cowRef, this::deepCopy);
    }

    public RspBitmap applyOffsetImpl(long offset, Supplier<RspBitmap> onZeroOffset, Supplier<RspBitmap> onAlignedOffset) {
        if (offset == 0L) {
            return onZeroOffset.get();
        }
        if ((offset & 0xFFFFL) == 0L) {
            RspBitmap ans = onAlignedOffset.get();
            ans.applyKeyOffset(offset);
            ans.ifDebugValidate();
            return ans;
        }
        RspBitmap rb = new RspBitmap();
        RspRangeIterator it = this.getRangeIterator();
        int i = 0;
        while (it.hasNext()) {
            it.next();
            long s = it.start();
            long e = it.end();
            i = rb.addRangeUnsafeNoWriteCheck(i, s + offset, e + offset);
        }
        rb.finishMutations();
        return rb;
    }

    public RspBitmap subrangeByPos(long firstPos, long lastPos, boolean returnNullIfEmptyResult) {
        RspBitmap rb = (RspBitmap)this.subrangeByPosInternal(firstPos, lastPos);
        if (rb == null || rb.isEmpty()) {
            if (returnNullIfEmptyResult) {
                return null;
            }
            return new RspBitmap();
        }
        return rb;
    }

    public RspBitmap subrangeByPos(long firstPos, long lastPos) {
        return this.subrangeByPos(firstPos, lastPos, false);
    }

    public RspBitmap subrangeByValue(long start, long end, boolean returnNullIfEmptyResult) {
        if (this.isEmpty()) {
            if (returnNullIfEmptyResult) {
                return null;
            }
            return (RspBitmap)this.cowRef();
        }
        if (start <= this.first() && this.last() <= end) {
            return (RspBitmap)this.cowRef();
        }
        RspBitmap rb = (RspBitmap)this.subrangeByKeyInternal(start, end);
        rb.finishMutationsAndOptimize();
        if (rb.isEmpty() && returnNullIfEmptyResult) {
            return null;
        }
        return rb;
    }

    public RspBitmap subrangeByValue(long start, long end) {
        return this.subrangeByValue(start, end, false);
    }

    public void invert(LongRangeConsumer builder, RowSet.RangeIterator it, long maxPos) {
        if (!it.hasNext()) {
            return;
        }
        int startIndex = 0;
        it.next();
        int knownIdx = 0;
        long knownBeforeCard = 0L;
        try (RspArray.SpanView view = ((RspArray.WorkData)workDataPerThread.get()).borrowSpanView();){
            block10: while (true) {
                Container c;
                long prevCap;
                long startHiBits;
                int i;
                if ((i = this.getSpanIndex(startIndex, startHiBits = RspBitmap.highBits(it.currentRangeStart()))) < 0) {
                    throw new IllegalArgumentException("invert for non-existing key:" + it.currentRangeStart());
                }
                if (this.acc == null) {
                    prevCap = this.cardinalityBeforeNoAcc(i, knownIdx, knownBeforeCard);
                    knownIdx = i;
                    knownBeforeCard = prevCap;
                } else {
                    prevCap = this.cardinalityBeforeWithAcc(i);
                }
                if (prevCap - 1L >= maxPos) {
                    return;
                }
                long spanInfo = this.spanInfos[i];
                Object span = this.spans[i];
                long flen = RspBitmap.getFullBlockSpanLen(spanInfo, span);
                if (flen > 0L) {
                    long k = RspBitmap.spanInfoToKey(spanInfo);
                    long spanCard = flen * 65536L;
                    long sLastPlusOne = k + spanCard;
                    do {
                        long startPos;
                        if ((startPos = prevCap + it.currentRangeStart() - k) > maxPos) {
                            return;
                        }
                        long end = RspBitmap.uMin(sLastPlusOne - 1L, it.currentRangeEnd());
                        long endPos = prevCap + end - k;
                        if (endPos > maxPos) {
                            builder.accept(startPos, maxPos);
                            return;
                        }
                        builder.accept(startPos, endPos);
                        if (it.currentRangeEnd() >= sLastPlusOne) {
                            it.postpone(sLastPlusOne);
                            startIndex = i + 1;
                            if (this.acc != null) continue block10;
                            knownIdx = startIndex;
                            knownBeforeCard += spanCard;
                            continue block10;
                        }
                        if (!it.hasNext()) {
                            return;
                        }
                        it.next();
                    } while (it.currentRangeStart() < sLastPlusOne);
                    startIndex = i + 1;
                    if (this.acc != null) continue;
                    knownIdx = startIndex;
                    knownBeforeCard += spanCard;
                    continue;
                }
                if (RspBitmap.isSingletonSpan(span)) {
                    long v = RspBitmap.spanInfoToSingletonSpanValue(spanInfo);
                    c = Container.singleton((short)RspBitmap.lowBitsAsShort(v));
                } else {
                    view.init(this, i, spanInfo, span);
                    c = view.getContainer();
                }
                RangeConsumer rc = (rs, re) -> {
                    long start = prevCap + (long)rs;
                    long end = prevCap + (long)re;
                    builder.accept(start, end - 1L);
                };
                int rMaxPos = (int)RspBitmap.uMin(maxPos - prevCap, 65536L);
                IndexRangeIteratorView rv = new IndexRangeIteratorView(it, startHiBits, startHiBits + 65536L);
                boolean maxReached = c.findRanges(rc, (RangeIterator)rv, rMaxPos);
                if (maxReached || rv.underlyingIterFinished()) {
                    return;
                }
                startIndex = i + 1;
                if (this.acc != null) continue;
                knownIdx = startIndex;
                knownBeforeCard += (long)c.getCardinality();
            }
        }
    }

    private static int long2hash(long v) {
        return (int)(v ^ v >>> 32);
    }

    public int hashCode() {
        int r = 17;
        if (!this.isEmpty()) {
            r = 31 * r + RspBitmap.long2hash(this.getCardinality());
            r = 31 * r + RspBitmap.long2hash(this.last());
        }
        return r;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RspBitmap)) {
            return false;
        }
        RspBitmap other = (RspBitmap)o;
        if (this.getCardinality() != other.getCardinality()) {
            return false;
        }
        RspRangeIterator it = this.getRangeIterator();
        RspRangeIterator oit = other.getRangeIterator();
        while (it.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            it.next();
            oit.next();
            if (it.start() != oit.start()) {
                return false;
            }
            if (it.end() == oit.end()) continue;
            return false;
        }
        return true;
    }

    public void finishMutations() {
        this.ensureCardinalityCache();
    }

    public void finishMutationsAndOptimize() {
        this.ensureAccAndOptimize();
    }

    @Override
    public RspBitmap ixCowRef() {
        return (RspBitmap)this.cowRef();
    }

    @Override
    public RspBitmap ixInsert(long key) {
        return this.add(key);
    }

    @Override
    public void ixRelease() {
        this.release();
    }

    @Override
    @VisibleForTesting
    public int ixRefCount() {
        return this.refCount();
    }

    @Override
    public RspBitmap ixInsertRange(long startKey, long endKey) {
        return this.addRange(startKey, endKey);
    }

    @Override
    public final OrderedLongSet ixInsertSecondHalf(LongChunk<OrderedRowKeys> values, int offset, int length) {
        RspBitmap ans = this.addValuesUnsafe(values, offset, length);
        ans.finishMutations();
        return ans;
    }

    @Override
    public final OrderedLongSet ixRemoveSecondHalf(LongChunk<OrderedRowKeys> values, int offset, int length) {
        return this.ixRemove(OrderedLongSet.fromChunk(values, offset, length, true));
    }

    @Override
    public RspBitmap ixAppendRange(long startKey, long endKey) {
        return this.appendRange(startKey, endKey);
    }

    @Override
    public RspBitmap ixRemove(long key) {
        return this.remove(key);
    }

    @Override
    public long ixLastKey() {
        return this.isEmpty() ? -1L : this.last();
    }

    @Override
    public long ixFirstKey() {
        return this.isEmpty() ? -1L : this.first();
    }

    @Override
    public long ixGet(long pos) {
        if (pos < 0L) {
            return -1L;
        }
        return this.get(pos);
    }

    @Override
    public void ixGetKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
        this.getKeysForPositions(inputPositions, outputKeys);
    }

    @Override
    public long ixFind(long key) {
        return this.find(key);
    }

    @Override
    public long ixCardinality() {
        return this.getCardinality();
    }

    @Override
    public boolean ixIsEmpty() {
        return this.isEmpty();
    }

    @Override
    public OrderedLongSet ixInvertOnNew(OrderedLongSet keys, long maximumPosition) {
        if (keys.ixIsEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (keys instanceof SingleRange) {
            long pos = this.ixFind(keys.ixFirstKey());
            if (pos < 0L) {
                throw new IllegalArgumentException("invert for non-existing key:" + keys.ixFirstKey());
            }
            if (pos > maximumPosition) {
                return OrderedLongSet.EMPTY;
            }
            return SingleRange.make(pos, Math.min(pos + keys.ixCardinality() - 1L, maximumPosition));
        }
        try (RowSet.RangeIterator rit = keys.ixRangeIterator();){
            OrderedLongSetBuilderSequential builder = new OrderedLongSetBuilderSequential();
            this.invert(builder, rit, maximumPosition);
            OrderedLongSet orderedLongSet = builder.getOrderedLongSet();
            return orderedLongSet;
        }
    }

    @Override
    public boolean ixForEachLong(LongAbortableConsumer lc) {
        return this.forEachLong(lc);
    }

    @Override
    public boolean ixForEachLongRange(LongRangeAbortableConsumer lc) {
        return this.forEachLongRange(lc);
    }

    @Override
    public OrderedLongSet ixSubindexByPosOnNew(long startPos, long endPosExclusive) {
        long endPos = endPosExclusive - 1L;
        if (endPos < startPos || endPos < 0L) {
            return OrderedLongSet.EMPTY;
        }
        long effectiveStartPos = Math.max(0L, startPos);
        RspBitmap result = this.subrangeByPos(effectiveStartPos, endPos, true);
        if (result == null) {
            return OrderedLongSet.EMPTY;
        }
        return result.ixCompact();
    }

    @Override
    public OrderedLongSet ixSubindexByKeyOnNew(long startKey, long endKey) {
        if (endKey < startKey || endKey < 0L) {
            return OrderedLongSet.EMPTY;
        }
        RspBitmap result = this.subrangeByValue(startKey = Math.max(0L, startKey), endKey, true);
        if (result == null) {
            return OrderedLongSet.EMPTY;
        }
        return result.ixCompact();
    }

    @Override
    public OrderedLongSet ixUpdate(OrderedLongSet added, OrderedLongSet removed) {
        if (added.ixIsEmpty()) {
            if (removed.ixIsEmpty()) {
                return this;
            }
            return this.ixRemove(removed);
        }
        if (removed.ixIsEmpty()) {
            return this.ixInsert(added);
        }
        return ((RspBitmap)this.getWriteRef()).ixUpdateNoWriteCheck(added, removed);
    }

    public OrderedLongSet ixUpdateNoWriteCheck(OrderedLongSet added, OrderedLongSet removed) {
        if (added instanceof SingleRange) {
            this.addRangeUnsafeNoWriteCheck(added.ixFirstKey(), added.ixLastKey());
            if (removed instanceof SingleRange) {
                this.removeRangeUnsafeNoWriteCheck(removed.ixFirstKey(), removed.ixLastKey());
            } else if (removed instanceof SortedRanges) {
                this.removeRangesUnsafeNoWriteCheck(removed.ixRangeIterator());
            } else {
                this.andNotEqualsUnsafeNoWriteCheck((RspBitmap)removed);
            }
        } else if (removed instanceof SingleRange) {
            this.removeRangeUnsafeNoWriteCheck(removed.ixFirstKey(), removed.ixLastKey());
            if (added instanceof SortedRanges) {
                this.addRangesUnsafeNoWriteCheck(added.ixRangeIterator());
            } else {
                this.orEqualsUnsafeNoWriteCheck((RspBitmap)added);
            }
        } else if (added instanceof RspBitmap && removed instanceof RspBitmap) {
            this.updateUnsafeNoWriteCheck((RspBitmap)added, (RspBitmap)removed);
        } else {
            OrderedLongSet ans = this.ixRemoveNoWriteCheck(removed);
            return ans.ixInsert(added);
        }
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        this.finishMutations();
        return this;
    }

    @Override
    public RspBitmap ixInsert(OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return this;
        }
        return ((RspBitmap)this.getWriteRef()).ixInsertNoWriteCheck(other);
    }

    public RspBitmap ixInsertNoWriteCheck(OrderedLongSet other) {
        if (other instanceof SingleRange) {
            this.insertOrderedLongSetUnsafeNoWriteCheck((SingleRange)other);
        } else if (other instanceof SortedRanges) {
            this.insertOrderedLongSetUnsafeNoWriteCheck((SortedRanges)other);
        } else {
            this.insertOrderedLongSetUnsafeNoWriteCheck((RspBitmap)other);
        }
        this.finishMutations();
        return this;
    }

    public void insertOrderedLongSetUnsafeNoWriteCheck(SingleRange ix) {
        this.addRangeUnsafeNoWriteCheck(0, ix.ixFirstKey(), ix.ixLastKey());
    }

    public void insertOrderedLongSetUnsafeNoWriteCheck(SortedRanges sr) {
        this.addRangesUnsafeNoWriteCheck(sr.getRangeIterator());
    }

    public void insertOrderedLongSetUnsafeNoWriteCheck(RspBitmap rb) {
        this.orEqualsUnsafeNoWriteCheck(rb);
    }

    @Override
    public OrderedLongSet ixRemove(OrderedLongSet other) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (other.ixIsEmpty()) {
            return this;
        }
        return ((RspBitmap)this.getWriteRef()).ixRemoveNoWriteCheck(other);
    }

    public OrderedLongSet ixRemoveNoWriteCheck(OrderedLongSet other) {
        if (other instanceof SingleRange) {
            this.removeRangeUnsafeNoWriteCheck(other.ixFirstKey(), other.ixLastKey());
        } else if (other instanceof SortedRanges) {
            this.removeRangesUnsafeNoWriteCheck(other.ixRangeIterator());
        } else {
            this.andNotEqualsUnsafeNoWriteCheck((RspBitmap)other);
        }
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        this.finishMutations();
        return this;
    }

    @Override
    public OrderedLongSet ixRetain(OrderedLongSet other) {
        return this.retainImpl(other, this::getWriteRef);
    }

    public OrderedLongSet ixRetainNoWriteCheck(OrderedLongSet other) {
        return this.retainImpl(other, () -> this);
    }

    private OrderedLongSet retainImpl(OrderedLongSet other, Supplier<RspBitmap> refSupplier) {
        if (this.isEmpty() || other.ixIsEmpty() || this.last() < other.ixFirstKey() || other.ixLastKey() < this.first()) {
            return OrderedLongSet.EMPTY;
        }
        if (other instanceof SingleRange) {
            return refSupplier.get().ixRetainRange(other.ixFirstKey(), other.ixLastKey());
        }
        if (other instanceof SortedRanges) {
            SortedRanges sr = (SortedRanges)other;
            OrderedLongSet ans = sr.intersectOnNew(this);
            return ans != null ? ans : RspBitmap.retainImpl(sr.toRsp(), refSupplier);
        }
        RspBitmap o = (RspBitmap)other;
        return RspBitmap.retainImpl(o, refSupplier);
    }

    private static OrderedLongSet retainImpl(RspBitmap other, Supplier<RspBitmap> refSupplier) {
        RspBitmap ans = refSupplier.get();
        ans.andEqualsUnsafeNoWriteCheck(other);
        if (ans.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        ans.finishMutations();
        return ans;
    }

    @Override
    public OrderedLongSet ixRetainRange(long start, long end) {
        if (this.ixIsEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        long myFirstKey = this.ixFirstKey();
        long myLastKey = this.ixLastKey();
        if (myLastKey < start || end < myFirstKey) {
            return OrderedLongSet.EMPTY;
        }
        boolean mayHaveChanged = false;
        RspBitmap ans = this;
        if (end < myLastKey) {
            mayHaveChanged = true;
            ans = ans.removeRangeUnsafe(end + 1L, myLastKey);
        }
        if (myFirstKey < start) {
            if (!mayHaveChanged) {
                mayHaveChanged = true;
                ans = ans.removeRangeUnsafe(myFirstKey, start - 1L);
            } else {
                ans.removeRangeUnsafeNoWriteCheck(myFirstKey, start - 1L);
            }
        }
        if (mayHaveChanged) {
            if (ans.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            ans.finishMutations();
            return ans;
        }
        return this;
    }

    public OrderedLongSet ixRetainRangeNoWriteCheck(long start, long end) {
        boolean mayHaveChanged = false;
        if (end < this.ixLastKey()) {
            mayHaveChanged = true;
            this.removeRangeUnsafeNoWriteCheck(end + 1L, this.ixLastKey());
        }
        if (this.ixFirstKey() < start) {
            mayHaveChanged = true;
            this.removeRangeUnsafeNoWriteCheck(this.ixFirstKey(), start - 1L);
        }
        if (mayHaveChanged) {
            if (this.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            this.finishMutations();
        }
        return this;
    }

    @Override
    public OrderedLongSet ixRemoveRange(long startKey, long endKey) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        RspBitmap rb = this.removeRangeUnsafe(startKey, endKey);
        if (rb.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        rb.finishMutations();
        return rb;
    }

    @Override
    public OrderedLongSet ixIntersectOnNew(OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (other instanceof SingleRange) {
            return this.ixSubindexByKeyOnNew(other.ixFirstKey(), other.ixLastKey());
        }
        if (other instanceof SortedRanges) {
            SortedRanges sr = (SortedRanges)other;
            return sr.intersectOnNew(this);
        }
        return RspBitmap.and(this, (RspBitmap)other);
    }

    @Override
    public boolean ixContainsRange(long start, long end) {
        return this.containsRange(start, end);
    }

    @Override
    public boolean ixOverlaps(OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return false;
        }
        if (other instanceof SingleRange) {
            return this.overlapsRange(other.ixFirstKey(), other.ixLastKey());
        }
        if (other instanceof SortedRanges) {
            SortedRanges sr = (SortedRanges)other;
            return sr.overlaps(this.ixRangeIterator());
        }
        RspBitmap o = (RspBitmap)other;
        return this.overlaps(o);
    }

    @Override
    public boolean ixOverlapsRange(long start, long end) {
        return this.overlapsRange(start, end);
    }

    public boolean subsetOf(SortedRanges sr) {
        if (this.isEmpty()) {
            return true;
        }
        if (sr.isEmpty()) {
            return false;
        }
        if (this.first() < sr.first() || sr.last() < this.last()) {
            return false;
        }
        long pendingLast = -1L;
        RowSet.RangeIterator it = sr.getRangeIterator();
        int i = 0;
        while (it.hasNext()) {
            it.next();
            long start = it.currentRangeStart();
            if (pendingLast != -1L) {
                if ((i = this.overlapsRange(i, pendingLast + 1L, start - 1L)) >= 0) {
                    return false;
                }
                i ^= 0xFFFFFFFF;
            }
            pendingLast = it.currentRangeEnd();
        }
        return true;
    }

    @Override
    public boolean ixSubsetOf(OrderedLongSet other) {
        if (this.ixIsEmpty()) {
            return true;
        }
        if (other.ixIsEmpty()) {
            return false;
        }
        if (other instanceof SingleRange) {
            return other.ixFirstKey() <= this.ixFirstKey() && this.ixLastKey() <= other.ixLastKey();
        }
        if (other instanceof SortedRanges) {
            return this.subsetOf((SortedRanges)other);
        }
        return this.subsetOf((RspBitmap)other);
    }

    @Override
    public OrderedLongSet ixMinusOnNew(OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return (OrderedLongSet)this.cowRef();
        }
        if (other instanceof SingleRange) {
            if (other.ixFirstKey() <= this.ixFirstKey() && this.ixLastKey() <= other.ixLastKey()) {
                return OrderedLongSet.EMPTY;
            }
            RspBitmap ans = this.deepCopy();
            ans.removeRangeUnsafeNoWriteCheck(other.ixFirstKey(), other.ixLastKey());
            ans.finishMutations();
            return ans;
        }
        if (other instanceof SortedRanges) {
            RspBitmap ans = this.deepCopy();
            SortedRanges sr = (SortedRanges)other;
            ans.removeRangesUnsafeNoWriteCheck(sr.getRangeIterator());
            ans.finishMutations();
            return ans;
        }
        return RspBitmap.andNot(this, (RspBitmap)other);
    }

    @Override
    public OrderedLongSet ixUnionOnNew(OrderedLongSet other) {
        if (this.isEmpty()) {
            return other.ixCowRef();
        }
        if (other.ixIsEmpty()) {
            return (OrderedLongSet)this.cowRef();
        }
        if (other instanceof SingleRange) {
            if (other.ixFirstKey() <= this.ixFirstKey() && this.ixLastKey() <= other.ixLastKey()) {
                return other.ixCowRef();
            }
            RspBitmap b = this.deepCopy();
            b.addRangeUnsafeNoWriteCheck(0, other.ixFirstKey(), other.ixLastKey());
            b.finishMutations();
            return b;
        }
        if (other instanceof SortedRanges) {
            return other.ixUnionOnNew(this);
        }
        return RspBitmap.or(this, (RspBitmap)other);
    }

    @Override
    public RspBitmap ixShiftOnNew(long shiftAmount) {
        return this.applyOffsetOnNew(shiftAmount);
    }

    @Override
    public RspBitmap ixShiftInPlace(long shiftAmount) {
        return this.applyOffset(shiftAmount);
    }

    public OrderedLongSet ixInsertWithShift(long shiftAmount, SortedRanges sr) {
        RspBitmap ans = (RspBitmap)this.getWriteRef();
        int i = 0;
        try (RowSet.RangeIterator rit = sr.getRangeIterator();){
            while (rit.hasNext()) {
                rit.next();
                long start = rit.currentRangeStart() + shiftAmount;
                long end = rit.currentRangeEnd() + shiftAmount;
                i = ans.addRangeUnsafeNoWriteCheck(i, start, end);
            }
        }
        ans.finishMutations();
        return ans;
    }

    @Override
    public OrderedLongSet ixInsertWithShift(long shiftAmount, OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return other.ixShiftOnNew(shiftAmount);
        }
        if (other instanceof SingleRange) {
            return this.addRange(other.ixFirstKey() + shiftAmount, other.ixLastKey() + shiftAmount);
        }
        if (other instanceof SortedRanges) {
            return this.ixInsertWithShift(shiftAmount, (SortedRanges)other);
        }
        if ((shiftAmount & 0xFFFFL) != 0L) {
            RspBitmap rspOther = (RspBitmap)other;
            rspOther = rspOther.applyOffsetOnNew(shiftAmount);
            RspBitmap ans = (RspBitmap)this.getWriteRef();
            ans.insertOrderedLongSetUnsafeNoWriteCheck(rspOther);
            ans.finishMutations();
            return ans;
        }
        return this.orEqualsShifted(shiftAmount, (RspBitmap)other);
    }

    @Override
    public RowSet.SearchIterator ixSearchIterator() {
        return new SearchIteratorImpl(this);
    }

    @Override
    public RowSet.Iterator ixIterator() {
        return new IteratorImpl(this);
    }

    @Override
    public RowSet.SearchIterator ixReverseIterator() {
        return new RowSet.SearchIterator(){
            final RspReverseIterator it;
            {
                this.it = RspBitmap.this.getReverseIterator();
            }

            public void close() {
                this.it.release();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public long currentValue() {
                return this.it.current();
            }

            @Override
            public long nextLong() {
                this.it.next();
                return this.it.current();
            }

            @Override
            public boolean advance(long v) {
                return this.it.advance(v);
            }

            @Override
            public long binarySearchValue(RowSet.TargetComparator targetComparator, int direction) {
                throw new UnsupportedOperationException("Reverse iterator does not support binary search.");
            }
        };
    }

    @Override
    public RowSet.RangeIterator ixRangeIterator() {
        return new RowSet.RangeIterator(){
            final RspRangeIterator it;
            {
                this.it = RspBitmap.this.getRangeIterator();
            }

            @Override
            public void close() {
                this.it.close();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public boolean advance(long v) {
                return this.it.advance(v);
            }

            @Override
            public void postpone(long v) {
                this.it.postpone(v);
            }

            @Override
            public long currentRangeStart() {
                return this.it.start();
            }

            @Override
            public long currentRangeEnd() {
                return this.it.end();
            }

            @Override
            public long next() {
                this.it.next();
                return this.it.start();
            }
        };
    }

    @Override
    public OrderedLongSet ixCompact() {
        OrderedLongSet timpl = this.tryCompact();
        if (timpl != null) {
            return timpl;
        }
        return this;
    }

    @Override
    public void ixValidate(String failMsg) {
        this.validate(failMsg);
    }

    @Override
    public RowSequence ixGetRowSequenceByPosition(long startPositionInclusive, long length) {
        return this.getRowSequenceByPosition(startPositionInclusive, length);
    }

    @Override
    public RowSequence ixGetRowSequenceByKeyRange(long startKeyInclusive, long endKeyInclusive) {
        return this.getRowSequenceByKeyRange(startKeyInclusive, endKeyInclusive);
    }

    @Override
    public RowSequence.Iterator ixGetRowSequenceIterator() {
        return this.getRowSequenceIterator();
    }

    @Override
    public long ixRangesCountUpperBound() {
        return this.rangesCountUpperBound();
    }

    @Override
    public long ixGetAverageRunLengthEstimate() {
        return this.getAverageRunLengthEstimate();
    }

    @Override
    public RspBitmap ixToRspOnNew() {
        return (RspBitmap)this.cowRef();
    }

    @Override
    public String toString() {
        return this.valuesToString();
    }

    public static class BuilderRandom
    implements OrderedLongSet.BuilderRandom {
        public RspBitmap rb;
        public RowSetCounts rowSetCounts;

        public BuilderRandom(RowSetCounts rowSetCounts, long start, long end) {
            this.rb = new RspBitmap(start, end);
            this.rowSetCounts = rowSetCounts;
        }

        public BuilderRandom(RowSetCounts rowSetCounts) {
            this.rb = new RspBitmap();
            this.rowSetCounts = rowSetCounts;
        }

        @Override
        public RspBitmap getOrderedLongSet() {
            RspBitmap ans = this.rb;
            this.rb = null;
            ans.tryCompactUnsafe(4);
            ans.finishMutationsAndOptimize();
            this.rowSetCounts.sampleRsp(ans);
            return ans;
        }

        @Override
        public void addKey(long key) {
            this.rb.addUnsafeNoWriteCheck(key);
        }

        @Override
        public void addRange(long start, long endInclusive) {
            this.rb.addRangeUnsafeNoWriteCheck(start, endInclusive);
        }

        @Override
        public void appendKey(long key) {
            this.rb.appendUnsafeNoWriteCheck(key);
        }

        @Override
        public void appendRange(long start, long endInclusive) {
            this.rb.appendRangeUnsafeNoWriteCheck(start, endInclusive);
        }

        @Override
        public void add(SortedRanges ix, boolean acquire) {
            this.rb.insertOrderedLongSetUnsafeNoWriteCheck(ix);
        }

        @Override
        public void add(RspBitmap ix, boolean acquire) {
            this.rb.insertOrderedLongSetUnsafeNoWriteCheck(ix);
        }
    }

    private static class IteratorImpl
    implements RowSet.Iterator {
        private final RspIterator it;

        public IteratorImpl(RspBitmap rb) {
            this.it = rb.getIterator();
        }

        public void close() {
            this.it.release();
        }

        @Override
        public boolean forEachLong(LongAbortableConsumer lc) {
            return this.it.forEachLong(lc);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public long nextLong() {
            return this.it.nextLong();
        }
    }

    private static class SearchIteratorImpl
    implements RowSet.SearchIterator {
        private final RspRangeIterator it;
        private long curr = 0L;
        private long next = 0L;
        private long currRangeEnd = -1L;

        public SearchIteratorImpl(RspBitmap rb) {
            this.it = rb.getRangeIterator();
        }

        public void close() {
            this.it.close();
        }

        @Override
        public boolean hasNext() {
            if (this.next <= this.currRangeEnd) {
                return true;
            }
            return this.it.hasNext();
        }

        @Override
        public long currentValue() {
            return this.curr;
        }

        @Override
        public long nextLong() {
            if (this.next <= this.currRangeEnd) {
                this.curr = this.next++;
            } else {
                this.it.next();
                this.curr = this.it.start();
                this.next = this.curr + 1L;
                this.currRangeEnd = this.it.end();
            }
            return this.curr;
        }

        @Override
        public boolean advance(long v) {
            if (this.currRangeEnd == -1L) {
                if (!this.it.hasNext()) {
                    return false;
                }
                this.it.next();
                this.curr = this.it.start();
                this.next = this.curr + 1L;
                this.currRangeEnd = this.it.end();
            }
            if (v <= this.currRangeEnd) {
                if (v > this.curr) {
                    this.curr = v;
                    this.next = this.curr + 1L;
                }
                return true;
            }
            if (this.it.advance(v)) {
                this.curr = v < this.it.start() ? this.it.start() : v;
                this.currRangeEnd = this.it.end();
                this.next = this.curr + 1L;
                return true;
            }
            this.next = 0L;
            this.currRangeEnd = -1L;
            return false;
        }

        @Override
        public long binarySearchValue(RowSet.TargetComparator tc, int dir) {
            RowSetUtils.Comparator comp;
            int c;
            if (this.currRangeEnd == -1L) {
                if (!this.it.hasNext()) {
                    return -1L;
                }
                this.it.next();
                this.curr = this.next = this.it.start();
                this.currRangeEnd = this.it.end();
            }
            if ((c = (comp = k -> tc.compareTargetTo(k, dir)).directionToTargetFrom(this.curr)) < 0) {
                return -1L;
            }
            this.it.search(comp);
            this.curr = this.it.start();
            this.next = this.curr + 1L;
            this.currRangeEnd = this.it.end();
            return this.curr;
        }
    }

    private static final class AddCtx {
        long key;
        int index;
        Container c;

        private AddCtx() {
        }
    }
}

