/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerShortBatchIterator;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import java.util.PrimitiveIterator;

public class RspIterator
implements PrimitiveIterator.OfLong,
SafeCloseable {
    private RspArray.SpanCursorForward p;
    private SingleSpanIterator sit;
    private RspArray.SpanView sitView;
    private static final int BUFSZ = Configuration.getInstance().getIntegerForClassWithDefault(RspIterator.class, "bufferSize", 122);
    private boolean hasNext;

    RspIterator(RspArray.SpanCursorForward p, long firstSpanSkipCount) {
        if (!p.hasNext()) {
            p.release();
            this.p = null;
            this.hasNext = false;
            return;
        }
        this.sitView = new RspArray.SpanView(null);
        this.p = p;
        this.nextSingleSpanIterator(firstSpanSkipCount);
        this.hasNext = true;
    }

    public RspIterator(RspArray.SpanCursorForward p) {
        this(p, 0L);
    }

    public void release() {
        if (this.sitView != null) {
            this.sitView.close();
        }
        if (this.p == null) {
            return;
        }
        this.p.release();
        this.p = null;
    }

    public void close() {
        this.release();
    }

    public boolean forEachLong(LongAbortableConsumer lc) {
        while (this.hasNext) {
            if (!this.sit.hasNext()) {
                this.nextSingleSpanIterator(0L);
            }
            boolean wantMore = this.sit.forEachLong(lc);
            boolean bl = this.hasNext = this.sit.hasNext() || this.p.hasNext();
            if (wantMore) continue;
            return false;
        }
        return true;
    }

    public int copyTo(long[] vs, int offset, int max) {
        int c = 0;
        while (this.hasNext) {
            if (!this.sit.hasNext()) {
                this.nextSingleSpanIterator(0L);
            }
            c += this.sit.copyTo(vs, offset + c, max - c);
            boolean bl = this.hasNext = this.sit.hasNext() || this.p.hasNext();
            if (c < max) continue;
            break;
        }
        return c;
    }

    public int copyTo(WritableLongChunk<? super OrderedRowKeys> chunk, int offset, int max) {
        int c = 0;
        while (this.hasNext) {
            if (!this.sit.hasNext()) {
                this.nextSingleSpanIterator(0L);
            }
            c += this.sit.copyTo(chunk, offset + c, max - c);
            boolean bl = this.hasNext = this.sit.hasNext() || this.p.hasNext();
            if (c < max) continue;
            break;
        }
        return c;
    }

    private void nextSingleSpanIterator(final long skipCount) {
        Assert.neqNull((Object)this.p, (String)"p");
        this.p.next();
        long spanInfo = this.p.spanInfo();
        Object s = this.p.span();
        if (RspArray.isSingletonSpan(s)) {
            if (skipCount != 0L) {
                throw new IllegalArgumentException("skipCount=" + skipCount + " and next span is single element");
            }
            final long singletonValue = RspArray.spanInfoToSingletonSpanValue(spanInfo);
            this.sitView.reset();
            this.sit = new SingleSpanIterator(){
                long v;
                {
                    this.v = singletonValue;
                }

                @Override
                public long nextLong() {
                    long ret = this.v;
                    this.v = -1L;
                    return ret;
                }

                @Override
                public boolean hasNext() {
                    return this.v != -1L;
                }

                @Override
                public boolean forEachLong(LongAbortableConsumer lc) {
                    if (this.v == -1L) {
                        return true;
                    }
                    long ret = this.v;
                    this.v = -1L;
                    return lc.accept(ret);
                }

                @Override
                public int copyTo(long[] vs, int offset, int max) {
                    if (max <= 0 || this.v == -1L) {
                        return 0;
                    }
                    vs[offset] = this.v;
                    this.v = -1L;
                    return 1;
                }

                @Override
                public int copyTo(WritableLongChunk<? super OrderedRowKeys> chunk, int offset, int max) {
                    if (max <= 0 || this.v == -1L) {
                        return 0;
                    }
                    chunk.set(offset, this.v);
                    this.v = -1L;
                    return 1;
                }
            };
            return;
        }
        final long flen = RspArray.getFullBlockSpanLen(spanInfo, s);
        final long k = RspArray.spanInfoToKey(spanInfo);
        if (flen > 0L) {
            this.sitView.reset();
            this.sit = new SingleSpanIterator(){
                long curr;
                final long end;
                {
                    this.curr = k + skipCount;
                    this.end = k + flen * 65536L - 1L;
                }

                @Override
                public boolean hasNext() {
                    return this.curr <= this.end;
                }

                @Override
                public long nextLong() {
                    return this.curr++;
                }

                @Override
                public boolean forEachLong(LongAbortableConsumer lc) {
                    while (this.curr <= this.end) {
                        boolean wantMore;
                        if (wantMore = lc.accept(this.curr++)) continue;
                        return false;
                    }
                    return true;
                }

                @Override
                public int copyTo(long[] vs, int offset, int max) {
                    int c = 0;
                    long last = Math.min(this.curr + (long)max - 1L, this.end);
                    while (this.curr <= last) {
                        vs[offset + c++] = this.curr++;
                    }
                    return c;
                }

                @Override
                public int copyTo(WritableLongChunk<? super OrderedRowKeys> chunk, int offset, int max) {
                    int c = 0;
                    long last = Math.min(this.curr + (long)max - 1L, this.end);
                    while (this.curr <= last) {
                        chunk.set(offset + c++, this.curr++);
                    }
                    return c;
                }
            };
            return;
        }
        this.sitView.init(this.p.arr(), this.p.arrIdx(), spanInfo, s);
        final Container c = this.sitView.getContainer();
        final int intSkipCount = (int)(Integer.MAX_VALUE & skipCount);
        this.sit = new SingleSpanIterator(){
            final ContainerShortBatchIterator cit;
            short[] buf;
            int count;
            int bi;
            {
                this.cit = c.getShortBatchIterator(intSkipCount);
                this.count = 0;
                this.bi = 0;
            }

            private long longValue(short v) {
                return k | RspArray.unsignedShortToLong(v);
            }

            @Override
            public long nextLong() {
                if (this.bi >= this.count) {
                    if (this.buf == null) {
                        this.buf = new short[BUFSZ];
                    }
                    this.count = this.cit.next(this.buf, 0, this.buf.length);
                    this.bi = 0;
                }
                return this.longValue(this.buf[this.bi++]);
            }

            @Override
            public boolean hasNext() {
                return this.bi < this.count || this.cit.hasNext();
            }

            @Override
            public boolean forEachLong(LongAbortableConsumer lc) {
                while (this.bi < this.count) {
                    boolean wantMore;
                    if (wantMore = lc.accept(this.longValue(this.buf[this.bi++]))) continue;
                    return false;
                }
                return this.cit.forEach(v -> lc.accept(this.longValue(v)));
            }

            @Override
            public int copyTo(long[] vs, int offset, int max) {
                int c2 = 0;
                while (c2 < max && this.bi < this.count) {
                    vs[offset + c2++] = this.longValue(this.buf[this.bi++]);
                }
                if (c2 < max && this.cit.hasNext()) {
                    int[] ac = new int[]{c2};
                    this.cit.forEach(v -> {
                        int n = ac[0];
                        ac[0] = n + 1;
                        vs[offset + n] = this.longValue(v);
                        return ac[0] < max;
                    });
                    return ac[0];
                }
                return c2;
            }

            @Override
            public int copyTo(WritableLongChunk<? super OrderedRowKeys> chunk, int offset, int max) {
                int c2 = 0;
                if (this.buf == null) {
                    this.buf = new short[BUFSZ];
                }
                while (true) {
                    int remaining = max - c2;
                    int limit = Math.min(this.bi + remaining, this.count);
                    while (this.bi < limit) {
                        chunk.set(offset + c2++, this.longValue(this.buf[this.bi++]));
                    }
                    if (c2 >= max || !this.cit.hasNext()) {
                        return c2;
                    }
                    this.count = this.cit.next(this.buf, 0, this.buf.length);
                    this.bi = 0;
                }
            }
        };
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public long nextLong() {
        if (!this.sit.hasNext()) {
            this.nextSingleSpanIterator(0L);
        }
        long v = this.sit.nextLong();
        boolean bl = this.hasNext = this.sit.hasNext() || this.p.hasNext();
        if (!this.hasNext) {
            this.p.release();
            this.p = null;
        }
        return v;
    }

    private static interface SingleSpanIterator {
        public boolean forEachLong(LongAbortableConsumer var1);

        public int copyTo(long[] var1, int var2, int var3);

        public int copyTo(WritableLongChunk<? super OrderedRowKeys> var1, int var2, int var3);

        public long nextLong();

        public boolean hasNext();
    }
}

