/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.container.Container;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;
import io.deephaven.util.SafeCloseable;

public class RspRangeBatchIterator
implements SafeCloseable {
    private RspArray.SpanCursorForward p;
    private SearchRangeIterator ri;
    private RspArray.SpanView riView;
    private boolean moreSpans;
    private static final int BUF_SZ = Configuration.getInstance().getIntegerForClassWithDefault(RspRangeBatchIterator.class, "shortBufSize", 64);
    private short[] buf = new short[BUF_SZ];
    private int bufOffset = 0;
    private int bufCount = 0;
    private long bufKey = -1L;
    private long pendingStartOffset = 0L;
    private long remaining;
    private static final short BLOCK_LAST_AS_SHORT = -1;

    public RspRangeBatchIterator(RspArray.SpanCursorForward p, long startOffset, long maxCount) {
        if (!p.hasNext() || maxCount <= 0L) {
            p.release();
            this.p = null;
            this.moreSpans = false;
            return;
        }
        this.riView = new RspArray.SpanView(null);
        this.p = p;
        this.remaining = maxCount;
        this.moreSpans = true;
        p.next();
        Object s = p.span();
        long spanInfo = p.spanInfo();
        long slen = RspArray.getFullBlockSpanLen(spanInfo, s);
        if (slen > 0L) {
            this.pendingStartOffset = startOffset;
            return;
        }
        if (RspArray.isSingletonSpan(s)) {
            if (startOffset != 0L) {
                throw new IllegalStateException("null span and startOffset=" + startOffset);
            }
            long singletonValue = RspArray.spanInfoToSingletonSpanValue(spanInfo);
            this.ri = Container.singleton((short)RspArray.lowBits(singletonValue)).getShortRangeIterator(0);
            this.bufKey = RspArray.spanInfoToKey(spanInfo);
            return;
        }
        this.riView.init(p.arr(), p.arrIdx(), spanInfo, s);
        this.ri = this.riView.getContainer().getShortRangeIterator((int)(Integer.MAX_VALUE & startOffset));
        this.bufKey = RspArray.spanInfoToKey(spanInfo);
        if (!this.ri.hasNext()) {
            throw new IllegalStateException("Illegal offset");
        }
    }

    public void close() {
        if (this.riView != null) {
            this.riView.close();
        }
    }

    public boolean hasNext() {
        return this.moreSpans || this.bufCount > 0;
    }

    private int flushBufToChunk(WritableLongChunk<OrderedRowKeyRanges> chunk, int chunkOffset, int chunkDelta, int chunkMaxCount) {
        int i;
        int bufDelta = Math.min(chunkMaxCount - chunkDelta, this.bufCount);
        for (i = 0; this.remaining > 0L && i < bufDelta; ++i) {
            long v1 = RspArray.unsignedShortToLong(this.buf[this.bufOffset + i]);
            chunk.set(chunkOffset + chunkDelta + i, this.bufKey | v1);
            long v2 = RspArray.unsignedShortToLong(this.buf[this.bufOffset + ++i]);
            long delta = v2 - v1 + 1L;
            if (delta > this.remaining) {
                delta = this.remaining;
                v2 = v1 + this.remaining - 1L;
            }
            chunk.set(chunkOffset + chunkDelta + i, this.bufKey | v2);
            this.remaining -= delta;
        }
        this.bufOffset += i;
        this.bufCount -= i;
        return i;
    }

    private void loadBuffer() {
        this.bufOffset = 0;
        int rangesWritten = this.ri.next(this.buf, 0, BUF_SZ / 2);
        this.bufCount = 2 * rangesWritten;
        if (!this.ri.hasNext()) {
            this.riView.reset();
            this.ri = null;
            if (!this.p.hasNext()) {
                this.moreSpans = false;
                return;
            }
            this.p.next();
        }
    }

    public int fillRangeChunk(WritableLongChunk<OrderedRowKeyRanges> chunk, int chunkOffset) {
        int chunkMaxCount = chunk.capacity();
        int chunkDelta = 0;
        long keyForPrevRangeEndAtSpanBoundary = -1L;
        if (this.bufCount > 0) {
            chunkDelta += this.flushBufToChunk(chunk, chunkOffset, chunkDelta, chunkMaxCount);
            if (this.remaining <= 0L) {
                this.setFinished();
                return chunkDelta / 2;
            }
            if (this.bufCount > 0) {
                return chunkDelta / 2;
            }
            long l = keyForPrevRangeEndAtSpanBoundary = this.buf[this.bufOffset - 1] == -1 ? this.bufKey + 65536L : -1L;
        }
        while (true) {
            if (this.ri != null) {
                if (this.bufCount == 0) {
                    this.loadBuffer();
                    if (keyForPrevRangeEndAtSpanBoundary != -1L && keyForPrevRangeEndAtSpanBoundary == this.bufKey && this.buf[0] == 0) {
                        long v = RspArray.unsignedShortToLong(this.buf[1]);
                        long delta = v + 1L;
                        if (delta >= this.remaining) {
                            v = this.remaining - 1L;
                            delta = this.remaining;
                        }
                        chunk.set(chunkOffset + chunkDelta - 1, this.bufKey | v);
                        this.remaining -= delta;
                        this.bufOffset = 2;
                        this.bufCount -= 2;
                        if (this.remaining <= 0L) {
                            this.setFinished();
                            return chunkDelta / 2;
                        }
                    }
                    keyForPrevRangeEndAtSpanBoundary = -1L;
                }
                if (chunkMaxCount - chunkDelta < 2) {
                    return chunkDelta / 2;
                }
                chunkDelta += this.flushBufToChunk(chunk, chunkOffset, chunkDelta, chunkMaxCount);
                if (this.remaining <= 0L) {
                    this.setFinished();
                    return chunkDelta / 2;
                }
                if (this.ri == null) {
                    if (this.bufCount > 0) {
                        return chunkDelta / 2;
                    }
                    keyForPrevRangeEndAtSpanBoundary = this.bufOffset > 0 && this.buf[this.bufOffset - 1] == -1 ? this.bufKey + 65536L : -1L;
                } else {
                    if (this.bufCount <= 0) continue;
                    return chunkDelta / 2;
                }
            }
            Object s = this.p.span();
            long spanInfo = this.p.spanInfo();
            long slen = RspArray.getFullBlockSpanLen(spanInfo, s);
            if (slen > 0L) {
                long d;
                long sk = RspArray.spanInfoToKey(spanInfo);
                if (keyForPrevRangeEndAtSpanBoundary != -1L && keyForPrevRangeEndAtSpanBoundary == sk) {
                    d = Math.min(this.remaining, slen * 65536L);
                    chunk.set(chunkOffset + chunkDelta - 1, sk + d - 1L);
                } else {
                    if (chunkMaxCount - chunkDelta < 2) {
                        return chunkDelta / 2;
                    }
                    long start = sk + this.pendingStartOffset;
                    chunk.set(chunkOffset + chunkDelta, start);
                    d = Math.min(this.remaining, slen * 65536L - this.pendingStartOffset);
                    this.pendingStartOffset = 0L;
                    chunk.set(chunkOffset + chunkDelta + 1, start + d - 1L);
                    chunkDelta += 2;
                }
                this.remaining -= d;
                if (this.remaining <= 0L) {
                    this.setFinished();
                    return chunkDelta / 2;
                }
                keyForPrevRangeEndAtSpanBoundary = sk + slen * 65536L;
                if (!this.p.hasNext()) {
                    this.setFinished();
                    return chunkDelta / 2;
                }
                this.p.next();
                s = this.p.span();
            }
            spanInfo = this.p.spanInfo();
            this.bufKey = RspArray.spanInfoToKey(spanInfo);
            if (RspArray.isSingletonSpan(s)) {
                long singletonValue = RspArray.spanInfoToSingletonSpanValue(spanInfo);
                short lowBitsValue = RspArray.lowBits(singletonValue);
                this.riView.reset();
                this.ri = new SingletonContainer.SearchRangeIter(lowBitsValue);
                continue;
            }
            this.riView.init(this.p.arr(), this.p.arrIdx(), spanInfo, s);
            this.ri = this.riView.getContainer().getShortRangeIterator(0);
        }
    }

    private void setFinished() {
        this.moreSpans = false;
        this.bufCount = 0;
        this.release();
    }

    public void release() {
        if (this.p == null) {
            return;
        }
        this.p.release();
        this.p = null;
    }
}

