/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.container.ContainerUtil;
import io.deephaven.engine.rowset.impl.rsp.container.SearchRangeIterator;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeIterator;

public class RspRangeIterator
implements LongRangeIterator,
SafeCloseable {
    private RspArray.SpanCursorForward p;
    private SearchRangeIterator ri;
    private RspArray.SpanView riView;
    private long start = 0L;
    private long end = -1L;
    private boolean nextValid;

    public RspRangeIterator(RspArray.SpanCursorForward p) {
        if (!p.hasNext()) {
            p.release();
            this.p = null;
            this.nextValid = false;
            return;
        }
        this.riView = new RspArray.SpanView(null);
        this.p = p;
        this.nextValid = true;
        p.next();
    }

    private void setFinished() {
        if (this.p != null) {
            this.p.release();
            this.p = null;
        }
        this.nextValid = false;
    }

    private void nextInterval() {
        boolean hasPrev = false;
        long spanInfo = this.p.spanInfo();
        long spanKey = RspArray.spanInfoToKey(spanInfo);
        while (true) {
            if (this.ri != null) {
                long kris = spanKey | (long)this.ri.start();
                int rie = this.ri.end() - 1;
                long krie = spanKey | (long)rie;
                if (hasPrev) {
                    if (this.ri.start() != 0) {
                        return;
                    }
                    this.end = krie;
                } else {
                    this.start = kris;
                    this.end = krie;
                }
                if (this.ri.hasNext()) {
                    this.ri.next();
                    return;
                }
                this.riView.reset();
                this.ri = null;
                if (!this.p.hasNext()) {
                    this.setFinished();
                    return;
                }
                this.p.next();
                if (rie != 65535) {
                    return;
                }
                hasPrev = true;
                spanInfo = this.p.spanInfo();
                spanKey = RspArray.spanInfoToKey(spanInfo);
            }
            if (hasPrev && spanKey - this.end != 1L) {
                return;
            }
            Object s = this.p.span();
            long slen = RspArray.getFullBlockSpanLen(spanInfo, s);
            if (slen > 0L) {
                if (!hasPrev) {
                    this.start = spanKey;
                    this.end = spanKey + slen * 65536L - 1L;
                } else {
                    this.end += slen * 65536L;
                }
                if (!this.p.hasNext()) {
                    this.setFinished();
                    return;
                }
                long prevSpanKey = spanKey;
                this.p.next();
                spanInfo = this.p.spanInfo();
                spanKey = RspArray.spanInfoToKey(spanInfo);
                if (prevSpanKey + slen * 65536L < spanKey) {
                    this.nextValid = true;
                    return;
                }
                hasPrev = true;
                s = this.p.span();
            }
            if (RspArray.isSingletonSpan(s)) {
                long singletonValue = RspArray.spanInfoToSingletonSpanValue(spanInfo);
                this.riView.reset();
                this.ri = new SingletonContainer.SearchRangeIter(RspArray.lowBits(singletonValue));
            } else {
                this.riView.init(this.p.arr(), this.p.arrIdx(), spanInfo, s);
                this.ri = this.riView.getContainer().getShortRangeIterator(0);
            }
            this.ri.hasNext();
            this.ri.next();
        }
    }

    private long peekNextStart() {
        long spanInfo = this.p.spanInfo();
        long spanKey = RspArray.spanInfoToKey(spanInfo);
        if (this.ri != null) {
            return spanKey | (long)this.ri.start();
        }
        Object s = this.p.span();
        if (RspArray.isSingletonSpan(s)) {
            return RspArray.spanInfoToSingletonSpanValue(spanInfo);
        }
        if (RspArray.getFullBlockSpanLen(spanInfo, s) > 0L) {
            return spanKey;
        }
        try (RspArray.SpanView res = RspArray.workDataPerThread.get().borrowSpanView(this.p.arr(), this.p.arrIdx(), spanInfo, s);){
            long l = spanKey | (long)res.getContainer().first();
            return l;
        }
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    public void postpone(long v) {
        this.start = v;
    }

    public boolean hasNext() {
        return this.nextValid;
    }

    public void next() {
        if (!this.nextValid) {
            return;
        }
        this.nextInterval();
    }

    public boolean forEachLongRange(LongRangeAbortableConsumer lrc) {
        while (this.nextValid) {
            this.nextInterval();
            if (lrc.accept(this.start, this.end)) continue;
            return false;
        }
        return true;
    }

    public boolean advance(long key) {
        if (this.end < this.start) {
            if (this.nextValid) {
                this.next();
            } else {
                return false;
            }
        }
        if (this.end >= key) {
            this.start = Math.max(key, this.start);
            return true;
        }
        if (!this.hasNext()) {
            return false;
        }
        long k = this.p.spanKey();
        if (!this.p.advance(key)) {
            this.setFinished();
            return false;
        }
        if (k != this.p.spanKey()) {
            this.riView.reset();
            this.ri = null;
        }
        this.nextInterval();
        if (this.end >= key) {
            this.start = Math.max(key, this.start);
            return true;
        }
        if (this.ri == null) {
            if (!this.hasNext()) {
                this.setFinished();
                return false;
            }
            this.next();
            return true;
        }
        int rk = (int)(key - this.p.spanKey());
        if (this.ri.advance(rk)) {
            this.nextInterval();
            this.start = Math.max(key, this.start);
            return true;
        }
        if (!this.p.hasNext()) {
            this.setFinished();
            return false;
        }
        this.p.next();
        this.riView.reset();
        this.ri = null;
        this.nextInterval();
        this.start = Math.max(key, this.start);
        return true;
    }

    public void search(RowSetUtils.Comparator comp) {
        if (!this.hasNext()) {
            this.start = RowSetUtils.rangeSearch(this.start, this.end, comp);
            return;
        }
        int c = comp.directionToTargetFrom(this.end);
        if (c <= 0) {
            if (c == 0 || this.start >= this.end) {
                this.start = this.end;
                return;
            }
            this.start = RowSetUtils.rangeSearch(this.start, this.end - 1L, comp);
            return;
        }
        long oldSpanKey = this.p.spanKey();
        this.p.search(comp);
        long targetSpanKey = this.p.spanKey();
        if (oldSpanKey != targetSpanKey) {
            this.riView.reset();
            this.ri = null;
        } else {
            long s = this.peekNextStart();
            c = comp.directionToTargetFrom(s);
            if (c < 0) {
                this.start = this.end;
                return;
            }
        }
        while (this.ri == null) {
            this.nextInterval();
            c = comp.directionToTargetFrom(this.end);
            if (c <= 0) {
                if (c == 0 || this.start >= this.end) {
                    this.start = this.end;
                    return;
                }
                this.start = RowSetUtils.rangeSearch(this.start, this.end - 1L, comp);
                return;
            }
            if (this.hasNext() && this.p.spanKey() == targetSpanKey) continue;
            this.start = this.end;
            return;
        }
        long spanKey = this.p.spanKey();
        ContainerUtil.TargetComparator rcomp = v -> comp.directionToTargetFrom(spanKey | (long)v);
        boolean found = this.ri.search(rcomp);
        if (found) {
            this.nextInterval();
            return;
        }
        this.start = RowSetUtils.rangeSearch(this.start, this.end, comp);
    }

    public void close() {
        if (this.riView != null) {
            this.riView.close();
        }
        if (this.p == null) {
            return;
        }
        this.p.release();
        this.p = null;
    }

    public RangeIteratorView rangeIteratorView(long startOffset, long rangesEnd) {
        return new RangeIteratorView(this, startOffset, rangesEnd);
    }

    public static class RangeIteratorView
    implements SearchRangeIterator {
        private RspRangeIterator it;
        private final long offset;
        private final long rangesEnd;
        private int start;
        private int end;
        private int nextStart;
        private int nextEnd;
        private boolean nextValid;
        private boolean noMore;
        private boolean itFinished;

        public RangeIteratorView(RspRangeIterator it, long offset, long rangesEnd) {
            this.it = it;
            this.offset = offset;
            this.rangesEnd = rangesEnd;
            if (it.start() < offset) {
                this.nextValid = false;
                return;
            }
            this.noMore = false;
            this.itFinished = false;
            this.computeNext();
        }

        private void setTerminated() {
            this.it = null;
            this.nextValid = false;
        }

        private void computeNext() {
            if (this.noMore || this.it.start() >= this.rangesEnd) {
                this.setTerminated();
                return;
            }
            this.nextValid = true;
            this.nextStart = (int)(this.it.start() - this.offset);
            if (this.it.end() >= this.rangesEnd) {
                this.nextEnd = (int)(this.rangesEnd - this.offset);
                this.it.postpone(this.rangesEnd);
                this.noMore = true;
                return;
            }
            this.nextEnd = (int)(this.it.end() - this.offset) + 1;
            if (this.it.hasNext()) {
                this.it.next();
                this.noMore = false;
                return;
            }
            this.itFinished = true;
            this.noMore = true;
        }

        public boolean hasNext() {
            return this.nextValid;
        }

        public int start() {
            return this.start;
        }

        public int end() {
            return this.end;
        }

        public void next() {
            this.start = this.nextStart;
            this.end = this.nextEnd;
            this.computeNext();
        }

        public boolean advance(int v) {
            throw new UnsupportedOperationException("advance is not supported on RangeIteratorView");
        }

        public boolean search(ContainerUtil.TargetComparator comp) {
            throw new UnsupportedOperationException("search is not supported on RangeIteratorView");
        }

        public boolean underlyingIterFinished() {
            return this.itFinished;
        }
    }
}

