/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.container.ShortAdvanceIterator;
import io.deephaven.engine.rowset.impl.rsp.container.SingletonContainer;
import io.deephaven.util.SafeCloseable;

public class RspReverseIterator
implements SafeCloseable {
    private RspArray.SpanCursor rp;
    private ShortAdvanceIterator ri;
    private RspArray.SpanView riView;
    long current = -1L;
    long next;
    boolean nextValid;
    long fullBlockSpanKey = -1L;

    public RspReverseIterator(RspArray.SpanCursor rp) {
        this.rp = rp;
        if (!rp.hasNext()) {
            this.setEnded();
            return;
        }
        this.riView = new RspArray.SpanView(null);
        rp.next();
        this.computeNext();
    }

    private void setEnded() {
        this.nextValid = false;
        this.release();
    }

    private void computeNext() {
        if (this.nextValid && this.fullBlockSpanKey != -1L) {
            this.computeNextFromFullSpan();
            return;
        }
        if (this.ri != null) {
            if (this.ri.hasNext()) {
                long k = this.rp.spanKey();
                this.next = RspArray.unsignedShortToLong(this.ri.next()) | k;
                this.nextValid = true;
                return;
            }
            this.riView.reset();
            this.ri = null;
            if (!this.rp.hasNext()) {
                this.setEnded();
                return;
            }
            this.rp.next();
        }
        this.updateNextFromSpanCursor();
    }

    private void updateNextFromSpanCursor() {
        long spanInfo = this.rp.spanInfo();
        long k = RspArray.spanInfoToKey(spanInfo);
        Object s = this.rp.span();
        long flen = RspArray.getFullBlockSpanLen(spanInfo, s);
        if (flen > 0L) {
            this.next = k + 65536L * flen - 1L;
            this.fullBlockSpanKey = k;
            this.nextValid = true;
            return;
        }
        if (RspArray.isSingletonSpan(s)) {
            this.riView.reset();
            long singletonValue = RspArray.spanInfoToSingletonSpanValue(spanInfo);
            this.ri = new SingletonContainer.ReverseIter(RspArray.lowBits(singletonValue));
        } else {
            this.riView.init(this.rp.arr(), this.rp.arrIdx(), spanInfo, s);
            this.ri = this.riView.getContainer().getReverseShortIterator();
        }
        this.nextValid = true;
        this.next = RspArray.unsignedShortToLong(this.ri.next()) | k;
        this.fullBlockSpanKey = -1L;
    }

    private void computeNextFromFullSpan() {
        --this.next;
        if (Long.compareUnsigned(this.next, this.fullBlockSpanKey) >= 0) {
            this.nextValid = true;
            return;
        }
        this.fullBlockSpanKey = -1L;
        if (!this.rp.hasNext()) {
            this.setEnded();
            return;
        }
        this.rp.next();
        this.updateNextFromSpanCursor();
    }

    public long current() {
        return this.current;
    }

    public boolean hasNext() {
        return this.nextValid;
    }

    public void next() {
        if (!this.nextValid) {
            return;
        }
        this.current = this.next;
        this.computeNext();
    }

    private void setAdvanceOverranState() {
        Object span = this.rp.span();
        long spanInfo = this.rp.spanInfo();
        if (RspArray.isSingletonSpan(span)) {
            this.current = RspArray.spanInfoToSingletonSpanValue(spanInfo);
            return;
        }
        long flen = RspArray.getFullBlockSpanLen(spanInfo, span);
        long key = RspArray.spanInfoToKey(spanInfo);
        if (flen > 0L) {
            this.current = key;
        } else {
            try (RspArray.SpanView res = RspArray.workDataPerThread.get().borrowSpanView(this.rp.arr(), this.rp.arrIdx(), spanInfo, span);){
                this.current = key | (long)res.getContainer().first();
            }
        }
    }

    private boolean tryCurrentSpanForAdvance(long v) {
        long kb = this.rp.spanKey();
        if (v < kb) {
            return false;
        }
        if (this.ri == null) {
            this.current = this.next = v;
            this.next();
            return true;
        }
        if (this.ri.advance((int)(0xFFFFL & v))) {
            this.current = kb | (long)this.ri.currAsInt();
            this.nextValid = false;
            this.computeNext();
            return true;
        }
        this.riView.reset();
        this.ri = null;
        if (!this.rp.hasNext()) {
            this.setAdvanceOverranState();
            this.setEnded();
            return false;
        }
        this.rp.next();
        this.nextValid = false;
        this.computeNext();
        this.current = this.next;
        this.computeNext();
        return true;
    }

    public boolean advance(long v) {
        if (!this.nextValid) {
            return this.current != -1L && this.current <= v;
        }
        if (this.current < 0L) {
            this.next();
            if (!this.nextValid) {
                return this.current <= v;
            }
        }
        if (this.current <= v) {
            return true;
        }
        if (this.next <= v) {
            this.next();
            return true;
        }
        if (this.tryCurrentSpanForAdvance(v)) {
            return true;
        }
        if (this.rp == null) {
            return false;
        }
        this.riView.reset();
        this.ri = null;
        this.nextValid = false;
        boolean valid = this.rp.advance(v);
        if (!valid) {
            this.setAdvanceOverranState();
            this.setEnded();
            return false;
        }
        this.computeNext();
        if (this.next <= v) {
            this.next();
            return true;
        }
        return this.tryCurrentSpanForAdvance(v);
    }

    public void release() {
        if (this.riView != null) {
            this.riView.close();
        }
        this.ri = null;
        if (this.rp != null) {
            this.rp.release();
        }
        this.rp = null;
    }

    public void close() {
        this.release();
    }
}

