/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.rsp;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowSequenceAsChunkImpl;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.rowset.impl.rsp.RspArray;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.rsp.RspIterator;
import io.deephaven.engine.rowset.impl.rsp.RspRangeBatchIterator;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import org.apache.commons.lang3.mutable.MutableLong;

public class RspRowSequence
extends RowSequenceAsChunkImpl {
    private RspArray arr;
    private long firstKey;
    private long lastKey;
    private int startIdx;
    private int endIdx;
    private long startOffset;
    private long endOffset;
    private long cardBeforeStartIdx;
    private long cardBeforeEndIdx;

    private static RspArray wrapRspArray(RspArray arr) {
        return arr;
    }

    RspRowSequence(RspArray arr, int startIdx, long startOffset, long cardBeforeStartIdx, int endIdx, long endOffset, long cardBeforeEndIdx) {
        if (RspArray.debug && (endIdx < startIdx || endIdx == startIdx && endOffset < startOffset)) {
            throw new IllegalArgumentException("Empty " + RspRowSequence.class.getSimpleName() + " :startIdx=" + startIdx + ", startOffset=" + startOffset + ", endIdx=" + endIdx + ", endOffset=" + endOffset);
        }
        arr.acquire();
        this.arr = RspRowSequence.wrapRspArray(arr);
        this.startIdx = startIdx;
        this.endIdx = endIdx;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.cardBeforeStartIdx = cardBeforeStartIdx;
        this.cardBeforeEndIdx = cardBeforeEndIdx;
        this.firstKey = -1L;
        this.lastKey = -1L;
    }

    @Override
    public void close() {
        this.closeRspRowSequence();
    }

    protected final void closeRspRowSequence() {
        if (this.arr == null) {
            return;
        }
        this.arr.release();
        this.arr = null;
        this.closeRowSequenceAsChunkImpl();
    }

    private RspRowSequence(RspArray arr) {
        this.arr = RspRowSequence.wrapRspArray(arr);
        this.startIdx = -1;
    }

    @Override
    public long firstRowKey() {
        if (this.firstKey == -1L) {
            this.firstKey = this.arr.get(this.startIdx, this.startOffset);
        }
        return this.firstKey;
    }

    @Override
    public long lastRowKey() {
        if (this.lastKey == -1L) {
            this.lastKey = this.arr.get(this.endIdx, this.endOffset);
        }
        return this.lastKey;
    }

    @Override
    public long getAverageRunLengthEstimate() {
        long sz = this.size();
        if (sz < 32L) {
            return 1L;
        }
        long estimate = this.arr.getAverageRunLengthEstimate(this.startIdx, this.endIdx);
        if (estimate > sz) {
            return Math.max(sz / 2L, 1L);
        }
        return estimate;
    }

    @Override
    public long rangesCountUpperBound() {
        return this.arr.rangesCountUpperBound(this.startIdx, this.endIdx);
    }

    public RspRowSequence copy(RspRowSequence other) {
        return new RspRowSequence(other.arr, other.startIdx, other.startOffset, other.cardBeforeStartIdx, other.endIdx, other.endOffset, other.cardBeforeEndIdx);
    }

    private void reset(int startIdx, long startOffset, long cardBeforeStartIdx, int endIdx, long endOffset, long cardBeforeEndIdx, long firstKey) {
        this.startIdx = startIdx;
        this.endIdx = endIdx;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.cardBeforeStartIdx = cardBeforeStartIdx;
        this.cardBeforeEndIdx = cardBeforeEndIdx;
        this.firstKey = firstKey;
        this.closeRowSequenceAsChunkImpl();
        this.lastKey = -1L;
    }

    @Override
    public Iterator getRowSequenceIterator() {
        return new Iterator(this);
    }

    @Override
    public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        long absoluteStart = startPositionInclusive + this.absoluteStartPos();
        if (absoluteStart > this.absoluteEndPos()) {
            return RowSequenceFactory.EMPTY;
        }
        long sizeLeftFromStart = this.size() - startPositionInclusive;
        return this.arr.getRowSequenceByPosition(absoluteStart, Math.min(sizeLeftFromStart, length));
    }

    @Override
    public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        return this.arr.getRowSequenceByKeyRangeConstrainedToIndexAndOffsetRange(startRowKeyInclusive, endRowKeyInclusive, this.startIdx, this.startOffset, this.cardBeforeStartIdx, this.endIdx, this.endOffset);
    }

    @Override
    public RowSet asRowSet() {
        RspBitmap newArr = new RspBitmap(this.arr, this.startIdx, this.startOffset, this.endIdx, this.endOffset);
        return new WritableRowSetImpl(newArr);
    }

    @Override
    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        RspIterator it = new RspIterator(new RspArray.SpanCursorForwardImpl(this.arr, this.startIdx), this.startOffset);
        int n = it.copyTo(chunkToFill, 0, this.intSize());
        chunkToFill.setSize(n);
    }

    @Override
    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        chunkToFill.setSize(0);
        RspRangeBatchIterator it = new RspRangeBatchIterator(new RspArray.SpanCursorForwardImpl(this.arr, this.startIdx), this.startOffset, this.size());
        int nRanges = 0;
        while (it.hasNext()) {
            int n = it.fillRangeChunk(chunkToFill, 2 * nRanges);
            nRanges += n;
        }
        chunkToFill.setSize(2 * nRanges);
    }

    private long absoluteStartPos() {
        return this.cardBeforeStartIdx + this.startOffset;
    }

    private long absoluteEndPos() {
        return this.cardBeforeEndIdx + this.endOffset;
    }

    @Override
    public long size() {
        return this.absoluteEndPos() - this.absoluteStartPos() + 1L;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean forEachRowKey(LongAbortableConsumer lac) {
        if (this.startIdx == this.endIdx) {
            return this.arr.forEachLongInSpanWithOffsetAndMaxCount(this.startIdx, this.startOffset, lac, this.size());
        }
        if (!this.arr.forEachLongInSpanWithOffset(this.startIdx, this.startOffset, lac)) {
            return false;
        }
        for (int i = this.startIdx + 1; i <= this.endIdx - 1; ++i) {
            if (this.arr.forEachLongInSpan(i, lac)) continue;
            return false;
        }
        return this.arr.forEachLongInSpanWithMaxCount(this.endIdx, lac, this.endOffset + 1L);
    }

    @Override
    public boolean forEachRowKeyRange(LongRangeAbortableConsumer lrac) {
        if (this.startIdx == this.endIdx) {
            long remaining = this.endOffset - this.startOffset + 1L;
            return this.arr.forEachLongRangeInSpanWithOffsetAndMaxCardinality(this.startIdx, this.startOffset, remaining, lrac);
        }
        long[] pendingRange = new long[2];
        LongRangeAbortableConsumer wrapper = RspArray.makeAdjacentRangesCollapsingWrapper(pendingRange, lrac);
        if (!this.arr.forEachLongRangeInSpanWithOffset(this.startIdx, this.startOffset, wrapper)) {
            return false;
        }
        for (int i = this.startIdx + 1; i < this.endIdx; ++i) {
            if (this.arr.forEachLongRangeInSpanWithOffset(i, 0L, wrapper)) continue;
            return false;
        }
        long remaining = this.endOffset + 1L;
        if (!this.arr.forEachLongRangeInSpanWithOffsetAndMaxCardinality(this.endIdx, 0L, remaining, wrapper)) {
            return false;
        }
        if (pendingRange[0] != -2L) {
            return lrac.accept(pendingRange[0], pendingRange[1]);
        }
        return true;
    }

    static class Iterator
    implements RowSequence.Iterator {
        private RspArray arr;
        private final RspRowSequence currBuf;
        private int currStartIdx;
        private int currEndIdx;
        private long currStartOffset;
        private long currEndOffset;
        private long currCardBeforeStartIdx;
        private long currCardBeforeEndIdx;
        private long sizeLeft;
        private final int rsEndIdx;
        private final long rsEndOffset;
        private long nextKey;

        public Iterator(RspRowSequence rs) {
            rs.arr.acquire();
            this.arr = rs.arr;
            this.sizeLeft = rs.size();
            this.currStartIdx = rs.startIdx;
            this.currStartOffset = rs.startOffset;
            this.currCardBeforeStartIdx = rs.cardBeforeStartIdx;
            this.rsEndIdx = rs.endIdx;
            this.rsEndOffset = rs.endOffset;
            this.currEndIdx = -1;
            this.currEndOffset = -1L;
            this.currCardBeforeEndIdx = -1L;
            this.currBuf = new RSWrapper(this.arr);
            this.nextKey = -1L;
        }

        @Override
        public void close() {
            this.currBuf.closeRowSequenceAsChunkImpl();
            if (this.arr == null) {
                return;
            }
            this.arr.release();
            this.arr = null;
        }

        @Override
        public boolean hasMore() {
            return this.sizeLeft > 0L;
        }

        @Override
        public long peekNextKey() {
            if (this.sizeLeft <= 0L) {
                return -1L;
            }
            if (this.nextKey == -1L) {
                long nextStartOffset;
                int nextStartIdx;
                if (this.currEndIdx == -1) {
                    nextStartIdx = this.currStartIdx;
                    nextStartOffset = this.currStartOffset;
                } else {
                    long spanCardinalityAtCurrEndIdx = this.arr.getSpanCardinalityAtIndexMaybeAcc(this.currEndIdx);
                    if (this.currEndOffset + 1L < spanCardinalityAtCurrEndIdx) {
                        nextStartIdx = this.currEndIdx;
                        nextStartOffset = this.currEndOffset + 1L;
                    } else {
                        nextStartIdx = this.currEndIdx + 1;
                        nextStartOffset = 0L;
                    }
                }
                this.nextKey = this.arr.get(nextStartIdx, nextStartOffset);
            }
            return this.nextKey;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKey) {
            if (maxKey < 0L) {
                return RowSequenceFactory.EMPTY;
            }
            long firstKey = this.nextKey;
            if (!this.updateCurrThrough(maxKey)) {
                return RowSequenceFactory.EMPTY;
            }
            this.currBuf.reset(this.currStartIdx, this.currStartOffset, this.currCardBeforeStartIdx, this.currEndIdx, this.currEndOffset, this.currCardBeforeEndIdx, firstKey);
            return this.currBuf;
        }

        private int endIndex(int fromIndex, long fromOffset, long cardBeforeIndex, long deltaNumberOfKeys, MutableLong prevCardMu) {
            long cardTarget = cardBeforeIndex + fromOffset + deltaNumberOfKeys;
            if (prevCardMu == null) {
                int j = RspArray.unsignedBinarySearch(idx -> this.arr.acc[idx], fromIndex, this.arr.size, cardTarget);
                if (j < 0 && (j = -j - 1) == this.arr.size) {
                    --j;
                }
                return j;
            }
            long prevCard = cardBeforeIndex;
            int i = fromIndex;
            while (true) {
                if (i == this.arr.size - 1) {
                    prevCardMu.setValue(prevCard);
                    return i;
                }
                long spanCard = this.arr.getSpanCardinalityAtIndex(i);
                long card = prevCard + spanCard;
                if (cardTarget <= card) {
                    prevCardMu.setValue(prevCard);
                    return i;
                }
                ++i;
                prevCard = card;
            }
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long desiredNumberOfKeys) {
            long firstKey = this.nextKey;
            long actualNumberOfKeys = this.nextRowSequenceWithLength(desiredNumberOfKeys);
            if (actualNumberOfKeys == 0L) {
                return RowSequenceFactory.EMPTY;
            }
            this.sizeLeft -= actualNumberOfKeys;
            this.currBuf.reset(this.currStartIdx, this.currStartOffset, this.currCardBeforeStartIdx, this.currEndIdx, this.currEndOffset, this.currCardBeforeEndIdx, firstKey);
            this.nextKey = -1L;
            return this.currBuf;
        }

        private long nextRowSequenceWithLength(long desiredNumberOfKeys) {
            long keysAvailableInStartSpan;
            long currStartIdxSpanCardinality;
            MutableLong prevCardMu;
            long boundedNumberOfKeys = Math.min(desiredNumberOfKeys, this.sizeLeft);
            if (boundedNumberOfKeys <= 0L) {
                return 0L;
            }
            MutableLong mutableLong = prevCardMu = this.arr.acc == null ? new MutableLong() : null;
            if (this.currEndIdx == -1) {
                this.currEndIdx = this.endIndex(this.currStartIdx, this.currStartOffset, this.currCardBeforeStartIdx, boundedNumberOfKeys, prevCardMu);
                if (this.currEndIdx == this.currStartIdx) {
                    this.currCardBeforeEndIdx = this.currCardBeforeStartIdx;
                    this.currEndOffset = this.currStartOffset + boundedNumberOfKeys - 1L;
                } else {
                    this.currCardBeforeEndIdx = prevCardMu != null ? prevCardMu.longValue() : this.arr.cardinalityBeforeWithAcc(this.currEndIdx);
                    long spanCardAtStartIdx = this.arr.getSpanCardinalityAtIndexMaybeAcc(this.currStartIdx);
                    long cardAtStartIdx = this.currCardBeforeStartIdx + spanCardAtStartIdx;
                    long firstSpanCount = spanCardAtStartIdx - this.currStartOffset;
                    long deltaCount = this.currCardBeforeEndIdx - cardAtStartIdx;
                    long remainingForEndSpan = boundedNumberOfKeys - firstSpanCount - deltaCount;
                    this.currEndOffset = remainingForEndSpan - 1L;
                }
                return boundedNumberOfKeys;
            }
            long spanCardinality = this.arr.getSpanCardinalityAtIndexMaybeAcc(this.currEndIdx);
            if (this.currEndOffset + 1L < spanCardinality) {
                this.currStartIdx = this.currEndIdx;
                this.currStartOffset = this.currEndOffset + 1L;
                this.currCardBeforeStartIdx = this.currCardBeforeEndIdx;
                currStartIdxSpanCardinality = spanCardinality;
                keysAvailableInStartSpan = spanCardinality - this.currStartOffset;
            } else {
                if (RspArray.debug) {
                    Assert.lt((int)(this.currEndIdx + 1), (String)"currEndIdx + 1", (int)this.arr.size, (String)"arr.size");
                }
                this.currStartIdx = this.currEndIdx + 1;
                this.currStartOffset = 0L;
                this.currCardBeforeStartIdx = this.currCardBeforeEndIdx + spanCardinality;
                keysAvailableInStartSpan = currStartIdxSpanCardinality = this.arr.getSpanCardinalityAtIndexMaybeAcc(this.currStartIdx);
            }
            if (keysAvailableInStartSpan >= boundedNumberOfKeys) {
                this.currEndIdx = this.currStartIdx;
                this.currEndOffset = this.currStartOffset + boundedNumberOfKeys - 1L;
                this.currCardBeforeEndIdx = this.currCardBeforeStartIdx;
                return boundedNumberOfKeys;
            }
            this.currEndIdx = this.endIndex(this.currStartIdx, this.currStartOffset, this.currCardBeforeStartIdx, boundedNumberOfKeys, prevCardMu);
            this.currCardBeforeEndIdx = prevCardMu != null ? prevCardMu.longValue() : this.arr.cardinalityBeforeWithAcc(this.currEndIdx);
            long keysBeforeLastSpan = keysAvailableInStartSpan + this.currCardBeforeEndIdx - this.currCardBeforeStartIdx - currStartIdxSpanCardinality;
            long keysLeftInLastSpan = boundedNumberOfKeys - keysBeforeLastSpan;
            if (keysLeftInLastSpan <= 0L) {
                throw new IllegalStateException("Internal error");
            }
            this.currEndOffset = keysLeftInLastSpan - 1L;
            return boundedNumberOfKeys;
        }

        @Override
        public boolean advance(long toKey) {
            boolean revert;
            if (this.sizeLeft <= 0L) {
                return false;
            }
            int savedStartIdx = this.currStartIdx;
            long savedStartOffset = this.currStartOffset;
            boolean found = this.arr.findOrNext(this.currStartIdx, this.rsEndIdx + 1, toKey, (index, offset) -> {
                this.currStartIdx = index;
                this.currStartOffset = offset;
            });
            if (!found) {
                revert = true;
            } else if (this.currEndIdx == -1) {
                revert = savedStartIdx == this.currStartIdx && this.currStartOffset < savedStartOffset;
            } else {
                boolean bl = revert = this.currEndIdx == this.currStartIdx && this.currStartOffset < this.currEndOffset;
            }
            if (revert) {
                this.currStartIdx = savedStartIdx;
                this.currStartOffset = savedStartOffset;
                return true;
            }
            long cardinalityUpAndIncludingPreviousEnd = this.currEndIdx == -1 ? this.currCardBeforeStartIdx + savedStartOffset : this.currCardBeforeEndIdx + this.currEndOffset + 1L;
            this.currCardBeforeStartIdx = this.arr.cardinalityBeforeMaybeAcc(this.currStartIdx, savedStartIdx, this.currCardBeforeStartIdx);
            this.currEndIdx = -1;
            this.currEndOffset = -1L;
            this.currCardBeforeEndIdx = -1L;
            long cardinalityBeforeStart = this.currCardBeforeStartIdx + this.currStartOffset;
            this.sizeLeft -= cardinalityBeforeStart - cardinalityUpAndIncludingPreviousEnd;
            if (this.sizeLeft <= 0L) {
                this.sizeLeft = 0L;
                this.nextKey = -1L;
                return false;
            }
            this.nextKey = -1L;
            return true;
        }

        private boolean updateCurrThrough(long toKey) {
            boolean found;
            if (this.sizeLeft <= 0L) {
                return false;
            }
            int savedEndIdx = this.currEndIdx;
            long savedEndOffset = this.currEndOffset;
            int savedStartIdx = this.currStartIdx;
            long savedStartOffset = this.currStartOffset;
            if (this.currEndIdx != -1) {
                long spanCardinality = this.arr.getSpanCardinalityAtIndexMaybeAcc(this.currEndIdx);
                if (this.currEndOffset + 1L < spanCardinality) {
                    this.currStartIdx = this.currEndIdx;
                    this.currStartOffset = this.currEndOffset + 1L;
                } else {
                    if (RspArray.debug) {
                        Assert.lt((int)(this.currEndIdx + 1), (String)"currEndIdx + 1", (int)this.arr.size, (String)"arr.size");
                    }
                    this.currStartIdx = this.currEndIdx + 1;
                    this.currStartOffset = 0L;
                }
            }
            if (!(found = this.arr.findOrPrev(this.currStartIdx, this.rsEndIdx + 1, toKey, (index, offset) -> {
                this.currEndIdx = index;
                this.currEndOffset = offset;
            })) || this.currEndIdx == this.currStartIdx && this.currEndOffset < this.currStartOffset) {
                this.currStartIdx = savedStartIdx;
                this.currStartOffset = savedStartOffset;
                this.currEndIdx = savedEndIdx;
                this.currEndOffset = savedEndOffset;
                return false;
            }
            if (this.currEndIdx == this.rsEndIdx && this.currEndOffset > this.rsEndOffset) {
                this.currEndOffset = this.rsEndOffset;
            }
            if (savedEndIdx != -1) {
                this.currCardBeforeStartIdx = this.arr.cardinalityBeforeMaybeAcc(this.currStartIdx, savedEndIdx, this.currCardBeforeEndIdx);
            }
            this.currCardBeforeEndIdx = this.arr.cardinalityBeforeMaybeAcc(this.currEndIdx, this.currStartIdx, this.currCardBeforeStartIdx);
            long cardinalityBeforeStart = this.currCardBeforeStartIdx + this.currStartOffset;
            long cardinalityBeforeEnd = this.currCardBeforeEndIdx + this.currEndOffset;
            this.sizeLeft -= cardinalityBeforeEnd - cardinalityBeforeStart + 1L;
            this.nextKey = -1L;
            return true;
        }

        @Override
        public long getRelativePosition() {
            return -this.sizeLeft;
        }

        private static class RSWrapper
        extends RspRowSequence {
            RSWrapper(RspArray arr) {
                super(arr);
            }

            @Override
            public void close() {
                if (RspArray.debug) {
                    throw new IllegalStateException();
                }
                this.closeRowSequenceAsChunkImpl();
            }
        }
    }
}

