/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.singlerange;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.LongChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.OrderedLongSetBuilderSequential;
import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.IntStartIntDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.IntStartLongDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.LongStartIntDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.LongStartLongEndSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.ShortStartShortDeltaSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.SingleIntSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.SingleLongSingleRange;
import io.deephaven.engine.rowset.impl.singlerange.SingleRangeRowSequence;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;

public abstract class SingleRange
implements OrderedLongSet {
    private static final boolean debug = Configuration.getInstance().getBooleanForClassWithDefault(SingleRange.class, "debug", false);

    public abstract long rangeStart();

    public abstract long rangeEnd();

    public abstract long getCardinality();

    public abstract SingleRange copy();

    protected static long unsignedIntToLong(int unsignedInt) {
        return SingleRange.maxUnsignedInt() & (long)unsignedInt;
    }

    protected static long maxUnsignedInt() {
        return 0xFFFFFFFFL;
    }

    protected static int lowBitsAsUnsignedInt(long v) {
        return (int)v;
    }

    protected static long maxUnsignedShort() {
        return 65535L;
    }

    protected static long unsignedShortToLong(short unsignedShort) {
        return SingleRange.maxUnsignedShort() & (long)unsignedShort;
    }

    protected static short lowBitsAsUnsignedShort(long v) {
        return (short)v;
    }

    public static SingleRange make(long start, long end) {
        short unsignedShortDelta;
        long delta = end - start;
        if (delta == 0L) {
            int unsignedIntStart = SingleRange.lowBitsAsUnsignedInt(start);
            if (SingleRange.unsignedIntToLong(unsignedIntStart) == start) {
                return new SingleIntSingleRange(unsignedIntStart);
            }
            return new SingleLongSingleRange(start);
        }
        short unsignedShortStart = SingleRange.lowBitsAsUnsignedShort(start);
        if (SingleRange.unsignedShortToLong(unsignedShortStart) == start && SingleRange.unsignedShortToLong(unsignedShortDelta = SingleRange.lowBitsAsUnsignedShort(delta)) == delta) {
            return new ShortStartShortDeltaSingleRange(unsignedShortStart, unsignedShortDelta);
        }
        int unsignedIntStart = SingleRange.lowBitsAsUnsignedInt(start);
        int unsignedIntDelta = SingleRange.lowBitsAsUnsignedInt(delta);
        if (SingleRange.unsignedIntToLong(unsignedIntDelta) == delta) {
            if (SingleRange.unsignedIntToLong(unsignedIntStart) == start) {
                return new IntStartIntDeltaSingleRange(unsignedIntStart, unsignedIntDelta);
            }
            return new LongStartIntDeltaSingleRange(start, unsignedIntDelta);
        }
        if (SingleRange.unsignedIntToLong(unsignedIntStart) == start) {
            return new IntStartLongDeltaSingleRange(unsignedIntStart, delta);
        }
        return new LongStartLongEndSingleRange(start, end);
    }

    @Override
    public final long ixLastKey() {
        return this.rangeEnd();
    }

    @Override
    public final long ixFirstKey() {
        return this.rangeStart();
    }

    @Override
    public final long ixCardinality() {
        return this.getCardinality();
    }

    @Override
    public final boolean ixForEachLong(LongAbortableConsumer lc) {
        for (long v = this.rangeStart(); v <= this.rangeEnd(); ++v) {
            if (lc.accept(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean ixForEachLongRange(LongRangeAbortableConsumer larc) {
        return larc.accept(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final SingleRange ixCowRef() {
        return this.copy();
    }

    @Override
    public final void ixRelease() {
    }

    @Override
    public final int ixRefCount() {
        return 1;
    }

    private void ifDebugValidate() {
        if (debug) {
            this.ixValidate();
        }
    }

    @Override
    public final OrderedLongSet ixInsert(long key) {
        if (this.rangeStart() <= key && key <= this.rangeEnd()) {
            return this;
        }
        if (key + 1L < this.rangeStart()) {
            return OrderedLongSet.twoRanges(key, key, this.rangeStart(), this.rangeEnd());
        }
        if (key + 1L == this.rangeStart()) {
            return SingleRange.make(key, this.rangeEnd());
        }
        if (this.rangeEnd() + 1L == key) {
            return SingleRange.make(this.rangeStart(), key);
        }
        return OrderedLongSet.twoRanges(this.rangeStart(), this.rangeEnd(), key, key);
    }

    @Override
    public final OrderedLongSet ixInsertRange(long startKey, long endKey) {
        if (this.rangeStart() <= startKey && endKey <= this.rangeEnd()) {
            return this;
        }
        if (this.overlapsOrAdjacentToRange(startKey, endKey)) {
            return SingleRange.make(Math.min(startKey, this.rangeStart()), Math.max(endKey, this.rangeEnd()));
        }
        if (startKey < this.rangeStart()) {
            return OrderedLongSet.twoRanges(startKey, endKey, this.rangeStart(), this.rangeEnd());
        }
        return OrderedLongSet.twoRanges(this.rangeStart(), this.rangeEnd(), startKey, endKey);
    }

    @Override
    public final OrderedLongSet ixInsertSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        return OrderedLongSet.fromChunk(keys, offset, length, false).ixInsertRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final OrderedLongSet ixRemoveSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        return this.ixRemove(OrderedLongSet.fromChunk(keys, offset, length, true));
    }

    @Override
    public final OrderedLongSet ixAppendRange(long startKey, long endKey) {
        if (this.rangeEnd() + 1L < startKey) {
            return OrderedLongSet.twoRanges(this.rangeStart(), this.rangeEnd(), startKey, endKey);
        }
        if (this.rangeEnd() + 1L == startKey) {
            return SingleRange.make(this.rangeStart(), endKey);
        }
        throw new IllegalStateException("startKey(=" + startKey + ") < rangeEnd(=" + this.rangeEnd() + ")");
    }

    @Override
    public final OrderedLongSet ixRemove(long key) {
        if (key < this.rangeStart() || key > this.rangeEnd()) {
            return this;
        }
        if (key == this.rangeStart()) {
            if (this.rangeEnd() == this.rangeStart()) {
                return OrderedLongSet.EMPTY;
            }
            return SingleRange.make(key + 1L, this.rangeEnd());
        }
        if (key == this.rangeEnd()) {
            return SingleRange.make(this.rangeStart(), key - 1L);
        }
        return OrderedLongSet.twoRanges(this.rangeStart(), key - 1L, key + 1L, this.rangeEnd());
    }

    private static long addSaturated(long x, long y) {
        long res = x + y;
        if (res < 0L) {
            return Long.MAX_VALUE;
        }
        return res;
    }

    @Override
    public final OrderedLongSet ixSubindexByPosOnNew(long startPos, long endPosExclusive) {
        long endPos = endPosExclusive - 1L;
        if (endPos < startPos || endPos < 0L) {
            return OrderedLongSet.EMPTY;
        }
        long sz = this.ixCardinality();
        if (startPos >= sz) {
            return OrderedLongSet.EMPTY;
        }
        long len = endPos - startPos + 1L;
        if (startPos == 0L && len >= sz) {
            return this.ixCowRef();
        }
        return SingleRange.make(this.rangeStart() + startPos, Math.min(SingleRange.addSaturated(this.rangeStart(), endPos), this.rangeEnd()));
    }

    @Override
    public final OrderedLongSet ixSubindexByKeyOnNew(long startKey, long endKey) {
        if (startKey > this.rangeEnd() || endKey < this.rangeStart()) {
            return OrderedLongSet.EMPTY;
        }
        if (startKey == this.rangeStart() && endKey == this.rangeEnd()) {
            return this.ixCowRef();
        }
        return SingleRange.make(Math.max(startKey, this.rangeStart()), Math.min(endKey, this.rangeEnd()));
    }

    @Override
    public final long ixGet(long pos) {
        if (pos < 0L || pos >= this.ixCardinality()) {
            return -1L;
        }
        return this.rangeStart() + pos;
    }

    @Override
    public final void ixGetKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
        long sz = this.ixCardinality();
        while (inputPositions.hasNext()) {
            long pos = inputPositions.nextLong();
            if (pos < 0L || pos >= sz) {
                outputKeys.accept(-1L);
                continue;
            }
            outputKeys.accept(this.rangeStart() + pos);
        }
    }

    @Override
    public final long ixFind(long key) {
        if (key < this.rangeStart()) {
            return -1L;
        }
        if (key > this.rangeEnd()) {
            return this.ixCardinality() ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return key - this.rangeStart();
    }

    @Override
    public RowSet.Iterator ixIterator() {
        return new Iterator(this);
    }

    @Override
    public final RowSet.SearchIterator ixSearchIterator() {
        return new SearchIterator(this);
    }

    @Override
    public final RowSet.SearchIterator ixReverseIterator() {
        return new ReverseIter(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final RowSet.RangeIterator ixRangeIterator() {
        return new RangeIter(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final boolean ixIsEmpty() {
        return false;
    }

    @Override
    public final OrderedLongSet ixUpdate(OrderedLongSet added, OrderedLongSet removed) {
        if (removed.ixIsEmpty() || removed.ixLastKey() < this.rangeStart() || removed.ixFirstKey() > this.rangeEnd()) {
            if (added.ixIsEmpty()) {
                return this;
            }
            return this.ixInsert(added);
        }
        if (removed instanceof SingleRange) {
            if (removed.ixFirstKey() <= this.ixFirstKey() && this.ixLastKey() <= removed.ixLastKey()) {
                return added.ixCowRef();
            }
            OrderedLongSet t = this.ixRemoveRange(removed.ixFirstKey(), removed.ixLastKey());
            return t.ixInsert(added);
        }
        if (added.ixIsEmpty()) {
            return this.ixRemove(removed);
        }
        if (added instanceof SingleRange) {
            return this.ixRemove(removed).ixInsertRange(added.ixFirstKey(), added.ixLastKey());
        }
        if (added instanceof SortedRanges) {
            SortedRanges ans = this.toSortedRanges();
            return ans.ixUpdate(added, removed);
        }
        RspBitmap ans = this.toRsp();
        ans.updateUnsafeNoWriteCheck(OrderedLongSet.asRspBitmap(added), OrderedLongSet.asRspBitmap(removed));
        if (ans.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        ans.finishMutations();
        return ans;
    }

    @Override
    public final OrderedLongSet ixRemove(OrderedLongSet removed) {
        return this.minus(removed);
    }

    private OrderedLongSet minus(OrderedLongSet removed) {
        if (removed.ixIsEmpty() || removed.ixLastKey() < this.rangeStart() || removed.ixFirstKey() > this.rangeEnd()) {
            return this;
        }
        if (this.ixSubsetOf(removed)) {
            return OrderedLongSet.EMPTY;
        }
        if (removed instanceof SingleRange) {
            return this.ixRemoveRange(removed.ixFirstKey(), removed.ixLastKey());
        }
        SortedRanges sr = this.toSortedRanges();
        OrderedLongSet r = sr.remove(removed);
        if (r != null) {
            return r;
        }
        RspBitmap ans = this.toRsp();
        ans.andNotEqualsUnsafeNoWriteCheck(OrderedLongSet.asRspBitmap(removed));
        if (ans.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        ans.finishMutations();
        return ans;
    }

    @Override
    public final OrderedLongSet ixRemoveRange(long startKey, long endKey) {
        if (endKey < this.rangeStart() || startKey > this.rangeEnd()) {
            return this;
        }
        if (startKey <= this.rangeStart() && this.rangeEnd() <= endKey) {
            return OrderedLongSet.EMPTY;
        }
        if (this.rangeStart() < startKey && endKey < this.rangeEnd()) {
            return OrderedLongSet.twoRanges(this.rangeStart(), startKey - 1L, endKey + 1L, this.rangeEnd());
        }
        if (endKey < this.rangeEnd()) {
            return SingleRange.make(endKey + 1L, this.rangeEnd());
        }
        return SingleRange.make(this.rangeStart(), startKey - 1L);
    }

    @Override
    public final OrderedLongSet ixRetain(OrderedLongSet other) {
        return this.intersect(other);
    }

    private OrderedLongSet intersect(OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        long otherFirstKey = other.ixFirstKey();
        if (this.rangeEnd() < otherFirstKey) {
            return OrderedLongSet.EMPTY;
        }
        long otherLastKey = other.ixLastKey();
        if (otherLastKey < this.rangeStart()) {
            return OrderedLongSet.EMPTY;
        }
        if (other instanceof SingleRange) {
            return SingleRange.make(Math.max(this.rangeStart(), otherFirstKey), Math.min(this.rangeEnd(), otherLastKey));
        }
        return other.ixSubindexByKeyOnNew(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final OrderedLongSet ixRetainRange(long start, long end) {
        if (this.rangeEnd() < start) {
            return OrderedLongSet.EMPTY;
        }
        if (end < this.rangeStart()) {
            return OrderedLongSet.EMPTY;
        }
        return SingleRange.make(Math.max(this.rangeStart(), start), Math.min(this.rangeEnd(), end));
    }

    @Override
    public final OrderedLongSet ixIntersectOnNew(OrderedLongSet intersected) {
        return this.intersect(intersected);
    }

    @Override
    public final boolean ixContainsRange(long start, long end) {
        return this.rangeStart() <= start && end <= this.rangeEnd();
    }

    @Override
    public final boolean ixOverlaps(OrderedLongSet impl) {
        if (impl.ixIsEmpty()) {
            return false;
        }
        if (impl instanceof SingleRange) {
            return impl.ixLastKey() >= this.rangeStart() && impl.ixFirstKey() <= this.rangeEnd();
        }
        return impl.ixOverlapsRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final boolean ixOverlapsRange(long start, long end) {
        return start <= this.rangeEnd() && end >= this.rangeStart();
    }

    private boolean overlapsOrAdjacentToRange(long start, long end) {
        return this.rangeEnd() >= start - 1L && end >= this.rangeStart() - 1L;
    }

    @Override
    public final boolean ixSubsetOf(OrderedLongSet impl) {
        if (impl.ixIsEmpty()) {
            return false;
        }
        if (impl instanceof SingleRange) {
            return impl.ixFirstKey() <= this.rangeStart() && this.rangeEnd() <= impl.ixLastKey();
        }
        return impl.ixContainsRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final OrderedLongSet ixMinusOnNew(OrderedLongSet set) {
        return this.minus(set);
    }

    @Override
    public final OrderedLongSet ixUnionOnNew(OrderedLongSet set) {
        return this.union(set);
    }

    private OrderedLongSet union(OrderedLongSet set) {
        RspBitmap rspSet;
        if (set.ixIsEmpty()) {
            return this.ixCowRef();
        }
        if (this.rangeStart() <= set.ixFirstKey() && set.ixLastKey() <= this.rangeEnd()) {
            return this.ixCowRef();
        }
        if (set instanceof SingleRange) {
            return this.ixInsertRange(set.ixFirstKey(), set.ixLastKey());
        }
        if (set instanceof SortedRanges) {
            SortedRanges sr = (SortedRanges)set;
            SortedRanges ans = sr.deepCopy().addRange(this.rangeStart(), this.rangeEnd());
            if (ans != null) {
                return ans;
            }
            rspSet = sr.toRsp();
        } else {
            rspSet = (RspBitmap)set;
        }
        RspBitmap ans = rspSet.deepCopy();
        ans.addRangeUnsafeNoWriteCheck(this.rangeStart(), this.rangeEnd());
        ans.finishMutations();
        return ans;
    }

    @Override
    public final OrderedLongSet ixShiftOnNew(long shiftAmount) {
        return SingleRange.make(this.rangeStart() + shiftAmount, this.rangeEnd() + shiftAmount);
    }

    @Override
    public final OrderedLongSet ixShiftInPlace(long shiftAmount) {
        return this.ixShiftOnNew(shiftAmount);
    }

    @Override
    public final OrderedLongSet ixInsert(OrderedLongSet added) {
        if (added.ixIsEmpty() || this.rangeStart() <= added.ixFirstKey() && added.ixLastKey() <= this.rangeEnd()) {
            return this;
        }
        if (added instanceof SingleRange) {
            return this.ixInsertRange(added.ixFirstKey(), added.ixLastKey());
        }
        OrderedLongSet ix = added.ixCowRef();
        return ix.ixInsertRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final OrderedLongSet ixInsertWithShift(long shiftAmount, OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return this;
        }
        long ansFirst = other.ixFirstKey() + shiftAmount;
        long ansLast = other.ixLastKey() + shiftAmount;
        if (this.rangeStart() <= ansFirst && ansLast <= this.rangeEnd()) {
            return this;
        }
        if (other instanceof SingleRange) {
            return this.ixInsertRange(ansFirst, ansLast);
        }
        return other.ixShiftOnNew(shiftAmount).ixInsertRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final RowSequence ixGetRowSequenceByPosition(long startPositionInclusive, long length) {
        if (startPositionInclusive >= this.ixCardinality() || length == 0L) {
            return RowSequenceFactory.EMPTY;
        }
        long s = this.rangeStart() + startPositionInclusive;
        long e = Math.min(s + length - 1L, this.rangeEnd());
        return new SingleRangeRowSequence(s, e);
    }

    @Override
    public final RowSequence ixGetRowSequenceByKeyRange(long startKeyInclusive, long endKeyInclusive) {
        if (startKeyInclusive > this.rangeEnd() || endKeyInclusive < this.rangeStart() || endKeyInclusive < startKeyInclusive) {
            return RowSequenceFactory.EMPTY;
        }
        return new SingleRangeRowSequence(Math.max(startKeyInclusive, this.rangeStart()), Math.min(endKeyInclusive, this.rangeEnd()));
    }

    @Override
    public final RowSequence.Iterator ixGetRowSequenceIterator() {
        return new SingleRangeRowSequence.Iterator(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final long ixRangesCountUpperBound() {
        return 1L;
    }

    @Override
    public final long ixGetAverageRunLengthEstimate() {
        return this.ixCardinality();
    }

    @Override
    public final OrderedLongSet ixInvertOnNew(OrderedLongSet keys, long maximumPosition) {
        OrderedLongSetBuilderSequential b = new OrderedLongSetBuilderSequential();
        RowSet.RangeIterator it = keys.ixRangeIterator();
        String exStr = "invert for non-existing key:";
        while (it.hasNext()) {
            it.next();
            long start = it.currentRangeStart();
            long end = it.currentRangeEnd();
            long startPos = start - this.rangeStart();
            if (startPos < 0L) {
                throw new IllegalArgumentException("invert for non-existing key:" + start);
            }
            if (startPos > maximumPosition) break;
            long endPos = startPos;
            if (start != end && (endPos = end - this.rangeStart()) < 0L) {
                throw new IllegalArgumentException("invert for non-existing key:" + end);
            }
            if (endPos > maximumPosition) {
                b.appendRange(startPos, maximumPosition);
                break;
            }
            b.appendRange(startPos, endPos);
        }
        return b.getOrderedLongSet();
    }

    public final RspBitmap toRsp() {
        return new RspBitmap(this.rangeStart(), this.rangeEnd());
    }

    public final SortedRanges toSortedRanges() {
        return SortedRanges.makeSingleRange(this.rangeStart(), this.rangeEnd());
    }

    @Override
    public final RspBitmap ixToRspOnNew() {
        return this.toRsp();
    }

    @Override
    public final SingleRange ixCompact() {
        return this;
    }

    @Override
    public final void ixValidate(String failMsg) {
        boolean b;
        boolean bl = b = this.rangeStart() >= 0L && this.rangeEnd() >= this.rangeStart();
        if (!b) {
            Object m = failMsg == null ? "" : failMsg + " ";
            Assert.geqZero((long)this.rangeStart(), (String)((String)m + "rangeStart"));
            Assert.geq((long)this.rangeEnd(), (String)((String)m + "rangeEnd"), (long)this.rangeStart(), (String)"rangeStart");
        }
    }

    private static final class RangeIter
    implements RowSet.RangeIterator {
        private long start;
        private final long end;
        private boolean hasNext;

        public RangeIter(long rangeStart, long rangeEnd) {
            this.start = rangeStart;
            this.end = rangeEnd;
            this.hasNext = true;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public boolean advance(long v) {
            this.hasNext = false;
            if (v <= this.start) {
                return true;
            }
            if (v > this.end) {
                return false;
            }
            this.start = v;
            return true;
        }

        @Override
        public void postpone(long v) {
            this.start = v;
        }

        @Override
        public long currentRangeStart() {
            return this.start;
        }

        @Override
        public long currentRangeEnd() {
            return this.end;
        }

        @Override
        public long next() {
            this.hasNext = false;
            return this.start;
        }
    }

    private static final class ReverseIter
    implements RowSet.SearchIterator {
        private final long start;
        private final long end;
        private long curr;

        public ReverseIter(long rangeStart, long rangeEnd) {
            this.start = rangeStart;
            this.end = rangeEnd;
            this.curr = rangeEnd + 1L;
        }

        public void close() {
        }

        @Override
        public boolean hasNext() {
            return this.start < this.curr;
        }

        @Override
        public long currentValue() {
            return this.curr;
        }

        @Override
        public long nextLong() {
            return --this.curr;
        }

        @Override
        public boolean advance(long v) {
            if (v < this.start) {
                this.curr = this.start;
                return false;
            }
            this.curr = Math.min(v, Math.min(this.curr, this.end));
            return true;
        }

        @Override
        public long binarySearchValue(RowSet.TargetComparator targetComparator, int direction) {
            throw new UnsupportedOperationException("Reverse iterator does not support binary search.");
        }
    }

    private static final class SearchIterator
    extends Iterator
    implements RowSet.SearchIterator {
        private final long rangeStart;

        public SearchIterator(SingleRange ix) {
            super(ix);
            this.rangeStart = ix.rangeStart();
        }

        @Override
        public long currentValue() {
            return this.curr;
        }

        @Override
        public boolean advance(long v) {
            if (this.curr < this.rangeStart) {
                this.curr = this.rangeStart;
            }
            if (v > this.last) {
                this.curr = this.last;
                return false;
            }
            if (v > this.curr) {
                this.curr = v;
            }
            return true;
        }

        @Override
        public long binarySearchValue(RowSet.TargetComparator tc, int dir) {
            if (this.curr < this.rangeStart) {
                if (tc.compareTargetTo(this.rangeStart, dir) < 0) {
                    return -1L;
                }
                this.curr = this.rangeStart;
            } else if (tc.compareTargetTo(this.curr, dir) < 0) {
                return -1L;
            }
            this.curr = RowSetUtils.rangeSearch(this.curr, this.last, k -> tc.compareTargetTo(k, dir));
            return this.curr;
        }
    }

    private static class Iterator
    implements RowSet.Iterator {
        protected long curr;
        protected final long last;

        public Iterator(SingleRange ix) {
            this.curr = ix.rangeStart() - 1L;
            this.last = ix.rangeEnd();
        }

        @Override
        public long nextLong() {
            return ++this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.curr < this.last;
        }

        public void close() {
        }
    }
}

