/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.singlerange;

import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.impl.singlerange.SingleRangeRowSequence;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;

public interface SingleRangeMixin
extends RowSequence {
    @Override
    default public boolean forEachRowKey(LongAbortableConsumer lc) {
        for (long v = this.rangeStart(); v <= this.rangeEnd(); ++v) {
            if (lc.accept(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public boolean forEachRowKeyRange(LongRangeAbortableConsumer larc) {
        return larc.accept(this.rangeStart(), this.rangeEnd());
    }

    @Override
    default public RowSequence getRowSequenceByPosition(long startPositionInclusive, long length) {
        if (startPositionInclusive >= this.size() || length == 0L) {
            return RowSequenceFactory.EMPTY;
        }
        long s = this.rangeStart() + startPositionInclusive;
        long e = Math.min(s + length - 1L, this.rangeEnd());
        return new SingleRangeRowSequence(s, e);
    }

    @Override
    default public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        if (startRowKeyInclusive > this.rangeEnd() || endRowKeyInclusive < this.rangeStart() || endRowKeyInclusive < startRowKeyInclusive) {
            return RowSequenceFactory.EMPTY;
        }
        return new SingleRangeRowSequence(Math.max(startRowKeyInclusive, this.rangeStart()), Math.min(endRowKeyInclusive, this.rangeEnd()));
    }

    @Override
    default public RowSequence.Iterator getRowSequenceIterator() {
        return new SingleRangeRowSequence.Iterator(this.rangeStart(), this.rangeEnd());
    }

    default public long rangesCountUpperBound() {
        return 1L;
    }

    @Override
    default public long getAverageRunLengthEstimate() {
        return this.size();
    }

    @Override
    default public boolean isContiguous() {
        return true;
    }

    @Override
    public long size();

    public long rangeStart();

    public long rangeEnd();
}

