/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.singlerange;

import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowSequenceAsChunkImpl;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.singlerange.SingleRangeMixin;

public class SingleRangeRowSequence
extends RowSequenceAsChunkImpl
implements SingleRangeMixin {
    private long rangeStart;
    private long rangeEnd;

    @Override
    public long rangeStart() {
        return this.rangeStart;
    }

    @Override
    public long rangeEnd() {
        return this.rangeEnd;
    }

    public SingleRangeRowSequence(long rangeStart, long rangeEnd) {
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    protected void reset(long rangeStart, long rangeEnd) {
        this.invalidateRowSequenceAsChunkImpl();
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    public SingleRangeRowSequence copy() {
        return new SingleRangeRowSequence(this.rangeStart, this.rangeEnd);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public long lastRowKey() {
        return this.rangeEnd;
    }

    @Override
    public long firstRowKey() {
        return this.rangeStart;
    }

    @Override
    public long size() {
        return this.rangeEnd - this.rangeStart + 1L;
    }

    @Override
    public long rangesCountUpperBound() {
        return 1L;
    }

    @Override
    public RowSet asRowSet() {
        return new WritableRowSetImpl(SingleRange.make(this.rangeStart(), this.rangeEnd()));
    }

    @Override
    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        int n = this.intSize();
        for (int i = 0; i < n; ++i) {
            chunkToFill.set(i, this.rangeStart() + (long)i);
        }
        chunkToFill.setSize(n);
    }

    @Override
    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        int maxSz = chunkToFill.size();
        if (maxSz < 2) {
            chunkToFill.setSize(0);
            return;
        }
        chunkToFill.set(0, this.rangeStart());
        chunkToFill.set(1, this.rangeEnd());
        chunkToFill.setSize(2);
    }

    static final class Iterator
    implements RowSequence.Iterator {
        private long currStart;
        private long currEnd;
        private long sizeLeft;
        private final SingleRangeRowSequence currBuf;

        public Iterator(long rangeStart, long rangeEnd) {
            this.currStart = rangeStart;
            this.currEnd = -1L;
            this.sizeLeft = rangeEnd - rangeStart + 1L;
            this.currBuf = new SingleRangeRowSequence(0L, 0L);
        }

        @Override
        public boolean hasMore() {
            return this.sizeLeft > 0L;
        }

        @Override
        public long peekNextKey() {
            if (this.sizeLeft <= 0L) {
                return -1L;
            }
            if (this.currEnd == -1L) {
                return this.currStart;
            }
            return this.currEnd + 1L;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKeyInclusive) {
            if (maxKeyInclusive < 0L || this.sizeLeft <= 0L) {
                return RowSequenceFactory.EMPTY;
            }
            if (this.currEnd != -1L) {
                if (maxKeyInclusive <= this.currEnd) {
                    return RowSequenceFactory.EMPTY;
                }
                this.currStart = this.currEnd + 1L;
            } else if (maxKeyInclusive < this.currStart) {
                return RowSequenceFactory.EMPTY;
            }
            this.currEnd = Math.min(this.currStart + this.sizeLeft - 1L, maxKeyInclusive);
            this.sizeLeft -= this.currEnd - this.currStart + 1L;
            this.currBuf.reset(this.currStart, this.currEnd);
            return this.currBuf;
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long numberOfKeys) {
            if (numberOfKeys <= 0L || this.sizeLeft <= 0L) {
                return RowSequenceFactory.EMPTY;
            }
            if (this.currEnd != -1L) {
                this.currStart = this.currEnd + 1L;
            }
            this.currEnd = this.currStart + Math.min(this.sizeLeft, numberOfKeys) - 1L;
            this.sizeLeft -= this.currEnd - this.currStart + 1L;
            this.currBuf.reset(this.currStart, this.currEnd);
            return this.currBuf;
        }

        @Override
        public boolean advance(long toKey) {
            if (this.sizeLeft <= 0L) {
                return false;
            }
            long last = this.currEnd == -1L ? this.currStart + this.sizeLeft - 1L : this.currEnd + 1L + this.sizeLeft - 1L;
            if (last < toKey) {
                this.sizeLeft = 0L;
                return false;
            }
            if (toKey > this.currStart) {
                this.currStart = toKey;
                this.currEnd = -1L;
                this.sizeLeft = last - this.currStart + 1L;
            }
            return true;
        }

        @Override
        public long getRelativePosition() {
            return -this.sizeLeft;
        }

        @Override
        public void close() {
            this.currBuf.close();
        }
    }
}

