/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.LongChunk;
import io.deephaven.configuration.Configuration;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.OrderedLongSet;
import io.deephaven.engine.rowset.impl.OrderedLongSetBuilderSequential;
import io.deephaven.engine.rowset.impl.RefCountedCow;
import io.deephaven.engine.rowset.impl.RowSetUtils;
import io.deephaven.engine.rowset.impl.RspBitmapBuilderSequential;
import io.deephaven.engine.rowset.impl.rsp.RspBitmap;
import io.deephaven.engine.rowset.impl.singlerange.SingleRange;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesInt;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesLong;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesRowSequence;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesShort;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import io.deephaven.util.metrics.IntCounterMetric;
import java.util.PrimitiveIterator;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class SortedRanges
extends RefCountedCow<SortedRanges>
implements OrderedLongSet {
    private static final IntCounterMetric sortedRangesToRspConversions = new IntCounterMetric("sortedRangesToRspConversions");
    protected static final int INITIAL_SIZE = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "initialSize", 2);
    public static final boolean DEBUG = Configuration.getInstance().getBooleanForClassWithDefault(SortedRanges.class, "debug", false);
    public static final int LONG_DENSE_MAX_CAPACITY = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "longDenseMaxCapacity", 256);
    public static final int LONG_SPARSE_MAX_CAPACITY = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "longSparseCapacity", 4096);
    public static final int INT_DENSE_MAX_CAPACITY = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "intDenseMaxCapacity", SortedRanges.arraySizeRoundingInt(2 * LONG_DENSE_MAX_CAPACITY));
    public static final int INT_SPARSE_MAX_CAPACITY = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "intSparseMaxCapacity", SortedRanges.arraySizeRoundingInt(2 * LONG_SPARSE_MAX_CAPACITY));
    public static final int SHORT_MAX_CAPACITY = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "shortMaxCapacity", 4090);
    public static final int ELEMENTS_PER_BLOCK_DENSE_THRESHOLD = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "elementsPerBlockDenseThreshold", 16);
    public static final int MAX_CAPACITY = Math.max(INT_SPARSE_MAX_CAPACITY, SHORT_MAX_CAPACITY);
    protected static final int LONG_EXTENT;
    protected static final int INT_EXTENT;
    protected static final int SHORT_EXTENT;
    protected static final boolean POOL_ARRAYS;
    public static final boolean USE_RANGES_ARRAY;
    private static ThreadLocal<SortedRangesLong> workSortedRangesLongPerThread;
    protected long cardinality;
    protected int count;

    @Override
    public abstract SortedRanges deepCopy();

    @Override
    public final SortedRanges self() {
        return this;
    }

    private static int arraySizeRounding(int sizeToRound, int elementSizeAsPowerOfTwo) {
        int sz = 12 + (sizeToRound << elementSizeAsPowerOfTwo);
        int szMod8 = sz & 7;
        int padding = szMod8 > 0 ? 8 - szMod8 : 0;
        return sizeToRound + (padding >> elementSizeAsPowerOfTwo);
    }

    public static int arraySizeRoundingInt(int sizeToRound) {
        return SortedRanges.arraySizeRounding(sizeToRound, 2);
    }

    public static int arraySizeRoundingShort(int sizeToRound) {
        return SortedRanges.arraySizeRounding(sizeToRound, 1);
    }

    protected SortedRanges() {
    }

    public static SortedRanges makeSingleRange(long start, long end) {
        return SortedRangesLong.makeSingleRange(start, end);
    }

    public static SortedRanges makeSingleElement(long v) {
        return SortedRanges.makeSingleRange(v, v);
    }

    public static SortedRanges makeEmpty() {
        return new SortedRangesLong();
    }

    public static SortedRanges tryMakeForKnownRangeFinalCapacityLowerBound(int initialCapacity, int finalCapacityLowerBound, long first, long last, boolean isDense) {
        int longBound;
        int intBound;
        long range = last - first;
        long offset = first;
        if (range <= 32767L) {
            if (finalCapacityLowerBound > SHORT_MAX_CAPACITY) {
                return null;
            }
            return new SortedRangesShort(initialCapacity, offset);
        }
        int n = intBound = isDense ? INT_DENSE_MAX_CAPACITY : INT_SPARSE_MAX_CAPACITY;
        if (finalCapacityLowerBound > intBound) {
            return null;
        }
        if (range <= Integer.MAX_VALUE) {
            return new SortedRangesInt(initialCapacity, offset);
        }
        int n2 = longBound = isDense ? LONG_DENSE_MAX_CAPACITY : LONG_SPARSE_MAX_CAPACITY;
        if (finalCapacityLowerBound > longBound) {
            return null;
        }
        return new SortedRangesLong(initialCapacity);
    }

    public static SortedRanges makeForKnownRange(long first, long last, boolean isDense) {
        return SortedRanges.tryMakeForKnownRangeUnknownMaxCapacity(INITIAL_SIZE, first, last, isDense);
    }

    public static SortedRanges tryMakeForKnownRangeUnknownMaxCapacity(int initialCapacity, long first, long last, boolean isDense) {
        return SortedRanges.tryMakeForKnownRangeFinalCapacityLowerBound(initialCapacity, initialCapacity, first, last, isDense);
    }

    public static SortedRanges tryMakeForKnownRangeKnownCount(int count, long first, long last) {
        boolean isDense = SortedRanges.isDenseLongSample(first, last, count);
        return SortedRanges.tryMakeForKnownRangeFinalCapacityLowerBound(count, count, first, last, isDense);
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }

    public final void clear() {
        this.count = 0;
    }

    public final long first() {
        return this.unpackedGet(0);
    }

    public final long last() {
        return Math.abs(this.unpackedGet(this.count - 1));
    }

    public final boolean hasMoreThanOneRange() {
        if (this.count > 2) {
            return true;
        }
        if (this.count <= 1) {
            return false;
        }
        return this.unpackedGet(1) >= 0L;
    }

    public final void validate() {
        this.validate(-1L, -1L);
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(Integer.toString(this.refCount()));
        sb.append(" { ");
        if (this.count == 0) {
            sb.append("}");
            return sb.toString();
        }
        boolean first = true;
        int i = 0;
        long iData = this.unpackedGet(0);
        boolean iNeg = false;
        long pendingStart = -1L;
        while (true) {
            if (iNeg) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(pendingStart).append("-").append(-iData);
                pendingStart = -1L;
                first = false;
            } else {
                if (pendingStart != -1L) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(pendingStart);
                    first = false;
                }
                pendingStart = iData;
            }
            if (++i >= this.count) break;
            iData = this.unpackedGet(i);
            iNeg = iData < 0L;
        }
        if (pendingStart != -1L) {
            if (!first) {
                sb.append(",");
            }
            sb.append(pendingStart);
        }
        sb.append(" }");
        return sb.toString();
    }

    public final boolean contains(long v) {
        if (this.count == 0) {
            return false;
        }
        int pos = this.unpackedBinarySearch(v, 0);
        return pos >= 0;
    }

    public final boolean containsRange(long start, long end) {
        boolean neg;
        if (this.count == 0) {
            return false;
        }
        int pos = this.unpackedBinarySearch(start, 0);
        if (pos < 0) {
            return false;
        }
        if (start == end) {
            return true;
        }
        if (pos == this.count - 1) {
            return false;
        }
        long data = this.unpackedGet(pos + 1);
        boolean bl = neg = data < 0L;
        if (!neg) {
            return false;
        }
        long value = -data;
        return end <= value;
    }

    public final long find(long v) {
        if (this.count == 0) {
            return -1L;
        }
        long packedValue = this.pack(v);
        if (packedValue < 0L) {
            return -1L;
        }
        return this.findPacked(packedValue);
    }

    private long findPacked(long packedValue) {
        long iData;
        int i = 0;
        int pos = 0;
        long iValue = iData = this.packedGet(0);
        while (packedValue >= iValue) {
            boolean jNeg;
            if (packedValue == iValue) {
                return pos;
            }
            int j = i + 1;
            if (j == this.count) {
                return -pos - 2;
            }
            long jData = this.packedGet(j);
            boolean bl = jNeg = jData < 0L;
            if (!jNeg) {
                ++pos;
                i = j;
                iValue = jData;
                continue;
            }
            long jValue = -jData;
            if (packedValue <= jValue) {
                return (long)pos + packedValue - iValue;
            }
            i = j + 1;
            if (i == this.count) {
                return -((long)pos + jValue + 2L - iValue);
            }
            pos = (int)((long)pos + (jValue - iValue + 1L));
            iData = this.packedGet(i);
            iValue = iData < 0L ? -iData : iData;
        }
        return -pos - 1;
    }

    public final long get(long targetPos) {
        if (targetPos < 0L || this.cardinality <= targetPos) {
            return -1L;
        }
        int i = 0;
        long pos = 0L;
        long iValue = this.packedGet(0);
        while (pos != targetPos) {
            boolean jNeg;
            int j = i + 1;
            long jData = this.packedGet(j);
            boolean bl = jNeg = jData < 0L;
            if (!jNeg) {
                ++pos;
                i = j;
                iValue = jData;
                continue;
            }
            long jValue = -jData;
            if (targetPos <= (pos += jValue - iValue)) {
                return this.unpack(jValue + targetPos - pos);
            }
            i = j + 1;
            if (DEBUG && i == this.count) {
                throw new IllegalStateException("Broken invariants: " + this.toString());
            }
            ++pos;
            iValue = this.packedGet(i);
        }
        return this.unpack(iValue);
    }

    public abstract SortedRanges applyShift(long var1);

    public abstract SortedRanges applyShiftOnNew(long var1);

    public final SortedRanges add(long v) {
        return this.addInternal(v, true);
    }

    public final SortedRanges addUnsafe(long v) {
        return this.addInternal(v, false);
    }

    public final SortedRanges addRange(long start, long end) {
        return this.addRangeInternal(start, end, true);
    }

    public final SortedRanges addRangeUnsafe(long start, long end) {
        return this.addRangeInternal(start, end, false);
    }

    public final SortedRanges append(long v) {
        return this.appendInternal(v, true);
    }

    public final SortedRanges appendUnsafe(long v) {
        return this.appendInternal(v, false);
    }

    public final SortedRanges appendRange(long start, long end) {
        return this.appendRangeInternal(start, end, true);
    }

    public final SortedRanges appendRangeUnsafe(long start, long end) {
        return this.appendRangeInternal(start, end, false);
    }

    public final SortedRanges remove(long v) {
        return this.removeInternal(v);
    }

    public final SortedRanges removeRange(long start, long end) {
        return this.removeRangeInternal(start, end);
    }

    public final boolean forEachLongRange(LongRangeAbortableConsumer lrac) {
        long pendingStart = -1L;
        for (int i = 0; i < this.count; ++i) {
            long data = this.unpackedGet(i);
            if (data < 0L) {
                if (!lrac.accept(pendingStart, -data)) {
                    return false;
                }
                pendingStart = -1L;
                continue;
            }
            if (pendingStart != -1L && !lrac.accept(pendingStart, pendingStart)) {
                return false;
            }
            pendingStart = data;
        }
        return pendingStart == -1L || lrac.accept(pendingStart, pendingStart);
    }

    public final boolean forEachLong(LongAbortableConsumer lac) {
        long prev = -1L;
        for (int i = 0; i < this.count; ++i) {
            long iData = this.unpackedGet(i);
            if (iData < 0L) {
                long iValue = -iData;
                long v = prev;
                while (true) {
                    if (!lac.accept(v)) {
                        return false;
                    }
                    if (v == iValue) break;
                    ++v;
                }
                prev = -1L;
                continue;
            }
            if (prev != -1L && !lac.accept(prev)) {
                return false;
            }
            prev = iData;
        }
        return prev == -1L || lac.accept(prev);
    }

    public final RowSet.Iterator getIterator() {
        return new Iterator(this);
    }

    public RowSet.RangeIterator getRangeIterator() {
        return new RangeIterator(this);
    }

    public final RowSet.SearchIterator getSearchIterator() {
        return new SearchIterator(this);
    }

    public final RowSet.SearchIterator getReverseIterator() {
        return new ReverseIterator(this);
    }

    public final long getCardinality() {
        return this.cardinality;
    }

    public final void getKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
        if (!inputPositions.hasNext()) {
            return;
        }
        int i = 0;
        long iPos = 0L;
        long iData = this.packedGet(0);
        boolean iDataNeg = false;
        long iPrevData = iData;
        do {
            long targetPos = inputPositions.nextLong();
            while (iPos < targetPos) {
                boolean bl = iDataNeg = (iData = this.packedGet(++i)) < 0L;
                if (iDataNeg) {
                    iPos += -iData - iPrevData;
                    continue;
                }
                ++iPos;
                iPrevData = iData;
            }
            long iValue = iDataNeg ? -iData : iData;
            long v = this.unpack(iValue) - (iPos - targetPos);
            outputKeys.accept(v);
        } while (inputPositions.hasNext());
    }

    public final SortedRanges subRangesByPos(long startPosIn, long endPosIn) {
        boolean brokenFinalRange;
        if (endPosIn < 0L) {
            return null;
        }
        long startPos = Math.max(0L, startPosIn);
        if (endPosIn < startPos || startPos >= this.cardinality) {
            return null;
        }
        long endPos = Math.min(endPosIn, this.cardinality - 1L);
        long inputRangeSpan = endPos - startPos;
        int i = 0;
        long iData = this.packedGet(0);
        if (this.count == 1) {
            SortedRanges ans = this.makeMyTypeAndOffset(2);
            ans.packedSet(0, iData);
            ans.cardinality = 1L;
            ans.count = 1;
            if (DEBUG) {
                this.validate(startPosIn, endPosIn);
            }
            return ans;
        }
        long pos = 0L;
        long iPrevData = iData;
        i = 0;
        while (pos < startPos) {
            boolean iNeg;
            boolean bl = iNeg = (iData = this.packedGet(++i)) < 0L;
            if (iNeg) {
                long delta = -iData - iPrevData;
                pos += delta;
                continue;
            }
            ++pos;
            iPrevData = iData;
        }
        if (endPos <= pos) {
            if (endPos == startPos) {
                SortedRanges ans = this.makeMyTypeAndOffset(2);
                ans.packedSet(0, Math.abs(iData) - (pos - startPos));
                ans.cardinality = 1L;
                ans.count = 1;
                if (DEBUG) {
                    this.validate(startPosIn, endPosIn);
                }
                return ans;
            }
            long s = -iData - (pos - startPos);
            long e = -iData - (pos - endPos);
            SortedRanges ans = this.makeMyTypeAndOffset(2);
            ans.packedSet(0, s);
            ans.packedSet(1, -e);
            ans.cardinality = e - s + 1L;
            ans.count = 2;
            if (DEBUG) {
                this.validate(startPosIn, endPosIn);
            }
            return ans;
        }
        boolean brokenInitialRange = startPos < pos;
        int ansLen = this.count - i + (brokenInitialRange ? 2 : 1);
        ansLen = (int)Math.min((long)ansLen, inputRangeSpan + 1L);
        SortedRanges ans = this.makeMyTypeAndOffset(ansLen);
        ans.count = 0;
        ans.cardinality = 0L;
        if (brokenInitialRange) {
            long s = -iData - (pos - startPos);
            ans.packedSet(ans.count++, s);
            ans.cardinality += pos - startPos + 1L;
        } else {
            iData = Math.abs(iData);
            ++ans.cardinality;
        }
        long deltaCard = 0L;
        while (pos < endPos) {
            boolean iNeg;
            ans.cardinality += deltaCard;
            ans.packedSet(ans.count++, iData);
            iData = this.packedGet(++i);
            boolean bl = iNeg = iData < 0L;
            if (iNeg) {
                deltaCard = -iData - iPrevData;
                pos += deltaCard;
                continue;
            }
            ++pos;
            iPrevData = iData;
            deltaCard = 1L;
        }
        boolean bl = brokenFinalRange = endPos < pos;
        if (brokenFinalRange) {
            long e = -iData - (pos - endPos);
            ans.packedSet(ans.count++, -e);
            ans.cardinality += e - iPrevData;
        } else {
            ans.packedSet(ans.count++, iData);
            ans.cardinality += deltaCard;
        }
        if (DEBUG) {
            this.validate(startPosIn, endPosIn);
        }
        return ans;
    }

    public final SortedRanges subRangesByKey(long start, long end) {
        if (this.isEmpty() || end < this.first() || this.last() < start) {
            return null;
        }
        long packedStart = Math.max(this.pack(start), 0L);
        long packedEnd = this.pack(end);
        return this.subRangesByKeyPacked(packedStart, packedEnd);
    }

    public final boolean overlapsRange(long start, long end) {
        long packedEnd;
        if (end < start || this.isEmpty()) {
            return false;
        }
        long last = this.last();
        if (this.last() < start) {
            return false;
        }
        long first = this.first();
        if (end < this.first()) {
            return false;
        }
        long packedStart = this.pack(Math.max(start, first));
        return this.overlapsRangeInternal(0, packedStart, packedEnd = this.pack(Math.min(end, last))) == -1;
    }

    private int overlapsRangeInternal(int startIdx, long packedStart, long packedEnd) {
        int iStart = this.absRawBinarySearch(packedStart, startIdx, this.count - 1);
        long iStartData = this.packedGet(iStart);
        if (iStartData < 0L || iStartData == packedStart) {
            return -1;
        }
        if (iStartData <= packedEnd) {
            return -1;
        }
        return iStart;
    }

    public final boolean overlaps(RowSet.RangeIterator rangeIter) {
        if (this.isEmpty()) {
            return false;
        }
        if (!rangeIter.advance(this.first())) {
            return false;
        }
        int i = 0;
        long last = this.last();
        long start;
        while (last >= (start = rangeIter.currentRangeStart())) {
            long end = rangeIter.currentRangeEnd();
            if ((i = this.overlapsRangeInternal(i, this.pack(start), this.pack(end))) < 0) {
                return true;
            }
            if (!rangeIter.hasNext()) {
                return false;
            }
            rangeIter.next();
        }
        return false;
    }

    public final SortedRanges retainRange(long start, long end) {
        long first;
        if (this.isEmpty()) {
            return this;
        }
        if (!this.canWrite()) {
            SortedRanges ans = this.subRangesByKey(start, end);
            return ans;
        }
        SortedRanges ans = this;
        long last = this.last();
        if (end < last) {
            ans = ans.removeRange(end + 1L, last);
        }
        if (start > (first = this.first())) {
            ans = ans.removeRange(0L, start - 1L);
        }
        return ans;
    }

    private SortedRanges packedAppend(long packedData, long unpackedData, boolean writeCheck) {
        SortedRanges ans = this.ensureCanAppend(this.count, unpackedData, writeCheck);
        if (ans == null) {
            return null;
        }
        if (this == ans) {
            this.packedSet(this.count++, packedData);
        } else {
            ans.unpackedSet(ans.count++, unpackedData);
        }
        return ans;
    }

    private SortedRanges unpackedAppend(long unpackedData, boolean writeCheck) {
        SortedRanges ans = this.ensureCanAppend(this.count, unpackedData, writeCheck);
        if (ans == null) {
            return null;
        }
        ans.unpackedSet(ans.count++, unpackedData);
        return ans;
    }

    private SortedRanges packedAppend2(long packedData1, long packedData2, long unpackedData1, long unpackedData2, boolean writeCheck) {
        SortedRanges ans = this.ensureCanAppend(this.count + 1, unpackedData2, writeCheck);
        if (ans == null) {
            return null;
        }
        if (this == ans) {
            this.packedSet(this.count++, packedData1);
            this.packedSet(this.count++, packedData2);
        } else {
            ans.unpackedSet(ans.count++, unpackedData1);
            ans.unpackedSet(ans.count++, unpackedData2);
        }
        return ans;
    }

    private static SortedRanges intersectRangeImplStep(SortedRanges out, SortedRanges sar, int iStart, long start, long end, MutableInt iStartOut) {
        long srcValue;
        if (!out.fits(start, end)) {
            return null;
        }
        long packedStart = sar.pack(start);
        int srcIndex = sar.absRawBinarySearch(packedStart, iStart, sar.count - 1);
        long srcData = sar.packedGet(srcIndex);
        boolean srcNeg = srcData < 0L;
        long packedEnd = sar.pack(end);
        if (srcNeg) {
            srcValue = -srcData;
            if (srcValue == packedStart) {
                if ((out = out.unpackedAppend(start, false)) == null) {
                    return null;
                }
                ++out.cardinality;
                if (packedEnd == packedStart) {
                    iStartOut.setValue(srcIndex + 1);
                    if (DEBUG) {
                        out.validate(start, end);
                    }
                    return out;
                }
            } else {
                if ((out = out.unpackedAppend(start, false)) == null) {
                    return null;
                }
                if (packedEnd <= srcValue) {
                    if (packedStart == packedEnd) {
                        ++out.cardinality;
                    } else {
                        if ((out = out.unpackedAppend(-end, false)) == null) {
                            return null;
                        }
                        out.cardinality += packedEnd - packedStart + 1L;
                    }
                    iStartOut.setValue(packedEnd < srcValue ? srcIndex : srcIndex + 1);
                    if (DEBUG) {
                        out.validate(start, end);
                    }
                    return out;
                }
                if ((out = out.unpackedAppend(sar.unpack(srcData), false)) == null) {
                    return null;
                }
                out.cardinality += srcValue - packedStart + 1L;
            }
            srcData = sar.packedGet(++srcIndex);
            srcNeg = false;
        }
        srcValue = srcData;
        long prevStart = srcData;
        boolean pastEnd = false;
        while (srcValue <= packedEnd) {
            if ((out = out.unpackedAppend(sar.unpack(srcData), false)) == null) {
                return null;
            }
            if (srcNeg) {
                out.cardinality += srcValue - prevStart;
            } else {
                ++out.cardinality;
                prevStart = srcData;
            }
            if (++srcIndex == sar.count) {
                pastEnd = true;
                break;
            }
            srcData = sar.packedGet(srcIndex);
            srcNeg = srcData < 0L;
            srcValue = srcNeg ? -srcData : srcData;
        }
        if (!pastEnd && srcNeg && prevStart < packedEnd) {
            if ((out = out.unpackedAppend(-end, false)) == null) {
                return null;
            }
            out.cardinality += packedEnd - prevStart;
        }
        iStartOut.setValue(srcIndex);
        if (DEBUG) {
            out.validate(start, end);
        }
        return out;
    }

    private static boolean forEachLongRangeFromLongRangesArray(long[] arr, int count, LongRangeAbortableConsumer lrac) {
        long pendingStart = -1L;
        for (int i = 0; i < count; ++i) {
            long data = arr[i];
            if (data < 0L) {
                if (!lrac.accept(pendingStart, -data)) {
                    return false;
                }
                pendingStart = -1L;
                continue;
            }
            if (pendingStart != -1L && !lrac.accept(pendingStart, pendingStart)) {
                return false;
            }
            pendingStart = data;
        }
        return pendingStart == -1L || lrac.accept(pendingStart, pendingStart);
    }

    private static OrderedLongSet makeRspBitmapFromLongRangesArray(long[] ranges, int count) {
        RspBitmapBuilderSequential builder = new RspBitmapBuilderSequential();
        SortedRanges.forEachLongRangeFromLongRangesArray(ranges, count, (start, end) -> {
            builder.appendRange(start, end);
            return true;
        });
        return builder.getOrderedLongSet();
    }

    public static boolean isDenseShort(short[] data, int count) {
        return count >= ELEMENTS_PER_BLOCK_DENSE_THRESHOLD;
    }

    private static long nKeys(long v0, long v1) {
        long k0Shifted = v0 >> RspBitmap.BITS_PER_BLOCK;
        long k1Shifted = v1 >> RspBitmap.BITS_PER_BLOCK;
        return k1Shifted - k0Shifted + 1L;
    }

    protected static boolean isDenseLongSample(long v0, long v1, int count) {
        return SortedRanges.nKeys(v0, v1) * (long)ELEMENTS_PER_BLOCK_DENSE_THRESHOLD <= (long)count;
    }

    public static boolean isDenseInt(int[] data, int count) {
        if (count < ELEMENTS_PER_BLOCK_DENSE_THRESHOLD) {
            return false;
        }
        return SortedRanges.isDenseLongSample(data[0], Math.abs(data[count - 1]), count);
    }

    public static boolean isDenseLong(long[] data, int count) {
        if (count < ELEMENTS_PER_BLOCK_DENSE_THRESHOLD) {
            return false;
        }
        return SortedRanges.isDenseLongSample(data[0], Math.abs(data[count - 1]), count);
    }

    public abstract boolean isDense();

    public final boolean isSparse() {
        return !this.isDense();
    }

    private static OrderedLongSet makeOrderedLongSetFromLongRangesArray(long[] ranges, int count, long card, SortedRanges out) {
        if (count == 0) {
            return OrderedLongSet.EMPTY;
        }
        if (count == 1) {
            return SingleRange.make(ranges[0], ranges[0]);
        }
        if (count == 2 && ranges[1] < 0L) {
            return SingleRange.make(ranges[0], -ranges[1]);
        }
        long offset = ranges[0];
        long domain = Math.abs(ranges[count - 1]) - offset;
        if (domain <= 32767L) {
            SortedRangesShort sr;
            if (count > SHORT_MAX_CAPACITY) {
                return SortedRanges.makeRspBitmapFromLongRangesArray(ranges, count);
            }
            if (out instanceof SortedRangesShort && out.dataLength() >= count) {
                sr = (SortedRangesShort)out;
                sr.offset = offset;
            } else {
                sr = new SortedRangesShort(count, offset);
            }
            for (int sri = 0; sri < count; ++sri) {
                sr.unpackedSet(sri, ranges[sri]);
            }
            sr.cardinality = card;
            sr.count = count;
            return sr;
        }
        if (SortedRanges.isDenseLong(ranges, count)) {
            return SortedRanges.makeRspBitmapFromLongRangesArray(ranges, count);
        }
        if (domain <= Integer.MAX_VALUE) {
            SortedRangesInt sr;
            if (count > INT_SPARSE_MAX_CAPACITY) {
                return SortedRanges.makeRspBitmapFromLongRangesArray(ranges, count);
            }
            if (out instanceof SortedRangesInt && out.dataLength() >= count) {
                sr = (SortedRangesInt)out;
                sr.offset = offset;
            } else {
                sr = new SortedRangesInt(count, offset);
            }
            for (int sri = 0; sri < count; ++sri) {
                sr.unpackedSet(sri, ranges[sri]);
            }
            sr.cardinality = card;
            sr.count = count;
            return sr;
        }
        if (count > LONG_SPARSE_MAX_CAPACITY) {
            return SortedRanges.makeRspBitmapFromLongRangesArray(ranges, count);
        }
        SortedRangesLong sr = out instanceof SortedRangesLong && out.dataLength() >= count ? (SortedRangesLong)out : new SortedRangesLong(count);
        System.arraycopy(ranges, 0, sr.data, 0, count);
        sr.cardinality = card;
        sr.count = count;
        return sr;
    }

    private static SortedRangesLong intersect(SortedRanges sr, OrderedLongSet tix) {
        return SortedRanges.intersect(sr, tix, false);
    }

    /*
     * Exception decompiling
     */
    private static SortedRangesLong intersect(SortedRanges sr, OrderedLongSet tix, boolean takeComplement) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[UNCONDITIONALDOLOOP]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static SortedRangesLong union(SortedRanges sr1, SortedRanges sr2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 34[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final OrderedLongSet retain(OrderedLongSet tix) {
        if (!USE_RANGES_ARRAY) {
            MutableObject sarOut = new MutableObject((Object)this);
            boolean valid = SortedRanges.retainLegacy((MutableObject<SortedRanges>)sarOut, tix);
            if (!valid) {
                return ((SortedRanges)sarOut.getValue()).toRsp().ixRetain(tix);
            }
            SortedRanges sr = (SortedRanges)sarOut.getValue();
            if (sr.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            return sr;
        }
        SortedRangesLong sr = SortedRanges.intersect(this, tix);
        if (sr == null) {
            return this.toRsp().ixRetain(tix);
        }
        return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])sr.data, sr.count, sr.cardinality, this);
    }

    private static boolean retainLegacy(MutableObject<SortedRanges> sarOut, OrderedLongSet tix) {
        try (RowSet.RangeIterator rangeIter = tix.ixRangeIterator();){
            SortedRanges sar = (SortedRanges)sarOut.getValue();
            long first = sar.first();
            boolean valid = rangeIter.advance(first);
            if (!valid) {
                throw new IllegalStateException();
            }
            long rstartFirst = rangeIter.currentRangeStart();
            if (rstartFirst > 0L) {
                SortedRanges ans = sar.removeRange(0L, rstartFirst - 1L);
                if (ans == null) {
                    boolean bl = false;
                    return bl;
                }
                sar = ans;
                if (sar.isEmpty()) {
                    sarOut.setValue((Object)sar);
                    boolean bl = true;
                    return bl;
                }
            }
            long previousRangeEnd = rangeIter.currentRangeEnd();
            long last = sar.last();
            while (rangeIter.hasNext()) {
                rangeIter.next();
                long rstart = rangeIter.currentRangeStart();
                if (last < rstart) break;
                SortedRanges ans = sar.removeRange(previousRangeEnd + 1L, rstart - 1L);
                if (ans == null) {
                    sarOut.setValue((Object)sar);
                    boolean bl = false;
                    return bl;
                }
                sar = ans;
                previousRangeEnd = rangeIter.currentRangeEnd();
            }
            if (previousRangeEnd < last) {
                SortedRanges ans = sar.removeRange(previousRangeEnd + 1L, last);
                if (ans == null) {
                    sarOut.setValue((Object)sar);
                    boolean bl = false;
                    return bl;
                }
                sar = ans;
            }
            sarOut.setValue((Object)sar);
            boolean bl = true;
            return bl;
        }
    }

    public final OrderedLongSet intersectOnNewImpl(OrderedLongSet other) {
        SortedRangesLong sr = SortedRanges.intersect(this, other);
        if (sr == null) {
            return null;
        }
        return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])sr.data, sr.count, sr.cardinality, null);
    }

    public final int count() {
        return this.count;
    }

    /*
     * Exception decompiling
     */
    public final boolean subsetOf(RowSet.RangeIterator ritOther) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    final OrderedLongSet minusOnNew(OrderedLongSet other) {
        if (!USE_RANGES_ARRAY) {
            return this.minusOnNewLegacy(other.ixRangeIterator());
        }
        SortedRangesLong sr = SortedRanges.intersect(this, other, true);
        if (sr == null) {
            return null;
        }
        return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])sr.data, sr.count, sr.cardinality, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private SortedRanges minusOnNewLegacy(RowSet.RangeIterator ritOther) {
        long rEnd;
        long rStart;
        SortedRanges ans = this.makeMyTypeAndOffset(2);
        int i = 0;
        long iData = this.unpackedGet(0);
        boolean ritValid = ritOther.advance(iData);
        if (ritValid) {
            rStart = ritOther.currentRangeStart();
            rEnd = ritOther.currentRangeEnd();
        } else {
            rEnd = -1L;
            rStart = -1L;
        }
        boolean iNeg = false;
        long pendingStart = -1L;
        while (true) {
            block25: {
                block22: {
                    block26: {
                        block27: {
                            block23: {
                                block21: {
                                    long iValue;
                                    block24: {
                                        if (!iNeg) break block23;
                                        iValue = -iData;
                                        if (rStart == -1L) break block24;
                                        if (iValue < rStart) {
                                            if ((ans = SortedRanges.appendRangeUnpacked(ans, pendingStart, iValue, false)) == null) {
                                                return null;
                                            }
                                            break block21;
                                        } else {
                                            if (pendingStart < rStart && (ans = SortedRanges.appendRangeUnpacked(ans, pendingStart, rStart - 1L, false)) == null) {
                                                return null;
                                            }
                                            if (rEnd < iValue) {
                                                pendingStart = Math.max(rEnd + 1L, pendingStart);
                                                if (!ritOther.hasNext()) {
                                                    if ((ans = SortedRanges.appendRangeUnpacked(ans, pendingStart, iValue, false)) == null) {
                                                        return null;
                                                    }
                                                    rStart = -1L;
                                                    break block21;
                                                } else {
                                                    ritValid = ritOther.advance(pendingStart);
                                                    if (!ritValid) {
                                                        rStart = -1L;
                                                        continue;
                                                    }
                                                    rStart = ritOther.currentRangeStart();
                                                    if (ans.fits(rStart, rEnd = ritOther.currentRangeEnd())) continue;
                                                    return null;
                                                }
                                            }
                                        }
                                        break block21;
                                    }
                                    if ((ans = SortedRanges.appendRangeUnpacked(ans, pendingStart, iValue, false)) == null) {
                                        return null;
                                    }
                                }
                                pendingStart = -1L;
                                break block25;
                            }
                            if (rStart == -1L) break block26;
                            if (pendingStart == -1L) break block22;
                            if (pendingStart >= rStart) break block27;
                            if ((ans = SortedRanges.appendUnpacked(ans, pendingStart, false)) == null) {
                                return null;
                            }
                            break block22;
                        }
                        if (pendingStart > rEnd) {
                            if (!ritOther.hasNext()) {
                                if ((ans = SortedRanges.appendUnpacked(ans, pendingStart, false)) == null) {
                                    return null;
                                }
                                rStart = -1L;
                                break block22;
                            } else {
                                ritOther.next();
                                rStart = ritOther.currentRangeStart();
                                if (ans.fits(rStart, rEnd = ritOther.currentRangeEnd())) continue;
                                return null;
                            }
                        }
                        break block22;
                    }
                    if (pendingStart != -1L && (ans = SortedRanges.appendUnpacked(ans, pendingStart, false)) == null) {
                        return null;
                    }
                }
                pendingStart = iData;
            }
            if (++i == this.count) {
                boolean append;
                if (pendingStart == -1L) return ans;
                boolean bl = append = rStart == -1L || pendingStart < rStart;
                if (!append && pendingStart > rEnd) {
                    ritValid = ritOther.advance(pendingStart);
                    append = !ritValid || ritOther.currentRangeStart() != pendingStart;
                }
                if (!append) return ans;
                return SortedRanges.appendUnpacked(ans, pendingStart, false);
            }
            iData = this.unpackedGet(i);
            iNeg = iData < 0L;
        }
    }

    public static OrderedLongSet unionOnNew(SortedRanges sar, SortedRanges otherSar) {
        if (!USE_RANGES_ARRAY) {
            return SortedRanges.unionOnNewLegacy(sar, otherSar);
        }
        SortedRangesLong sr = SortedRanges.union(sar, otherSar);
        if (sr == null) {
            return null;
        }
        return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])sr.data, sr.count, sr.cardinality, null);
    }

    public static SortedRanges unionOnNewLegacy(SortedRanges sar, SortedRanges otherSar) {
        int otherCount;
        long unionFirst = Math.min(sar.first(), otherSar.first());
        long unionLast = Math.max(sar.last(), otherSar.last());
        int count = sar.count();
        SortedRanges out = SortedRanges.tryMakeForKnownRangeFinalCapacityLowerBound(Math.max(count, otherCount = otherSar.count()), count + otherCount, unionFirst, unionLast, sar.isDense() && otherSar.isDense());
        if (out != null) {
            try (RowSet.RangeIterator sarIter = sar.getRangeIterator();
                 RowSet.RangeIterator otherIter = otherSar.getRangeIterator();){
                SortedRanges.unionOnNewHelper(out, sarIter, otherIter);
            }
        }
        return out;
    }

    private static void unionOnNewHelper(SortedRanges out, RowSet.RangeIterator riter1, RowSet.RangeIterator riter2) {
        long end;
        riter1.next();
        long start1 = riter1.currentRangeStart();
        long end1 = riter1.currentRangeEnd();
        riter2.next();
        long start2 = riter2.currentRangeStart();
        long end2 = riter2.currentRangeEnd();
        while (true) {
            if (end1 < start2) {
                out = out.appendRange(start1, end1);
                if (riter1.hasNext()) {
                    riter1.next();
                    start1 = riter1.currentRangeStart();
                    end1 = riter1.currentRangeEnd();
                    continue;
                }
                out.appendRange(start2, end2);
                break;
            }
            if (end2 < start1) {
                out = out.appendRange(start2, end2);
                if (riter2.hasNext()) {
                    riter2.next();
                    start2 = riter2.currentRangeStart();
                    end2 = riter2.currentRangeEnd();
                    continue;
                }
                out.appendRange(start1, end1);
                break;
            }
            if (end1 < end2) {
                out = out.appendRange(Math.min(start1, start2), end2);
                boolean valid1 = riter1.advance(end2 + 1L);
                if (!riter2.hasNext()) {
                    if (!valid1) break;
                    out = out.appendRange(riter1.currentRangeStart(), riter1.currentRangeEnd());
                    break;
                }
                if (!valid1) break;
                riter2.next();
            } else {
                out = out.appendRange(Math.min(start1, start2), end1);
                boolean valid2 = riter2.advance(end1 + 1L);
                if (!riter1.hasNext()) {
                    if (!valid2) break;
                    out = out.appendRange(riter2.currentRangeStart(), riter2.currentRangeEnd());
                    break;
                }
                if (!valid2) break;
                riter1.next();
            }
            start1 = riter1.currentRangeStart();
            end1 = riter1.currentRangeEnd();
            start2 = riter2.currentRangeStart();
            end2 = riter2.currentRangeEnd();
        }
        while (riter1.hasNext()) {
            riter1.next();
            long start = riter1.currentRangeStart();
            end = riter1.currentRangeEnd();
            out = out.appendRange(start, end);
        }
        while (riter2.hasNext()) {
            riter2.next();
            long start = riter2.currentRangeStart();
            end = riter2.currentRangeEnd();
            out = out.appendRange(start, end);
        }
    }

    public final OrderedLongSet insertImpl(SortedRanges other) {
        return this.insertImpl(other, true);
    }

    public final SortedRanges mergeAppend(SortedRanges other, boolean writeCheck) {
        int otherFirstPosToRead;
        int firstPosToWrite;
        SortedRanges result;
        long unpackedLast = this.unpackedGet(this.count - 1);
        long otherUnpackedLast = other.unpackedGet(other.count - 1);
        if (Math.abs(unpackedLast) + 1L == other.first()) {
            boolean weEndInRange = unpackedLast < 0L;
            long otherKeyAtPos1 = -1L;
            if (other.count > 1 && (otherKeyAtPos1 = other.unpackedGet(1)) < 0L) {
                result = weEndInRange ? this.ensureCanAppend(this.count - 1 + other.count - 2, otherUnpackedLast, writeCheck) : this.ensureCanAppend(this.count - 1 + other.count - 1, otherUnpackedLast, writeCheck);
                if (result == null) {
                    return null;
                }
                if (weEndInRange) {
                    result.unpackedSet(result.count - 1, otherKeyAtPos1);
                    firstPosToWrite = result.count;
                } else {
                    result.unpackedSet(result.count, otherKeyAtPos1);
                    firstPosToWrite = result.count + 1;
                }
                otherFirstPosToRead = 2;
            } else {
                result = weEndInRange ? this.ensureCanAppend(this.count - 1 + other.count - 1, otherUnpackedLast, writeCheck) : this.ensureCanAppend(this.count - 1 + other.count, otherUnpackedLast, writeCheck);
                if (result == null) {
                    return null;
                }
                if (weEndInRange) {
                    result.unpackedSet(result.count - 1, -other.first());
                    firstPosToWrite = result.count;
                } else {
                    result.unpackedSet(result.count, -other.first());
                    firstPosToWrite = result.count + 1;
                }
                otherFirstPosToRead = 1;
            }
        } else {
            result = this.ensureCanAppend(this.count - 1 + other.count, otherUnpackedLast, writeCheck);
            if (result == null) {
                return null;
            }
            otherFirstPosToRead = 0;
            firstPosToWrite = result.count;
        }
        int posToWrite = firstPosToWrite;
        int otherPosToRead = otherFirstPosToRead;
        while (otherPosToRead < other.count) {
            result.unpackedSet(posToWrite++, other.unpackedGet(otherPosToRead++));
        }
        result.count = posToWrite;
        result.cardinality += other.cardinality;
        return result;
    }

    public final OrderedLongSet insertImpl(SortedRanges other, boolean writeCheck) {
        SortedRanges sr;
        if (this.isEmpty()) {
            return (OrderedLongSet)other.cowRef();
        }
        if (this.last() < other.first()) {
            sr = this.mergeAppend(other, writeCheck);
            if (sr != null) {
                return sr;
            }
        } else if (!USE_RANGES_ARRAY) {
            MutableObject holder = new MutableObject((Object)this);
            boolean valid = SortedRanges.insertInternal((MutableObject<SortedRanges>)holder, other, writeCheck);
            if (valid) {
                return (OrderedLongSet)holder.getValue();
            }
        } else {
            sr = SortedRanges.union(this, other);
            if (sr != null) {
                return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])((SortedRangesLong)sr).data, ((SortedRangesLong)sr).count, ((SortedRangesLong)sr).cardinality, !writeCheck || this.canWrite() ? this : null);
            }
        }
        RspBitmap rb = this.ixToRspOnNew();
        rb.insertOrderedLongSetUnsafeNoWriteCheck(other);
        rb.finishMutations();
        return rb;
    }

    private static boolean insertInternal(MutableObject<SortedRanges> sarHolder, SortedRanges other, boolean writeCheckArg) {
        long pendingStart = -1L;
        SortedRanges sar = (SortedRanges)sarHolder.getValue();
        long otherLast = other.last();
        if (!sar.fits(other.first(), otherLast)) {
            return false;
        }
        MutableInt iAdd = new MutableInt(0);
        boolean writeCheck = writeCheckArg;
        for (int iOther = 0; iOther < other.count; ++iOther) {
            boolean iNeg;
            long iData = other.unpackedGet(iOther);
            boolean bl = iNeg = iData < 0L;
            if (iNeg) {
                long startPacked = sar.pack(pendingStart);
                long endPacked = sar.pack(-iData);
                long deltaCard = endPacked - startPacked + 1L;
                iAdd.setValue(sar.absRawBinarySearch(startPacked, iAdd.intValue(), sar.count - 1));
                SortedRanges ans = SortedRanges.addRangePackedWithStart(sar, iAdd.intValue(), startPacked, endPacked, pendingStart, -iData, deltaCard, iAdd, writeCheck);
                if (ans == null) {
                    sarHolder.setValue((Object)sar);
                    return false;
                }
                if (sar != ans) {
                    if (!ans.fits(otherLast)) {
                        sarHolder.setValue((Object)sar);
                        return false;
                    }
                    sar = ans;
                    writeCheck = false;
                }
                pendingStart = -1L;
                continue;
            }
            if (pendingStart != -1L) {
                long pendingStartPacked = sar.pack(pendingStart);
                iAdd.setValue(sar.absRawBinarySearch(pendingStartPacked, iAdd.intValue(), sar.count - 1));
                SortedRanges ans = SortedRanges.addPackedWithStart(sar, iAdd.intValue(), pendingStartPacked, pendingStart, iAdd, writeCheck);
                if (ans == null) {
                    sarHolder.setValue((Object)sar);
                    return false;
                }
                if (sar != ans) {
                    if (!ans.fits(otherLast)) {
                        sarHolder.setValue((Object)sar);
                        return false;
                    }
                    sar = ans;
                    writeCheck = false;
                }
            }
            pendingStart = iData;
        }
        if (pendingStart != -1L) {
            long pendingStartPacked = sar.pack(pendingStart);
            int iStart = sar.absRawBinarySearch(pendingStartPacked, iAdd.intValue(), sar.count - 1);
            SortedRanges ans = SortedRanges.addPackedWithStart(sar, iStart, pendingStartPacked, pendingStart, null, writeCheck);
            if (ans == null) {
                sarHolder.setValue((Object)sar);
                return false;
            }
            sar = ans;
        }
        sarHolder.setValue((Object)sar);
        if (DEBUG) {
            sar.validate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeLegacy(MutableObject<SortedRanges> sarOut, RowSet.RangeIterator rit) {
        try {
            long start;
            MutableInt iRm = new MutableInt(0);
            SortedRanges sar = (SortedRanges)sarOut.getValue();
            long first = sar.first();
            boolean valid = rit.advance(first);
            if (!valid) {
                boolean bl = true;
                return bl;
            }
            long last = sar.last();
            boolean writeCheck = true;
            while ((start = rit.currentRangeStart()) <= last) {
                long end = Math.min(rit.currentRangeEnd(), last);
                if (end > last) {
                    end = last;
                }
                long packedStart = sar.pack(start);
                long packedEnd = sar.pack(end);
                int i = iRm.intValue();
                SortedRanges ans = SortedRanges.removeRangePackedWithStart(sar, i = sar.absRawBinarySearch(packedStart, i, sar.count - 1), packedStart, packedEnd, start, end, iRm, writeCheck);
                if (ans == null) {
                    sarOut.setValue((Object)sar);
                    boolean bl = false;
                    return bl;
                }
                if (ans != sar) {
                    sar = ans;
                    writeCheck = false;
                }
                if (!rit.hasNext()) break;
                rit.next();
            }
            sarOut.setValue((Object)sar);
            boolean bl = true;
            return bl;
        }
        finally {
            rit.close();
        }
    }

    public final OrderedLongSet invertRangeOnNew(long start, long end, long maxPosition) {
        long packedStart = this.pack(start);
        int i = 0;
        long pos = 0L;
        long data = this.packedGet(i);
        boolean neg = false;
        long pendingStart = -1L;
        while (true) {
            if (neg) {
                long rangeEnd = -data;
                if (packedStart <= rangeEnd) {
                    long packedEnd = this.pack(end);
                    if (packedEnd > rangeEnd) {
                        return null;
                    }
                    long rangeOffsetPos = pos - 1L;
                    long resultStart = rangeOffsetPos + packedStart - pendingStart;
                    if (resultStart > maxPosition) {
                        return OrderedLongSet.EMPTY;
                    }
                    long resultEnd = Math.min(rangeOffsetPos + packedEnd - pendingStart, maxPosition);
                    return SingleRange.make(resultStart, resultEnd);
                }
                pos += rangeEnd - pendingStart;
            } else {
                if (packedStart <= data) {
                    if (packedStart < data) {
                        return null;
                    }
                    if (end == start || pos == maxPosition) {
                        return SingleRange.make(pos, pos);
                    }
                    if (i + 1 >= this.count) {
                        return null;
                    }
                    long nextData = this.packedGet(i + 1);
                    if (nextData > 0L) {
                        return null;
                    }
                    long nextValue = -nextData;
                    long packedEnd = this.pack(end);
                    if (packedEnd > nextValue) {
                        return null;
                    }
                    return SingleRange.make(pos, Math.min(maxPosition, pos + packedEnd - data));
                }
                ++pos;
                pendingStart = data;
            }
            if (pos > maxPosition) {
                return OrderedLongSet.EMPTY;
            }
            if (++i >= this.count) {
                return null;
            }
            data = this.packedGet(i);
            neg = data < 0L;
        }
    }

    public final boolean invertOnNew(RowSet.RangeIterator rit, OrderedLongSetBuilderSequential builder, long maxPosition) {
        rit.next();
        long start = rit.currentRangeStart();
        long end = rit.currentRangeEnd();
        long packedStart = this.pack(start);
        int i = 0;
        long pos = 0L;
        long data = this.packedGet(i);
        boolean neg = false;
        long pendingStart = -1L;
        while (true) {
            if (neg) {
                long rangeEnd = -data;
                if (packedStart <= rangeEnd) {
                    long packedEnd = this.pack(end);
                    if (packedEnd > rangeEnd) {
                        return false;
                    }
                    long rangeOffsetPos = pos - 1L;
                    long resultStart = rangeOffsetPos + packedStart - pendingStart;
                    if (resultStart > maxPosition) {
                        return true;
                    }
                    long resultEnd = Math.min(rangeOffsetPos + packedEnd - pendingStart, maxPosition);
                    builder.appendRange(resultStart, resultEnd);
                    if (resultEnd == maxPosition || !rit.hasNext()) {
                        return true;
                    }
                    rit.next();
                    start = rit.currentRangeStart();
                    end = rit.currentRangeEnd();
                    packedStart = this.pack(start);
                    if (packedStart <= rangeEnd) {
                        pos += packedStart - pendingStart;
                        pendingStart = packedStart;
                        continue;
                    }
                }
                pos += rangeEnd - pendingStart;
            } else {
                if (packedStart <= data) {
                    if (packedStart < data) {
                        return false;
                    }
                    if (end == start || pos == maxPosition) {
                        builder.appendKey(pos);
                        if (pos == maxPosition) {
                            return true;
                        }
                    } else {
                        if (i + 1 >= this.count) {
                            return false;
                        }
                        long nextData = this.packedGet(i + 1);
                        if (nextData > 0L) {
                            return false;
                        }
                        long nextValue = -nextData;
                        long packedEnd = this.pack(end);
                        if (packedEnd > nextValue) {
                            return false;
                        }
                        long resultEnd = pos + packedEnd - data;
                        if (resultEnd >= maxPosition) {
                            builder.appendRange(pos, maxPosition);
                            return true;
                        }
                        builder.appendRange(pos, resultEnd);
                    }
                    if (!rit.hasNext()) {
                        return true;
                    }
                    rit.next();
                    start = rit.currentRangeStart();
                    end = rit.currentRangeEnd();
                    packedStart = this.pack(start);
                }
                ++pos;
                pendingStart = data;
            }
            if (pos > maxPosition) {
                return true;
            }
            if (++i >= this.count) {
                return false;
            }
            data = this.packedGet(i);
            neg = data < 0L;
        }
    }

    public final RowSequence getRowSequenceByPosition(long pos, long length) {
        long card = this.getCardinality();
        if (this.isEmpty() || pos >= card) {
            return RowSequenceFactory.EMPTY;
        }
        if (pos + length >= card) {
            length = card - pos;
        }
        return this.getRowSequenceByPositionWithStart(0L, 0, pos, length);
    }

    public final RowSequence getRowSequenceByPositionWithStart(long iStartPos, int istart, long startPosForOK, long lengthForOK) {
        int i = istart;
        long iPos = iStartPos;
        long iData = this.packedGet(i);
        boolean iNeg = false;
        long pendingStart = -1L;
        int startIdx = -1;
        int endIdx = -1;
        long startOffset = 1L;
        long endOffset = -1L;
        while (true) {
            if (iNeg) {
                if ((iPos += -iData - pendingStart - 1L) >= startPosForOK) {
                    startIdx = i;
                    startOffset = startPosForOK - iPos;
                    break;
                }
                pendingStart = -1L;
            } else {
                if (iPos >= startPosForOK) {
                    if (i + 1 >= this.count) {
                        startIdx = i;
                        startOffset = 0L;
                        endIdx = i;
                        endOffset = 0L;
                        return new SortedRangesRowSequence(this, startPosForOK, startIdx, startOffset, endIdx, endOffset, 1L);
                    }
                    long nextData = this.packedGet(i + 1);
                    if (nextData < 0L) {
                        startIdx = i + 1;
                        startOffset = iData + nextData;
                        iPos += -nextData - iData;
                        break;
                    }
                    startIdx = i;
                    startOffset = 0L;
                    break;
                }
                pendingStart = iData;
            }
            ++iPos;
            iData = this.packedGet(++i);
            iNeg = iData < 0L;
        }
        long endPositionInclusive = startPosForOK + lengthForOK - 1L;
        if (iPos >= endPositionInclusive) {
            endIdx = startIdx;
            endOffset = startOffset + lengthForOK - 1L;
            return new SortedRangesRowSequence(this, startPosForOK, startIdx, startOffset, endIdx, endOffset, lengthForOK);
        }
        i = startIdx + 1;
        ++iPos;
        iData = this.packedGet(i);
        iNeg = false;
        while (true) {
            if (iNeg) {
                if ((iPos += -iData - pendingStart - 1L) >= endPositionInclusive) {
                    endIdx = i;
                    endOffset = endPositionInclusive - iPos;
                    break;
                }
                pendingStart = -1L;
            } else {
                if (iPos >= endPositionInclusive) {
                    if (i + 1 >= this.count) {
                        endIdx = i;
                        endOffset = 0L;
                        break;
                    }
                    long nextData = this.packedGet(i + 1);
                    if (nextData < 0L) {
                        endIdx = i + 1;
                        endOffset = iData + nextData;
                        break;
                    }
                    endIdx = i;
                    endOffset = 0L;
                    break;
                }
                pendingStart = iData;
            }
            if (i + 1 >= this.count) {
                endIdx = i;
                endOffset = 0L;
                break;
            }
            ++iPos;
            iNeg = (iData = this.packedGet(++i)) < 0L;
        }
        return new SortedRangesRowSequence(this, startPosForOK, startIdx, startOffset, endIdx, endOffset, lengthForOK);
    }

    public final RowSequence getRowSequenceByKeyRange(long start, long end) {
        if (this.isEmpty()) {
            return RowSequenceFactory.EMPTY;
        }
        long last = this.last();
        if (last < start) {
            return RowSequenceFactory.EMPTY;
        }
        long first = this.first();
        if (end < first) {
            return RowSequenceFactory.EMPTY;
        }
        long packedStart = this.pack(Math.max(start, first));
        long packedEnd = this.pack(Math.min(end, last));
        return this.getRowSequenceByKeyRangePackedWithStart(0L, 0, packedStart, packedEnd);
    }

    final RowSequence getRowSequenceByKeyRangePackedWithStart(long iStartPos, int iStart, long packedStart, long packedEnd) {
        long iValue;
        int i = iStart;
        long iPos = iStartPos;
        long iData = this.packedGet(i);
        boolean iNeg = false;
        long pendingStart = iData;
        int startIdx = -1;
        long startOffset = 0L;
        long startPos = -1L;
        while (true) {
            if (iNeg) {
                iValue = -iData;
                iPos += iValue - pendingStart;
                if (iValue >= packedStart) {
                    startPos = iPos + packedStart - pendingStart;
                    startIdx = i;
                    startOffset = packedStart - iValue;
                    break;
                }
                pendingStart = -1L;
            } else {
                ++iPos;
                if (iData >= packedStart) {
                    boolean iNextNeg;
                    if (iData > packedStart && iData > packedEnd) {
                        return RowSequenceFactory.EMPTY;
                    }
                    if (i + 1 >= this.count) {
                        return new SortedRangesRowSequence(this, iPos, i, 0L, i, 0L, 1L);
                    }
                    startPos = iPos;
                    int iNext = i + 1;
                    long iNextData = this.packedGet(iNext);
                    boolean bl = iNextNeg = iNextData < 0L;
                    if (iNextNeg) {
                        long iNextValue = -iNextData;
                        if (iNextValue >= packedEnd) {
                            return new SortedRangesRowSequence(this, iPos, iNext, iData - iNextValue, iNext, packedEnd - iNextValue, packedEnd - iData + 1L);
                        }
                        startIdx = iNext;
                        startOffset = iData - iNextValue;
                        pendingStart = iData;
                        i = iNext;
                        iNeg = true;
                        iData = iNextData;
                        break;
                    }
                    if ((long)iNext > packedEnd) {
                        return new SortedRangesRowSequence(this, startPos, i, 0L, i, 0L, 1L);
                    }
                    pendingStart = -1L;
                    startOffset = 0L;
                    startIdx = i;
                    i = iNext;
                    iNeg = false;
                    iData = iNextData;
                    break;
                }
                pendingStart = iData;
            }
            if (DEBUG && ++i >= this.count) {
                throw new IllegalStateException("Broken invariant.");
            }
            iData = this.packedGet(i);
            iNeg = iData < 0L;
        }
        while (true) {
            if (iNeg) {
                iValue = -iData;
                if (iValue >= packedEnd) {
                    long endOffset = packedEnd - iValue;
                    return new SortedRangesRowSequence(this, startPos, startIdx, startOffset, i, endOffset, packedEnd - pendingStart + iPos - startPos + 1L);
                }
                iPos += iValue - pendingStart;
                pendingStart = -1L;
            } else {
                if (iData > packedEnd) {
                    return new SortedRangesRowSequence(this, startPos, startIdx, startOffset, i - 1, 0L, iPos - startPos + 1L);
                }
                ++iPos;
                pendingStart = iData;
            }
            if (i + 1 >= this.count) {
                return new SortedRangesRowSequence(this, startPos, startIdx, startOffset, i, 0L, iPos - startPos + 1L);
            }
            iNeg = (iData = this.packedGet(++i)) < 0L;
        }
    }

    public final RowSequence.Iterator getRowSequenceIterator() {
        if (this.isEmpty()) {
            return RowSequenceFactory.EMPTY_ITERATOR;
        }
        return new SortedRangesRowSequence.Iterator(new SortedRangesRowSequence(this));
    }

    public final long getAverageRunLengthEstimate() {
        if (this.isEmpty()) {
            return 0L;
        }
        int count = this.count();
        int n = Math.min(9, count);
        int negs = 0;
        for (int i = 1; i < n; ++i) {
            if (this.packedGet(i) >= 0L) continue;
            ++negs;
        }
        double initialRanges = n - negs;
        double initialFactor = (double)n / (initialRanges * (double)count);
        return Math.round(initialFactor * (double)this.getCardinality());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SortedRanges intersectLegacy(SortedRanges sar, long last, RowSet.RangeIterator rangeIter) {
        try {
            long start;
            boolean valid;
            int i;
            SortedRanges out = sar.makeMyTypeAndOffset(sar.count);
            MutableInt iOut = new MutableInt(0);
            int lasti = i = 0;
            while ((lasti == i || (valid = rangeIter.advance(sar.unpackedGet(i)))) && last >= (start = rangeIter.currentRangeStart())) {
                long end = rangeIter.currentRangeEnd();
                if ((out = SortedRanges.intersectRangeImplStep(out, sar, i, start, end = Math.min(end, last), iOut)) == null) {
                    SortedRanges sortedRanges = null;
                    return sortedRanges;
                }
                lasti = i;
                i = iOut.intValue();
                if (i >= sar.count || !rangeIter.hasNext()) break;
                rangeIter.next();
            }
            SortedRanges sortedRanges = out;
            return sortedRanges;
        }
        finally {
            rangeIter.close();
        }
    }

    private SortedRanges subRangesByKeyPacked(long packedStart, long packedEnd) {
        long iStartData;
        int iStart = this.absRawBinarySearch(packedStart, 0, this.count - 1);
        int iEnd = this.absRawBinarySearch(packedEnd, iStart, this.count - 1);
        if (iEnd >= this.count) {
            iEnd = this.count - 1;
        }
        boolean iStartNeg = (iStartData = this.packedGet(iStart)) < 0L;
        long iStartValue = iStartNeg ? -iStartData : iStartData;
        long iEndData = this.packedGet(iEnd);
        boolean iEndNeg = iEndData < 0L;
        long iEndValue = iEndNeg ? -iEndData : iEndData;
        int requiredLen = iEnd - iStart;
        if (iStartNeg && iStartValue > packedStart) {
            ++requiredLen;
        }
        if (iEndNeg) {
            long iEndPrevValue;
            if (iEndValue <= packedEnd) {
                ++requiredLen;
            } else if (iEnd > 0 && (iEndPrevValue = this.packedGet(iEnd - 1)) < iEndValue - 1L) {
                ++requiredLen;
            }
        } else if (iEndValue <= packedEnd) {
            ++requiredLen;
        }
        int iSrc = iStart;
        SortedRanges ans = this.makeMyTypeAndOffset(requiredLen);
        if (iStartNeg) {
            if (packedStart < iStartValue) {
                ans.packedSet(0, packedStart);
                if (packedEnd <= iStartValue || iEnd == iStart) {
                    if (packedEnd > packedStart) {
                        long end = Math.min(packedEnd, iEndValue);
                        ans.packedSet(1, -end);
                        ans.cardinality = end - packedStart + 1L;
                        ans.count = 2;
                    } else {
                        ans.cardinality = 1L;
                        ans.count = 1;
                    }
                    if (DEBUG) {
                        ans.validate(packedStart, packedEnd);
                    }
                    return ans;
                }
                ans.packedSet(1, iStartData);
                ans.count = 2;
                ans.cardinality += iStartValue - packedStart + 1L;
            } else {
                ans.packedSet(0, iStartValue);
                ans.count = 1;
                ++ans.cardinality;
                if (iStart == iEnd) {
                    ans.cardinality = 1L;
                    ans.count = 1;
                    if (DEBUG) {
                        ans.validate(packedStart, packedEnd);
                    }
                    return ans;
                }
            }
            ++iSrc;
        } else if (packedEnd < iStartValue) {
            return null;
        }
        long pendingStart = -1L;
        while (iSrc < iEnd) {
            boolean neg;
            long data = this.packedGet(iSrc);
            ans.packedSet(ans.count, data);
            boolean bl = neg = data < 0L;
            if (neg) {
                ans.cardinality += -data - pendingStart + 1L;
                pendingStart = -1L;
            } else {
                if (pendingStart != -1L) {
                    ++ans.cardinality;
                }
                pendingStart = data;
            }
            ++iSrc;
            ++ans.count;
        }
        if (iEndNeg) {
            long end = Math.min(packedEnd, iEndValue);
            ans.packedSet(ans.count++, -end);
            ans.cardinality += end - pendingStart + 1L;
        } else {
            if (pendingStart != -1L) {
                ++ans.cardinality;
            }
            if (iEndValue <= packedEnd) {
                ++ans.cardinality;
                ans.packedSet(ans.count++, iEndValue);
            }
        }
        if (DEBUG) {
            ans.validate(packedStart, packedEnd);
        }
        return ans;
    }

    protected static int shortArrayCapacityForLastIndex(int lastIndex) {
        int c = SortedRanges.capacityForLastIndex(lastIndex, SHORT_EXTENT, SHORT_MAX_CAPACITY);
        if (c == 0) {
            return 0;
        }
        return SortedRanges.arraySizeRoundingShort(c);
    }

    protected static int intArrayCapacityForLastIndex(int lastIndex, boolean isDense) {
        int c = SortedRanges.capacityForLastIndex(lastIndex, INT_EXTENT, isDense ? INT_DENSE_MAX_CAPACITY : INT_SPARSE_MAX_CAPACITY);
        if (c == 0) {
            return 0;
        }
        return SortedRanges.arraySizeRoundingInt(c);
    }

    protected static int longArrayCapacityForLastIndex(int lastIndex, boolean isDense) {
        return SortedRanges.capacityForLastIndex(lastIndex, LONG_EXTENT, isDense ? LONG_DENSE_MAX_CAPACITY : LONG_SPARSE_MAX_CAPACITY);
    }

    public abstract boolean fits(long var1);

    public abstract boolean fits(long var1, long var3);

    public abstract boolean fitsForAppend(long var1);

    protected abstract SortedRanges makeMyTypeAndOffset(int var1);

    protected abstract SortedRanges growOnNew(int var1);

    protected abstract int packedValuesPerCacheLine();

    protected abstract long packedGet(int var1);

    protected final long absPackedGet(int i) {
        return Math.abs(this.packedGet(i));
    }

    protected abstract void packedSet(int var1, long var2);

    protected abstract long pack(long var1);

    protected abstract long unpackedGet(int var1);

    protected abstract long absUnpackedGet(int var1);

    protected abstract void unpackedSet(int var1, long var2);

    protected abstract long unpack(long var1);

    protected abstract int dataLength();

    protected abstract SortedRanges ensureCanAppend(int var1, long var2, boolean var4);

    protected abstract void moveData(int var1, int var2, int var3);

    protected abstract void copyData(int var1);

    protected abstract SortedRanges addInternal(long var1, boolean var3);

    protected abstract SortedRanges addRangeInternal(long var1, long var3, boolean var5);

    protected abstract SortedRanges appendInternal(long var1, boolean var3);

    protected abstract SortedRanges appendRangeInternal(long var1, long var3, boolean var5);

    protected abstract SortedRanges removeInternal(long var1);

    protected abstract SortedRanges removeRangeInternal(long var1, long var3);

    protected abstract SortedRanges tryPackFor(long var1, long var3, int var5, boolean var6);

    protected final SortedRanges tryPackWithNewLast(long newLastKey, int maxPos, boolean isDense) {
        return this.tryPackFor(this.first(), newLastKey, maxPos, isDense);
    }

    protected abstract SortedRanges tryPack();

    public abstract int bytesAllocated();

    public abstract int bytesUsed();

    public abstract SortedRanges tryCompactUnsafe(int var1);

    public final SortedRanges tryCompact(int k) {
        if (!this.canWrite()) {
            return this;
        }
        return this.tryCompactUnsafe(k);
    }

    private static int capacityForLastIndex(int lastIndex, int extent, int maxCapacity) {
        int e;
        if (lastIndex >= maxCapacity) {
            return 0;
        }
        if (extent == maxCapacity) {
            return maxCapacity;
        }
        int tgtMinCap = lastIndex + 1;
        if (tgtMinCap < extent) {
            int log2 = 32 - Integer.numberOfLeadingZeros(tgtMinCap);
            int pow2 = 1 << log2 - 1;
            if (tgtMinCap > pow2) {
                pow2 <<= 1;
            }
            if (pow2 <= extent) {
                return pow2;
            }
        }
        if ((e = lastIndex & ~(extent - 1)) < extent) {
            e = extent;
        }
        while (e <= lastIndex) {
            e += extent;
        }
        if (e > maxCapacity) {
            e = maxCapacity;
        }
        return e;
    }

    protected static boolean isLongAllocationSize(int length) {
        return SortedRanges.isAllocationSize(length, LONG_EXTENT);
    }

    protected static boolean isIntAllocationSize(int length) {
        int beforeRounding = length - 1;
        return SortedRanges.isAllocationSize(beforeRounding, INT_EXTENT);
    }

    protected static boolean isShortAllocationSize(int length) {
        int beforeRounding = length - 2;
        return SortedRanges.isAllocationSize(beforeRounding, SHORT_EXTENT);
    }

    private static boolean isAllocationSize(int beforeRounding, int extent) {
        if (beforeRounding > extent) {
            return (beforeRounding & extent - 1) == 0;
        }
        return Integer.bitCount(beforeRounding) == 1;
    }

    final int unpackedBinarySearch(long unpackedTarget, int startPos) {
        long packedTarget = this.pack(unpackedTarget);
        return this.packedBinarySearch(packedTarget, startPos);
    }

    private int packedBinarySearch(long packedTarget, int startPos) {
        long absMaxPosPackedValue;
        int minPos = startPos;
        long absMinPosPackedValue = this.packedGet(minPos);
        if (packedTarget <= absMinPosPackedValue) {
            return packedTarget < absMinPosPackedValue ? ~minPos : minPos;
        }
        int maxPos = this.count - 1;
        long maxPosPackedValue = this.packedGet(maxPos);
        boolean maxPosNeg = maxPosPackedValue < 0L;
        long l = absMaxPosPackedValue = maxPosNeg ? -maxPosPackedValue : maxPosPackedValue;
        if (absMaxPosPackedValue <= packedTarget) {
            if (absMaxPosPackedValue == packedTarget) {
                if (maxPosNeg) {
                    return this.count - 2;
                }
                return this.count - 1;
            }
            return ~this.count;
        }
        while (maxPos - minPos > this.packedValuesPerCacheLine()) {
            long absMidPosPackedValue;
            int midPos = (minPos + maxPos) / 2;
            long midPosPackedValue = this.packedGet(midPos);
            boolean midPosNeg = midPosPackedValue < 0L;
            long l2 = absMidPosPackedValue = midPosNeg ? -midPosPackedValue : midPosPackedValue;
            if (absMidPosPackedValue > packedTarget) {
                maxPos = midPos;
                maxPosNeg = midPosNeg;
                continue;
            }
            if (absMidPosPackedValue < packedTarget) {
                minPos = midPos;
                continue;
            }
            return midPosNeg ? midPos - 1 : midPos;
        }
        for (int i = minPos + 1; i < maxPos; ++i) {
            long absPackedValue;
            long packedValue = this.packedGet(i);
            boolean neg = packedValue < 0L;
            long l3 = absPackedValue = neg ? -packedValue : packedValue;
            if (packedTarget > absPackedValue) continue;
            if (packedTarget == absPackedValue) {
                return neg ? i - 1 : i;
            }
            return neg ? i - 1 : ~i;
        }
        return maxPosNeg ? maxPos - 1 : ~maxPos;
    }

    final int absRawBinarySearch(long packedTarget, int startIdx, int endIdx) {
        long absEndPosPackedValue = this.absPackedGet(endIdx);
        if (absEndPosPackedValue <= packedTarget) {
            if (absEndPosPackedValue == packedTarget) {
                return endIdx;
            }
            return endIdx + 1;
        }
        int maxPos = endIdx;
        long absStartPosPackedValue = this.absPackedGet(startIdx);
        if (packedTarget <= absStartPosPackedValue) {
            return startIdx;
        }
        int minPos = startIdx;
        while (maxPos - minPos > this.packedValuesPerCacheLine()) {
            int midPos = (minPos + maxPos) / 2;
            long absMidPosPackedValue = this.absPackedGet(midPos);
            if (absMidPosPackedValue > packedTarget) {
                maxPos = midPos;
                continue;
            }
            if (absMidPosPackedValue < packedTarget) {
                minPos = midPos;
                continue;
            }
            return midPos;
        }
        for (int i = minPos + 1; i < maxPos; ++i) {
            long absPackedValue = this.absPackedGet(i);
            if (packedTarget > absPackedValue) continue;
            return i;
        }
        return maxPos;
    }

    protected abstract SortedRanges checkSizeAndMoveData(int var1, int var2, int var3, long var4, boolean var6);

    private SortedRanges open(int pos, long packedData, boolean writeCheck) {
        long first = pos == 0 ? this.unpack(packedData) : this.first();
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 1, this.count - pos, first, writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData);
            ++this.count;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, packedData + dOff);
            ans.count = this.count + 1;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    private SortedRanges openNeg(int pos, long packedData, boolean writeCheck) {
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 1, this.count - pos, this.first(), writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData);
            ++this.count;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, -dOff + packedData);
            ans.count = this.count + 1;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    private SortedRanges open(int pos, long packedData1, long packedData2, boolean writeCheck) {
        long first = pos == 0 ? this.unpack(packedData1) : this.first();
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 1, this.count - pos, first, writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData1);
            this.packedSet(pos + 1, packedData2);
            ++this.count;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, packedData1 + dOff);
            ans.packedSet(pos + 1, -dOff + packedData2);
            ans.count = this.count + 1;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    private SortedRanges openNeg(int pos, long packedData1, long packedData2, boolean writeCheck) {
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 1, this.count - pos, this.first(), writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData1);
            this.packedSet(pos + 1, packedData2);
            ++this.count;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, -dOff + packedData1);
            ans.packedSet(pos + 1, packedData2 + dOff);
            ans.count = this.count + 1;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    private SortedRanges open2(int pos, long packedData1, long packedData2, boolean writeCheck) {
        long first = pos == 0 ? this.unpack(packedData1) : this.first();
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 2, this.count - pos, first, writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData1);
            this.packedSet(pos + 1, packedData2);
            this.count += 2;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, packedData1 + dOff);
            ans.packedSet(pos + 1, -dOff + packedData2);
            ans.count = this.count + 2;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    private SortedRanges open2Neg(int pos, long packedData1, long packedData2, boolean writeCheck) {
        long offset = this.unpack(0L);
        SortedRanges ans = this.checkSizeAndMoveData(pos, pos + 2, this.count - pos, this.first(), writeCheck);
        if (ans == null) {
            return null;
        }
        if (ans == this) {
            this.packedSet(pos, packedData1);
            this.packedSet(pos + 1, packedData2);
            this.count += 2;
        } else {
            long dOff = offset - ans.unpack(0L);
            ans.packedSet(pos, -dOff + packedData1);
            ans.packedSet(pos + 1, packedData2 + dOff);
            ans.count = this.count + 2;
            ans.cardinality = this.cardinality;
        }
        return ans;
    }

    protected final void close(int pos) {
        this.moveData(pos + 1, pos, this.count - pos - 1);
        --this.count;
    }

    protected final void close2(int pos) {
        this.moveData(pos + 2, pos, this.count - pos - 2);
        this.count -= 2;
    }

    protected static SortedRanges addPacked(SortedRanges sar, long packedValue, long value, boolean writeCheck) {
        if (sar.count == 0) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.packedSet(0, packedValue);
            sar.count = 1;
            sar.cardinality = 1L;
            return sar;
        }
        int iStart = sar.absRawBinarySearch(packedValue, 0, sar.count - 1);
        return SortedRanges.addPackedWithStart(sar, iStart, packedValue, value, null, writeCheck);
    }

    protected static SortedRanges addPackedWithStart(SortedRanges sar, int iStart, long packedValue, long value, MutableInt iStartOut, boolean writeCheck) {
        long iValue;
        int i = iStart;
        if (i == sar.count) {
            long jValue;
            int j = sar.count - 1;
            long jData = sar.packedGet(j);
            boolean jNeg = jData < 0L;
            long l = jValue = jNeg ? -jData : jData;
            if (jValue == packedValue - 1L) {
                if (jNeg) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    ++sar.cardinality;
                    sar.packedSet(j, -packedValue);
                    if (iStartOut != null) {
                        iStartOut.setValue(j + 1);
                    }
                    if (DEBUG) {
                        sar.validate(packedValue, packedValue);
                    }
                    return sar;
                }
                if ((sar = sar.packedAppend(-packedValue, -value, writeCheck)) == null) {
                    return null;
                }
                ++sar.cardinality;
                if (iStartOut != null) {
                    iStartOut.setValue(sar.count);
                }
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            if ((sar = sar.packedAppend(packedValue, value, writeCheck)) == null) {
                return null;
            }
            ++sar.cardinality;
            if (iStartOut != null) {
                iStartOut.setValue(sar.count);
            }
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        long iData = sar.packedGet(i);
        boolean iNeg = iData < 0L;
        long l = iValue = iNeg ? -iData : iData;
        if (packedValue == iValue || iNeg) {
            return sar;
        }
        boolean mergeToLeftRange = false;
        boolean mergeToLeftSingle = false;
        if (i > 0) {
            long jValue;
            int j = i - 1;
            long jData = sar.packedGet(j);
            boolean jNeg = jData < 0L;
            long l2 = jValue = jNeg ? -jData : jData;
            if (jValue == packedValue - 1L) {
                if (jNeg) {
                    mergeToLeftRange = true;
                } else {
                    mergeToLeftSingle = true;
                }
            }
        }
        boolean mergeToRightRange = false;
        boolean mergeToRightSingle = false;
        if (iValue == packedValue + 1L) {
            if (i < sar.count - 1) {
                boolean jNeg;
                int j = i + 1;
                long jData = sar.packedGet(j);
                boolean bl = jNeg = jData < 0L;
                if (jNeg) {
                    mergeToRightRange = true;
                } else {
                    mergeToRightSingle = true;
                }
            } else {
                mergeToRightSingle = true;
            }
        }
        if (mergeToLeftRange) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            ++sar.cardinality;
            if (mergeToRightRange) {
                sar.close2(i - 1);
                if (iStartOut != null) {
                    iStartOut.setValue(i - 1);
                }
            } else if (mergeToRightSingle) {
                sar.close(i);
                sar.packedSet(i - 1, -(packedValue + 1L));
                if (iStartOut != null) {
                    iStartOut.setValue(i - 2);
                }
            } else {
                sar.packedSet(i - 1, -packedValue);
                if (iStartOut != null) {
                    iStartOut.setValue(i);
                }
            }
        } else if (mergeToLeftSingle) {
            if (mergeToRightRange) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                ++sar.cardinality;
                sar.close(i);
                if (iStartOut != null) {
                    iStartOut.setValue(i);
                }
            } else if (mergeToRightSingle) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                ++sar.cardinality;
                sar.packedSet(i, -(packedValue + 1L));
                if (iStartOut != null) {
                    iStartOut.setValue(i - 1);
                }
            } else {
                if ((sar = sar.openNeg(i, -packedValue, writeCheck)) == null) {
                    return null;
                }
                ++sar.cardinality;
                if (iStartOut != null) {
                    iStartOut.setValue(i + 1);
                }
            }
        } else if (mergeToRightRange) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            ++sar.cardinality;
            sar.packedSet(i, packedValue);
            if (iStartOut != null) {
                iStartOut.setValue(i + 1);
            }
        } else if (mergeToRightSingle) {
            if ((sar = sar.open(i, packedValue, -(packedValue + 1L), writeCheck)) == null) {
                return null;
            }
            ++sar.cardinality;
            if (iStartOut != null) {
                iStartOut.setValue(i);
            }
        } else {
            if ((sar = sar.open(i, packedValue, writeCheck)) == null) {
                return null;
            }
            ++sar.cardinality;
            if (iStartOut != null) {
                iStartOut.setValue(i + 1);
            }
        }
        if (DEBUG) {
            sar.validate(packedValue, packedValue);
        }
        return sar;
    }

    final void collapse(int iDst, int iSrc) {
        if (iSrc <= iDst) {
            return;
        }
        if (iSrc < this.count) {
            this.moveData(iSrc, iDst, this.count - iSrc);
            this.count -= iSrc - iDst;
            return;
        }
        this.count = iDst;
    }

    protected static SortedRanges addRangePacked(SortedRanges sar, long packedStart, long packedEnd, long start, long end, boolean writeCheck) {
        long deltaCard = packedEnd - packedStart + 1L;
        if (deltaCard == 1L) {
            return SortedRanges.addPacked(sar, packedStart, start, writeCheck);
        }
        if (sar.count == 0) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.packedSet(0, packedStart);
            sar.packedSet(1, -packedEnd);
            sar.count = 2;
            sar.cardinality = deltaCard;
            if (DEBUG) {
                sar.validate(packedStart, packedEnd);
            }
            return sar;
        }
        int iStart = sar.absRawBinarySearch(packedStart, 0, sar.count - 1);
        return SortedRanges.addRangePackedWithStart(sar, iStart, packedStart, packedEnd, start, end, deltaCard, null, writeCheck);
    }

    protected static SortedRanges addRangePackedWithStart(SortedRanges sar, int iStart, long packedStart, long packedEnd, long start, long end, long deltaCard, MutableInt iStartOut, boolean writeCheck) {
        int iEnd;
        long iStartValue;
        if (iStart == sar.count) {
            long jValue;
            int j = sar.count - 1;
            long jData = sar.packedGet(j);
            boolean jNeg = jData < 0L;
            long l = jValue = jNeg ? -jData : jData;
            if (jValue == packedStart - 1L) {
                if (jNeg) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    sar.packedSet(j, -packedEnd);
                    sar.cardinality += deltaCard;
                    if (iStartOut != null) {
                        iStartOut.setValue(j + 1);
                    }
                    if (DEBUG) {
                        sar.validate(packedStart, packedEnd);
                    }
                    return sar;
                }
                if ((sar = sar.packedAppend(-packedEnd, -end, writeCheck)) == null) {
                    return null;
                }
                sar.cardinality += deltaCard;
                if (iStartOut != null) {
                    iStartOut.setValue(sar.count);
                }
                if (DEBUG) {
                    sar.validate(packedStart, packedEnd);
                }
                return sar;
            }
            if ((sar = sar.packedAppend2(packedStart, -packedEnd, start, -end, writeCheck)) == null) {
                return null;
            }
            sar.cardinality += deltaCard;
            if (iStartOut != null) {
                iStartOut.setValue(sar.count);
            }
            if (DEBUG) {
                sar.validate(packedStart, packedEnd);
            }
            return sar;
        }
        long iStartData = sar.packedGet(iStart);
        boolean iStartNeg = iStartData < 0L;
        long l = iStartValue = iStartNeg ? -iStartData : iStartData;
        if (packedEnd <= iStartValue && iStartNeg) {
            if (iStartOut != null) {
                iStartOut.setValue(iStart);
            }
            if (DEBUG) {
                sar.validate(packedStart, packedEnd);
            }
            return sar;
        }
        boolean mergeToLeftRange = false;
        boolean mergeToLeftSingle = false;
        if (packedStart == iStartValue) {
            if (++iStart == sar.count) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                if (iStartNeg) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    sar.packedSet(iStart - 1, -packedEnd);
                    if (iStartOut != null) {
                        iStartOut.setValue(sar.count);
                    }
                } else {
                    if ((sar = sar.packedAppend(-packedEnd, -end, writeCheck)) == null) {
                        return null;
                    }
                    if (iStartOut != null) {
                        iStartOut.setValue(sar.count);
                    }
                }
                sar.cardinality += deltaCard - 1L;
                if (DEBUG) {
                    sar.validate(packedStart, packedEnd);
                }
                return sar;
            }
            iStartData = sar.packedGet(iStart);
            if (iStartNeg) {
                mergeToLeftRange = true;
                ++packedStart;
                --deltaCard;
                iStartNeg = false;
                iStartValue = iStartData;
            } else {
                iStartNeg = iStartData < 0L;
                long l2 = iStartValue = iStartNeg ? -iStartData : iStartData;
                if (!iStartNeg) {
                    --deltaCard;
                    mergeToLeftSingle = true;
                } else {
                    if (packedEnd <= -iStartData) {
                        if (iStartOut != null) {
                            iStartOut.setValue(iStart - 1);
                        }
                        if (DEBUG) {
                            sar.validate(packedStart, packedEnd);
                        }
                        return sar;
                    }
                    if (++iStart == sar.count) {
                        if (iStartValue >= packedEnd) {
                            if (iStartOut != null) {
                                iStartOut.setValue(sar.count - 2);
                            }
                            if (DEBUG) {
                                sar.validate(packedStart, packedEnd);
                            }
                            return sar;
                        }
                        if (writeCheck) {
                            sar = (SortedRanges)sar.getWriteRef();
                        }
                        sar.packedSet(sar.count - 1, -packedEnd);
                        if (iStartOut != null) {
                            iStartOut.setValue(sar.count - 2);
                        }
                        sar.cardinality += packedEnd - iStartValue;
                        if (DEBUG) {
                            sar.validate(packedStart, packedEnd);
                        }
                        return sar;
                    }
                    deltaCard -= iStartValue - packedStart + 1L;
                    packedStart = iStartValue + 1L;
                    iStartNeg = false;
                    iStartValue = sar.packedGet(iStart);
                    mergeToLeftRange = true;
                }
            }
        } else if (iStartNeg) {
            if (iStart == sar.count - 1) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.cardinality += packedEnd - iStartValue;
                sar.packedSet(iStart, -packedEnd);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 1);
                }
                if (DEBUG) {
                    sar.validate(packedStart, packedEnd);
                }
                return sar;
            }
            packedStart = iStartValue + 1L;
            deltaCard = packedEnd - packedStart + 1L;
            iStartNeg = false;
            iStartValue = sar.packedGet(++iStart);
            mergeToLeftRange = true;
        } else if (iStart > 0) {
            long jValue;
            int j = iStart - 1;
            long jData = sar.packedGet(j);
            boolean jNeg = jData < 0L;
            long l3 = jValue = jNeg ? -jData : jData;
            if (jValue == packedStart - 1L) {
                if (jNeg) {
                    mergeToLeftRange = true;
                } else {
                    mergeToLeftSingle = true;
                }
            }
        }
        long pendingStart = -1L;
        long betweenCard = 0L;
        boolean mergeToRightRange = false;
        boolean mergeToRightSingle = false;
        int i = iStart;
        boolean iNeg = iStartNeg;
        long iValue = iStartValue;
        while (true) {
            if (packedEnd <= iValue) {
                if (iNeg) {
                    deltaCard -= packedEnd - pendingStart + 1L;
                    packedEnd = pendingStart - 1L;
                    mergeToRightRange = true;
                    iEnd = i - 1;
                } else {
                    if (iValue <= packedEnd + 1L) {
                        if (iValue == packedEnd) {
                            --packedEnd;
                            --deltaCard;
                        }
                        if (i < sar.count - 1) {
                            int j = i + 1;
                            long jData = sar.packedGet(j);
                            if (jData < 0L) {
                                mergeToRightRange = true;
                            } else {
                                mergeToRightSingle = true;
                            }
                        } else {
                            mergeToRightSingle = true;
                        }
                    }
                    if (pendingStart != -1L) {
                        ++betweenCard;
                    }
                    iEnd = i;
                }
                pendingStart = -1L;
                break;
            }
            if (iNeg) {
                betweenCard += iValue - pendingStart + 1L;
                pendingStart = -1L;
            } else {
                if (pendingStart != -1L) {
                    ++betweenCard;
                }
                pendingStart = iValue;
            }
            if (++i == sar.count) {
                iEnd = sar.count;
                break;
            }
            long iData = sar.packedGet(i);
            iNeg = iData < 0L;
            iValue = iNeg ? -iData : iData;
        }
        if (pendingStart != -1L) {
            ++betweenCard;
        }
        int len = iEnd - iStart;
        if (mergeToLeftRange) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            if (mergeToRightRange) {
                sar.collapse(iStart - 1, iEnd + 1);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart - 2);
                }
            } else if (mergeToRightSingle) {
                sar.packedSet(iStart - 1, -(packedEnd + 1L));
                sar.collapse(iStart, iEnd + 1);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart - 2);
                }
            } else {
                sar.packedSet(iStart - 1, -packedEnd);
                sar.collapse(iStart, iEnd);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart);
                }
            }
        } else if (mergeToLeftSingle) {
            if (mergeToRightRange) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.collapse(iStart, iEnd + 1);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart - 1);
                }
            } else if (mergeToRightSingle) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, -(packedEnd + 1L));
                sar.collapse(iStart + 1, iEnd + 1);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart - 1);
                }
            } else if (len > 0) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, -packedEnd);
                sar.collapse(iStart + 1, iEnd);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 1);
                }
            } else {
                if ((sar = sar.openNeg(iStart, -packedEnd, writeCheck)) == null) {
                    return null;
                }
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 1);
                }
            }
        } else if (mergeToRightRange) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.packedSet(iStart, packedStart);
            sar.collapse(iStart + 1, iEnd + 1);
            if (iStartOut != null) {
                iStartOut.setValue(iStart);
            }
        } else if (mergeToRightSingle) {
            if (len > 0) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, packedStart);
                sar.packedSet(iStart + 1, -(packedEnd + 1L));
                sar.collapse(iStart + 2, iEnd + 1);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart);
                }
            } else {
                if ((sar = sar.open(iStart, packedStart, -(packedEnd + 1L), writeCheck)) == null) {
                    return null;
                }
                if (iStartOut != null) {
                    iStartOut.setValue(iStart);
                }
            }
        } else {
            if (len == 0) {
                if ((sar = sar.open2(iStart, packedStart, -packedEnd, writeCheck)) == null) {
                    return null;
                }
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 2);
                }
            } else if (len == 1) {
                if ((sar = sar.open(iStart, packedStart, -packedEnd, writeCheck)) == null) {
                    return null;
                }
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 2);
                }
            } else {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, packedStart);
                sar.packedSet(iStart + 1, -packedEnd);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 2);
                }
            }
            sar.collapse(iStart + 2, iEnd);
        }
        sar.cardinality += deltaCard - betweenCard;
        if (DEBUG) {
            sar.validate(packedStart, packedEnd);
        }
        return sar;
    }

    private static SortedRanges appendUnpacked(SortedRanges sar, long value, boolean writeCheck) {
        if (!sar.fits(value)) {
            return null;
        }
        return SortedRanges.appendPacked(sar, sar.pack(value), value, writeCheck);
    }

    protected static SortedRanges appendPacked(SortedRanges sar, long packedValue, long value, boolean writeCheck) {
        long lastValue;
        if (sar.count == 0) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.cardinality = 1L;
            sar.count = 1;
            sar.packedSet(0, packedValue);
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        long lastData = sar.packedGet(sar.count - 1);
        boolean lastNeg = lastData < 0L;
        long l = lastValue = lastNeg ? -lastData : lastData;
        if (packedValue <= lastValue + 1L) {
            if (packedValue <= lastValue) {
                throw new IllegalArgumentException("Trying to append v=" + packedValue + " when last=" + lastValue);
            }
            if (lastNeg) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(sar.count - 1, -packedValue);
                ++sar.cardinality;
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            if ((sar = sar.packedAppend(-packedValue, -value, writeCheck)) == null) {
                return null;
            }
            ++sar.cardinality;
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        if ((sar = sar.packedAppend(packedValue, value, writeCheck)) == null) {
            return null;
        }
        ++sar.cardinality;
        if (DEBUG) {
            sar.validate(packedValue, packedValue);
        }
        return sar;
    }

    protected static SortedRanges appendRangeUnpacked(SortedRanges sar, long start, long end, boolean writeCheck) {
        if (!sar.fits(start, end)) {
            return null;
        }
        return SortedRanges.appendRangePacked(sar, sar.pack(start), sar.pack(end), start, end, writeCheck);
    }

    protected static SortedRanges appendRangePacked(SortedRanges sar, long packedStart, long packedEnd, long start, long end, boolean writeCheck) {
        long lastValue;
        long deltaCard = packedEnd - packedStart + 1L;
        if (deltaCard == 1L) {
            return SortedRanges.appendPacked(sar, packedStart, start, writeCheck);
        }
        if (sar.count == 0) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.packedSet(0, packedStart);
            sar.packedSet(1, -packedEnd);
            sar.cardinality = deltaCard;
            sar.count = 2;
            if (DEBUG) {
                sar.validate(packedStart, packedEnd);
            }
            return sar;
        }
        long lastData = sar.packedGet(sar.count - 1);
        boolean lastNeg = lastData < 0L;
        long l = lastValue = lastNeg ? -lastData : lastData;
        if (packedStart <= lastValue + 1L) {
            if (packedStart <= lastValue) {
                throw new IllegalArgumentException("Trying to append start=" + packedStart + " end=" + packedEnd + " when last=" + lastValue);
            }
            if (lastNeg) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.cardinality += deltaCard;
                sar.packedSet(sar.count - 1, -packedEnd);
                if (DEBUG) {
                    sar.validate(packedStart, packedEnd);
                }
                return sar;
            }
            if ((sar = sar.packedAppend(-packedEnd, -end, writeCheck)) == null) {
                return null;
            }
            sar.cardinality += deltaCard;
            if (DEBUG) {
                sar.validate(packedStart, packedEnd);
            }
            return sar;
        }
        if ((sar = sar.packedAppend2(packedStart, -packedEnd, start, -end, writeCheck)) == null) {
            return null;
        }
        sar.cardinality += deltaCard;
        if (DEBUG) {
            sar.validate(packedStart, packedEnd);
        }
        return sar;
    }

    protected static SortedRanges removePacked(SortedRanges sar, long packedValue, long value) {
        long iValue;
        long jValue;
        if (sar.count == 0) {
            return sar;
        }
        int j = sar.count - 1;
        long jData = sar.packedGet(j);
        boolean jNeg = jData < 0L;
        long l = jValue = jNeg ? -jData : jData;
        if (jValue <= packedValue) {
            if (jValue < packedValue) {
                return sar;
            }
            sar = (SortedRanges)sar.getWriteRef();
            --sar.cardinality;
            if (jNeg) {
                int i = j - 1;
                long iValue2 = sar.packedGet(i);
                if (iValue2 == packedValue - 1L) {
                    --sar.count;
                    if (DEBUG) {
                        sar.validate(packedValue, packedValue);
                    }
                    return sar;
                }
                sar.packedSet(j, -(packedValue - 1L));
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            --sar.count;
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        int i = 0;
        long iData = sar.packedGet(i);
        boolean iNeg = iData < 0L;
        long l2 = iValue = iNeg ? -iData : iData;
        if (packedValue <= iValue) {
            if (packedValue < iValue) {
                return sar;
            }
            sar = (SortedRanges)sar.getWriteRef();
            --sar.cardinality;
            j = i + 1;
            jData = sar.packedGet(j);
            boolean bl = jNeg = jData < 0L;
            if (!jNeg) {
                sar.close(i);
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            jValue = -jData;
            if (packedValue + 1L == jValue) {
                sar.close(i);
                sar.packedSet(i, jValue);
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            sar.packedSet(i, packedValue + 1L);
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        if (sar.count == 2) {
            if (!jNeg) {
                return sar;
            }
        } else {
            j = sar.absRawBinarySearch(packedValue, 1, sar.count - 2);
            jData = sar.packedGet(j);
            jNeg = jData < 0L;
            long l3 = jValue = jNeg ? -jData : jData;
            if (jValue == packedValue) {
                sar = (SortedRanges)sar.getWriteRef();
                --sar.cardinality;
                if (!jNeg) {
                    i = j + 1;
                    iData = sar.packedGet(i);
                    boolean bl = iNeg = iData < 0L;
                    if (!iNeg) {
                        sar.close(j);
                        if (DEBUG) {
                            sar.validate(packedValue, packedValue);
                        }
                        return sar;
                    }
                    iValue = -iData;
                    if (packedValue + 1L == iValue) {
                        sar.close(j);
                        sar.packedSet(j, iValue);
                        if (DEBUG) {
                            sar.validate(packedValue, packedValue);
                        }
                        return sar;
                    }
                    sar.packedSet(j, packedValue + 1L);
                    return sar;
                }
                i = j - 1;
                iValue = sar.packedGet(i);
                if (iValue == packedValue - 1L) {
                    sar.close(j);
                    if (DEBUG) {
                        sar.validate(packedValue, packedValue);
                    }
                    return sar;
                }
                sar.packedSet(j, -(packedValue - 1L));
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            if (!jNeg) {
                return sar;
            }
            i = j - 1;
            iValue = sar.packedGet(i);
        }
        if (iValue == packedValue - 1L) {
            if (jValue == packedValue + 1L) {
                sar = (SortedRanges)sar.getWriteRef();
                --sar.cardinality;
                sar.packedSet(j, jValue);
                if (DEBUG) {
                    sar.validate(packedValue, packedValue);
                }
                return sar;
            }
            if ((sar = sar.open(j, packedValue + 1L, true)) == null) {
                return null;
            }
            --sar.cardinality;
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        if (jValue == packedValue + 1L) {
            if ((sar = sar.openNeg(j, -(packedValue - 1L), jValue, true)) == null) {
                return null;
            }
            --sar.cardinality;
            if (DEBUG) {
                sar.validate(packedValue, packedValue);
            }
            return sar;
        }
        if ((sar = sar.open2Neg(j, -(packedValue - 1L), packedValue + 1L, true)) == null) {
            return null;
        }
        --sar.cardinality;
        if (DEBUG) {
            sar.validate(packedValue, packedValue);
        }
        return sar;
    }

    protected static SortedRanges removeRangePacked(SortedRanges sar, long packedStart, long packedEnd, long start, long end) {
        int iStart = sar.absRawBinarySearch(packedStart, 0, sar.count - 1);
        return SortedRanges.removeRangePackedWithStart(sar, iStart, packedStart, packedEnd, start, end, null, true);
    }

    protected static SortedRanges removeRangePackedWithStart(SortedRanges sar, int iStart, long packedStart, long packedEnd, long start, long end, MutableInt iStartOut, boolean writeCheck) {
        long pre;
        long iStartValue;
        if (iStart >= sar.count) {
            if (iStartOut != null) {
                iStartOut.setValue(sar.count);
            }
            return sar;
        }
        long iStartData = sar.packedGet(iStart);
        boolean iStartNeg = iStartData < 0L;
        long l = iStartValue = iStartNeg ? -iStartData : iStartData;
        if (iStart == 0 && packedEnd < iStartValue) {
            return sar;
        }
        boolean truncateLeftRange = false;
        long deltaCard = 0L;
        long pendingStart = -1L;
        if (iStartValue == packedStart) {
            if (iStartNeg) {
                pre = sar.packedGet(iStart - 1);
                if (pre < packedStart - 1L) {
                    truncateLeftRange = true;
                }
                if (iStart + 1 >= sar.count) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    if (truncateLeftRange) {
                        sar.packedSet(iStart, -(packedStart - 1L));
                        --sar.cardinality;
                        if (iStartOut != null) {
                            iStartOut.setValue(iStart + 1);
                        }
                        if (DEBUG) {
                            sar.validate(packedStart, packedEnd);
                        }
                        return sar;
                    }
                    --sar.count;
                    --sar.cardinality;
                    if (iStartOut != null) {
                        iStartOut.setValue(sar.count);
                    }
                    if (DEBUG) {
                        sar.validate(packedStart, packedEnd);
                    }
                    return sar;
                }
                pendingStart = iStartValue;
            } else if (iStart + 1 >= sar.count) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                --sar.count;
                --sar.cardinality;
                if (iStartOut != null) {
                    iStartOut.setValue(sar.count);
                }
                if (DEBUG) {
                    sar.validate(packedStart, packedEnd);
                }
                return sar;
            }
        } else if (iStartNeg) {
            deltaCard = Math.min(packedEnd, iStartValue) - packedStart + 1L;
            pre = sar.packedGet(iStart - 1);
            if (pre < packedStart - 1L) {
                truncateLeftRange = true;
            }
        }
        boolean truncateRightRange = false;
        boolean truncateRightSingle = false;
        int i = iStart;
        boolean iNeg = iStartNeg;
        long iValue = iStartValue;
        int iEndExclusive = -1;
        while (true) {
            if (packedEnd <= iValue) {
                boolean nextNeg;
                if (iNeg) {
                    if (pendingStart != -1L) {
                        deltaCard += packedEnd - pendingStart + 1L;
                    }
                    if (packedEnd < iValue) {
                        if (iValue > packedEnd + 1L) {
                            truncateRightRange = true;
                        } else {
                            truncateRightSingle = true;
                        }
                        iEndExclusive = i;
                        break;
                    }
                    iEndExclusive = i + 1;
                    break;
                }
                if (pendingStart != -1L) {
                    ++deltaCard;
                }
                if (packedEnd < iValue) {
                    iEndExclusive = i;
                    break;
                }
                ++deltaCard;
                iEndExclusive = i + 1;
                if (iEndExclusive >= sar.count) break;
                long nextData = sar.packedGet(iEndExclusive);
                boolean bl = nextNeg = nextData < 0L;
                if (!nextNeg) break;
                long nextValue = -nextData;
                if (nextValue > packedEnd + 1L) {
                    truncateRightRange = true;
                    break;
                }
                truncateRightSingle = true;
                break;
            }
            if (iNeg) {
                if (pendingStart != -1L) {
                    deltaCard += iValue - pendingStart + 1L;
                    pendingStart = -1L;
                }
            } else {
                if (pendingStart != -1L) {
                    ++deltaCard;
                }
                pendingStart = iValue;
            }
            if (++i >= sar.count) {
                iEndExclusive = i;
                if (pendingStart == -1L) break;
                ++deltaCard;
                break;
            }
            long iData = sar.packedGet(i);
            iNeg = iData < 0L;
            iValue = iNeg ? -iData : iData;
        }
        int len = iEndExclusive - iStart;
        if (truncateLeftRange) {
            if (truncateRightRange) {
                if (len > 1) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    sar.packedSet(iStart, -(packedStart - 1L));
                    sar.packedSet(iStart + 1, packedEnd + 1L);
                    sar.collapse(iStart + 2, iEndExclusive);
                    if (iStartOut != null) {
                        iStartOut.setValue(iStart + 1);
                    }
                } else {
                    if ((sar = sar.open2Neg(iStart, -(packedStart - 1L), packedEnd + 1L, writeCheck)) == null) {
                        return null;
                    }
                    if (iStartOut != null) {
                        iStartOut.setValue(iStart + 1);
                    }
                }
            } else if (truncateRightSingle) {
                if (len > 0) {
                    if (writeCheck) {
                        sar = (SortedRanges)sar.getWriteRef();
                    }
                    sar.packedSet(iStart, -(packedStart - 1L));
                    sar.packedSet(iStart + 1, packedEnd + 1L);
                    sar.collapse(iStart + 2, iEndExclusive + 1);
                    if (iStartOut != null) {
                        iStartOut.setValue(iStart + 1);
                    }
                } else {
                    if ((sar = sar.openNeg(iStart, -(packedStart - 1L), packedEnd + 1L, writeCheck)) == null) {
                        return null;
                    }
                    if (iStartOut != null) {
                        iStartOut.setValue(iStart + 1);
                    }
                }
            } else {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, -(packedStart - 1L));
                sar.collapse(iStart + 1, iEndExclusive);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 1);
                }
            }
        } else if (truncateRightRange) {
            if (len > 0) {
                if (writeCheck) {
                    sar = (SortedRanges)sar.getWriteRef();
                }
                sar.packedSet(iStart, packedEnd + 1L);
                sar.collapse(iStart + 1, iEndExclusive);
                if (iStartOut != null) {
                    iStartOut.setValue(iStart + 1);
                }
            } else {
                if ((sar = sar.open(iEndExclusive, packedEnd + 1L, writeCheck)) == null) {
                    return null;
                }
                if (iStartOut != null) {
                    iStartOut.setValue(iEndExclusive);
                }
            }
        } else if (truncateRightSingle) {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.packedSet(iStart, packedEnd + 1L);
            sar.collapse(iStart + 1, iEndExclusive + 1);
            if (iStartOut != null) {
                iStartOut.setValue(iStart + 1);
            }
        } else {
            if (writeCheck) {
                sar = (SortedRanges)sar.getWriteRef();
            }
            sar.collapse(iStart, iEndExclusive);
            if (iStartOut != null) {
                iStartOut.setValue(iStart);
            }
        }
        sar.cardinality -= deltaCard;
        if (DEBUG) {
            sar.validate(packedStart, packedEnd);
        }
        return sar;
    }

    protected final void validate(long iv1, long iv2) {
        this.validate(null, iv1, iv2);
    }

    protected final void validate(String strArg, long iv1, long iv2) {
        Object str = strArg == null ? "" : strArg + " ";
        String msg = (String)str + "(" + iv1 + "," + iv2 + ")";
        long sz = 0L;
        boolean eprev = false;
        long vprev = -1L;
        for (int i = 0; i < this.count; ++i) {
            long vi;
            String cmsg = "i=" + i + msg;
            long di = this.packedGet(i);
            boolean ei = di < 0L;
            long l = vi = ei ? -di : di;
            if (i == 0) {
                if (ei) {
                    throw new IllegalStateException(cmsg + ": negative at i=0");
                }
                ++sz;
            } else {
                if (ei) {
                    if (eprev) {
                        throw new IllegalStateException(cmsg + ": two consecutive negatives i=" + i);
                    }
                    long delta = vi - vprev;
                    if (delta < 1L) {
                        throw new IllegalStateException(cmsg + ": range delta=" + delta + " at i=" + i);
                    }
                    sz += delta;
                } else {
                    if (vi - vprev < 2L) {
                        throw new IllegalStateException(cmsg + ": adjacent not merged at i=" + i);
                    }
                    ++sz;
                }
                if (vprev >= vi) {
                    throw new IllegalStateException(cmsg + ": out of order at i=" + i);
                }
            }
            eprev = ei;
            vprev = vi;
        }
        if (sz != this.cardinality) {
            throw new IllegalStateException(msg + " wrong cardinality=" + this.cardinality + " should be " + sz);
        }
    }

    static void checkEquals(OrderedLongSet expected, OrderedLongSet ans) {
        SortedRanges.checkEquals(expected, ans, null);
    }

    static void checkEquals(OrderedLongSet expected, OrderedLongSet ans, OrderedLongSet orig) {
        ans.ixValidate();
        long expCard = expected.ixCardinality();
        long ansCard = ans.ixCardinality();
        boolean failedCard = expCard != ansCard;
        boolean expSubset = expected.ixSubsetOf(ans);
        boolean ansSubset = ans.ixSubsetOf(expected);
        if (failedCard || !expSubset || !ansSubset) {
            throw new IllegalStateException((failedCard ? "cardinality" : "subset") + " check failed for for expected(" + expCard + ")=" + expected + ", ans(" + ansCard + ")=" + ans + (String)(orig == null ? "" : ", orig(" + orig.ixCardinality() + ")=" + orig));
        }
    }

    @Override
    public final SortedRanges ixCowRef() {
        return (SortedRanges)this.cowRef();
    }

    @Override
    public final void ixRelease() {
        this.release();
    }

    @Override
    public final int ixRefCount() {
        return this.refCount();
    }

    @Override
    public final OrderedLongSet ixInsert(long key) {
        SortedRanges ans = this.add(key);
        if (ans != null) {
            return ans;
        }
        RspBitmap rb = this.ixToRspOnNew();
        rb.addUnsafeNoWriteCheck(key);
        rb.finishMutations();
        return rb;
    }

    @Override
    public final OrderedLongSet ixInsertRange(long startKey, long endKey) {
        SortedRanges ans = this.addRange(startKey, endKey);
        if (ans != null) {
            return ans;
        }
        RspBitmap rb = this.ixToRspOnNew();
        rb.addRangeUnsafeNoWriteCheck(startKey, endKey);
        rb.finishMutations();
        return rb;
    }

    @Override
    public final OrderedLongSet ixInsertSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        return this.ixInsert(OrderedLongSet.fromChunk(keys, offset, length, true));
    }

    @Override
    public final OrderedLongSet ixRemoveSecondHalf(LongChunk<OrderedRowKeys> keys, int offset, int length) {
        return this.ixRemove(OrderedLongSet.fromChunk(keys, offset, length, true));
    }

    @Override
    public final OrderedLongSet ixAppendRange(long startKey, long endKey) {
        SortedRanges ans = this.appendRange(startKey, endKey);
        if (ans != null) {
            return ans;
        }
        RspBitmap rb = this.ixToRspOnNew();
        rb.appendRangeUnsafeNoWriteCheck(startKey, endKey);
        rb.finishMutations();
        return rb;
    }

    @Override
    public final OrderedLongSet ixRemove(long key) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        SortedRanges ans = this.remove(key);
        if (ans != null) {
            if (ans.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            return ans;
        }
        RspBitmap rb = this.ixToRspOnNew();
        rb.removeUnsafeNoWriteCheck(key);
        rb.finishMutations();
        return rb;
    }

    @Override
    public final long ixLastKey() {
        return this.isEmpty() ? -1L : this.last();
    }

    @Override
    public final long ixFirstKey() {
        return this.isEmpty() ? -1L : this.first();
    }

    @Override
    public final boolean ixForEachLong(LongAbortableConsumer lc) {
        return this.forEachLong(lc);
    }

    @Override
    public final boolean ixForEachLongRange(LongRangeAbortableConsumer lrac) {
        return this.forEachLongRange(lrac);
    }

    @Override
    public final OrderedLongSet ixSubindexByPosOnNew(long startPos, long endPosExclusive) {
        if (endPosExclusive <= startPos || endPosExclusive <= 0L || startPos >= this.getCardinality()) {
            return OrderedLongSet.EMPTY;
        }
        if (startPos == 0L && endPosExclusive >= this.getCardinality()) {
            return (OrderedLongSet)this.cowRef();
        }
        SortedRanges ans = this.subRangesByPos(startPos, endPosExclusive - 1L);
        return ans;
    }

    @Override
    public final OrderedLongSet ixSubindexByKeyOnNew(long startKey, long endKey) {
        SortedRanges ans = this.subRangesByKey(startKey, endKey);
        if (ans == null) {
            return OrderedLongSet.EMPTY;
        }
        return ans;
    }

    @Override
    public final long ixGet(long pos) {
        return this.get(pos);
    }

    @Override
    public final void ixGetKeysForPositions(PrimitiveIterator.OfLong inputPositions, LongConsumer outputKeys) {
        this.getKeysForPositions(inputPositions, outputKeys);
    }

    @Override
    public final long ixFind(long key) {
        return this.find(key);
    }

    @Override
    public final RowSet.Iterator ixIterator() {
        return this.getIterator();
    }

    @Override
    public final RowSet.SearchIterator ixSearchIterator() {
        return this.getSearchIterator();
    }

    @Override
    public final RowSet.SearchIterator ixReverseIterator() {
        return this.getReverseIterator();
    }

    @Override
    public final RowSet.RangeIterator ixRangeIterator() {
        return this.getRangeIterator();
    }

    @Override
    public final long ixCardinality() {
        return this.getCardinality();
    }

    @Override
    public final boolean ixIsEmpty() {
        return this.isEmpty();
    }

    @Override
    public final OrderedLongSet ixUpdate(OrderedLongSet added, OrderedLongSet removed) {
        if (this.isEmpty()) {
            return added.ixCowRef();
        }
        if (!removed.ixIsEmpty()) {
            if (removed instanceof SingleRange) {
                OrderedLongSet removeResult = this.ixRemoveRange(removed.ixFirstKey(), removed.ixLastKey());
                return removeResult.ixInsert(added);
            }
            OrderedLongSet ans = this.remove(removed);
            if (ans == null) {
                return this.ixToRspOnNew().ixUpdateNoWriteCheck(added, removed);
            }
            return ans.ixInsert(added);
        }
        if (added.ixIsEmpty()) {
            return this;
        }
        if (added instanceof SingleRange) {
            return this.ixInsertRange(added.ixFirstKey(), added.ixLastKey());
        }
        if (added instanceof SortedRanges) {
            SortedRanges addedSar = (SortedRanges)added;
            return this.insertImpl(addedSar);
        }
        return this.ixToRspOnNew().ixUpdate(added, removed);
    }

    @Override
    public final OrderedLongSet ixRemove(OrderedLongSet removed) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (removed.ixIsEmpty()) {
            return this;
        }
        if (removed instanceof SingleRange) {
            return this.ixRemoveRange(removed.ixFirstKey(), removed.ixLastKey());
        }
        OrderedLongSet ans = this.remove(removed);
        if (ans != null) {
            return ans;
        }
        return this.toRsp().ixRemoveNoWriteCheck(removed);
    }

    public final OrderedLongSet remove(OrderedLongSet removed) {
        if (!USE_RANGES_ARRAY) {
            try (RowSet.RangeIterator removedIter = removed.ixRangeIterator();){
                MutableObject holder = new MutableObject((Object)this);
                boolean valid = SortedRanges.removeLegacy((MutableObject<SortedRanges>)holder, removedIter);
                if (!valid) {
                    OrderedLongSet orderedLongSet = null;
                    return orderedLongSet;
                }
                SortedRanges ans = (SortedRanges)holder.getValue();
                if (ans.isEmpty()) {
                    OrderedLongSet orderedLongSet = OrderedLongSet.EMPTY;
                    return orderedLongSet;
                }
                SortedRanges sortedRanges = ans;
                return sortedRanges;
            }
        }
        SortedRangesLong sr = SortedRanges.intersect(this, removed, true);
        if (sr == null) {
            return null;
        }
        return SortedRanges.makeOrderedLongSetFromLongRangesArray((long[])sr.data, sr.count, sr.cardinality, this.canWrite() ? this : null);
    }

    @Override
    public final OrderedLongSet ixRemoveRange(long startKey, long endKey) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        SortedRanges ans = this.removeRange(startKey, endKey);
        if (ans == null) {
            RspBitmap rb = this.ixToRspOnNew();
            rb.removeRangeUnsafeNoWriteCheck(startKey, endKey);
            rb.finishMutations();
            return rb;
        }
        if (ans.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        return ans;
    }

    @Override
    public final OrderedLongSet ixRetain(OrderedLongSet toIntersect) {
        if (toIntersect.ixIsEmpty() || this.isEmpty() || toIntersect.ixLastKey() < this.first() || this.last() < toIntersect.ixFirstKey()) {
            return OrderedLongSet.EMPTY;
        }
        if (!this.canWrite()) {
            OrderedLongSet ix = this.ixIntersectOnNew(toIntersect);
            return ix;
        }
        if (toIntersect instanceof SingleRange) {
            return this.ixRetainRange(toIntersect.ixFirstKey(), toIntersect.ixLastKey());
        }
        if (toIntersect instanceof SortedRanges) {
            return this.retain(toIntersect);
        }
        return this.ixToRspOnNew().ixRetainNoWriteCheck(toIntersect);
    }

    @Override
    public final OrderedLongSet ixRetainRange(long start, long end) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        long first = this.first();
        if (end < first) {
            return OrderedLongSet.EMPTY;
        }
        long last = this.last();
        if (last < start) {
            return OrderedLongSet.EMPTY;
        }
        SortedRanges ans = this.retainRange(Math.max(start, first), Math.min(end, last));
        if (ans == null) {
            return this.ixToRspOnNew().ixRetainRangeNoWriteCheck(start, end);
        }
        if (ans.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        return ans;
    }

    @Override
    public final OrderedLongSet ixIntersectOnNew(OrderedLongSet toIntersect) {
        if (toIntersect instanceof SingleRange) {
            return this.ixSubindexByKeyOnNew(toIntersect.ixFirstKey(), toIntersect.ixLastKey());
        }
        return this.intersectOnNew(toIntersect);
    }

    public final OrderedLongSet intersectOnNew(OrderedLongSet toIntersect) {
        if (this.isEmpty() || toIntersect.ixIsEmpty() || this.last() < toIntersect.ixFirstKey() || toIntersect.ixLastKey() < this.first()) {
            return OrderedLongSet.EMPTY;
        }
        if (!USE_RANGES_ARRAY) {
            RowSet.RangeIterator rangeIter = toIntersect.ixRangeIterator();
            rangeIter.advance(this.first());
            long last = this.last();
            SortedRanges sr = SortedRanges.intersectLegacy(this, last, rangeIter);
            if (sr != null) {
                return sr;
            }
        } else {
            OrderedLongSet ans = this.intersectOnNewImpl(toIntersect);
            if (ans != null) {
                return ans;
            }
        }
        return this.ixToRspOnNew().ixRetainNoWriteCheck(toIntersect);
    }

    @Override
    public final boolean ixContainsRange(long start, long end) {
        return this.containsRange(start, end);
    }

    @Override
    public final boolean ixOverlaps(OrderedLongSet impl) {
        if (impl.ixIsEmpty()) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (impl instanceof SingleRange) {
            return this.overlapsRange(impl.ixFirstKey(), impl.ixLastKey());
        }
        RowSet.RangeIterator it = impl.ixRangeIterator();
        return this.overlaps(it);
    }

    @Override
    public final boolean ixOverlapsRange(long start, long end) {
        return this.overlapsRange(start, end);
    }

    @Override
    public final boolean ixSubsetOf(OrderedLongSet other) {
        long otherFirst;
        if (this.isEmpty()) {
            return true;
        }
        if (other.ixIsEmpty()) {
            return false;
        }
        long last = this.last();
        if (last < (otherFirst = other.ixFirstKey())) {
            return false;
        }
        long first = this.first();
        long otherLast = other.ixLastKey();
        if (otherLast < first) {
            return false;
        }
        if (other instanceof SingleRange) {
            return otherFirst <= first && last <= otherLast;
        }
        if (this.getCardinality() > other.ixCardinality()) {
            return false;
        }
        RowSet.RangeIterator rit = other.ixRangeIterator();
        return this.subsetOf(rit);
    }

    @Override
    public final OrderedLongSet ixMinusOnNew(OrderedLongSet other) {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (other.ixIsEmpty() || this.last() < other.ixFirstKey() || other.ixLastKey() < this.first()) {
            return (OrderedLongSet)this.cowRef();
        }
        if (other instanceof SingleRange) {
            SortedRanges ans = this.deepCopy();
            if ((ans = ans.removeRange(other.ixFirstKey(), other.ixLastKey())) != null) {
                return ans;
            }
        } else {
            OrderedLongSet ans = this.minusOnNew(other);
            if (ans != null) {
                return ans;
            }
        }
        return this.ixToRspOnNew().ixRemoveNoWriteCheck(other);
    }

    @Override
    public final OrderedLongSet ixUnionOnNew(OrderedLongSet other) {
        SortedRanges otherSar;
        OrderedLongSet out;
        if (other.ixIsEmpty()) {
            if (this.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            return (OrderedLongSet)this.cowRef();
        }
        if (this.isEmpty()) {
            return other.ixCowRef();
        }
        if (other instanceof SingleRange) {
            long start = other.ixFirstKey();
            long end = other.ixLastKey();
            SortedRanges ans = this.deepCopy();
            if ((ans = ans.addRange(start, end)) != null) {
                return ans;
            }
            RspBitmap rb = this.ixToRspOnNew();
            rb.addRangeUnsafeNoWriteCheck(start, end);
            rb.finishMutations();
            return rb;
        }
        if (other instanceof SortedRanges && (out = SortedRanges.unionOnNew(this, otherSar = (SortedRanges)other)) != null) {
            return out;
        }
        return this.ixToRspOnNew().ixInsertNoWriteCheck(other);
    }

    @Override
    public final OrderedLongSet ixShiftOnNew(long shiftAmount) {
        SortedRanges ans = this.applyShiftOnNew(shiftAmount);
        if (ans != null) {
            return ans;
        }
        return this.toRsp().applyOffsetNoWriteCheck(shiftAmount);
    }

    @Override
    public final OrderedLongSet ixShiftInPlace(long shiftAmount) {
        SortedRanges ans = this.applyShift(shiftAmount);
        if (ans != null) {
            return ans;
        }
        return this.toRsp().applyOffsetNoWriteCheck(shiftAmount);
    }

    @Override
    public final OrderedLongSet ixInsertWithShift(long shiftAmount, OrderedLongSet other) {
        if (other.ixIsEmpty()) {
            return this;
        }
        if (this.ixIsEmpty()) {
            return other.ixShiftOnNew(shiftAmount);
        }
        if (other instanceof SingleRange) {
            long end;
            long start = other.ixFirstKey() + shiftAmount;
            SortedRanges ans = this.addRange(start, end = other.ixLastKey() + shiftAmount);
            if (ans != null) {
                return ans;
            }
            RspBitmap rspAns = this.toRsp();
            rspAns.addRangeUnsafeNoWriteCheck(start, end);
            rspAns.finishMutations();
            return rspAns;
        }
        if (other instanceof SortedRanges) {
            SortedRanges sr = (SortedRanges)other;
            sr = sr.applyShiftOnNew(shiftAmount);
            return this.ixInsertImpl(sr);
        }
        RspBitmap rsp = (RspBitmap)other;
        rsp = (RspBitmap)rsp.applyOffsetOnNew(shiftAmount).getWriteRef();
        rsp.insertOrderedLongSetUnsafeNoWriteCheck(this);
        rsp.finishMutations();
        return rsp;
    }

    private OrderedLongSet ixInsertImpl(SortedRanges addedSar) {
        return this.insertImpl(addedSar);
    }

    @Override
    public final OrderedLongSet ixInsert(OrderedLongSet added) {
        if (added.ixIsEmpty()) {
            if (this.isEmpty()) {
                return OrderedLongSet.EMPTY;
            }
            return this;
        }
        if (this.isEmpty()) {
            return added.ixCowRef();
        }
        if (added instanceof SingleRange) {
            SortedRanges ans = this.addRange(added.ixFirstKey(), added.ixLastKey());
            if (ans != null) {
                return ans;
            }
            RspBitmap rb = this.ixToRspOnNew();
            rb.addRangeUnsafeNoWriteCheck(added.ixFirstKey(), added.ixLastKey());
            rb.finishMutations();
            return rb;
        }
        if (added instanceof SortedRanges) {
            SortedRanges addedSar = (SortedRanges)added;
            return this.ixInsertImpl(addedSar);
        }
        RspBitmap rsp = this.ixToRspOnNew();
        rsp.orEqualsUnsafeNoWriteCheck((RspBitmap)added);
        rsp.finishMutations();
        return rsp;
    }

    @Override
    public final RowSequence ixGetRowSequenceByPosition(long startPositionInclusive, long length) {
        return this.getRowSequenceByPosition(startPositionInclusive, length);
    }

    @Override
    public final RowSequence ixGetRowSequenceByKeyRange(long startKeyInclusive, long endKeyInclusive) {
        return this.getRowSequenceByKeyRange(startKeyInclusive, endKeyInclusive);
    }

    @Override
    public final RowSequence.Iterator ixGetRowSequenceIterator() {
        return this.getRowSequenceIterator();
    }

    @Override
    public final long ixRangesCountUpperBound() {
        return this.count();
    }

    @Override
    public final long ixGetAverageRunLengthEstimate() {
        return this.getAverageRunLengthEstimate();
    }

    @Override
    public final RspBitmap ixToRspOnNew() {
        return this.toRsp();
    }

    public final RspBitmap toRsp() {
        RspBitmap rsp = new RspBitmap();
        this.forEachLongRange((start, end) -> {
            rsp.appendRangeUnsafeNoWriteCheck(start, end);
            return true;
        });
        rsp.finishMutations();
        sortedRangesToRspConversions.sample(1);
        return rsp;
    }

    @Override
    public final OrderedLongSet ixInvertOnNew(OrderedLongSet keys, long maxPosition) {
        if (keys.ixIsEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (keys instanceof SingleRange) {
            OrderedLongSet r = this.invertRangeOnNew(keys.ixFirstKey(), keys.ixLastKey(), maxPosition);
            if (r != null) {
                return r;
            }
        } else {
            OrderedLongSetBuilderSequential builder;
            RowSet.RangeIterator rit = keys.ixRangeIterator();
            if (this.invertOnNew(rit, builder = new OrderedLongSetBuilderSequential(), maxPosition)) {
                return builder.getOrderedLongSet();
            }
        }
        throw new IllegalArgumentException("keys argument has elements not in the rowSet");
    }

    @Override
    public final OrderedLongSet ixCompact() {
        if (this.isEmpty()) {
            return OrderedLongSet.EMPTY;
        }
        if (!this.hasMoreThanOneRange()) {
            return SingleRange.make(this.first(), this.last());
        }
        return this.tryCompact(4);
    }

    @Override
    public final void ixValidate(String failMsg) {
        this.validate(failMsg, -1L, -1L);
    }

    static {
        Assert.assertion((ELEMENTS_PER_BLOCK_DENSE_THRESHOLD >= 2 ? 1 : 0) != 0, (String)"ELEMENTS_PER_BLOCK_DENSE_THRESHOLD >= 2");
        Assert.assertion((LONG_DENSE_MAX_CAPACITY <= LONG_SPARSE_MAX_CAPACITY ? 1 : 0) != 0, (String)"LONG_DENSE_MAX_CAPACITY <= LONG_SPARSE_MAX_CAPACITY");
        Assert.assertion((INT_DENSE_MAX_CAPACITY <= INT_SPARSE_MAX_CAPACITY ? 1 : 0) != 0, (String)"INT_DENSE_MAX_CAPACITY <= INT_SPARSE_MAX_CAPACITY");
        Assert.assertion((LONG_SPARSE_MAX_CAPACITY <= INT_SPARSE_MAX_CAPACITY ? 1 : 0) != 0, (String)"LONG_SPARSE_MAX_CAPACITY <= INT_SPARSE_MAX_CAPACITY");
        Assert.assertion((LONG_DENSE_MAX_CAPACITY <= INT_DENSE_MAX_CAPACITY ? 1 : 0) != 0, (String)"LONG_DENSE_MAX_CAPACITY <= INT_DENSE_MAX_CAPACITY");
        LONG_EXTENT = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "longExtent", 64);
        INT_EXTENT = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "intExtent", 2 * LONG_EXTENT);
        SHORT_EXTENT = Configuration.getInstance().getIntegerForClassWithDefault(SortedRanges.class, "shortExtent", 2 * INT_EXTENT);
        POOL_ARRAYS = Configuration.getInstance().getBooleanForClassWithDefault(SortedRanges.class, "poolArrays", false);
        USE_RANGES_ARRAY = Configuration.getInstance().getBooleanForClassWithDefault(SortedRanges.class, "useRangesArray", true);
        workSortedRangesLongPerThread = ThreadLocal.withInitial(() -> new SortedRangesLong(new long[MAX_CAPACITY], 0, 0L));
    }

    private static final class ReverseIterator
    implements RowSet.SearchIterator {
        private int nextRangeIdx = -1;
        private long rangeCurr = -1L;
        private long rangeStart = -1L;
        private SortedRanges sar;

        private ReverseIterator(SortedRanges sar) {
            if (sar.isEmpty()) {
                this.sar = null;
                return;
            }
            sar.acquire();
            this.sar = sar;
            this.nextRangeIdx = sar.count - 1;
        }

        public void close() {
            if (this.sar != null) {
                this.sar.release();
                this.sar = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.rangeCurr > this.rangeStart || this.nextRangeIdx >= 0;
        }

        @Override
        public long currentValue() {
            return this.rangeCurr;
        }

        private void nextRange() {
            long data;
            boolean neg;
            boolean bl = neg = (data = this.sar.unpackedGet(this.nextRangeIdx--)) < 0L;
            if (neg) {
                this.rangeCurr = -data;
                this.rangeStart = this.sar.unpackedGet(this.nextRangeIdx--);
            } else {
                this.rangeCurr = this.rangeStart = data;
            }
            if (this.nextRangeIdx < 0) {
                this.close();
            }
        }

        @Override
        public long nextLong() {
            if (--this.rangeCurr < this.rangeStart) {
                this.nextRange();
            }
            return this.rangeCurr;
        }

        @Override
        public boolean advance(long v) {
            boolean iNeg;
            if (this.rangeCurr == -1L) {
                if (this.sar == null) {
                    return false;
                }
                this.nextRange();
            }
            if (this.rangeStart <= v) {
                this.rangeCurr = Math.min(v, this.rangeCurr);
                return true;
            }
            if (this.sar == null || this.nextRangeIdx < 0) {
                this.rangeCurr = this.rangeStart;
                this.close();
                return false;
            }
            long packedValue = this.sar.pack(v);
            if (packedValue < 0L) {
                this.rangeCurr = this.rangeStart = this.sar.unpackedGet(0);
                this.close();
                return false;
            }
            int i = this.sar.absRawBinarySearch(packedValue, 0, this.nextRangeIdx);
            long iData = this.sar.packedGet(i);
            boolean bl = iNeg = iData < 0L;
            if (iNeg) {
                long iPrevValue = this.sar.packedGet(i - 1);
                this.nextRangeIdx = i - 2;
                this.rangeStart = this.sar.unpack(iPrevValue);
                this.rangeCurr = v;
                if (this.nextRangeIdx < 0) {
                    this.close();
                }
                return true;
            }
            if (iData == packedValue) {
                this.rangeStart = this.rangeCurr = v;
                this.nextRangeIdx = i - 1;
                if (this.nextRangeIdx < 0) {
                    this.close();
                }
                return true;
            }
            if (--i < 0) {
                this.nextRangeIdx = i;
                this.rangeStart = this.rangeCurr = this.sar.unpack(iData);
                this.close();
                return false;
            }
            iData = this.sar.packedGet(i);
            boolean bl2 = iNeg = iData < 0L;
            if (iNeg) {
                this.nextRangeIdx = i - 2;
                this.rangeCurr = this.sar.unpack(-iData);
                this.rangeStart = this.sar.unpackedGet(i - 1);
                if (this.nextRangeIdx < 0) {
                    this.close();
                }
                return true;
            }
            this.nextRangeIdx = i - 1;
            this.rangeCurr = this.rangeStart = this.sar.unpack(iData);
            if (this.nextRangeIdx < 0) {
                this.close();
            }
            return true;
        }

        @Override
        public long binarySearchValue(RowSet.TargetComparator comp, int dir) {
            throw new UnsupportedOperationException("Reverse iterator does not support binary search.");
        }
    }

    private static final class SearchIterator
    extends RangeIteratorBase
    implements RowSet.SearchIterator {
        private boolean pendingNext = false;

        private SearchIterator(SortedRanges sar) {
            super(sar);
        }

        @Override
        public boolean hasNext() {
            return this.pendingNext || this.currRangeStart < this.currRangeEnd || this.hasNextRange();
        }

        @Override
        public long nextLong() {
            if (this.pendingNext) {
                this.pendingNext = false;
                return this.currRangeStart;
            }
            if (this.currRangeStart < this.currRangeEnd) {
                ++this.currRangeStart;
            } else if (this.hasNextRange()) {
                this.nextRange();
            }
            if (this.currRangeStart == this.currRangeEnd && !this.hasNextRange()) {
                this.close();
            }
            return this.currRangeStart;
        }

        @Override
        public long currentValue() {
            return this.currRangeStart;
        }

        public void close() {
            if (this.sar != null) {
                this.sar.release();
                this.sar = null;
            }
        }

        @Override
        public boolean advance(long v) {
            this.pendingNext = false;
            return this.advanceImpl(v);
        }

        private static int searchPos(MutableLong outData, SortedRanges sar, RowSetUtils.Comparator comp, int startPos) {
            long endPosUnpackedData = sar.unpackedGet(sar.count - 1);
            long endPosUnpackedValue = Math.abs(endPosUnpackedData);
            int c = comp.directionToTargetFrom(endPosUnpackedValue);
            if (c >= 0) {
                outData.setValue(endPosUnpackedData);
                return sar.count - 1;
            }
            int maxPos = sar.count - 1;
            long startPosUnpackedValue = sar.unpackedGet(startPos);
            c = comp.directionToTargetFrom(startPosUnpackedValue);
            if (c <= 0) {
                if (c == 0) {
                    outData.setValue(startPosUnpackedValue);
                    return startPos;
                }
                return startPos - 1;
            }
            int minPos = startPos;
            long minPosUnpackedData = startPosUnpackedValue;
            while (maxPos - minPos > 1) {
                int midPos = (minPos + maxPos) / 2;
                long midPosUnpackedData = sar.unpackedGet(midPos);
                long midPosUnpackedValue = Math.abs(midPosUnpackedData);
                c = comp.directionToTargetFrom(midPosUnpackedValue);
                if (c > 0) {
                    minPos = midPos;
                    minPosUnpackedData = midPosUnpackedData;
                    continue;
                }
                if (c < 0) {
                    maxPos = midPos;
                    continue;
                }
                outData.setValue(midPosUnpackedData);
                return midPos;
            }
            outData.setValue(minPosUnpackedData);
            return minPos;
        }

        @Override
        public long binarySearchValue(RowSet.TargetComparator comp, int dir) {
            boolean nextNeg;
            boolean neg;
            int c;
            this.pendingNext = false;
            boolean rollbackNextIfNotFound = false;
            if (this.currRangeStart == -1L) {
                if (!this.hasNext()) {
                    return -1L;
                }
                rollbackNextIfNotFound = true;
                this.nextRange();
            }
            if ((c = comp.compareTargetTo(this.currRangeEnd, dir)) <= 0) {
                if (c == 0) {
                    this.currRangeStart = this.currRangeEnd;
                    return this.currRangeStart;
                }
                c = comp.compareTargetTo(this.currRangeStart, dir);
                if (c < 0) {
                    if (rollbackNextIfNotFound) {
                        this.pendingNext = true;
                    }
                    return -1L;
                }
                this.currRangeStart = RowSetUtils.rangeSearch(this.currRangeStart, this.currRangeEnd, v -> comp.compareTargetTo(v, dir));
                return this.currRangeStart;
            }
            if (this.sar == null || this.nextRangeIdx == this.sar.count) {
                this.currRangeStart = this.currRangeEnd;
                this.close();
                return this.currRangeEnd;
            }
            MutableLong outValue = new MutableLong();
            RowSetUtils.Comparator ixComp = v -> comp.compareTargetTo(v, dir);
            int i = SearchIterator.searchPos(outValue, this.sar, ixComp, this.nextRangeIdx);
            if (i < this.nextRangeIdx) {
                this.currRangeStart = this.currRangeEnd;
                return this.currRangeStart;
            }
            long data = outValue.longValue();
            boolean bl = neg = data < 0L;
            if (neg) {
                this.currRangeStart = this.currRangeEnd = -data;
                this.nextRangeIdx = i + 1;
                if (this.nextRangeIdx < this.sar.count) {
                    this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
                }
                return this.currRangeStart;
            }
            int next = i + 1;
            if (next == this.sar.count) {
                this.currRangeStart = this.currRangeEnd = data;
                this.nextRangeIdx = next;
                return this.currRangeStart;
            }
            long nextData = this.sar.unpackedGet(next);
            boolean bl2 = nextNeg = nextData < 0L;
            if (nextNeg) {
                long searchEndValue = -nextData - 1L;
                this.currRangeStart = RowSetUtils.rangeSearch(data, searchEndValue, v -> comp.compareTargetTo(v, dir));
                this.currRangeEnd = -nextData;
                this.nextRangeIdx = next + 1;
                if (this.nextRangeIdx < this.sar.count) {
                    this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
                }
                return this.currRangeStart;
            }
            this.currRangeStart = this.currRangeEnd = data;
            this.nextRangeIdx = next;
            this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
            return this.currRangeStart;
        }
    }

    public static final class RangeIterator
    extends RangeIteratorBase
    implements RowSet.RangeIterator {
        private RangeIterator(SortedRanges sar) {
            super(sar);
        }

        @Override
        public void postpone(long v) {
            this.currRangeStart = v;
        }

        @Override
        public long currentRangeStart() {
            return this.currRangeStart;
        }

        @Override
        public long currentRangeEnd() {
            return this.currRangeEnd;
        }

        @Override
        public boolean hasNext() {
            return this.hasNextRange();
        }

        @Override
        public long next() {
            this.nextRange();
            return this.currRangeStart;
        }

        @Override
        public boolean advance(long v) {
            return this.advanceImpl(v);
        }

        @Override
        public void close() {
            this.closeImpl();
        }
    }

    private static class RangeIteratorBase {
        protected int nextRangeIdx = 0;
        protected long nextValue;
        protected long currRangeStart = -1L;
        protected long currRangeEnd = -1L;
        protected SortedRanges sar;

        protected RangeIteratorBase(SortedRanges sar) {
            if (sar.isEmpty()) {
                this.sar = null;
                return;
            }
            sar.acquire();
            this.sar = sar;
            this.nextValue = sar.unpackedGet(this.nextRangeIdx);
        }

        protected final void nextRange() {
            this.currRangeStart = this.nextValue;
            if (++this.nextRangeIdx == this.sar.count) {
                this.currRangeEnd = this.currRangeStart;
                this.closeImpl();
                return;
            }
            this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
            if (this.nextValue < 0L) {
                this.currRangeEnd = -this.nextValue;
                ++this.nextRangeIdx;
                if (this.nextRangeIdx == this.sar.count) {
                    this.closeImpl();
                } else {
                    this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
                }
                return;
            }
            this.currRangeEnd = this.currRangeStart;
        }

        protected final boolean hasNextRange() {
            return this.sar != null && this.nextRangeIdx < this.sar.count;
        }

        public final boolean advanceImpl(long v) {
            if (this.currRangeStart == -1L) {
                if (!this.hasNextRange()) {
                    return false;
                }
                this.nextRange();
            }
            if (v <= this.currRangeEnd) {
                if (this.currRangeStart < v) {
                    this.currRangeStart = v;
                }
                return true;
            }
            if (this.sar == null || this.nextRangeIdx == this.sar.count) {
                this.currRangeEnd = -1L;
                this.currRangeStart = -1L;
                this.closeImpl();
                return false;
            }
            int p = this.sar.unpackedBinarySearch(v, this.nextRangeIdx);
            if (p < 0 && (p ^= 0xFFFFFFFF) == this.sar.count) {
                this.nextRangeIdx = this.sar.count;
                this.currRangeEnd = -1L;
                this.currRangeStart = -1L;
                this.closeImpl();
                return false;
            }
            long x = this.sar.unpackedGet(p);
            this.currRangeStart = Math.max(x, v);
            if (++p == this.sar.count) {
                this.currRangeEnd = this.currRangeStart;
                this.nextRangeIdx = this.sar.count;
                return true;
            }
            this.nextValue = this.sar.unpackedGet(p);
            if (this.nextValue < 0L) {
                this.currRangeEnd = -this.nextValue;
                this.nextRangeIdx = p + 1;
                if (this.nextRangeIdx < this.sar.count) {
                    this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
                }
                return true;
            }
            this.currRangeEnd = this.currRangeStart;
            this.nextRangeIdx = p;
            this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
            return true;
        }

        public final void closeImpl() {
            if (this.sar != null) {
                this.sar.release();
                this.sar = null;
            }
        }
    }

    private static final class Iterator
    implements RowSet.Iterator {
        private int nextRangeIdx = 0;
        private long nextValue;
        private long rangeCurr = -1L;
        private long rangeEnd = -1L;
        private SortedRanges sar;

        private Iterator(SortedRanges sar) {
            if (sar.isEmpty()) {
                this.sar = null;
                return;
            }
            sar.acquire();
            this.sar = sar;
            this.nextValue = sar.unpackedGet(this.nextRangeIdx);
        }

        @Override
        public long nextLong() {
            if (++this.rangeCurr > this.rangeEnd) {
                this.nextRange();
            }
            return this.rangeCurr;
        }

        @Override
        public boolean hasNext() {
            return this.rangeCurr < this.rangeEnd || this.sar != null && this.nextRangeIdx < this.sar.count;
        }

        private void nextRange() {
            this.rangeCurr = this.nextValue;
            if (++this.nextRangeIdx == this.sar.count) {
                this.rangeEnd = this.rangeCurr;
                this.close();
                return;
            }
            this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
            if (this.nextValue < 0L) {
                this.rangeEnd = -this.nextValue;
                ++this.nextRangeIdx;
                if (this.nextRangeIdx == this.sar.count) {
                    this.close();
                } else {
                    this.nextValue = this.sar.unpackedGet(this.nextRangeIdx);
                }
            } else {
                this.rangeEnd = this.rangeCurr;
            }
        }

        public void close() {
            if (this.sar != null) {
                this.sar.release();
                this.sar = null;
            }
        }
    }
}

