/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesLong;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesPacked;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesShort;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesTyped;

public final class SortedRangesInt
extends SortedRangesPacked<int[]> {
    private static ThreadLocal<TIntObjectHashMap<int[]>> ARRAY_POOL = ThreadLocal.withInitial(() -> new TIntObjectHashMap(16));

    @Override
    public SortedRangesInt deepCopy() {
        return new SortedRangesInt(SortedRangesInt.copyData(this), this.offset, this.count, this.cardinality);
    }

    @Override
    protected int packedValuesPerCacheLine() {
        return 16;
    }

    @Override
    protected SortedRangesInt makeMyTypeAndOffset(int initialCapacity) {
        return new SortedRangesInt(initialCapacity, this.offset);
    }

    @Override
    protected int[] makeArray(int capacity) {
        TIntObjectHashMap<int[]> localPool;
        int[] arr;
        int roundedCapacity = SortedRangesInt.arraySizeRoundingInt(capacity);
        if (POOL_ARRAYS && (arr = (int[])(localPool = ARRAY_POOL.get()).remove(roundedCapacity)) != null) {
            return arr;
        }
        return new int[roundedCapacity];
    }

    @Override
    public void freeArray(int[] arr) {
        if (!POOL_ARRAYS) {
            return;
        }
        if (!SortedRangesInt.isIntAllocationSize(arr.length)) {
            return;
        }
        TIntObjectHashMap<int[]> localPool = ARRAY_POOL.get();
        localPool.put(arr.length, (Object)arr);
    }

    @Override
    protected int dataLength() {
        return ((int[])this.data).length;
    }

    @Override
    protected long maxValueForType() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int capacityForLastIndex(int lastIndex, boolean isDense) {
        return SortedRangesInt.intArrayCapacityForLastIndex(lastIndex, isDense);
    }

    @Override
    protected long unpackedGet(int i) {
        return this.unpack(((int[])this.data)[i]);
    }

    @Override
    protected long absUnpackedGet(int i) {
        int iData = ((int[])this.data)[i];
        if (iData < 0) {
            return this.offset() - (long)iData;
        }
        return this.offset() + (long)iData;
    }

    @Override
    protected void unpackedSet(int i, long v) {
        ((int[])this.data)[i] = (int)this.pack(v);
    }

    @Override
    protected long packedGet(int i) {
        return ((int[])this.data)[i];
    }

    @Override
    protected void packedSet(int i, long v) {
        ((int[])this.data)[i] = (int)v;
    }

    public SortedRangesInt(int initialCapacity, long offset) {
        super(initialCapacity, offset);
    }

    public SortedRangesInt(int[] data, long offset, int count, long cardinality) {
        super(data, offset, count, cardinality);
    }

    public SortedRangesInt(long offset, SortedRangesLong sa, int initialCapacity) {
        super(SortedRangesInt.fromLongArray((long[])sa.data, sa.count, offset, initialCapacity), offset, sa.count, sa.cardinality);
    }

    private static int[] fromLongArray(long[] longArray, int count, long newOffset, int capacity) {
        int[] intArray = new int[capacity];
        for (int i = 0; i < count; ++i) {
            int iv;
            long v = longArray[i];
            intArray[i] = iv = (int)(v < 0L ? newOffset + v : v - newOffset);
        }
        return intArray;
    }

    @Override
    protected SortedRanges tryPackFor(long first, long last, int maxPos, boolean isDense) {
        long range = last - first;
        if (range > 32767L) {
            return null;
        }
        int initialShortCapacity = SortedRangesInt.shortArrayCapacityForLastIndex(maxPos);
        if (initialShortCapacity == 0) {
            return null;
        }
        return new SortedRangesShort(first, this, initialShortCapacity);
    }

    @Override
    public SortedRanges tryMakePackedType(int maxPos, long first, boolean isDense) {
        long range = this.last() - first;
        if (range > 32767L) {
            return null;
        }
        int initialShortCapacity = SortedRangesInt.shortArrayCapacityForLastIndex(maxPos);
        if (initialShortCapacity == 0) {
            return null;
        }
        return new SortedRangesShort(initialShortCapacity, first);
    }

    @Override
    protected SortedRangesInt growOnNew(int capacity) {
        SortedRangesInt ans = new SortedRangesInt(capacity, this.offset);
        System.arraycopy(this.data, 0, ans.data, 0, this.count);
        ans.cardinality = this.cardinality;
        ans.count = this.count;
        if (POOL_ARRAYS && this.canWrite()) {
            this.freeArray((int[])this.data);
        }
        return ans;
    }

    protected SortedRangesInt makeMyType(int[] data, long offset, int count, long cardinality) {
        return new SortedRangesInt(data, offset, count, cardinality);
    }

    @Override
    protected void rebaseAndShift(int[] dataOut, long newOffset, long shiftOffset, SortedRangesTyped<int[]> sar, long first) {
        long newUnpackedFirst = first + shiftOffset;
        dataOut[0] = (int)(newUnpackedFirst - newOffset);
        long netOffset = this.offset + shiftOffset - newOffset;
        for (int i = 1; i < sar.count; ++i) {
            long v = ((int[])sar.data)[i];
            dataOut[i] = (int)(v < 0L ? v - netOffset : v + netOffset);
        }
    }

    @Override
    public int bytesAllocated() {
        return ((int[])this.data).length * 4;
    }

    @Override
    public int bytesUsed() {
        return this.count * 4;
    }

    @Override
    protected SortedRangesShort tryPack() {
        long first = this.first();
        long range = this.last() - first;
        if (range > 32767L) {
            return null;
        }
        SortedRangesShort sr = new SortedRangesShort(this.count, first);
        this.copyTo(sr);
        return sr;
    }

    @Override
    public boolean isDense() {
        return SortedRangesInt.isDenseInt((int[])this.data, this.count);
    }
}

