/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesInt;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesPacked;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesShort;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesTyped;

public final class SortedRangesLong
extends SortedRangesTyped<long[]> {
    private static ThreadLocal<TIntObjectHashMap<long[]>> ARRAY_POOL = ThreadLocal.withInitial(() -> new TIntObjectHashMap(16));

    @Override
    public boolean fits(long v) {
        return true;
    }

    @Override
    public boolean fits(long start, long end) {
        return true;
    }

    @Override
    public boolean fitsForAppend(long end) {
        return true;
    }

    @Override
    public SortedRangesLong deepCopy() {
        return new SortedRangesLong(SortedRangesLong.copyData(this), this.count, this.cardinality);
    }

    @Override
    protected int packedValuesPerCacheLine() {
        return 8;
    }

    @Override
    protected int capacityForLastIndex(int lastIndex, boolean isDense) {
        return SortedRangesLong.longArrayCapacityForLastIndex(lastIndex, isDense);
    }

    @Override
    protected long[] makeArray(int capacity) {
        TIntObjectHashMap<long[]> localPool;
        long[] arr;
        if (POOL_ARRAYS && (arr = (long[])(localPool = ARRAY_POOL.get()).remove(capacity)) != null) {
            return arr;
        }
        return new long[capacity];
    }

    @Override
    protected void freeArray(long[] arr) {
        if (!POOL_ARRAYS) {
            return;
        }
        if (!SortedRangesLong.isLongAllocationSize(arr.length)) {
            return;
        }
        TIntObjectHashMap<long[]> localPool = ARRAY_POOL.get();
        localPool.put(arr.length, (Object)arr);
    }

    @Override
    protected SortedRangesLong makeMyTypeAndOffset(int initialCapacity) {
        return new SortedRangesLong(initialCapacity);
    }

    @Override
    protected int dataLength() {
        return ((long[])this.data).length;
    }

    @Override
    protected long packedGet(int i) {
        return ((long[])this.data)[i];
    }

    @Override
    protected void packedSet(int i, long value) {
        ((long[])this.data)[i] = value;
    }

    @Override
    protected long pack(long value) {
        return value;
    }

    @Override
    protected long unpackedGet(int i) {
        return ((long[])this.data)[i];
    }

    @Override
    protected long absUnpackedGet(int i) {
        return Math.abs(((long[])this.data)[i]);
    }

    @Override
    protected void unpackedSet(int i, long value) {
        ((long[])this.data)[i] = value;
    }

    @Override
    protected long unpack(long rawValue) {
        return rawValue;
    }

    public SortedRangesLong() {
        this(INITIAL_SIZE);
    }

    public SortedRangesLong(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedRangesLong(long[] data) {
        super(data);
    }

    public SortedRangesLong(long[] data, int count, long cardinality) {
        super(data, count, cardinality);
    }

    public static SortedRangesLong makeSingleRange(long start, long end) {
        return new SortedRangesLong(start, end);
    }

    private SortedRangesLong(long start, long end) {
        super(2);
        if (start == end) {
            this.count = 1;
            this.cardinality = 1L;
            this.packedSet(0, start);
            if (DEBUG) {
                this.validate(start, end);
            }
            return;
        }
        this.count = 2;
        this.cardinality = end - start + 1L;
        this.packedSet(0, start);
        this.packedSet(1, -end);
        if (DEBUG) {
            this.validate(start, end);
        }
    }

    @Override
    public SortedRanges addInternal(long v, boolean writeCheck) {
        return SortedRangesLong.addPacked(this, v, v, writeCheck);
    }

    @Override
    public SortedRanges addRangeInternal(long start, long end, boolean writeCheck) {
        return SortedRangesLong.addRangePacked(this, start, end, start, end, writeCheck);
    }

    @Override
    public final SortedRanges appendInternal(long v, boolean writeCheck) {
        return SortedRangesLong.appendPacked(this, v, v, writeCheck);
    }

    @Override
    public final SortedRanges appendRangeInternal(long start, long end, boolean writeCheck) {
        return SortedRangesLong.appendRangePacked(this, start, end, start, end, writeCheck);
    }

    @Override
    public SortedRanges removeInternal(long v) {
        return SortedRangesLong.removePacked(this, v, v);
    }

    @Override
    public SortedRanges removeRangeInternal(long start, long end) {
        return SortedRangesLong.removeRangePacked(this, start, end, start, end);
    }

    private static void shiftValues(long[] dataOut, long shiftOffset, SortedRangesLong sar, long v) {
        dataOut[0] = v + shiftOffset;
        for (int i = 1; i < sar.count; ++i) {
            v = ((long[])sar.data)[i];
            dataOut[i] = v < 0L ? v - shiftOffset : v + shiftOffset;
        }
    }

    @Override
    public SortedRanges applyShift(long shiftOffset) {
        if (shiftOffset == 0L || this.isEmpty()) {
            return this;
        }
        long v = ((long[])this.data)[0];
        if (v + shiftOffset < 0L) {
            throw new IllegalArgumentException("shiftOffset=" + shiftOffset + " when first=" + v);
        }
        boolean isNew = !this.canWrite();
        long[] targetData = isNew ? new long[((long[])this.data).length] : (long[])this.data;
        SortedRangesLong.shiftValues(targetData, shiftOffset, this, v);
        if (isNew) {
            return new SortedRangesLong(targetData, this.count, this.cardinality);
        }
        if (DEBUG) {
            this.validate();
        }
        return this;
    }

    @Override
    public SortedRanges applyShiftOnNew(long shiftOffset) {
        if (shiftOffset == 0L || this.isEmpty()) {
            this.acquire();
            return this;
        }
        long v = ((long[])this.data)[0];
        if (v + shiftOffset < 0L) {
            throw new IllegalArgumentException("shiftOffset=" + shiftOffset + " when first=" + v);
        }
        long[] targetData = new long[((long[])this.data).length];
        SortedRangesLong.shiftValues(targetData, shiftOffset, this, v);
        return new SortedRangesLong(targetData, this.count, this.cardinality);
    }

    @Override
    public SortedRanges tryPackFor(long first, long last, int newLastPos, boolean isDense) {
        long range = last - first;
        if (range > Integer.MAX_VALUE) {
            return null;
        }
        int initialIntCapacity = SortedRangesLong.intArrayCapacityForLastIndex(newLastPos, isDense);
        if (initialIntCapacity == 0) {
            return null;
        }
        return new SortedRangesInt(first, this, initialIntCapacity);
    }

    @Override
    public SortedRanges tryMakePackedType(int maxPos, long first, boolean isDense) {
        long range = this.last() - first;
        if (range > Integer.MAX_VALUE) {
            return null;
        }
        int initialIntCapacity = SortedRangesLong.intArrayCapacityForLastIndex(maxPos, isDense);
        if (initialIntCapacity == 0) {
            return null;
        }
        return new SortedRangesInt(initialIntCapacity, first);
    }

    @Override
    protected SortedRangesLong growOnNew(int capacity) {
        SortedRangesLong ans = new SortedRangesLong(capacity);
        System.arraycopy(this.data, 0, ans.data, 0, this.count);
        ans.cardinality = this.cardinality;
        ans.count = this.count;
        if (POOL_ARRAYS && this.canWrite()) {
            this.freeArray((long[])this.data);
        }
        return ans;
    }

    @Override
    public int bytesAllocated() {
        return ((long[])this.data).length * 8;
    }

    @Override
    public int bytesUsed() {
        return this.count * 8;
    }

    @Override
    protected SortedRanges tryPack() {
        long first = this.first();
        long last = this.last();
        long range = last - first;
        if (range > Integer.MAX_VALUE) {
            return null;
        }
        SortedRangesPacked sr = range > 32767L ? new SortedRangesInt(this.count, first) : new SortedRangesShort(this.count, first);
        this.copyTo(sr);
        return sr;
    }

    boolean trySimpleAppend(long start, long end) {
        if (this.count >= ((long[])this.data).length) {
            return false;
        }
        ((long[])this.data)[this.count++] = start;
        if (start != end) {
            if (this.count >= ((long[])this.data).length) {
                return false;
            }
            ((long[])this.data)[this.count++] = -end;
            this.cardinality += end - start + 1L;
        } else {
            ++this.cardinality;
        }
        return true;
    }

    void reset() {
        this.count = 0;
        this.cardinality = 0L;
    }

    @Override
    public boolean isDense() {
        return SortedRangesLong.isDenseLong((long[])this.data, this.count);
    }
}

