/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesLong;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesTyped;

public abstract class SortedRangesPacked<ArrayType>
extends SortedRangesTyped<ArrayType> {
    protected long offset;

    protected abstract long maxValueForType();

    @Override
    public boolean fits(long value) {
        return this.offset <= value && value - this.offset <= this.maxValueForType();
    }

    @Override
    public boolean fits(long start, long end) {
        return this.offset <= start && end - this.offset <= this.maxValueForType();
    }

    @Override
    public boolean fitsForAppend(long end) {
        return end - this.offset <= this.maxValueForType();
    }

    @Override
    protected final long pack(long unpackedValue) {
        if (unpackedValue < 0L) {
            return this.offset + unpackedValue;
        }
        return unpackedValue - this.offset;
    }

    @Override
    protected final long unpack(long packedValue) {
        if (packedValue < 0L) {
            return -this.offset + packedValue;
        }
        return this.offset + packedValue;
    }

    protected SortedRangesPacked(int initialCapacity, long offset) {
        super(initialCapacity);
        this.offset = offset;
    }

    protected SortedRangesPacked(ArrayType data, long offset) {
        super(data);
        this.offset = offset;
    }

    protected SortedRangesPacked(ArrayType data, long offset, int count, long cardinality) {
        super(data, count, cardinality);
        this.offset = offset;
    }

    protected abstract SortedRanges makeMyType(ArrayType var1, long var2, int var4, long var5);

    protected final long offset() {
        return this.offset;
    }

    @Override
    public final SortedRanges addInternal(long v, boolean writeCheck) {
        long packedValue = this.pack(v);
        if (packedValue < 0L || packedValue > this.maxValueForType()) {
            SortedRangesLong ans = this.tryConvertToSrLong(1);
            if (ans == null) {
                return null;
            }
            return ans.addInternal(v, false);
        }
        return SortedRangesPacked.addPacked(this, packedValue, v, writeCheck);
    }

    @Override
    public final SortedRanges addRangeInternal(long start, long end, boolean writeCheck) {
        long packedEnd;
        long packedStart = this.pack(start);
        if (packedStart >= 0L && (packedEnd = this.pack(end)) <= this.maxValueForType()) {
            return SortedRangesPacked.addRangePacked(this, packedStart, packedEnd, start, end, writeCheck);
        }
        SortedRangesLong ans = this.tryConvertToSrLong(2);
        if (ans == null) {
            return null;
        }
        return ans.addRangeInternal(start, end, false);
    }

    @Override
    public final SortedRanges appendInternal(long v, boolean writeCheck) {
        long packedValue = this.pack(v);
        if (packedValue < 0L || packedValue > this.maxValueForType()) {
            SortedRangesLong ans = this.tryConvertToSrLong(1);
            if (ans == null) {
                return null;
            }
            return ans.appendInternal(v, false);
        }
        return SortedRangesPacked.appendPacked(this, packedValue, v, writeCheck);
    }

    @Override
    public final SortedRanges appendRangeInternal(long start, long end, boolean writeCheck) {
        long packedEnd;
        long packedStart = this.pack(start);
        if (packedStart >= 0L && (packedEnd = this.pack(end)) <= this.maxValueForType()) {
            return SortedRangesPacked.appendRangePacked(this, packedStart, packedEnd, start, end, writeCheck);
        }
        SortedRangesLong ans = this.tryConvertToSrLong(2);
        if (ans == null) {
            return null;
        }
        return ans.appendRangeInternal(start, end, false);
    }

    @Override
    public final SortedRanges removeInternal(long v) {
        long packedValue = this.pack(v);
        if (packedValue < 0L || packedValue > this.maxValueForType()) {
            return this;
        }
        return SortedRangesPacked.removePacked(this, packedValue, v);
    }

    @Override
    public final SortedRanges removeRangeInternal(long start, long end) {
        long packedEnd = this.pack(end);
        if (packedEnd < 0L) {
            return this;
        }
        long packedStart = this.pack(start);
        if (packedStart < 0L) {
            packedStart = 0L;
        }
        if (packedEnd > this.maxValueForType()) {
            packedEnd = this.maxValueForType();
        }
        return SortedRangesPacked.removeRangePacked(this, packedStart, packedEnd, start, end);
    }

    protected abstract void rebaseAndShift(ArrayType var1, long var2, long var4, SortedRangesTyped<ArrayType> var6, long var7);

    @Override
    public SortedRanges applyShift(long shiftOffset) {
        if (shiftOffset == 0L || this.isEmpty()) {
            return this;
        }
        long v = this.unpackedGet(0);
        if (v + shiftOffset < 0L) {
            throw new IllegalArgumentException("shiftOffset=" + shiftOffset + " when first=" + v);
        }
        return this.applyShiftImpl(shiftOffset, v, !this.canWrite());
    }

    private SortedRanges applyShiftImpl(long shiftOffset, long first, boolean isNew) {
        long newOffset = this.offset + shiftOffset;
        if (newOffset >= first) {
            if (isNew) {
                Object targetData = SortedRangesPacked.copyData(this);
                return this.makeMyType(targetData, newOffset, this.count, this.cardinality);
            }
            this.offset = newOffset;
            if (DEBUG) {
                this.validate();
            }
            return this;
        }
        newOffset = first + shiftOffset;
        if (isNew) {
            Object targetData = this.makeArray(this.dataLength());
            this.rebaseAndShift(targetData, newOffset, shiftOffset, this, first);
            return this.makeMyType(targetData, newOffset, this.count, this.cardinality);
        }
        this.rebaseAndShift(this.data, newOffset, shiftOffset, this, first);
        this.offset = newOffset;
        if (DEBUG) {
            this.validate();
        }
        return this;
    }

    @Override
    public SortedRanges applyShiftOnNew(long shiftOffset) {
        if (shiftOffset == 0L || this.isEmpty()) {
            this.acquire();
            return this;
        }
        long v = this.unpackedGet(0);
        if (v + shiftOffset < 0L) {
            throw new IllegalArgumentException("offsetDelta=" + shiftOffset + " when first=" + v);
        }
        return this.applyShiftImpl(shiftOffset, v, true);
    }

    private SortedRangesLong tryConvertToSrLong(int deltaCapacity) {
        if (this.count == 0) {
            if (deltaCapacity > LONG_DENSE_MAX_CAPACITY) {
                return null;
            }
            return new SortedRangesLong(deltaCapacity);
        }
        int desiredCap = this.count + deltaCapacity;
        int capacity = SortedRangesPacked.longArrayCapacityForLastIndex(desiredCap - 1, SortedRangesPacked.isDenseLongSample(this.first(), this.last(), this.count));
        if (capacity == 0) {
            return null;
        }
        SortedRangesLong ans = new SortedRangesLong(capacity);
        this.copyTo(ans);
        return ans;
    }
}

