/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import io.deephaven.base.verify.Assert;
import io.deephaven.chunk.WritableLongChunk;
import io.deephaven.engine.rowset.RowSequence;
import io.deephaven.engine.rowset.RowSequenceFactory;
import io.deephaven.engine.rowset.RowSet;
import io.deephaven.engine.rowset.RowSetFactory;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeyRanges;
import io.deephaven.engine.rowset.chunkattributes.OrderedRowKeys;
import io.deephaven.engine.rowset.impl.RowSequenceAsChunkImpl;
import io.deephaven.engine.rowset.impl.WritableRowSetImpl;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.util.datastructures.LongAbortableConsumer;
import io.deephaven.util.datastructures.LongRangeAbortableConsumer;
import java.util.function.BiConsumer;

public class SortedRangesRowSequence
extends RowSequenceAsChunkImpl {
    private static final boolean DEBUG = SortedRanges.DEBUG;
    private SortedRanges sar;
    private int startIdx;
    private int endIdx;
    private long startPos;
    private long startOffset;
    private long endOffset;
    private long size;

    SortedRangesRowSequence(SortedRanges sar) {
        long data1;
        sar.acquire();
        this.sar = sar;
        if (sar.isEmpty()) {
            throw new IllegalArgumentException("sar=" + sar);
        }
        this.size = sar.getCardinality();
        this.endIdx = sar.count - 1;
        this.endOffset = 0L;
        if (this.size == 1L || (data1 = sar.packedGet(1)) >= 0L) {
            this.startIdx = 0;
            this.startOffset = 0L;
            return;
        }
        long data0 = sar.packedGet(0);
        this.startIdx = 1;
        this.startOffset = data0 + data1;
        this.ifDebugValidate();
    }

    SortedRangesRowSequence(SortedRanges sar, long startPos, int startIdx, long startOffset, int endIdx, long endOffset, long size) {
        sar.acquire();
        this.startPos = startPos;
        this.sar = sar;
        this.startIdx = startIdx;
        this.startOffset = startOffset;
        this.endIdx = endIdx;
        this.endOffset = endOffset;
        this.size = size;
        this.ifDebugValidate();
    }

    private SortedRangesRowSequence(SortedRanges sar, long startPos) {
        this.sar = sar;
        this.startPos = startPos;
    }

    @Override
    public void close() {
        this.closeSortedArrayRowSequence();
    }

    protected final void closeSortedArrayRowSequence() {
        if (this.sar == null) {
            return;
        }
        this.sar.release();
        this.sar = null;
        this.closeRowSequenceAsChunkImpl();
    }

    @Override
    public Iterator getRowSequenceIterator() {
        return new Iterator(this);
    }

    @Override
    public RowSequence getRowSequenceByPosition(long pos, long length) {
        long iPos;
        int i;
        if (length <= 0L || pos >= this.size) {
            return RowSequenceFactory.EMPTY;
        }
        long data = this.sar.packedGet(this.startIdx);
        if (data < 0L) {
            long startRangeEndValue = -data;
            i = this.startIdx - 1;
            long startRangeStartValue = this.sar.packedGet(i);
            iPos = this.startPos - this.startOffset - (startRangeEndValue - startRangeStartValue);
        } else {
            i = this.startIdx;
            iPos = this.startPos;
        }
        if (length > this.size - pos) {
            length = this.size - pos;
        }
        return this.sar.getRowSequenceByPositionWithStart(iPos, i, this.startPos + pos, length);
    }

    @Override
    public RowSequence getRowSequenceByKeyRange(long startRowKeyInclusive, long endRowKeyInclusive) {
        long iPos;
        int i;
        if (this.size == 0L) {
            return RowSequenceFactory.EMPTY;
        }
        long lastKey = this.lastRowKey();
        long firstKey = this.firstRowKey();
        startRowKeyInclusive = Math.max(startRowKeyInclusive, firstKey);
        if ((endRowKeyInclusive = Math.min(endRowKeyInclusive, lastKey)) < startRowKeyInclusive) {
            return RowSequenceFactory.EMPTY;
        }
        long data = this.sar.packedGet(this.startIdx);
        if (data < 0L) {
            long startRangeEndValue = -data;
            i = this.startIdx - 1;
            long startRangeStartValue = this.sar.packedGet(i);
            iPos = this.startPos + startRangeEndValue + this.startOffset - startRangeStartValue;
        } else {
            i = this.startIdx;
            iPos = 0L;
        }
        return this.sar.getRowSequenceByKeyRangePackedWithStart(iPos, i, this.sar.pack(startRowKeyInclusive), this.sar.pack(endRowKeyInclusive));
    }

    @Override
    public RowSet asRowSet() {
        if (this.size == this.sar.getCardinality()) {
            return new WritableRowSetImpl(this.sar.deepCopy());
        }
        if (this.size <= 0L) {
            return RowSetFactory.empty();
        }
        SortedRanges ans = this.sar.makeMyTypeAndOffset(Math.min(this.endIdx - this.startIdx + 2, this.sar.count));
        ans.cardinality = this.size;
        long packedStartValue = this.sar.absPackedGet(this.startIdx);
        ans.packedSet(0, packedStartValue + this.startOffset);
        if (this.startIdx == this.endIdx) {
            if (this.endOffset > this.startOffset) {
                ans.packedSet(1, -(packedStartValue + this.endOffset));
                ans.count = 2;
            } else {
                ans.count = 1;
            }
        } else {
            boolean endIdxIsNeg;
            int iSar = this.startOffset < 0L ? this.startIdx : this.startIdx + 1;
            int iAns = 1;
            long lastData = 0L;
            while (iSar < this.endIdx) {
                int n = iAns++;
                lastData = this.sar.packedGet(iSar++);
                ans.packedSet(n, lastData);
            }
            long endIdxData = this.sar.packedGet(this.endIdx);
            boolean bl = endIdxIsNeg = endIdxData < 0L;
            if (endIdxIsNeg) {
                long endValue = -endIdxData + this.endOffset;
                if (endValue > lastData) {
                    ans.packedSet(iAns++, -endValue);
                }
            } else {
                ans.packedSet(iAns++, endIdxData);
            }
            ans.count = iAns;
        }
        return new WritableRowSetImpl(ans);
    }

    @Override
    public void fillRowKeyChunk(WritableLongChunk<? super OrderedRowKeys> chunkToFill) {
        chunkToFill.setSize(0);
        this.forEachRowKey(key -> {
            chunkToFill.add(key);
            return true;
        });
    }

    @Override
    public void fillRowKeyRangesChunk(WritableLongChunk<OrderedRowKeyRanges> chunkToFill) {
        chunkToFill.setSize(0);
        this.forEachRowKeyRange((start, end) -> {
            chunkToFill.add(start);
            chunkToFill.add(end);
            return true;
        });
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public long firstRowKey() {
        return this.sar.absUnpackedGet(this.startIdx) + this.startOffset;
    }

    @Override
    public long lastRowKey() {
        return this.sar.absUnpackedGet(this.endIdx) + this.endOffset;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long getAverageRunLengthEstimate() {
        return this.size / (long)(this.endIdx - this.startIdx + 1);
    }

    @Override
    public boolean forEachRowKey(LongAbortableConsumer lac) {
        long iData;
        if (this.size == 0L) {
            return true;
        }
        int i = this.startIdx;
        long startValue = this.sar.absUnpackedGet(i);
        if (this.startIdx == this.endIdx) {
            for (long offset = this.startOffset; offset <= this.endOffset; ++offset) {
                if (lac.accept(startValue + offset)) continue;
                return false;
            }
            return true;
        }
        for (long offset = this.startOffset; offset <= 0L; ++offset) {
            if (lac.accept(startValue + offset)) continue;
            return false;
        }
        long pendingStart = this.sar.unpackedGet(++i);
        if (i == this.endIdx) {
            return lac.accept(pendingStart);
        }
        ++i;
        while (i < this.endIdx) {
            boolean iNeg;
            iData = this.sar.unpackedGet(i);
            boolean bl = iNeg = iData < 0L;
            if (iNeg) {
                long iValue = -iData;
                for (long v = pendingStart; v <= iValue; ++v) {
                    if (lac.accept(v)) continue;
                    return false;
                }
                pendingStart = -1L;
            } else {
                if (pendingStart != -1L && !lac.accept(pendingStart)) {
                    return false;
                }
                pendingStart = iData;
            }
            ++i;
        }
        if (pendingStart != -1L && !lac.accept(pendingStart)) {
            return false;
        }
        iData = this.sar.unpackedGet(this.endIdx);
        if (iData < 0L) {
            long iValue = -iData;
            for (long v = pendingStart + 1L; v <= iValue + this.endOffset; ++v) {
                if (lac.accept(v)) continue;
                return false;
            }
        } else if (!lac.accept(iData)) {
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachRowKeyRange(LongRangeAbortableConsumer lrac) {
        long iData;
        if (this.size == 0L) {
            return true;
        }
        int i = this.startIdx;
        long startValue = this.sar.absUnpackedGet(i);
        if (this.startIdx == this.endIdx) {
            return lrac.accept(startValue + this.startOffset, startValue + this.endOffset);
        }
        if (!lrac.accept(startValue + this.startOffset, startValue)) {
            return false;
        }
        long pendingStart = this.sar.unpackedGet(++i);
        if (i == this.endIdx) {
            return lrac.accept(pendingStart, pendingStart);
        }
        ++i;
        while (i < this.endIdx) {
            boolean iNeg;
            iData = this.sar.unpackedGet(i);
            boolean bl = iNeg = iData < 0L;
            if (iNeg) {
                if (!lrac.accept(pendingStart, -iData)) {
                    return false;
                }
                pendingStart = -1L;
            } else {
                if (pendingStart != -1L && !lrac.accept(pendingStart, pendingStart)) {
                    return false;
                }
                pendingStart = iData;
            }
            ++i;
        }
        iData = this.sar.unpackedGet(this.endIdx);
        if (iData < 0L) {
            long iValue = -iData;
            if (!lrac.accept(pendingStart, iValue + this.endOffset)) {
                return false;
            }
        } else {
            if (pendingStart != -1L && !lrac.accept(pendingStart, pendingStart)) {
                return false;
            }
            if (!lrac.accept(iData, iData)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long rangesCountUpperBound() {
        return this.endIdx - Math.max(this.startIdx - 1, 0) + 1;
    }

    private void reset(long startPos, int startIdx, long startOffset, int endIdx, long endOffset, long size) {
        if (this.sar != null) {
            this.closeRowSequenceAsChunkImpl();
        }
        this.startPos = startPos;
        this.startIdx = startIdx;
        this.endIdx = endIdx;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.size = size;
        this.ifDebugValidate();
    }

    private void ifDebugValidate() {
        if (DEBUG) {
            this.validate();
        }
    }

    private static void validateOffset(String m, int idx, long offset, SortedRanges sr) {
        long v = sr.unpackedGet(idx);
        BiConsumer<String, String> fail = (prefix, suffix) -> {
            throw new IllegalStateException(m + (String)(prefix != null && prefix.length() > 0 ? " " + prefix : "") + ": idx=" + idx + ", v=" + v + ", offset=" + offset + (String)(suffix != null && suffix.length() > 0 ? ", " + suffix : ""));
        };
        if (v >= 0L) {
            long next;
            if (offset != 0L) {
                fail.accept("v >= 0 && offset !=0", null);
            }
            if (idx < sr.count - 1 && (next = sr.unpackedGet(idx + 1)) < 0L) {
                fail.accept("v >=0 ", "next=" + next);
            }
        } else if (idx >= 1) {
            long prev = sr.unpackedGet(idx - 1);
            if (prev < 0L || -v + offset < prev) {
                fail.accept("v < 0", "prev=" + prev);
            }
        } else {
            fail.accept("v < 0 && idx <= 0", null);
        }
    }

    public void validate() {
        if (this.startIdx < 0 || this.endIdx > this.sar.count) {
            throw new IllegalStateException("startIdx=" + this.startIdx + ", endIdx=" + this.endIdx);
        }
        SortedRangesRowSequence.validateOffset("start", this.startIdx, this.startOffset, this.sar);
        SortedRangesRowSequence.validateOffset("end", this.endIdx, this.endOffset, this.sar);
    }

    static class Iterator
    implements RowSequence.Iterator {
        private SortedRanges sar;
        private final SortedRangesRowSequence currBuf;
        private int currStartIdx;
        private int currEndIdx;
        private long currStartOffset;
        private long currEndOffset;
        private long sizeLeft;
        private final int rsEndIdx;
        private final long rsEndOffset;
        private long nextKey;
        private long pendingAdvanceSize = 0L;

        public Iterator(SortedRangesRowSequence rs) {
            rs.sar.acquire();
            this.sar = rs.sar;
            this.currStartIdx = rs.startIdx;
            this.currStartOffset = rs.startOffset;
            this.rsEndIdx = rs.endIdx;
            this.rsEndOffset = rs.endOffset;
            this.currEndIdx = -1;
            this.currEndOffset = 1L;
            this.currBuf = new RSWrapper(this.sar, rs.startPos);
            this.sizeLeft = rs.size;
            this.nextKey = -1L;
        }

        @Override
        public void close() {
            this.currBuf.closeRowSequenceAsChunkImpl();
            if (this.sar == null) {
                return;
            }
            this.sar.release();
            this.sar = null;
        }

        @Override
        public boolean hasMore() {
            return this.sizeLeft > 0L;
        }

        @Override
        public long peekNextKey() {
            if (!this.hasMore()) {
                return -1L;
            }
            if (this.nextKey == -1L) {
                long offset;
                int pos;
                if (this.currEndIdx == -1) {
                    pos = this.currStartIdx;
                    offset = this.currStartOffset;
                } else if (this.currEndOffset < 0L) {
                    pos = this.currEndIdx;
                    offset = this.currEndOffset + 1L;
                } else {
                    pos = this.currEndIdx + 1;
                    offset = 0L;
                }
                this.nextKey = this.sar.absUnpackedGet(pos) + offset;
            }
            return this.nextKey;
        }

        private long updateCurrThrough(long toKey) {
            if (!this.hasMore()) {
                return 0L;
            }
            int savedStartIdx = this.currStartIdx;
            long savedStartOffset = this.currStartOffset;
            if (this.currEndIdx != -1) {
                if (this.currEndOffset < 0L) {
                    this.currStartIdx = this.currEndIdx;
                    this.currStartOffset = this.currEndOffset + 1L;
                } else {
                    this.currStartIdx = this.currEndIdx + 1;
                    if (SortedRanges.DEBUG) {
                        Assert.lt((int)(this.currEndIdx + 1), (String)"currEndIdx + 1", (int)this.sar.count, (String)"sar.count");
                    }
                    if (this.currStartIdx + 1 < this.sar.count) {
                        long nextData = this.sar.packedGet(this.currStartIdx + 1);
                        if (nextData < 0L) {
                            long currStartValue = this.sar.packedGet(this.currStartIdx);
                            ++this.currStartIdx;
                            this.currStartOffset = currStartValue + nextData;
                        } else {
                            this.currStartOffset = 0L;
                        }
                    } else {
                        this.currStartOffset = 0L;
                    }
                }
            }
            long packedToKey = this.sar.pack(toKey);
            long rangeEndKey = this.sar.absPackedGet(this.currStartIdx);
            long startKey = rangeEndKey + this.currStartOffset;
            if (startKey > packedToKey) {
                this.currStartIdx = savedStartIdx;
                this.currStartOffset = savedStartOffset;
                return 0L;
            }
            if (rangeEndKey >= packedToKey) {
                this.currEndIdx = this.currStartIdx;
                this.currEndOffset = packedToKey - rangeEndKey;
                long sz = this.currEndOffset - this.currStartOffset + 1L;
                if (sz > this.sizeLeft) {
                    this.currEndIdx = this.rsEndIdx;
                    this.currEndOffset = this.rsEndOffset;
                    return this.sizeLeft;
                }
                return sz;
            }
            long sz = 1L - this.currStartOffset;
            if (sz > this.sizeLeft) {
                this.currEndIdx = this.rsEndIdx;
                this.currEndOffset = this.rsEndOffset;
                return this.sizeLeft;
            }
            long pendingStart = -1L;
            for (int i = this.currStartIdx + 1; i <= this.rsEndIdx; ++i) {
                boolean neg;
                long iData = this.sar.packedGet(i);
                boolean bl = neg = iData < 0L;
                if (neg) {
                    if (-iData >= packedToKey) {
                        this.currEndIdx = i;
                        this.currEndOffset = packedToKey + iData;
                        if (this.currEndIdx == this.rsEndIdx && this.currEndOffset > this.rsEndOffset) {
                            this.currEndOffset = this.rsEndOffset;
                            packedToKey = -iData + this.rsEndOffset;
                        }
                        if ((sz += packedToKey - pendingStart) > this.sizeLeft) {
                            this.currEndIdx = this.rsEndIdx;
                            this.currEndOffset = this.rsEndOffset;
                            return this.sizeLeft;
                        }
                        return sz;
                    }
                    sz += -iData - pendingStart;
                    pendingStart = -1L;
                    continue;
                }
                if (iData > packedToKey) {
                    this.currEndIdx = i - 1;
                    this.currEndOffset = 0L;
                    if (sz > this.sizeLeft) {
                        this.currEndIdx = this.rsEndIdx;
                        this.currEndOffset = this.rsEndOffset;
                        return this.sizeLeft;
                    }
                    return sz;
                }
                ++sz;
                if (iData == packedToKey) {
                    long nextData;
                    if (sz > this.sizeLeft) {
                        this.currEndIdx = this.rsEndIdx;
                        this.currEndOffset = this.rsEndOffset;
                        return this.sizeLeft;
                    }
                    if (i + 1 > this.rsEndIdx || (nextData = this.sar.packedGet(i + 1)) >= 0L) {
                        this.currEndIdx = i;
                        this.currEndOffset = 0L;
                        return sz;
                    }
                    this.currEndIdx = i + 1;
                    this.currEndOffset = nextData + packedToKey;
                    return sz;
                }
                pendingStart = iData;
            }
            if (sz > this.sizeLeft) {
                this.currEndIdx = this.rsEndIdx;
                this.currEndOffset = this.rsEndOffset;
                return this.sizeLeft;
            }
            this.currEndIdx = this.rsEndIdx;
            this.currEndOffset = 0L;
            return sz;
        }

        @Override
        public RowSequence getNextRowSequenceThrough(long maxKey) {
            if (maxKey < 0L) {
                return RowSequenceFactory.EMPTY;
            }
            long sz = this.updateCurrThrough(maxKey);
            if (sz == 0L) {
                return RowSequenceFactory.EMPTY;
            }
            this.nextKey = -1L;
            this.currBuf.reset(this.currBuf.startPos + this.currBuf.size + this.pendingAdvanceSize, this.currStartIdx, this.currStartOffset, this.currEndIdx, this.currEndOffset, sz);
            this.pendingAdvanceSize = 0L;
            this.sizeLeft -= sz;
            return this.currBuf;
        }

        private void nextRowSequenceWithLength(long actualLen) {
            boolean iNeg;
            long iData;
            long pendingStart;
            int i;
            long delta;
            long accumLen = 0L;
            if (this.currEndIdx != -1) {
                if (this.currEndOffset < 0L) {
                    delta = actualLen + this.currEndOffset;
                    if (delta <= 0L) {
                        this.currStartIdx = this.currEndIdx;
                        this.currStartOffset = this.currEndOffset + 1L;
                        this.currEndIdx = this.currStartIdx;
                        this.currEndOffset = delta;
                        return;
                    }
                    this.currStartIdx = this.currEndIdx;
                    this.currStartOffset = this.currEndOffset + 1L;
                    accumLen += -this.currEndOffset;
                    i = this.currEndIdx + 1;
                    pendingStart = -1L;
                    iData = this.sar.packedGet(i);
                    iNeg = iData < 0L;
                } else {
                    i = this.currEndIdx + 1;
                    if (i == this.rsEndIdx || i + 1 == this.sar.count) {
                        this.currStartIdx = this.currEndIdx = i;
                        this.currEndOffset = 0L;
                        this.currStartOffset = 0L;
                        return;
                    }
                    long iNextData = this.sar.packedGet(i + 1);
                    if (iNextData < 0L) {
                        long iValue = this.sar.packedGet(i);
                        long firstRangeLen = -iNextData - iValue + 1L;
                        this.currStartIdx = i + 1;
                        this.currStartOffset = -firstRangeLen + 1L;
                        if (actualLen <= firstRangeLen) {
                            this.currEndIdx = this.currStartIdx;
                            this.currEndOffset = actualLen - firstRangeLen;
                            return;
                        }
                        accumLen += firstRangeLen;
                        pendingStart = -1L;
                        iData = this.sar.packedGet(i += 2);
                        iNeg = iData < 0L;
                    } else {
                        if (actualLen == 1L) {
                            this.currStartIdx = this.currEndIdx = i;
                            this.currEndOffset = 0L;
                            this.currStartOffset = 0L;
                            return;
                        }
                        this.currStartIdx = i;
                        this.currStartOffset = 0L;
                        if (i + 1 == this.rsEndIdx || i + 2 == this.sar.count) {
                            this.currEndIdx = i + 1;
                            this.currEndOffset = 0L;
                            return;
                        }
                        ++accumLen;
                        pendingStart = iNextData;
                        ++i;
                        iData = iNextData;
                        iNeg = false;
                    }
                }
            } else {
                long firstRangeLen = 1L - this.currStartOffset;
                if (firstRangeLen >= actualLen) {
                    this.currEndIdx = this.currStartIdx;
                    this.currEndOffset = this.currStartOffset + actualLen - 1L;
                    return;
                }
                accumLen += 1L - this.currStartOffset;
                i = this.currStartIdx + 1;
                pendingStart = -1L;
                iData = this.sar.packedGet(i);
                boolean bl = iNeg = iData < 0L;
            }
            while (true) {
                if (iNeg) {
                    delta = -iData - pendingStart;
                    if (accumLen + delta >= actualLen || i == this.rsEndIdx) {
                        delta = Math.min(delta, actualLen - accumLen);
                        this.currEndIdx = i;
                        this.currEndOffset = iData + pendingStart + delta;
                        return;
                    }
                    accumLen += delta;
                    pendingStart = -1L;
                } else {
                    ++accumLen;
                    if (i == this.rsEndIdx) {
                        this.currEndIdx = i;
                        this.currEndOffset = 0L;
                        return;
                    }
                    if (accumLen == actualLen) {
                        long nextData;
                        if (i + 1 < this.sar.count && (nextData = this.sar.packedGet(i + 1)) < 0L) {
                            this.currEndIdx = i + 1;
                            this.currEndOffset = iData + nextData;
                            return;
                        }
                        this.currEndIdx = i;
                        this.currEndOffset = 0L;
                        return;
                    }
                    pendingStart = iData;
                }
                iData = this.sar.packedGet(++i);
                iNeg = iData < 0L;
            }
        }

        @Override
        public RowSequence getNextRowSequenceWithLength(long desiredLen) {
            long actualLen = Math.min(desiredLen, this.sizeLeft);
            if (actualLen == 0L) {
                return RowSequenceFactory.EMPTY;
            }
            this.nextRowSequenceWithLength(actualLen);
            this.nextKey = -1L;
            this.currBuf.reset(this.currBuf.startPos + this.currBuf.size + this.pendingAdvanceSize, this.currStartIdx, this.currStartOffset, this.currEndIdx, this.currEndOffset, actualLen);
            this.pendingAdvanceSize = 0L;
            this.sizeLeft -= actualLen;
            return this.currBuf;
        }

        @Override
        public boolean advance(long toKey) {
            if (this.sizeLeft == 0L || toKey <= 0L || this.currEndIdx != -1 && toKey <= this.currBuf.lastRowKey()) {
                return this.sizeLeft > 0L;
            }
            long sz = this.updateCurrThrough(toKey - 1L);
            this.nextKey = -1L;
            this.pendingAdvanceSize = sz;
            this.sizeLeft -= sz;
            return this.sizeLeft > 0L;
        }

        @Override
        public long getRelativePosition() {
            return -this.sizeLeft;
        }

        private static class RSWrapper
        extends SortedRangesRowSequence {
            RSWrapper(SortedRanges sar, long startPos) {
                super(sar, startPos);
            }

            @Override
            public void close() {
                if (SortedRanges.DEBUG) {
                    throw new IllegalStateException();
                }
                this.closeRowSequenceAsChunkImpl();
            }
        }
    }
}

