/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import gnu.trove.map.hash.TIntObjectHashMap;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesInt;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesLong;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesPacked;
import io.deephaven.engine.rowset.impl.sortedranges.SortedRangesTyped;

public final class SortedRangesShort
extends SortedRangesPacked<short[]> {
    private static ThreadLocal<TIntObjectHashMap<short[]>> ARRAY_POOL = ThreadLocal.withInitial(() -> new TIntObjectHashMap(16));

    @Override
    public SortedRangesShort deepCopy() {
        return new SortedRangesShort(SortedRangesShort.copyData(this), this.offset, this.count, this.cardinality);
    }

    @Override
    protected int packedValuesPerCacheLine() {
        return 32;
    }

    @Override
    protected SortedRangesShort makeMyTypeAndOffset(int initialCapacity) {
        return new SortedRangesShort(initialCapacity, this.offset);
    }

    @Override
    protected short[] makeArray(int capacity) {
        TIntObjectHashMap<short[]> localPool;
        short[] arr;
        int roundedCapacity = SortedRangesShort.arraySizeRoundingShort(capacity);
        if (POOL_ARRAYS && (arr = (short[])(localPool = ARRAY_POOL.get()).remove(roundedCapacity)) != null) {
            return arr;
        }
        return new short[roundedCapacity];
    }

    @Override
    protected void freeArray(short[] arr) {
        if (!POOL_ARRAYS) {
            return;
        }
        if (!SortedRangesShort.isShortAllocationSize(arr.length)) {
            return;
        }
        TIntObjectHashMap<short[]> localPool = ARRAY_POOL.get();
        localPool.put(arr.length, (Object)arr);
    }

    @Override
    protected int dataLength() {
        return ((short[])this.data).length;
    }

    @Override
    protected long maxValueForType() {
        return 32767L;
    }

    @Override
    protected int capacityForLastIndex(int lastIndex, boolean isDense) {
        return SortedRangesShort.shortArrayCapacityForLastIndex(lastIndex);
    }

    @Override
    protected long unpackedGet(int i) {
        return this.unpack(((short[])this.data)[i]);
    }

    @Override
    protected long absUnpackedGet(int i) {
        short iData = ((short[])this.data)[i];
        if (iData < 0) {
            return this.offset() - (long)iData;
        }
        return this.offset() + (long)iData;
    }

    @Override
    protected void unpackedSet(int i, long v) {
        ((short[])this.data)[i] = (short)this.pack(v);
    }

    @Override
    protected long packedGet(int i) {
        return ((short[])this.data)[i];
    }

    @Override
    protected void packedSet(int i, long v) {
        ((short[])this.data)[i] = (short)v;
    }

    public SortedRangesShort(int initialCapacity, long offset) {
        super(initialCapacity, offset);
    }

    public SortedRangesShort(short[] data, long offset, int count, long cardinality) {
        super(data, offset, count, cardinality);
    }

    public SortedRangesShort(SortedRangesLong sa) {
        super(SortedRangesShort.fromLongArray((long[])sa.data, sa.count), sa.first(), sa.count, sa.cardinality);
    }

    private static short[] fromLongArray(long[] longArray, int count) {
        short[] shortArray = new short[longArray.length];
        shortArray[0] = 0;
        long offset = longArray[0];
        for (int i = 1; i < count; ++i) {
            short iv;
            long v = longArray[i];
            shortArray[i] = iv = (short)(v < 0L ? v + offset : v - offset);
        }
        return shortArray;
    }

    public SortedRangesShort(long offset, SortedRangesInt sa, int initialCapacity) {
        super(SortedRangesShort.fromIntArray((int[])sa.data, sa.count, sa.offset, offset, initialCapacity), offset, sa.count, sa.cardinality);
    }

    private static short[] fromIntArray(int[] intArray, int count, long oldOffset, long newOffset, int capacity) {
        short[] shortArray = new short[capacity];
        for (int i = 0; i < count; ++i) {
            short sv;
            int v = intArray[i];
            shortArray[i] = sv = (short)(v < 0 ? newOffset - oldOffset + (long)v : (long)v + oldOffset - newOffset);
        }
        return shortArray;
    }

    @Override
    protected SortedRanges tryPackFor(long first, long last, int maxPos, boolean isDense) {
        return null;
    }

    @Override
    protected SortedRanges tryMakePackedType(int maxPos, long first, boolean isDense) {
        return null;
    }

    @Override
    protected SortedRangesShort growOnNew(int capacity) {
        SortedRangesShort ans = new SortedRangesShort(capacity, this.offset);
        System.arraycopy(this.data, 0, ans.data, 0, this.count);
        ans.cardinality = this.cardinality;
        ans.count = this.count;
        if (POOL_ARRAYS && this.canWrite()) {
            this.freeArray((short[])this.data);
        }
        return ans;
    }

    protected SortedRangesShort makeMyType(short[] data, long offset, int count, long cardinality) {
        return new SortedRangesShort(data, offset, count, cardinality);
    }

    @Override
    protected void rebaseAndShift(short[] dataOut, long newOffset, long shiftOffset, SortedRangesTyped<short[]> sar, long first) {
        long newUnpackedFirst = first + shiftOffset;
        dataOut[0] = (short)(newUnpackedFirst - newOffset);
        long netOffset = this.offset + shiftOffset - newOffset;
        for (int i = 1; i < sar.count; ++i) {
            long v = ((short[])sar.data)[i];
            dataOut[i] = (short)(v < 0L ? v - netOffset : v + netOffset);
        }
    }

    @Override
    public int bytesAllocated() {
        return ((short[])this.data).length * 2;
    }

    @Override
    public int bytesUsed() {
        return this.count * 2;
    }

    @Override
    protected SortedRanges tryPack() {
        return null;
    }

    @Override
    public boolean isDense() {
        return SortedRangesShort.isDenseShort((short[])this.data, this.count);
    }
}

