/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.engine.rowset.impl.sortedranges;

import io.deephaven.engine.rowset.impl.sortedranges.SortedRanges;

public abstract class SortedRangesTyped<ArrayType>
extends SortedRanges {
    protected ArrayType data;

    protected abstract ArrayType makeArray(int var1);

    protected abstract void freeArray(ArrayType var1);

    protected abstract int capacityForLastIndex(int var1, boolean var2);

    protected abstract SortedRanges tryMakePackedType(int var1, long var2, boolean var4);

    @Override
    protected abstract SortedRangesTyped<ArrayType> makeMyTypeAndOffset(int var1);

    protected SortedRangesTyped(int initialCapacity) {
        this.data = this.makeArray(initialCapacity);
        this.count = 0;
        this.cardinality = 0L;
    }

    protected SortedRangesTyped(ArrayType data) {
        this(data, 0, 0L);
    }

    protected SortedRangesTyped(ArrayType data, int count, long cardinality) {
        this.data = data;
        this.count = count;
        this.cardinality = cardinality;
    }

    protected final void copyDataForMoveToNew(SortedRanges srOut, int srcPos, int dstPos, int len) {
        for (int i = 0; i < srcPos; ++i) {
            srOut.unpackedSet(i, this.unpackedGet(i));
        }
        this.copyData(srOut, srcPos, dstPos, len);
    }

    protected final void copyData(SortedRanges srOut, int srcPos, int dstPos, int len) {
        for (int i = 0; i < len; ++i) {
            srOut.unpackedSet(dstPos + i, this.unpackedGet(srcPos + i));
        }
    }

    protected final void copyTo(SortedRanges srOut) {
        this.copyData(srOut, 0, 0, this.count);
        srOut.count = this.count;
        srOut.cardinality = this.cardinality;
    }

    @Override
    public final SortedRanges tryCompactUnsafe(int k) {
        SortedRanges packed = this.tryPack();
        if (packed != null) {
            return packed;
        }
        int dataLen = this.dataLength();
        if (k == 0 ? this.count == dataLen : dataLen - this.count <= dataLen >> k) {
            return this;
        }
        ArrayType newData = this.makeArray(this.count);
        System.arraycopy(this.data, 0, newData, 0, this.count);
        this.freeArray(this.data);
        this.data = newData;
        return this;
    }

    @Override
    protected final SortedRanges checkSizeAndMoveData(int srcPos, int dstPos, int len, long first, boolean writeCheck) {
        int maxPos = dstPos + len - 1;
        if (maxPos < this.dataLength()) {
            if (!writeCheck || this.canWrite()) {
                this.moveData(srcPos, dstPos, len);
                return this;
            }
            SortedRanges ans = this.makeMyTypeAndOffset(this.dataLength());
            System.arraycopy(this.data, 0, ((SortedRangesTyped)ans).data, 0, srcPos);
            System.arraycopy(this.data, srcPos, ((SortedRangesTyped)ans).data, dstPos, len);
            return ans;
        }
        boolean isDense = SortedRangesTyped.isDenseLongSample(first, this.last(), this.count);
        int newCapacity = this.capacityForLastIndex(maxPos, isDense);
        if (newCapacity == 0) {
            SortedRanges ans = this.tryMakePackedType(maxPos, first, isDense);
            if (ans == null) {
                return null;
            }
            this.copyDataForMoveToNew(ans, srcPos, dstPos, len);
            if (POOL_ARRAYS && this.canWrite()) {
                this.freeArray(this.data);
            }
            return ans;
        }
        if (!writeCheck || this.canWrite()) {
            ArrayType newData = this.makeArray(newCapacity);
            System.arraycopy(this.data, 0, newData, 0, srcPos);
            System.arraycopy(this.data, srcPos, newData, dstPos, len);
            this.freeArray(this.data);
            this.data = newData;
            return this;
        }
        SortedRanges ans = this.makeMyTypeAndOffset(newCapacity);
        System.arraycopy(this.data, 0, ((SortedRangesTyped)ans).data, 0, srcPos);
        System.arraycopy(this.data, srcPos, ((SortedRangesTyped)ans).data, dstPos, len);
        if (POOL_ARRAYS && this.canWrite()) {
            this.freeArray(this.data);
        }
        return ans;
    }

    @Override
    protected final SortedRanges ensureCanAppend(int newLastPos, long unpackedNewLastKey, boolean writeCheck) {
        SortedRanges ans;
        long absUnpackedLastKey = Math.abs(unpackedNewLastKey);
        if (!this.fitsForAppend(absUnpackedLastKey)) {
            return null;
        }
        if (newLastPos < this.dataLength()) {
            return writeCheck ? (SortedRanges)this.getWriteRef() : this;
        }
        boolean isDense = true;
        int newCapacity = this.capacityForLastIndex(newLastPos, isDense);
        if (newCapacity == 0) {
            isDense = SortedRangesTyped.isDenseLongSample(this.first(), absUnpackedLastKey, this.count);
            ans = this.tryPackWithNewLast(absUnpackedLastKey, newLastPos, isDense);
            if (ans != null) {
                if (POOL_ARRAYS && this.canWrite()) {
                    this.freeArray(this.data);
                }
                return ans;
            }
            if (isDense) {
                return null;
            }
            newCapacity = this.capacityForLastIndex(newLastPos, false);
            if (newCapacity == 0) {
                return null;
            }
        }
        if (!writeCheck || this.canWrite()) {
            this.copyData(newCapacity);
            return this;
        }
        ans = this.growOnNew(newCapacity);
        return ans;
    }

    protected static <ArrayType> ArrayType copyData(SortedRangesTyped<ArrayType> sta) {
        int newSz = sta.dataLength();
        ArrayType dst = sta.makeArray(newSz);
        System.arraycopy(sta.data, 0, dst, 0, sta.count);
        return dst;
    }

    @Override
    protected final void copyData(int newCapacity) {
        ArrayType dst = this.makeArray(newCapacity);
        System.arraycopy(this.data, 0, dst, 0, this.count);
        this.freeArray(this.data);
        this.data = dst;
    }

    @Override
    protected final void moveData(int srcPos, int dstPos, int len) {
        System.arraycopy(this.data, srcPos, this.data, dstPos, len);
    }
}

