/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stringset;

import io.deephaven.stringset.StringSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;

public class ArrayStringSet
implements StringSet,
Serializable {
    private final String[] innerSet;
    private ToIntFunction<String> lastToOffset;
    private long lastEncoding;

    public ArrayStringSet(String ... values) {
        Arrays.sort(values);
        this.innerSet = values;
    }

    @Override
    public boolean contains(String value) {
        for (int vi = 0; vi < this.innerSet.length; ++vi) {
            if (!value.equals(this.innerSet[vi])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAny(String ... values) {
        for (int vi = 0; vi < values.length; ++vi) {
            if (!this.contains(values[vi])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(String ... values) {
        for (int vi = 0; vi < values.length; ++vi) {
            if (this.contains(values[vi])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.innerSet.length;
    }

    @Override
    public String[] values() {
        return this.innerSet;
    }

    @Override
    public String[] sortedValues() {
        return this.values();
    }

    @Override
    public boolean isEmpty() {
        return this.innerSet.length == 0;
    }

    @Override
    public synchronized long getEncoding(@NotNull ToIntFunction<String> toOffset) {
        if (this.lastToOffset == toOffset) {
            return this.lastEncoding;
        }
        long encoding = 0L;
        for (int vi = 0; vi < this.innerSet.length; ++vi) {
            String s = this.innerSet[vi];
            int key = toOffset.applyAsInt(s);
            if (key > 63) {
                throw new RuntimeException("Symbol " + s + " exceeds the limit of 63 symbols for ArrayStringSet");
            }
            encoding |= 1L << key;
        }
        this.lastEncoding = encoding;
        this.lastToOffset = toOffset;
        return encoding;
    }

    public final String toString() {
        return this.defaultToString();
    }

    public final int hashCode() {
        return this.defaultHashCode();
    }

    public final boolean equals(Object other) {
        return this.defaultEquals(other);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.innerSet).iterator();
    }
}

