/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stringset;

import io.deephaven.datastructures.util.CollectionUtil;
import io.deephaven.stringset.StringSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;

public class HashStringSet
implements StringSet,
Serializable {
    private static final long serialVersionUID = 6033718768047284093L;
    private Set<String> innerSet;

    public HashStringSet(String[] values, int start, int length) {
        this.innerSet = new HashSet<String>(length);
        while (length-- > 0) {
            this.innerSet.add(values[start++]);
        }
    }

    public HashStringSet(String ... values) {
        this.innerSet = new HashSet<String>(values.length);
        this.innerSet.addAll(Arrays.asList(values));
    }

    public HashStringSet(Collection<String> values) {
        this.innerSet = new HashSet<String>(values);
    }

    public HashStringSet(int initialCapacity) {
        this.innerSet = new HashSet<String>(initialCapacity);
    }

    public void addStringToSet(String val) {
        this.innerSet.add(val);
    }

    @Override
    public boolean contains(String value) {
        return this.innerSet.contains(value);
    }

    @Override
    public boolean containsAny(String ... values) {
        for (String value : values) {
            if (!this.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(String ... values) {
        for (String value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.innerSet.size();
    }

    @Override
    public String[] values() {
        return this.innerSet.toArray(CollectionUtil.ZERO_LENGTH_STRING_ARRAY);
    }

    @Override
    public String[] sortedValues() {
        Object[] values = this.values();
        Arrays.sort(values);
        return values;
    }

    @Override
    public boolean isEmpty() {
        return this.innerSet.isEmpty();
    }

    @Override
    public long getEncoding(@NotNull ToIntFunction<String> toOffset) {
        long encoding = 0L;
        for (String s : this) {
            int key = toOffset.applyAsInt(s);
            if (key > 63) {
                throw new RuntimeException("Symbol " + s + " exceeds the limit of 63 symbols for HashStringSet");
            }
            encoding |= 1L << key;
        }
        return encoding;
    }

    public final String toString() {
        return this.defaultToString();
    }

    public final int hashCode() {
        return this.defaultHashCode();
    }

    public final boolean equals(Object other) {
        return this.defaultEquals(other);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.innerSet.iterator();
    }
}

