/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stringset;

import io.deephaven.base.MathUtil;
import io.deephaven.stringset.HashStringSet;
import io.deephaven.stringset.StringSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;

public class LongBitmapStringSet
implements StringSet,
Serializable {
    private final ReversibleLookup<String> reversibleLookup;
    private final long valueBitSet;
    private int bitCount = Integer.MIN_VALUE;
    private int highestOneBitIndex = Integer.MIN_VALUE;
    private transient HashStringSet replacement;

    public LongBitmapStringSet(@NotNull ReversibleLookup<String> reversibleLookup, long valueBitSet) {
        this.reversibleLookup = reversibleLookup;
        this.valueBitSet = valueBitSet;
    }

    private int getHighestOneBitIndex() {
        return this.highestOneBitIndex == Integer.MIN_VALUE ? (this.highestOneBitIndex = MathUtil.floorLog2((long)this.valueBitSet)) : this.highestOneBitIndex;
    }

    private int getBitCount() {
        return this.bitCount == Integer.MIN_VALUE ? (this.bitCount = Long.bitCount(this.valueBitSet)) : this.bitCount;
    }

    private boolean isBitOn(int bitIndex) {
        return (this.valueBitSet & 1L << bitIndex) != 0L;
    }

    private Object writeReplace() {
        if (this.replacement == null) {
            this.replacement = new HashStringSet(this.values());
        }
        return this.replacement;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException("LongBitmapStringSet should never be deserialized - it uses writeReplace() to serialize itself as different class entirely.");
    }

    @Override
    public final boolean contains(String value) {
        int highestIndex = this.getHighestOneBitIndex();
        int index = this.reversibleLookup.rget(highestIndex, value);
        return index >= 0 && index <= highestIndex && this.isBitOn(index);
    }

    @Override
    public final boolean containsAny(String ... values) {
        for (String value : values) {
            if (!this.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAll(String ... values) {
        for (String value : values) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int size() {
        return this.getBitCount();
    }

    @Override
    public final String[] values() {
        String[] values = new String[this.size()];
        int vi = 0;
        for (int bi = 0; bi <= this.getHighestOneBitIndex(); ++bi) {
            if (!this.isBitOn(bi)) continue;
            values[vi++] = this.reversibleLookup.get(bi);
        }
        return values;
    }

    @Override
    public final String[] sortedValues() {
        Object[] values = this.values();
        Arrays.sort(values);
        return values;
    }

    @Override
    public final boolean isEmpty() {
        return this.valueBitSet == 0L;
    }

    @Override
    public long getEncoding(@NotNull ToIntFunction<String> toOffset) {
        if (this.valueBitSet == 0L) {
            return 0L;
        }
        long encoding = 0L;
        for (int bi = 0; bi <= this.getHighestOneBitIndex(); ++bi) {
            if (!this.isBitOn(bi)) continue;
            String value = this.reversibleLookup.get(bi);
            int keyBitIndex = toOffset.applyAsInt(value);
            if (keyBitIndex >= 64) {
                throw new RuntimeException("Symbol manager returned a rowSet " + keyBitIndex + " greater than the maximum, for symbol " + value);
            }
            encoding |= 1L << keyBitIndex;
        }
        return encoding;
    }

    public final String toString() {
        return this.defaultToString();
    }

    public int hashCode() {
        return this.defaultHashCode();
    }

    public boolean equals(Object other) {
        return this.defaultEquals(other);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return Arrays.asList(this.values()).iterator();
    }

    public static interface ReversibleLookup<DATA_TYPE> {
        public DATA_TYPE get(long var1);

        public int rget(int var1, DATA_TYPE var2);
    }
}

