/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.stringset;

import java.util.Arrays;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.NotNull;

public interface StringSet
extends Iterable<String> {
    public boolean contains(String var1);

    public boolean containsAny(String ... var1);

    public boolean containsAll(String ... var1);

    public int size();

    public String[] values();

    public String[] sortedValues();

    public boolean isEmpty();

    public long getEncoding(@NotNull ToIntFunction<String> var1);

    default public String defaultToString() {
        return Arrays.toString(this.sortedValues());
    }

    default public int defaultHashCode() {
        return Arrays.hashCode(this.sortedValues());
    }

    default public boolean defaultEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!StringSet.class.isAssignableFrom(other.getClass())) {
            return false;
        }
        return Arrays.equals(this.sortedValues(), ((StringSet)other).sortedValues());
    }
}

